/*
 * Decompiled with CFR 0.152.
 */
package jme.canvas;

import java.awt.Color;

public class ColorManager {
    public static final String colorHashPrefix = "COLOR_HASH";
    public ColorInfo[] psColor;

    public void initDefaultBackGroundColorPaletteIfNeeded() {
        if (this.psColor == null) {
            this.psColor = new ColorInfo[8];
            this.psColor[0] = new ColorInfo(Color.gray, null, 0);
            this.psColor[1] = new ColorInfo(Color.cyan, "1", 1);
            this.psColor[2] = new ColorInfo(new Color(255, 204, 102), "2", 2);
            this.psColor[3] = new ColorInfo(new Color(255, 255, 0), "3", 3);
            this.psColor[4] = new ColorInfo(new Color(255, 153, 153), "4", 4);
            this.psColor[5] = new ColorInfo(new Color(51, 204, 255), "5", 5);
            this.psColor[6] = new ColorInfo(new Color(255, 153, 255), "6", 6);
            this.psColor[7] = new ColorInfo(new Color(102, 255, 102), "7", 7);
        }
    }

    public int numberOfBackgroundColors() {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        return this.psColor.length - 1;
    }

    public int[][] getBackGroundColorPaletteAsInteger() {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        int[][] result = new int[this.psColor.length - 1][3];
        for (int i = 1; i < this.psColor.length; ++i) {
            Color c = this.getColor(i);
            result[i - 1][0] = c.getRed();
            result[i - 1][1] = c.getGreen();
            result[i - 1][2] = c.getBlue();
        }
        return result;
    }

    public String[] getBackGroundColorPalette() {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        String[] result = new String[this.psColor.length - 1];
        for (int i = 1; i < this.psColor.length; ++i) {
            result[i - 1] = ColorManager.makeHexColor(this.psColor[i].color);
        }
        return result;
    }

    public ColorInfo getColorInfo(int index) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        if (index >= 0 && index < this.psColor.length) {
            return this.psColor[index];
        }
        return null;
    }

    public ColorInfo getColorInfoOfColorHash(String hash) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        for (ColorInfo each : this.psColor) {
            if (each.hash != hash) continue;
            return each;
        }
        return null;
    }

    public Color getColor(int index) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        if (index >= 0 && index < this.psColor.length) {
            return this.psColor[index].color;
        }
        return null;
    }

    public String getColorAssociatedLabel(int index) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        if (index >= 0 && index < this.psColor.length) {
            return this.psColor[index].name;
        }
        return null;
    }

    public String getColorAssociatedHash(int index) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        if (index >= 0 && index < this.psColor.length) {
            return this.psColor[index].hash;
        }
        return null;
    }

    public void setBackGroundColorPalette(String[] palette) {
        int n = palette.length;
        ColorSpec[] colorSpecPalette = new ColorSpec[n];
        for (int i = 0; i < n; ++i) {
            String color = palette[i];
            String label = "" + (i + 1);
            colorSpecPalette[i] = new ColorSpec(color, label);
        }
        this.setMarkerMenuBackGroundColorPalette(colorSpecPalette);
    }

    public void setMarkerMenuBackGroundColorPalette(ColorSpec[] palette) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        ColorInfo firstColor = this.psColor[0];
        this.psColor = new ColorInfo[palette.length + 1];
        this.psColor[0] = firstColor;
        for (int i = 0; i < palette.length; ++i) {
            this.psColor[i + 1] = new ColorInfo(ColorManager.parseHexColor(palette[i].color), palette[i].label, i + 1);
        }
    }

    public Color averageColor(int[] colorCodes) {
        this.initDefaultBackGroundColorPaletteIfNeeded();
        int singleColorIndex = -1;
        if (colorCodes != null && colorCodes.length >= 1) {
            int red = 0;
            int green = 0;
            int blue = 0;
            int count = 0;
            for (int colorIndex : colorCodes) {
                if (colorIndex < 0 || colorIndex >= this.psColor.length) continue;
                Color color = this.psColor[colorIndex].color;
                red += color.getRed();
                green += color.getGreen();
                blue += color.getBlue();
                ++count;
                singleColorIndex = colorIndex;
            }
            if (count > 0) {
                if (count == 1) {
                    if (singleColorIndex >= 0) {
                        return this.psColor[singleColorIndex].color;
                    }
                } else {
                    Color color = new Color(red / count, green / count, blue / count);
                    return color;
                }
            }
        }
        return null;
    }

    public static Color parseHexColor(String hex) {
        Color c = Color.white;
        try {
            if (!hex.startsWith("#")) {
                throw new Exception("bad hex encoding");
            }
            int r = Integer.parseInt(hex.substring(1, 3), 16);
            int g = Integer.parseInt(hex.substring(3, 5), 16);
            int b = Integer.parseInt(hex.substring(5, 7), 16);
            c = new Color(r, g, b);
            return c;
        }
        catch (Exception e) {
            System.err.println("Problems in parsing background color " + hex);
            return c;
        }
    }

    public static String makeHexColor(Color c) {
        String hex = "#" + ColorManager.byteToHexString(c.getRed()) + ColorManager.byteToHexString(c.getGreen()) + ColorManager.byteToHexString(c.getBlue());
        return hex;
    }

    protected static String byteToHexString(int c) {
        String hex = Integer.toHexString(c);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static double brightness(Color c) {
        double result = (double)c.getRed() * 299.0 + (double)c.getGreen() * 587.0 + (double)(c.getBlue() * 114);
        return result /= 1000.0;
    }

    public static Color contrast(Color c) {
        Color result = ColorManager.brightness(c) > 123.0 ? Color.BLACK : Color.WHITE;
        return result;
    }

    public class ColorInfo {
        public Color color;
        public String name;
        public String hash;
        public int index;

        ColorInfo(Color color, String name, int index) {
            this.color = color;
            this.name = name;
            this.hash = "COLOR_HASH\t" + index;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ColorSpec {
        String color;
        String label;

        public ColorSpec(String hexColor, String label) {
            this.color = hexColor;
            this.label = label;
        }
    }
}

