/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Base64;
import javajs.util.P3d;
import javajs.util.PT;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jme.JME;
import jme.JMEmol;
import jme.JMEmolList;
import jme.core.Atom;
import jme.core.Bond;
import jme.core.JMECore;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.writers.CDXMLWriter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.smiles.SmilesMatcher;
import org.jmol.util.Elements;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class JMEJmol
extends JME
implements WindowListener {
    Viewer vwr;
    private Container parentWindow;
    private String fileName;
    private boolean allowClean = true;
    private SmilesMatcher smilesMatcher;
    String[] args = new String[0];
    private boolean cleaning = false;

    public JMEJmol() {
        super(null, true, new String[0]);
    }

    public JMEJmol(String[] args) {
        super(null, true, args);
        this.args = args;
        this.setRemoveHsC();
    }

    public void setViewer(JFrame frame, Viewer vwr, Container parent, String frameType) {
        this.parentWindow = parent;
        this.vwr = vwr;
        if (parent == null && frame == null && !"search".equals(frameType)) {
            this.headless = vwr.headless;
        }
        if (!this.headless) {
            if (frame == null) {
                frame = this.getJmolFrame(frameType, parent == null);
            }
            this.setFrame(frame);
        }
        this.initialize(this.args);
        if (parent != null) {
            if (vwr != null) {
                vwr.getInchi(null, null, null);
            }
            SwingUtilities.invokeLater(() -> this.start(new String[0]));
        }
    }

    private JFrame getJmolFrame(String type, boolean exit0) {
        JFrame frame = new JFrame(type == "search" ? "Substructure search" : this.getTitle());
        JPanel pp = new JPanel();
        JPanel p = new JPanel();
        pp.add("Center", p);
        p.setLayout(new BoxLayout(p, 0));
        if ("search".equals(type)) {
            JButton b = new JButton("search");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String smiles = JMEJmol.this.smiles();
                    Object f = JMEJmol.this.options.getInfo("searchCallback");
                }
            });
        } else {
            if (exit0) {
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        System.exit(0);
                    }
                });
            }
            JButton b = new JButton("clean");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.doClean();
                }
            });
            b = new JButton("from 3D");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.from3D();
                }
            });
            p.add(Box.createHorizontalStrut(5));
            b = new JButton("replace 3D");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.to3D(false);
                }
            });
            b = new JButton("add 3D");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.to3D(true);
                }
            });
            p.add(Box.createHorizontalStrut(5));
            b = new JButton("to MOL");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.toMOL("?jme.mol");
                }
            });
            b = new JButton("to CDXML");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.toCDXML("?jme.cdxml");
                }
            });
            b = new JButton("to PNG");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.toBorderedPNG("?", 10, 10);
                }
            });
            b = new JButton("InChI");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMEJmol.this.toInChI();
                }
            });
        }
        frame.add("South", pp);
        frame.setBounds(300, 300, 700, 400);
        frame.addWindowListener(this);
        return frame;
    }

    protected void toInChI() {
        String mol = this.molFile();
        String inchi = this.vwr.getInchi(null, mol, null);
        JOptionPane.showInputDialog(this, "Standard InChI", null, 1, null, null, inchi);
    }

    public boolean hasStructure(String pattern, boolean isSmarts) {
        String smiles = super.smiles();
        return this.vwr.hasStructure(pattern, smiles, isSmarts);
    }

    public int[] findMatchingStructures(String smarts, String[] smilesSet, boolean isSmarts) {
        try {
            return this.vwr.getSmilesMatcher().hasStructure(smarts == null ? this.smilesFromJmol() : smarts, smilesSet, 0);
        }
        catch (Exception e) {
            this.say("there was a problem with matching the SMILES " + e);
            e.printStackTrace();
            return null;
        }
    }

    public SmilesMatcher getSmilesMatcher() {
        return this.smilesMatcher == null ? (this.smilesMatcher = new SmilesMatcher()) : this.smilesMatcher;
    }

    public byte[] toPNG(String filename) {
        return this.toBorderedPNG(filename, 10, 10);
    }

    public Dimension getImageSize() {
        Rectangle2D.Double coordBox = this.activeMol.computeBoundingBoxWithAtomLabels(null);
        double f = this.molecularAreaScalePixelsPerCoord;
        return new Dimension((int)(coordBox.width * f), (int)(coordBox.height * f));
    }

    public String toHtmlDataURI() {
        return "data:image/png;base64," + Base64.getBase64(this.toBorderedPNG(null, 10, 10));
    }

    public byte[] toBorderedPNG(String filename, int marginX, int marginY) {
        try {
            BufferedImage img = this.getBufferedImage(marginX, marginY);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "PNG", bos);
            if (filename == null) {
                return bos.toByteArray();
            }
            this.toFile(this.headless && filename.indexOf("?") >= 0 ? "jmol.png" : filename, bos.toByteArray(), "png");
        }
        catch (IOException e1) {
            this.sorry("Something went wrong: " + e1);
        }
        return null;
    }

    public BufferedImage getBufferedImage(int marginX, int marginY) {
        return this.drawMolecularArea(null, new Point(marginX, marginY));
    }

    public void from3D() {
        if (this.vwr.getFrameAtoms().isEmpty()) {
            return;
        }
        Map<String, Object> info = this.vwr.getCurrentModelAuxInfo();
        if (info == null) {
            this.sorry("More than one model is visible in Jmol.");
            return;
        }
        boolean is2D = "2D".equals(info.get("dimension"));
        String mol = null;
        try {
            if (is2D) {
                mol = this.vwr.getModelExtract("thisModel", false, false, "MOL");
            } else {
                String smiles = this.vwr.getSmiles(this.vwr.getFrameAtoms());
                mol = this.getMolFromSmiles(smiles, false);
            }
            if (mol == null) {
                this.sorry("Something went wrong.");
            }
            this.clear();
            this.readMolFile(mol);
        }
        catch (Exception e) {
            this.sorry(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public String smiles() {
        if (this.activeMol.natoms == 0) {
            return "";
        }
        String mol = this.molFile();
        if (mol.length() == 0) {
            return "";
        }
        return this.vwr.getInchi(null, mol, "smiles");
    }

    public String smilesFromJmol() {
        if (this.activeMol.natoms == 0) {
            return "";
        }
        String mol = this.molFile();
        if (mol.length() == 0) {
            return "";
        }
        return this.vwr.getInchi(null, mol, "smiles");
    }

    public String inchi() {
        return this.inchi("standard");
    }

    public String inchiFixedH() {
        return this.inchi("fixedH");
    }

    public String inchi(String options) {
        return this.vwr.getInchi(null, this.molFile(), options == null ? "standard" : options);
    }

    private String getMolFromSmiles(String smiles, boolean is3D) {
        System.out.println("JmolJME using SMILES " + smiles);
        String url = JC.resolveDataBase("smiles" + (is3D ? "3D" : "2D"), PT.escapeUrl(smiles), null);
        return this.vwr.getFileAsString(url);
    }

    void sorry(String msg) {
        System.err.println(msg);
        if (!this.headless) {
            JOptionPane.showMessageDialog(this, msg, "Sorry, can't do that.", 1);
        }
    }

    void say(String msg) {
        System.out.println(msg);
        this.infoText = msg;
    }

    public void to3D(boolean isAppend) {
        String smiles = this.smiles();
        if (smiles == null || smiles.length() == 0) {
            this.sorry("There was a problem generating the SMILES from the InChI");
            return;
        }
        System.out.println("using smiles from InChI: " + smiles);
        String mol = this.getMolFromSmiles(smiles, true);
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        this.vwr.openStringInlineParamsAppend(mol, htParams, isAppend);
        if (!this.headless) {
            this.parentWindow.requestFocus();
            this.vwr.refresh(1, "JmolJME");
        }
    }

    public void setFrameVisible(boolean b) {
        if (this.myFrame != null) {
            this.myFrame.setVisible(b);
        }
    }

    protected String toMOL(String filename) {
        String mol = this.molFile();
        if (filename == null) {
            return mol;
        }
        this.toFile(this.fixOutFilename(filename), mol, "txt");
        return null;
    }

    private String fixOutFilename(String filename) {
        return !this.headless ? filename : filename.replace('?', '_');
    }

    public String toSVG(String filename) {
        String svg = super.getOclSVG();
        if (filename == null) {
            return svg;
        }
        this.toFile(this.fixOutFilename(filename), svg, "txt");
        return null;
    }

    protected String toCDXML(String filename) {
        String mol = this.molFile();
        String xml = CDXMLWriter.fromString(this.vwr, "Mol", mol);
        if (filename == null) {
            return xml;
        }
        this.toFile(this.fixOutFilename(filename), xml, "txt");
        return null;
    }

    private void setFileName(String fname) {
        this.fileName = fname;
    }

    private void read2D(String fname, AtomSetCollection asc) {
        this.fileName = fname;
        this.options.reaction = false;
        JmolAdapter a = this.vwr.getModelAdapter();
        this.readAtomSet(a.getAtomIterator(asc), a.getBondIterator(asc));
    }

    protected void openMolByName(String name) {
        try {
            String mol = (String)this.vwr.setLoadFormat(false, "$$" + name, '$', true);
            mol = this.vwr.getFileAsString(mol);
            this.readMolFile(mol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readAtomSet(JmolAdapterAtomIterator atomIterator, JmolAdapterBondIterator bondIterator) {
        JMEmolList inputMolList = new JMEmolList();
        try {
            JMEmol mol = new JMEmol(null, this.params);
            JMEJmol.createJMEFromJmolAdapter(mol, atomIterator, bondIterator);
            inputMolList.add(mol);
            if (!inputMolList.isReallyEmpty()) {
                this.processIncomingMolecules(inputMolList, true);
            }
            if (this.activeMol.checkNeedsCleaning()) {
                this.say("Close atoms found; cleaning");
                this.doClean();
                this.repaint();
            }
        }
        catch (Exception e) {
            this.info(JMEJmol.makeErrorMessage(e));
        }
    }

    public static void createJMEFromJmolAdapter(JMECore mol, JmolAdapterAtomIterator atomIterator, JmolAdapterBondIterator bondIterator) {
        Hashtable<Object, Integer> atomMap = new Hashtable<Object, Integer>();
        while (atomIterator.hasNext()) {
            String sym = Elements.elementSymbolFromNumber(atomIterator.getElementNumber());
            Atom a = mol.createAtom(sym);
            atomMap.put(atomIterator.getUniqueID(), mol.natoms);
            P3d pt = atomIterator.getXYZ();
            a.x = pt.x;
            a.y = -pt.y;
            a.q = atomIterator.getFormalCharge();
            mol.setAtom(mol.natoms, JmolAdapter.getElementSymbol(atomIterator.getElement()));
        }
        block8: while (bondIterator.hasNext()) {
            Bond b = mol.createAndAddBondFromOther(null);
            b.va = (Integer)atomMap.get(bondIterator.getAtomUniqueID1());
            b.vb = (Integer)atomMap.get(bondIterator.getAtomUniqueID2());
            int bo = bondIterator.getEncodedOrder();
            switch (bo) {
                case 1025: {
                    b.bondType = 1;
                    b.stereo = 1;
                    continue block8;
                }
                case 1041: {
                    b.bondType = 1;
                    b.stereo = 2;
                    continue block8;
                }
                case 1: 
                case 513: {
                    b.bondType = 1;
                    continue block8;
                }
                case 2: 
                case 514: {
                    b.bondType = 2;
                    continue block8;
                }
                case 3: {
                    b.bondType = 3;
                    continue block8;
                }
            }
            if ((bo & 7) == 0) continue;
            b.bondType = bo & 7;
        }
        mol.finalizeMolecule();
    }

    private void read3D(String fname) {
        String mol = this.vwr.getFileAsString(fname);
        this.loadSmilesCleanly(this.getSmiles(mol));
    }

    private String getSmiles(String mol) {
        return this.vwr.getInchi(null, mol, "smiles");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object val = evt.getNewValue();
        if (val == null) {
            return;
        }
        try {
            if (name == "FileDropper.file") {
                this.readFile((String)val);
            } else if (name == "FileDropper.inline") {
                this.readDroppedData(val);
            }
        }
        catch (Throwable t) {
            System.err.println("JME couldn't load data for drop " + name);
        }
    }

    @Override
    protected void readDroppedData(Object newValue) {
        String data = newValue.toString();
        String trimmed = data.trim();
        try {
            if (trimmed.indexOf("\n") >= 0) {
                this.readMolFile(data);
            } else if (trimmed.indexOf(" ") >= 0) {
                this.readMolecule(data);
            } else {
                this.readSmiles(trimmed);
            }
            this.activeMol.center();
        }
        catch (Exception e) {
            System.err.println("JME error reading data starting with " + data.substring(Math.min(data.length(), 100)));
        }
    }

    @Override
    protected void readSmiles(String data) {
        try {
            this.readMolFile(JMEJmol.getOclAdapter().SMILEStoMOL(data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void readDroppedTextFile(String fileName) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream fis = null;
        try {
            int n;
            fis = fileName.indexOf("://") >= 0 ? new URL(fileName).openStream() : new FileInputStream(fileName);
            byte[] bytes = new byte[4096];
            while ((n = fis.read(bytes)) > 0) {
                bos.write(bytes, 0, n);
            }
            fis.close();
        }
        catch (Exception e) {
            System.err.println("JME error reading file " + fileName);
        }
        this.readDroppedData(new String(bos.toByteArray()));
    }

    void doClean() {
        if (!this.allowClean) {
            return;
        }
        String smiles = this.vwr.getInchi(null, this.molFile(), "smiles");
        this.loadSmilesCleanly(smiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmilesCleanly(String smiles) {
        if (smiles == null || smiles.length() == 0 || this.cleaning) {
            return;
        }
        System.out.println("using smiles from InChI: " + smiles);
        String mol = null;
        try {
            this.cleaning = true;
            mol = this.getMolFromSmiles(smiles, false);
            if (mol == null) {
                this.sorry("Something went wrong.");
            } else {
                this.readMolFile(mol);
            }
        }
        catch (Exception e) {
            this.sorry(e.toString());
            e.printStackTrace();
        }
        finally {
            this.cleaning = false;
        }
    }

    protected Object readFile(String fname) {
        block6: {
            try {
                this.setFileName(fname);
                File f = new File(fname);
                System.out.println("JmolJME reading file " + f.getAbsolutePath());
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fname));
                boolean isBinary = Resolver.getBinaryType(bis) != null;
                String type = this.vwr.getModelAdapter().getFileTypeName(bis);
                bis.close();
                if ("Jme".equals(type)) {
                    this.clear();
                    this.readMolecule(this.vwr.getFileAsString(fname));
                    this.activeMol.center();
                    return null;
                }
                Hashtable<String, Object> htParams = new Hashtable<String, Object>();
                htParams.put("filter", "NOH;NO3D;fileType=" + type);
                htParams.put("binary", isBinary);
                this.vwr.setLoadParameters(htParams, false);
                bis = new BufferedInputStream(new FileInputStream(fname));
                Object ret = this.vwr.getModelAdapter().getAtomSetCollectionFromReader(fname, bis, htParams);
                if (ret instanceof AtomSetCollection) {
                    AtomSetCollection asc = (AtomSetCollection)ret;
                    Map<String, Object> info = asc.getAtomSetAuxiliaryInfo(0);
                    boolean is2D = "2D".equals(info.get("dimension"));
                    this.clear();
                    if (is2D) {
                        this.read2D(fname, asc);
                    } else {
                        this.read3D(fname);
                    }
                    break block6;
                }
                this.sorry(ret.toString());
                return ret.toString();
            }
            catch (Exception e) {
                this.sorry(e.toString());
                e.printStackTrace();
                return e;
            }
        }
        this.repaint();
        System.out.println("JJME " + fname);
        return null;
    }

    private void toFile(String name, final Object bytesOrString, final String type) {
        boolean useThread;
        boolean bl = useThread = name.indexOf("?") >= 0;
        if (useThread && this.headless) {
            this.sorry("Filenames must not contain '?' in headless mode - '?' replaced with '_'");
            name = name.replace('?', '_');
            useThread = false;
        }
        final String finalName = name;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                System.out.println("JmolJME writing file " + finalName);
                boolean haveDialog = finalName.startsWith("?");
                String f = JMEJmol.this.vwr.writeFile(finalName, bytesOrString, type);
                if (haveDialog && f != null && f.indexOf("OK") == 0) {
                    int pt = f.indexOf(" ", 3);
                    if ((pt = (f = f.substring(f.indexOf(" ", pt + 1)).trim()).lastIndexOf("/")) <= 0) {
                        return;
                    }
                    f = f.substring(0, pt + 1);
                    JMEJmol.this.vwr.setStringProperty("currentLocalPath", f);
                }
                System.out.println(f);
            }
        };
        if (useThread) {
            new Thread(r).start();
        } else {
            r.run();
        }
    }

    @Override
    protected void subclassAddToCopyMenu(JPopupMenu popup, boolean hasAtom) {
        this.addMenuItem(popup, hasAtom, "Save as SVG graphic", "Jmol-saveSVG");
        this.addMenuItem(popup, hasAtom, "Save as PNG image", "Jmol-savePNG");
        this.addMenuItem(popup, hasAtom, "Save as MOL file", "Jmol-saveMOL");
        this.addMenuItem(popup, hasAtom, "Save as CDXML file", "Jmol-saveCDXML");
    }

    @Override
    protected boolean subclassHandleMenuAction(String cmd) {
        switch (cmd) {
            case "Jmol-savePNG": {
                this.toBorderedPNG("?jme.png", 10, 10);
                return true;
            }
            case "Jmol-saveSVG": {
                this.toSVG("?jme.svg");
                return true;
            }
            case "Jmol-saveMOL": {
                this.toMOL("?jme.mol");
                return true;
            }
            case "Jmol-saveCDXML": {
                this.toCDXML("?jme.cdxml");
                return true;
            }
        }
        return false;
    }

    private String getTitle() {
        return "JME-SwingJS 2D Molecular Editor" + (this.fileName == null ? "" : " " + this.fileName);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.myFrame != null) {
            this.myFrame.setVisible(false);
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void dispose() {
        this.vwr = null;
        if (this.myFrame != null) {
            this.myFrame.dispose();
        }
        this.myFrame = null;
        this.parentWindow = null;
    }

    @Override
    protected void handleAdditionalParameters() {
    }

    public static void main(String[] args) {
        JFrame frame = null;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("isApp", Boolean.TRUE);
        info.put("headless", Boolean.TRUE);
        info.put("noscripting", Boolean.TRUE);
        info.put("noDisplay", Boolean.TRUE);
        info.put("repaintManager", "NONE");
        Viewer vwr = new Viewer(info);
        JMEJmol jjme = new JMEJmol(new String[]{"$NOINIT$"});
        jjme.vwr = vwr;
        String type = null;
        boolean dostart = true;
        if (args.length > 0) {
            if (args[0].equals("headless")) {
                jjme.initialize(args);
                jjme.options("headless");
                dostart = false;
            } else if (args[0].equals("search")) {
                jjme.initialize(args);
                type = "search";
            } else if (args[0].equals("test")) {
                switch (args[1]) {
                    case "headless": {
                        jjme.initialize(args);
                        JMEJmol.testJMEHeadless(jjme);
                        dostart = false;
                        break;
                    }
                    case "data": {
                        jjme.initialize(args);
                        JMEJmol.testJmolData(jjme, args);
                        dostart = false;
                        break;
                    }
                    case "jmol": {
                        type = "jmol";
                    }
                }
            }
        }
        if (dostart) {
            JMEJmol.startJmolJME(frame, jjme, type);
        }
    }

    private static void startJmolJME(JFrame frame, JMEJmol jjme, String type) {
        JFrame embeddingFrame = null;
        if ("jmol".equals(type)) {
            embeddingFrame = new JFrame();
        } else if (!"search".equals(type) && frame == null) {
            frame = new JFrame("JmolJME Molecular Editor");
            frame.setName("JME");
            frame.setBounds(300, 200, 432, 384);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        jjme.setViewer(frame, jjme.vwr, embeddingFrame, type);
        jjme.vwr.getInchi(null, null, null);
        SwingUtilities.invokeLater(() -> {
            jjme.myFrame.setVisible(true);
            jjme.start(new String[0]);
        });
    }

    private static void testJMEHeadless(JMEJmol jjme) {
        jjme.options("headless");
        jjme.openMolByName("morphine");
        jjme.toBorderedPNG("c:/temp/test.png", 10, 10);
    }

    private static void testJmolData(JMEJmol jjme, String[] args) {
        JFrame frame = new JFrame("JmolJME Molecular Editor");
        frame.setName("JME");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        frame.setBounds(300, 200, 432, 384);
        jjme.vwr.getInchi(null, null, null);
        jjme.setViewer(frame, jjme.vwr, null, null);
        SwingUtilities.invokeLater(() -> {
            jjme.start(args);
            jjme.readFile("data/3af.cdxml");
        });
    }
}

