/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.util.A4d;
import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.T3d;
import javajs.util.V3d;

public class Qd {
    public double q0 = 1.0;
    public double q1;
    public double q2;
    public double q3;
    private M3d mat;
    private static final P4d qZero = new P4d();
    private static final double RAD_PER_DEG = Math.PI / 180;

    public static Qd newQ(Qd q) {
        Qd q1 = new Qd();
        q1.set(q);
        return q1;
    }

    public static Qd newVA(T3d v, double theta) {
        Qd q = new Qd();
        q.setTA(v, theta);
        return q;
    }

    public static Qd newM(M3d mat) {
        Qd q = new Qd();
        q.setM(M3d.newM3(mat));
        return q;
    }

    public static Qd newAA(A4d a) {
        Qd q = new Qd();
        q.setAA(a);
        return q;
    }

    public static Qd newP4(P4d pt) {
        Qd q = new Qd();
        q.setP4(pt);
        return q;
    }

    public static Qd new4(double q1, double q2, double q3, double q0) {
        Qd q = new Qd();
        if (q0 < -1.0) {
            q.q0 = -1.0;
            return q;
        }
        if (q0 > 1.0) {
            q.q0 = 1.0;
            return q;
        }
        q.q0 = q0;
        q.q1 = q1;
        q.q2 = q2;
        q.q3 = q3;
        return q;
    }

    public void set(Qd q) {
        this.q0 = q.q0;
        this.q1 = q.q1;
        this.q2 = q.q2;
        this.q3 = q.q3;
    }

    private void setP4(P4d pt) {
        double factor;
        double d = factor = pt == null ? 0.0 : pt.distance4(qZero);
        if (factor == 0.0) {
            this.q0 = 1.0;
            return;
        }
        this.q0 = pt.w / factor;
        this.q1 = pt.x / factor;
        this.q2 = pt.y / factor;
        this.q3 = pt.z / factor;
    }

    public void setTA(T3d pt, double theta) {
        if (pt.x == 0.0 && pt.y == 0.0 && pt.z == 0.0) {
            this.q0 = 1.0;
            return;
        }
        double fact = Math.sin(theta / 2.0 * (Math.PI / 180)) / Math.sqrt(pt.x * pt.x + pt.y * pt.y + pt.z * pt.z);
        this.q0 = Math.cos(theta / 2.0 * (Math.PI / 180));
        this.q1 = pt.x * fact;
        this.q2 = pt.y * fact;
        this.q3 = pt.z * fact;
    }

    public void setAA(A4d a) {
        A4d aa = A4d.newAA(a);
        if (aa.angle == 0.0) {
            aa.y = 1.0;
        }
        this.setM(new M3d().setAA(aa));
    }

    private void setM(M3d mat) {
        double z;
        double y;
        double x;
        double w;
        this.mat = mat;
        double trace = mat.m00 + mat.m11 + mat.m22;
        if (trace >= 0.5) {
            w = Math.sqrt(1.0 + trace);
            x = (mat.m21 - mat.m12) / w;
            y = (mat.m02 - mat.m20) / w;
            z = (mat.m10 - mat.m01) / w;
        } else {
            double d;
            double temp = mat.m00 + mat.m00 - trace;
            if (d >= 0.5) {
                x = Math.sqrt(1.0 + temp);
                w = (mat.m21 - mat.m12) / x;
                y = (mat.m10 + mat.m01) / x;
                z = (mat.m20 + mat.m02) / x;
            } else {
                temp = mat.m11 + mat.m11 - trace;
                if (temp >= 0.5 || mat.m11 > mat.m22) {
                    y = Math.sqrt(1.0 + temp);
                    w = (mat.m02 - mat.m20) / y;
                    x = (mat.m10 + mat.m01) / y;
                    z = (mat.m21 + mat.m12) / y;
                } else {
                    z = Math.sqrt(1.0 + mat.m22 + mat.m22 - trace);
                    w = (mat.m10 - mat.m01) / z;
                    x = (mat.m20 + mat.m02) / z;
                    y = (mat.m21 + mat.m12) / z;
                }
            }
        }
        this.q0 = w * 0.5;
        this.q1 = x * 0.5;
        this.q2 = y * 0.5;
        this.q3 = z * 0.5;
    }

    public void setRef(Qd qref) {
        if (qref == null) {
            this.mul(this.getFixFactor());
            return;
        }
        if (this.dot(qref) >= 0.0) {
            return;
        }
        this.q0 *= -1.0;
        this.q1 *= -1.0;
        this.q2 *= -1.0;
        this.q3 *= -1.0;
    }

    public static final Qd getQuaternionFrame(P3d center, T3d x, T3d xy) {
        return Qd.newFrame(center, x, xy, true);
    }

    private static Qd newFrame(P3d center, T3d vA, T3d vB, boolean doCopy) {
        if (doCopy) {
            vA = V3d.newV(vA);
            vB = V3d.newV(vB);
        }
        if (center != null) {
            vA.sub(center);
            vB.sub(center);
        }
        return Qd.getQuaternionFrameV((V3d)vA, (V3d)vB, null, false);
    }

    public static final Qd getQuaternionFrameV(V3d vA, V3d vB, V3d vC, boolean yBased) {
        if (vC == null) {
            vC = new V3d();
            vC.cross(vA, vB);
            if (yBased) {
                vA.cross(vB, vC);
            }
        }
        V3d vBprime = new V3d();
        vBprime.cross(vC, vA);
        vA.normalize();
        vBprime.normalize();
        vC.normalize();
        M3d mat = new M3d();
        mat.setColumnV(0, vA);
        mat.setColumnV(1, vBprime);
        mat.setColumnV(2, vC);
        Qd q = Qd.newM(mat);
        return q;
    }

    public M3d getMatrix() {
        if (this.mat == null) {
            this.setMatrix();
        }
        return this.mat;
    }

    private void setMatrix() {
        this.mat = new M3d();
        this.mat.m00 = this.q0 * this.q0 + this.q1 * this.q1 - this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m01 = 2.0 * this.q1 * this.q2 - 2.0 * this.q0 * this.q3;
        this.mat.m02 = 2.0 * this.q1 * this.q3 + 2.0 * this.q0 * this.q2;
        this.mat.m10 = 2.0 * this.q1 * this.q2 + 2.0 * this.q0 * this.q3;
        this.mat.m11 = this.q0 * this.q0 - this.q1 * this.q1 + this.q2 * this.q2 - this.q3 * this.q3;
        this.mat.m12 = 2.0 * this.q2 * this.q3 - 2.0 * this.q0 * this.q1;
        this.mat.m20 = 2.0 * this.q1 * this.q3 - 2.0 * this.q0 * this.q2;
        this.mat.m21 = 2.0 * this.q2 * this.q3 + 2.0 * this.q0 * this.q1;
        this.mat.m22 = this.q0 * this.q0 - this.q1 * this.q1 - this.q2 * this.q2 + this.q3 * this.q3;
    }

    public Qd add(double x) {
        return Qd.newVA(this.getNormal(), this.getTheta() + x);
    }

    public Qd mul(double x) {
        return x == 1.0 ? Qd.new4(this.q1, this.q2, this.q3, this.q0) : Qd.newVA(this.getNormal(), this.getTheta() * x);
    }

    public Qd mulQ(Qd p) {
        return Qd.new4(this.q0 * p.q1 + this.q1 * p.q0 + this.q2 * p.q3 - this.q3 * p.q2, this.q0 * p.q2 + this.q2 * p.q0 + this.q3 * p.q1 - this.q1 * p.q3, this.q0 * p.q3 + this.q3 * p.q0 + this.q1 * p.q2 - this.q2 * p.q1, this.q0 * p.q0 - this.q1 * p.q1 - this.q2 * p.q2 - this.q3 * p.q3);
    }

    public Qd div(Qd p) {
        return this.mulQ(p.inv());
    }

    public Qd divLeft(Qd p) {
        return this.inv().mulQ(p);
    }

    public double dot(Qd q) {
        return this.q0 * q.q0 + this.q1 * q.q1 + this.q2 * q.q2 + this.q3 * q.q3;
    }

    public Qd inv() {
        return Qd.new4(-this.q1, -this.q2, -this.q3, this.q0);
    }

    public Qd negate() {
        return Qd.new4(-this.q1, -this.q2, -this.q3, -this.q0);
    }

    private double getFixFactor() {
        return this.q0 < 0.0 || this.q0 == 0.0 && (this.q1 < 0.0 || this.q1 == 0.0 && (this.q2 < 0.0 || this.q2 == 0.0 && this.q3 < 0.0)) ? -1 : 1;
    }

    public V3d getVector(int i) {
        return this.getVectorScaled(i, 1.0);
    }

    public V3d getVectorScaled(int i, double scale) {
        if (i == -1) {
            return V3d.new3(this.q1 * (scale *= this.getFixFactor()), this.q2 * scale, this.q3 * scale);
        }
        if (this.mat == null) {
            this.setMatrix();
        }
        V3d v = new V3d();
        this.mat.getColumnV(i, v);
        if (scale != 1.0) {
            v.scale(scale);
        }
        return v;
    }

    public V3d getNormal() {
        V3d v = Qd.getRawNormal(this);
        v.scale(this.getFixFactor());
        return v;
    }

    private static V3d getRawNormal(Qd q) {
        V3d v = V3d.new3(q.q1, q.q2, q.q3);
        if (v.length() == 0.0) {
            return V3d.new3(0.0, 0.0, 1.0);
        }
        v.normalize();
        return v;
    }

    public double getTheta() {
        return Math.acos(Math.abs(this.q0)) * 2.0 * 180.0 / Math.PI;
    }

    public double getThetaRadians() {
        return Math.acos(Math.abs(this.q0)) * 2.0;
    }

    public V3d getNormalDirected(V3d v0) {
        V3d v = this.getNormal();
        if (v.x * v0.x + v.y * v0.y + v.z * v0.z < 0.0) {
            v.scale(-1.0);
        }
        return v;
    }

    public V3d get3dProjection(V3d v3d) {
        v3d.set(this.q1, this.q2, this.q3);
        return v3d;
    }

    public P4d getThetaDirected(P4d axisAngle) {
        double theta = this.getTheta();
        V3d v = this.getNormal();
        if (axisAngle.x * this.q1 + axisAngle.y * this.q2 + axisAngle.z * this.q3 < 0.0) {
            v.scale(-1.0);
            theta = -theta;
        }
        axisAngle.set4(v.x, v.y, v.z, theta);
        return axisAngle;
    }

    public double getThetaDirectedV(V3d vector) {
        double theta = this.getTheta();
        V3d v = this.getNormal();
        if (vector.x * this.q1 + vector.y * this.q2 + vector.z * this.q3 < 0.0) {
            v.scale(-1.0);
            theta = -theta;
        }
        return theta;
    }

    public P4d toP4d() {
        return P4d.new4(this.q1, this.q2, this.q3, this.q0);
    }

    public A4d toA4d() {
        double theta = 2.0 * Math.acos(Math.abs(this.q0));
        double sinTheta2 = Math.sin(theta / 2.0);
        V3d v = this.getNormal();
        if (sinTheta2 < 0.0) {
            v.scale(-1.0);
            theta = Math.PI - theta;
        }
        return A4d.newVA(v, theta);
    }

    public T3d transform2(T3d pt, T3d ptNew) {
        if (this.mat == null) {
            this.setMatrix();
        }
        this.mat.rotate2(pt, ptNew);
        return ptNew;
    }

    public Qd leftDifference(Qd q2) {
        Qd q2adjusted = this.dot(q2) < 0.0 ? q2.negate() : q2;
        return this.inv().mulQ(q2adjusted);
    }

    public Qd rightDifference(Qd q2) {
        Qd q2adjusted = this.dot(q2) < 0.0 ? q2.negate() : q2;
        return this.mulQ(q2adjusted.inv());
    }

    public String toString() {
        return "{" + this.q1 + " " + this.q2 + " " + this.q3 + " " + this.q0 + "}";
    }

    public static Qd[] div(Qd[] data1, Qd[] data2, int nMax, boolean isRelative) {
        int n;
        if (data1 == null || data2 == null || (n = Math.min(data1.length, data2.length)) == 0) {
            return null;
        }
        if (nMax > 0 && n > nMax) {
            n = nMax;
        }
        Qd[] dqs = new Qd[n];
        for (int i = 0; i < n; ++i) {
            if (data1[i] == null || data2[i] == null) {
                return null;
            }
            dqs[i] = isRelative ? data1[i].divLeft(data2[i]) : data1[i].div(data2[i]);
        }
        return dqs;
    }

    public static Qd sphereMean(Qd[] data, double[] retStddev, double criterion) {
        if (data == null || data.length == 0) {
            return new Qd();
        }
        if (retStddev == null) {
            retStddev = new double[1];
        }
        if (data.length == 1) {
            retStddev[0] = 0.0;
            return Qd.newQ(data[0]);
        }
        double diff = Double.MAX_VALUE;
        double lastStddev = Double.MAX_VALUE;
        Qd qMean = Qd.simpleAverage(data);
        int maxIter = 100;
        int iter = 0;
        while (diff > criterion && lastStddev != 0.0 && iter < maxIter) {
            qMean = Qd.newMean(data, qMean);
            retStddev[0] = Qd.stdDev(data, qMean);
            diff = Math.abs(retStddev[0] - lastStddev);
            lastStddev = retStddev[0];
        }
        return qMean;
    }

    private static Qd simpleAverage(Qd[] ndata) {
        V3d mean = V3d.new3(0.0, 0.0, 1.0);
        V3d v = ndata[0].getNormal();
        mean.add(v);
        int i = ndata.length;
        while (--i >= 0) {
            mean.add(ndata[i].getNormalDirected(mean));
        }
        mean.sub(v);
        mean.normalize();
        double f = 0.0;
        int i2 = ndata.length;
        while (--i2 >= 0) {
            f += Math.abs(ndata[i2].get3dProjection(v).dot(mean));
        }
        if (f != 0.0) {
            mean.scale(f / (double)ndata.length);
        }
        if (Double.isNaN(f = Math.sqrt(1.0 - mean.lengthSquared()))) {
            f = 0.0;
        }
        return Qd.newP4(P4d.new4(mean.x, mean.y, mean.z, f));
    }

    private static Qd newMean(Qd[] data, Qd mean) {
        V3d sum = new V3d();
        int i = data.length;
        while (--i >= 0) {
            Qd q = data[i];
            Qd dq = q.div(mean);
            V3d v = dq.getNormal();
            v.scale(dq.getTheta());
            sum.add(v);
        }
        sum.scale(1.0 / (double)data.length);
        Qd dqMean = Qd.newVA(sum, sum.length());
        return dqMean.mulQ(mean);
    }

    private static double stdDev(Qd[] data, Qd mean) {
        int n;
        double sum2 = 0.0;
        int i = n = data.length;
        while (--i >= 0) {
            double theta = data[i].div(mean).getTheta();
            sum2 += theta * theta;
        }
        return Math.sqrt(sum2 / (double)n);
    }

    public double[] getEulerZYZ() {
        if (this.q1 == 0.0 && this.q2 == 0.0) {
            double theta = this.getTheta();
            return new double[]{this.q3 < 0.0 ? -theta : theta, 0.0, 0.0};
        }
        double rA = Math.atan2(2.0 * (this.q2 * this.q3 + this.q0 * this.q1), 2.0 * (-this.q1 * this.q3 + this.q0 * this.q2));
        double rB = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double rG = Math.atan2(2.0 * (this.q2 * this.q3 - this.q0 * this.q1), 2.0 * (this.q0 * this.q2 + this.q1 * this.q3));
        return new double[]{rA / (Math.PI / 180), rB / (Math.PI / 180), rG / (Math.PI / 180)};
    }

    public double[] getEulerZXZ() {
        if (this.q1 == 0.0 && this.q2 == 0.0) {
            double theta = this.getTheta();
            return new double[]{this.q3 < 0.0 ? -theta : theta, 0.0, 0.0};
        }
        double rA = Math.atan2(2.0 * (this.q1 * this.q3 - this.q0 * this.q2), 2.0 * (this.q0 * this.q1 + this.q2 * this.q3));
        double rB = Math.acos(this.q3 * this.q3 - this.q2 * this.q2 - this.q1 * this.q1 + this.q0 * this.q0);
        double rG = Math.atan2(2.0 * (this.q1 * this.q3 + this.q0 * this.q2), 2.0 * (-this.q2 * this.q3 + this.q0 * this.q1));
        return new double[]{rA / (Math.PI / 180), rB / (Math.PI / 180), rG / (Math.PI / 180)};
    }
}

