/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.volume;

import com.junrar.Archive;
import com.junrar.volume.FileVolume;
import com.junrar.volume.Volume;
import com.junrar.volume.VolumeHelper;
import com.junrar.volume.VolumeManager;
import java.io.File;

public class FileVolumeManager
implements VolumeManager {
    private final File firstVolume;

    public FileVolumeManager(File firstVolume) {
        this.firstVolume = firstVolume;
    }

    @Override
    public Volume nextVolume(Archive archive, Volume last) {
        if (last == null) {
            return new FileVolume(archive, this.firstVolume);
        }
        FileVolume lastFileVolume = (FileVolume)last;
        boolean oldNumbering = !archive.getMainHeader().isNewNumbering() || archive.isOldFormat();
        String nextName = VolumeHelper.nextVolumeName(lastFileVolume.getFile().getAbsolutePath(), oldNumbering);
        File nextVolume = new File(nextName);
        return new FileVolume(archive, nextVolume);
    }
}

