/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.unpack.vm;

import com.junrar.crc.RarCRC;
import com.junrar.io.Raw;
import com.junrar.unpack.vm.BitInput;
import com.junrar.unpack.vm.VMCmdFlags;
import com.junrar.unpack.vm.VMCommands;
import com.junrar.unpack.vm.VMFlags;
import com.junrar.unpack.vm.VMOpType;
import com.junrar.unpack.vm.VMPreparedCommand;
import com.junrar.unpack.vm.VMPreparedOperand;
import com.junrar.unpack.vm.VMPreparedProgram;
import com.junrar.unpack.vm.VMStandardFilterSignature;
import com.junrar.unpack.vm.VMStandardFilters;
import java.util.List;
import java.util.Vector;

public class RarVM
extends BitInput {
    public static final int VM_MEMSIZE = 262144;
    public static final int VM_MEMMASK = 262143;
    public static final int VM_GLOBALMEMADDR = 245760;
    public static final int VM_GLOBALMEMSIZE = 8192;
    public static final int VM_FIXEDGLOBALSIZE = 64;
    private static final int regCount = 8;
    private static final long UINT_MASK = -1L;
    private byte[] mem = null;
    private final int[] R = new int[8];
    private int flags;
    private int maxOpCount = 25000000;
    private int codeSize;
    private int IP;

    public void init() {
        if (this.mem == null) {
            this.mem = new byte[262148];
        }
    }

    private boolean isVMMem(byte[] mem) {
        return this.mem == mem;
    }

    private int getValue(boolean byteMode, byte[] mem, int offset) {
        if (byteMode) {
            if (this.isVMMem(mem)) {
                return mem[offset];
            }
            return mem[offset] & 0xFF;
        }
        if (this.isVMMem(mem)) {
            return Raw.readIntLittleEndian(mem, offset);
        }
        return Raw.readIntBigEndian(mem, offset);
    }

    private void setValue(boolean byteMode, byte[] mem, int offset, int value) {
        if (byteMode) {
            mem[offset] = this.isVMMem(mem) ? (byte)value : (byte)(mem[offset] & 0 | (byte)(value & 0xFF));
        } else if (this.isVMMem(mem)) {
            Raw.writeIntLittleEndian(mem, offset, value);
        } else {
            Raw.writeIntBigEndian(mem, offset, value);
        }
    }

    public void setLowEndianValue(byte[] mem, int offset, int value) {
        Raw.writeIntLittleEndian(mem, offset, value);
    }

    public void setLowEndianValue(Vector<Byte> mem, int offset, int value) {
        mem.set(offset + 0, (byte)(value & 0xFF));
        mem.set(offset + 1, (byte)(value >>> 8 & 0xFF));
        mem.set(offset + 2, (byte)(value >>> 16 & 0xFF));
        mem.set(offset + 3, (byte)(value >>> 24 & 0xFF));
    }

    private int getOperand(VMPreparedOperand cmdOp) {
        int ret = 0;
        if (cmdOp.getType() == VMOpType.VM_OPREGMEM) {
            int pos = cmdOp.getOffset() + cmdOp.getBase() & 0x3FFFF;
            ret = Raw.readIntLittleEndian(this.mem, pos);
        } else {
            int pos = cmdOp.getOffset();
            ret = Raw.readIntLittleEndian(this.mem, pos);
        }
        return ret;
    }

    public void execute(VMPreparedProgram prg) {
        int newBlockSize;
        int newBlockPos;
        List<VMPreparedCommand> preparedCode;
        long staticSize;
        for (int i = 0; i < prg.getInitR().length; ++i) {
            this.R[i] = prg.getInitR()[i];
        }
        long globalSize = Math.min(prg.getGlobalData().size(), 8192) & 0xFFFFFFFF;
        if (globalSize != 0L) {
            int i = 0;
            while ((long)i < globalSize) {
                this.mem[245760 + i] = prg.getGlobalData().get(i);
                ++i;
            }
        }
        if ((staticSize = Math.min((long)prg.getStaticData().size(), 8192L - globalSize) & 0xFFFFFFFFFFFFFFFFL) != 0L) {
            int i = 0;
            while ((long)i < staticSize) {
                this.mem[245760 + (int)globalSize + i] = prg.getStaticData().get(i);
                ++i;
            }
        }
        this.R[7] = 262144;
        this.flags = 0;
        List<VMPreparedCommand> list = preparedCode = prg.getAltCmd().size() != 0 ? prg.getAltCmd() : prg.getCmd();
        if (!this.ExecuteCode(preparedCode, prg.getCmdCount())) {
            preparedCode.get(0).setOpCode(VMCommands.VM_RET);
        }
        if ((newBlockPos = this.getValue(false, this.mem, 245792) & 0x3FFFF) + (newBlockSize = this.getValue(false, this.mem, 245788) & 0x3FFFF) >= 262144) {
            newBlockPos = 0;
            newBlockSize = 0;
        }
        prg.setFilteredDataOffset(newBlockPos);
        prg.setFilteredDataSize(newBlockSize);
        prg.getGlobalData().clear();
        int dataSize = Math.min(this.getValue(false, this.mem, 245808), 8128);
        if (dataSize != 0) {
            prg.getGlobalData().setSize(dataSize + 64);
            for (int i = 0; i < dataSize + 64; ++i) {
                prg.getGlobalData().set(i, this.mem[245760 + i]);
            }
        }
    }

    public byte[] getMem() {
        return this.mem;
    }

    private boolean setIP(int ip) {
        if (ip >= this.codeSize) {
            return true;
        }
        if (--this.maxOpCount <= 0) {
            return false;
        }
        this.IP = ip;
        return true;
    }

    private boolean ExecuteCode(List<VMPreparedCommand> preparedCode, int cmdCount) {
        this.maxOpCount = 25000000;
        this.codeSize = cmdCount;
        this.IP = 0;
        block56: while (true) {
            VMPreparedCommand cmd = preparedCode.get(this.IP);
            int op1 = this.getOperand(cmd.getOp1());
            int op2 = this.getOperand(cmd.getOp2());
            switch (cmd.getOpCode()) {
                case VM_MOV: {
                    this.setValue(cmd.isByteMode(), this.mem, op1, this.getValue(cmd.isByteMode(), this.mem, op2));
                    break;
                }
                case VM_MOVB: {
                    this.setValue(true, this.mem, op1, this.getValue(true, this.mem, op2));
                    break;
                }
                case VM_MOVD: {
                    this.setValue(false, this.mem, op1, this.getValue(false, this.mem, op2));
                    break;
                }
                case VM_CMP: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int result = value1 - this.getValue(cmd.isByteMode(), this.mem, op2);
                    if (result == 0) {
                        this.flags = VMFlags.VM_FZ.getFlag();
                        break;
                    }
                    this.flags = result > value1 ? 1 : 0 | result & VMFlags.VM_FS.getFlag();
                    break;
                }
                case VM_CMPB: {
                    int value1 = this.getValue(true, this.mem, op1);
                    int result = value1 - this.getValue(true, this.mem, op2);
                    if (result == 0) {
                        this.flags = VMFlags.VM_FZ.getFlag();
                        break;
                    }
                    this.flags = result > value1 ? 1 : 0 | result & VMFlags.VM_FS.getFlag();
                    break;
                }
                case VM_CMPD: {
                    int value1 = this.getValue(false, this.mem, op1);
                    int result = value1 - this.getValue(false, this.mem, op2);
                    if (result == 0) {
                        this.flags = VMFlags.VM_FZ.getFlag();
                        break;
                    }
                    this.flags = result > value1 ? 1 : 0 | result & VMFlags.VM_FS.getFlag();
                    break;
                }
                case VM_ADD: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int result = (int)((long)value1 + (long)this.getValue(cmd.isByteMode(), this.mem, op2) & 0xFFFFFFFFFFFFFFFFL);
                    this.flags = cmd.isByteMode() ? ((result &= 0xFF) < value1 ? 1 : 0 | (result == 0 ? VMFlags.VM_FZ.getFlag() : ((result & 0x80) != 0 ? VMFlags.VM_FS.getFlag() : 0))) : (result < value1 ? 1 : 0 | (result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag()));
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_ADDB: {
                    this.setValue(true, this.mem, op1, (int)((long)this.getValue(true, this.mem, op1) & -1L + (long)this.getValue(true, this.mem, op2) & 0xFFFFFFFFFFFFFFFFL));
                    break;
                }
                case VM_ADDD: {
                    this.setValue(false, this.mem, op1, (int)((long)this.getValue(false, this.mem, op1) & -1L + (long)this.getValue(false, this.mem, op2) & 0xFFFFFFFFFFFFFFFFL));
                    break;
                }
                case VM_SUB: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int result = (int)((long)value1 & -1L - (long)this.getValue(cmd.isByteMode(), this.mem, op2) & 0xFFFFFFFFFFFFFFFFL);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : (result > value1 ? 1 : 0 | result & VMFlags.VM_FS.getFlag());
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_SUBB: {
                    this.setValue(true, this.mem, op1, (int)((long)this.getValue(true, this.mem, op1) & -1L - (long)this.getValue(true, this.mem, op2) & 0xFFFFFFFFFFFFFFFFL));
                    break;
                }
                case VM_SUBD: {
                    this.setValue(false, this.mem, op1, (int)((long)this.getValue(false, this.mem, op1) & -1L - (long)this.getValue(false, this.mem, op2) & 0xFFFFFFFFFFFFFFFFL));
                    break;
                }
                case VM_JZ: {
                    if ((this.flags & VMFlags.VM_FZ.getFlag()) == 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_JNZ: {
                    if ((this.flags & VMFlags.VM_FZ.getFlag()) != 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_INC: {
                    int result = (int)((long)this.getValue(cmd.isByteMode(), this.mem, op1) & 0L);
                    if (cmd.isByteMode()) {
                        result &= 0xFF;
                    }
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag();
                    break;
                }
                case VM_INCB: {
                    this.setValue(true, this.mem, op1, (int)((long)this.getValue(true, this.mem, op1) & 0L));
                    break;
                }
                case VM_INCD: {
                    this.setValue(false, this.mem, op1, (int)((long)this.getValue(false, this.mem, op1) & 0L));
                    break;
                }
                case VM_DEC: {
                    int result = (int)((long)this.getValue(cmd.isByteMode(), this.mem, op1) & 0xFFFFFFFFFFFFFFFEL);
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag();
                    break;
                }
                case VM_DECB: {
                    this.setValue(true, this.mem, op1, (int)((long)this.getValue(true, this.mem, op1) & 0xFFFFFFFFFFFFFFFEL));
                    break;
                }
                case VM_DECD: {
                    this.setValue(false, this.mem, op1, (int)((long)this.getValue(false, this.mem, op1) & 0xFFFFFFFFFFFFFFFEL));
                    break;
                }
                case VM_JMP: {
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_XOR: {
                    int result = this.getValue(cmd.isByteMode(), this.mem, op1) ^ this.getValue(cmd.isByteMode(), this.mem, op2);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag();
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_AND: {
                    int result = this.getValue(cmd.isByteMode(), this.mem, op1) & this.getValue(cmd.isByteMode(), this.mem, op2);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag();
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_OR: {
                    int result = this.getValue(cmd.isByteMode(), this.mem, op1) | this.getValue(cmd.isByteMode(), this.mem, op2);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag();
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_TEST: {
                    int result = this.getValue(cmd.isByteMode(), this.mem, op1) & this.getValue(cmd.isByteMode(), this.mem, op2);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag();
                    break;
                }
                case VM_JS: {
                    if ((this.flags & VMFlags.VM_FS.getFlag()) == 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_JNS: {
                    if ((this.flags & VMFlags.VM_FS.getFlag()) != 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_JB: {
                    if ((this.flags & VMFlags.VM_FC.getFlag()) == 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_JBE: {
                    if ((this.flags & (VMFlags.VM_FC.getFlag() | VMFlags.VM_FZ.getFlag())) == 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_JA: {
                    if ((this.flags & (VMFlags.VM_FC.getFlag() | VMFlags.VM_FZ.getFlag())) != 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_JAE: {
                    if ((this.flags & VMFlags.VM_FC.getFlag()) != 0) break;
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_PUSH: {
                    this.R[7] = this.R[7] - 4;
                    this.setValue(false, this.mem, this.R[7] & 0x3FFFF, this.getValue(false, this.mem, op1));
                    break;
                }
                case VM_POP: {
                    this.setValue(false, this.mem, op1, this.getValue(false, this.mem, this.R[7] & 0x3FFFF));
                    this.R[7] = this.R[7] + 4;
                    break;
                }
                case VM_CALL: {
                    this.R[7] = this.R[7] - 4;
                    this.setValue(false, this.mem, this.R[7] & 0x3FFFF, this.IP + 1);
                    this.setIP(this.getValue(false, this.mem, op1));
                    continue block56;
                }
                case VM_NOT: {
                    this.setValue(cmd.isByteMode(), this.mem, op1, ~this.getValue(cmd.isByteMode(), this.mem, op1));
                    break;
                }
                case VM_SHL: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int value2 = this.getValue(cmd.isByteMode(), this.mem, op2);
                    int result = value1 << value2;
                    this.flags = (result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag()) | ((value1 << value2 - 1 & Integer.MIN_VALUE) != 0 ? VMFlags.VM_FC.getFlag() : 0);
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_SHR: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int value2 = this.getValue(cmd.isByteMode(), this.mem, op2);
                    int result = value1 >>> value2;
                    this.flags = (result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag()) | value1 >>> value2 - 1 & VMFlags.VM_FC.getFlag();
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_SAR: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int value2 = this.getValue(cmd.isByteMode(), this.mem, op2);
                    int result = value1 >>> value2;
                    this.flags = (result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag()) | value1 >>> value2 - 1 & VMFlags.VM_FC.getFlag();
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_NEG: {
                    int result = -this.getValue(cmd.isByteMode(), this.mem, op1);
                    this.flags = result == 0 ? VMFlags.VM_FZ.getFlag() : VMFlags.VM_FC.getFlag() | result & VMFlags.VM_FS.getFlag();
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_NEGB: {
                    this.setValue(true, this.mem, op1, -this.getValue(true, this.mem, op1));
                    break;
                }
                case VM_NEGD: {
                    this.setValue(false, this.mem, op1, -this.getValue(false, this.mem, op1));
                    break;
                }
                case VM_PUSHA: {
                    int i = 0;
                    int SP = this.R[7] - 4;
                    while (i < 8) {
                        this.setValue(false, this.mem, SP & 0x3FFFF, this.R[i]);
                        ++i;
                        SP -= 4;
                    }
                    this.R[7] = this.R[7] - 32;
                    break;
                }
                case VM_POPA: {
                    int i = 0;
                    int SP = this.R[7];
                    while (i < 8) {
                        this.R[7 - i] = this.getValue(false, this.mem, SP & 0x3FFFF);
                        ++i;
                        SP += 4;
                    }
                    break;
                }
                case VM_PUSHF: {
                    this.R[7] = this.R[7] - 4;
                    this.setValue(false, this.mem, this.R[7] & 0x3FFFF, this.flags);
                    break;
                }
                case VM_POPF: {
                    this.flags = this.getValue(false, this.mem, this.R[7] & 0x3FFFF);
                    this.R[7] = this.R[7] + 4;
                    break;
                }
                case VM_MOVZX: {
                    this.setValue(false, this.mem, op1, this.getValue(true, this.mem, op2));
                    break;
                }
                case VM_MOVSX: {
                    this.setValue(false, this.mem, op1, (byte)this.getValue(true, this.mem, op2));
                    break;
                }
                case VM_XCHG: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    this.setValue(cmd.isByteMode(), this.mem, op1, this.getValue(cmd.isByteMode(), this.mem, op2));
                    this.setValue(cmd.isByteMode(), this.mem, op2, value1);
                    break;
                }
                case VM_MUL: {
                    int result = (int)((long)this.getValue(cmd.isByteMode(), this.mem, op1) & -1L * (long)this.getValue(cmd.isByteMode(), this.mem, op2) & 0xFFFFFFFFFFFFFFFFL & 0xFFFFFFFFFFFFFFFFL);
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_DIV: {
                    int divider = this.getValue(cmd.isByteMode(), this.mem, op2);
                    if (divider == 0) break;
                    int result = this.getValue(cmd.isByteMode(), this.mem, op1) / divider;
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_ADC: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int FC = this.flags & VMFlags.VM_FC.getFlag();
                    int result = (int)((long)value1 & -1L + (long)this.getValue(cmd.isByteMode(), this.mem, op2) & -1L + (long)FC & 0xFFFFFFFFFFFFFFFFL);
                    if (cmd.isByteMode()) {
                        result &= 0xFF;
                    }
                    this.flags = result < value1 || result == value1 && FC != 0 ? 1 : 0 | (result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag());
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_SBB: {
                    int value1 = this.getValue(cmd.isByteMode(), this.mem, op1);
                    int FC = this.flags & VMFlags.VM_FC.getFlag();
                    int result = (int)((long)value1 & -1L - (long)this.getValue(cmd.isByteMode(), this.mem, op2) & -1L - (long)FC & 0xFFFFFFFFFFFFFFFFL);
                    if (cmd.isByteMode()) {
                        result &= 0xFF;
                    }
                    this.flags = result > value1 || result == value1 && FC != 0 ? 1 : 0 | (result == 0 ? VMFlags.VM_FZ.getFlag() : result & VMFlags.VM_FS.getFlag());
                    this.setValue(cmd.isByteMode(), this.mem, op1, result);
                    break;
                }
                case VM_RET: {
                    if (this.R[7] >= 262144) {
                        return true;
                    }
                    this.setIP(this.getValue(false, this.mem, this.R[7] & 0x3FFFF));
                    this.R[7] = this.R[7] + 4;
                    continue block56;
                }
                case VM_STANDARD: {
                    this.ExecuteStandardFilter(VMStandardFilters.findFilter(cmd.getOp1().getData()));
                    break;
                }
            }
            ++this.IP;
            --this.maxOpCount;
        }
    }

    public void prepare(byte[] code, int codeSize, VMPreparedProgram prg) {
        this.InitBitInput();
        int cpLength = Math.min(32768, codeSize);
        for (int i = 0; i < cpLength; ++i) {
            int n = i;
            this.inBuf[n] = (byte)(this.inBuf[n] | code[i]);
        }
        byte xorSum = 0;
        for (int i = 1; i < codeSize; ++i) {
            xorSum = (byte)(xorSum ^ code[i]);
        }
        this.faddbits(8);
        prg.setCmdCount(0);
        if (xorSum == code[0]) {
            VMStandardFilters filterType = this.IsStandardFilter(code, codeSize);
            if (filterType != VMStandardFilters.VMSF_NONE) {
                VMPreparedCommand curCmd = new VMPreparedCommand();
                curCmd.setOpCode(VMCommands.VM_STANDARD);
                curCmd.getOp1().setData(filterType.getFilter());
                curCmd.getOp1().setType(VMOpType.VM_OPNONE);
                curCmd.getOp2().setType(VMOpType.VM_OPNONE);
                codeSize = 0;
                prg.getCmd().add(curCmd);
                prg.setCmdCount(prg.getCmdCount() + 1);
            }
            int dataFlag = this.fgetbits();
            this.faddbits(1);
            if ((dataFlag & 0x8000) != 0) {
                long dataSize = (long)RarVM.ReadData(this) & 0L;
                int i = 0;
                while (this.inAddr < codeSize && (long)i < dataSize) {
                    prg.getStaticData().add((byte)(this.fgetbits() >>> 8));
                    this.faddbits(8);
                    ++i;
                }
            }
            while (this.inAddr < codeSize) {
                VMPreparedCommand curCmd = new VMPreparedCommand();
                int data = this.fgetbits();
                if ((data & 0x8000) == 0) {
                    curCmd.setOpCode(VMCommands.findVMCommand(data >>> 12));
                    this.faddbits(4);
                } else {
                    curCmd.setOpCode(VMCommands.findVMCommand((data >>> 10) - 24));
                    this.faddbits(6);
                }
                if ((VMCmdFlags.VM_CmdFlags[curCmd.getOpCode().getVMCommand()] & 4) != 0) {
                    curCmd.setByteMode(this.fgetbits() >>> 15 == 1);
                    this.faddbits(1);
                } else {
                    curCmd.setByteMode(false);
                }
                curCmd.getOp1().setType(VMOpType.VM_OPNONE);
                curCmd.getOp2().setType(VMOpType.VM_OPNONE);
                int opNum = VMCmdFlags.VM_CmdFlags[curCmd.getOpCode().getVMCommand()] & 3;
                if (opNum > 0) {
                    this.decodeArg(curCmd.getOp1(), curCmd.isByteMode());
                    if (opNum == 2) {
                        this.decodeArg(curCmd.getOp2(), curCmd.isByteMode());
                    } else if (curCmd.getOp1().getType() == VMOpType.VM_OPINT && (VMCmdFlags.VM_CmdFlags[curCmd.getOpCode().getVMCommand()] & 0x18) != 0) {
                        int distance = curCmd.getOp1().getData();
                        if (distance >= 256) {
                            distance -= 256;
                        } else {
                            if (distance >= 136) {
                                distance -= 264;
                            } else if (distance >= 16) {
                                distance -= 8;
                            } else if (distance >= 8) {
                                distance -= 16;
                            }
                            distance += prg.getCmdCount();
                        }
                        curCmd.getOp1().setData(distance);
                    }
                }
                prg.setCmdCount(prg.getCmdCount() + 1);
                prg.getCmd().add(curCmd);
            }
        }
        VMPreparedCommand curCmd = new VMPreparedCommand();
        curCmd.setOpCode(VMCommands.VM_RET);
        curCmd.getOp1().setType(VMOpType.VM_OPNONE);
        curCmd.getOp2().setType(VMOpType.VM_OPNONE);
        prg.getCmd().add(curCmd);
        prg.setCmdCount(prg.getCmdCount() + 1);
        if (codeSize != 0) {
            this.optimize(prg);
        }
    }

    private void decodeArg(VMPreparedOperand op, boolean byteMode) {
        int data = this.fgetbits();
        if ((data & 0x8000) != 0) {
            op.setType(VMOpType.VM_OPREG);
            op.setData(data >>> 12 & 7);
            op.setOffset(op.getData());
            this.faddbits(4);
        } else if ((data & 0xC000) == 0) {
            op.setType(VMOpType.VM_OPINT);
            if (byteMode) {
                op.setData(data >>> 6 & 0xFF);
                this.faddbits(10);
            } else {
                this.faddbits(2);
                op.setData(RarVM.ReadData(this));
            }
        } else {
            op.setType(VMOpType.VM_OPREGMEM);
            if ((data & 0x2000) == 0) {
                op.setData(data >>> 10 & 7);
                op.setOffset(op.getData());
                op.setBase(0);
                this.faddbits(6);
            } else {
                if ((data & 0x1000) == 0) {
                    op.setData(data >>> 9 & 7);
                    op.setOffset(op.getData());
                    this.faddbits(7);
                } else {
                    op.setData(0);
                    this.faddbits(4);
                }
                op.setBase(RarVM.ReadData(this));
            }
        }
    }

    private void optimize(VMPreparedProgram prg) {
        List<VMPreparedCommand> commands = prg.getCmd();
        block11: for (VMPreparedCommand cmd : commands) {
            switch (cmd.getOpCode()) {
                case VM_MOV: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_MOVB : VMCommands.VM_MOVD);
                    continue block11;
                }
                case VM_CMP: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_CMPB : VMCommands.VM_CMPD);
                    continue block11;
                }
            }
            if ((VMCmdFlags.VM_CmdFlags[cmd.getOpCode().getVMCommand()] & 0x40) == 0) continue;
            boolean flagsRequired = false;
            for (int i = commands.indexOf(cmd) + 1; i < commands.size(); ++i) {
                byte flags = VMCmdFlags.VM_CmdFlags[commands.get(i).getOpCode().getVMCommand()];
                if ((flags & 0x38) != 0) {
                    flagsRequired = true;
                    break;
                }
                if ((flags & 0x40) != 0) break;
            }
            if (flagsRequired) continue;
            switch (cmd.getOpCode()) {
                case VM_ADD: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_ADDB : VMCommands.VM_ADDD);
                    continue block11;
                }
                case VM_SUB: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_SUBB : VMCommands.VM_SUBD);
                    continue block11;
                }
                case VM_INC: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_INCB : VMCommands.VM_INCD);
                    continue block11;
                }
                case VM_DEC: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_DECB : VMCommands.VM_DECD);
                    continue block11;
                }
                case VM_NEG: {
                    cmd.setOpCode(cmd.isByteMode() ? VMCommands.VM_NEGB : VMCommands.VM_NEGD);
                    continue block11;
                }
            }
        }
    }

    public static int ReadData(BitInput rarVM) {
        int data = rarVM.fgetbits();
        switch (data & 0xC000) {
            case 0: {
                rarVM.faddbits(6);
                return data >>> 10 & 0xF;
            }
            case 16384: {
                if ((data & 0x3C00) == 0) {
                    data = 0xFFFFFF00 | data >>> 2 & 0xFF;
                    rarVM.faddbits(14);
                } else {
                    data = data >>> 6 & 0xFF;
                    rarVM.faddbits(10);
                }
                return data;
            }
            case 32768: {
                rarVM.faddbits(2);
                data = rarVM.fgetbits();
                rarVM.faddbits(16);
                return data;
            }
        }
        rarVM.faddbits(2);
        data = rarVM.fgetbits() << 16;
        rarVM.faddbits(16);
        rarVM.faddbits(16);
        return data |= rarVM.fgetbits();
    }

    private VMStandardFilters IsStandardFilter(byte[] code, int codeSize) {
        VMStandardFilterSignature[] stdList = new VMStandardFilterSignature[]{new VMStandardFilterSignature(53, -1386780537, VMStandardFilters.VMSF_E8), new VMStandardFilterSignature(57, 1020781950, VMStandardFilters.VMSF_E8E9), new VMStandardFilterSignature(120, 929663295, VMStandardFilters.VMSF_ITANIUM), new VMStandardFilterSignature(29, 235276157, VMStandardFilters.VMSF_DELTA), new VMStandardFilterSignature(149, 472669640, VMStandardFilters.VMSF_RGB), new VMStandardFilterSignature(216, -1132075263, VMStandardFilters.VMSF_AUDIO), new VMStandardFilterSignature(40, 1186579808, VMStandardFilters.VMSF_UPCASE)};
        int CodeCRC = ~RarCRC.checkCrc(-1, code, 0, code.length);
        for (int i = 0; i < stdList.length; ++i) {
            if (stdList[i].getCRC() != CodeCRC || stdList[i].getLength() != code.length) continue;
            return stdList[i].getType();
        }
        return VMStandardFilters.VMSF_NONE;
    }

    private void ExecuteStandardFilter(VMStandardFilters filterType) {
        switch (filterType) {
            case VMSF_E8: 
            case VMSF_E8E9: {
                int dataSize = this.R[4];
                long fileOffset = this.R[6] & 0xFFFFFFFF;
                if (dataSize >= 245760) break;
                int fileSize = 0x1000000;
                byte cmpByte2 = (byte)(filterType == VMStandardFilters.VMSF_E8E9 ? 233 : 232);
                int curPos = 0;
                while (curPos < dataSize - 4) {
                    byte curByte;
                    if ((curByte = this.mem[curPos++]) != -24 && curByte != cmpByte2) continue;
                    long offset = (long)curPos + fileOffset;
                    long Addr = this.getValue(false, this.mem, curPos);
                    if ((Addr & Integer.MIN_VALUE) != 0L) {
                        if ((Addr + offset & Integer.MIN_VALUE) == 0L) {
                            this.setValue(false, this.mem, curPos, (int)Addr + fileSize);
                        }
                    } else if ((Addr - (long)fileSize & Integer.MIN_VALUE) != 0L) {
                        this.setValue(false, this.mem, curPos, (int)(Addr - offset));
                    }
                    curPos += 4;
                }
                break;
            }
            case VMSF_ITANIUM: {
                int dataSize = this.R[4];
                long fileOffset = this.R[6] & 0xFFFFFFFF;
                if (dataSize >= 245760) break;
                int curPos = 0;
                byte[] Masks = new byte[]{4, 4, 6, 6, 0, 0, 7, 7, 4, 4, 0, 0, 4, 4, 0, 0};
                fileOffset >>>= 4;
                while (curPos < dataSize - 21) {
                    byte cmdMask;
                    int Byte2 = (this.mem[curPos] & 0x1F) - 16;
                    if (Byte2 >= 0 && (cmdMask = Masks[Byte2]) != 0) {
                        for (int i = 0; i <= 2; ++i) {
                            int startPos;
                            int opType;
                            if ((cmdMask & 1 << i) == 0 || (opType = this.filterItanium_GetBits(curPos, (startPos = i * 41 + 5) + 37, 4)) != 5) continue;
                            int offset = this.filterItanium_GetBits(curPos, startPos + 13, 20);
                            this.filterItanium_SetBits(curPos, (int)((long)offset - fileOffset) & 0xFFFFF, startPos + 13, 20);
                        }
                    }
                    curPos += 16;
                    ++fileOffset;
                }
                break;
            }
            case VMSF_DELTA: {
                int dataSize = this.R[4] & 0xFFFFFFFF;
                int channels = this.R[0] & 0xFFFFFFFF;
                int srcPos = 0;
                int border = dataSize * 2 & 0xFFFFFFFF;
                this.setValue(false, this.mem, 245792, dataSize);
                if (dataSize >= 122880) break;
                for (int curChannel = 0; curChannel < channels; ++curChannel) {
                    byte PrevByte = 0;
                    for (int destPos = dataSize + curChannel; destPos < border; destPos += channels) {
                        this.mem[destPos] = PrevByte = (byte)(PrevByte - this.mem[srcPos++]);
                    }
                }
                break;
            }
            case VMSF_RGB: {
                int dataSize = this.R[4];
                int width = this.R[0] - 3;
                int posR = this.R[1];
                int channels = 3;
                int srcPos = 0;
                int destDataPos = dataSize;
                this.setValue(false, this.mem, 245792, dataSize);
                if (dataSize >= 122880 || posR < 0) break;
                for (int curChannel = 0; curChannel < channels; ++curChannel) {
                    long prevByte = 0L;
                    for (int i = curChannel; i < dataSize; i += channels) {
                        long predicted;
                        int upperPos = i - width;
                        if (upperPos >= 3) {
                            int upperDataPos = destDataPos + upperPos;
                            int upperByte = this.mem[upperDataPos] & 0xFF;
                            int upperLeftByte = this.mem[upperDataPos - 3] & 0xFF;
                            predicted = prevByte + (long)upperByte - (long)upperLeftByte;
                            int pa = Math.abs((int)(predicted - prevByte));
                            int pb = Math.abs((int)(predicted - (long)upperByte));
                            int pc = Math.abs((int)(predicted - (long)upperLeftByte));
                            predicted = pa <= pb && pa <= pc ? prevByte : (pb <= pc ? (long)upperByte : (long)upperLeftByte);
                        } else {
                            predicted = prevByte;
                        }
                        prevByte = predicted - (long)this.mem[srcPos++] & 0xFFL & 0xFFL;
                        this.mem[destDataPos + i] = (byte)(prevByte & 0xFFL);
                    }
                }
                int border = dataSize - 2;
                for (int i = posR; i < border; i += 3) {
                    byte G = this.mem[destDataPos + i + 1];
                    int n = destDataPos + i;
                    this.mem[n] = (byte)(this.mem[n] + G);
                    int n2 = destDataPos + i + 2;
                    this.mem[n2] = (byte)(this.mem[n2] + G);
                }
                break;
            }
            case VMSF_AUDIO: {
                int dataSize = this.R[4];
                int channels = this.R[0];
                int srcPos = 0;
                int destDataPos = dataSize;
                this.setValue(false, this.mem, 245792, dataSize);
                if (dataSize >= 122880) break;
                for (int curChannel = 0; curChannel < channels; ++curChannel) {
                    long prevByte = 0L;
                    long prevDelta = 0L;
                    long[] Dif = new long[7];
                    int D1 = 0;
                    int D2 = 0;
                    int K1 = 0;
                    int K2 = 0;
                    int K3 = 0;
                    int i = curChannel;
                    int byteCount = 0;
                    while (i < dataSize) {
                        int D3 = D2;
                        D2 = (int)prevDelta - D1;
                        D1 = (int)prevDelta;
                        long predicted = 8L * prevByte + (long)(K1 * D1) + (long)(K2 * D2) + (long)(K3 * D3);
                        predicted = predicted >>> 3 & 0xFFL;
                        long curByte = this.mem[srcPos++] & 0xFF;
                        predicted = predicted - curByte & 0xFFFFFFFFFFFFFFFFL;
                        this.mem[destDataPos + i] = (byte)predicted;
                        prevDelta = (byte)(predicted - prevByte);
                        prevByte = predicted;
                        int D = (byte)curByte << 3;
                        Dif[0] = Dif[0] + (long)Math.abs(D);
                        Dif[1] = Dif[1] + (long)Math.abs(D - D1);
                        Dif[2] = Dif[2] + (long)Math.abs(D + D1);
                        Dif[3] = Dif[3] + (long)Math.abs(D - D2);
                        Dif[4] = Dif[4] + (long)Math.abs(D + D2);
                        Dif[5] = Dif[5] + (long)Math.abs(D - D3);
                        Dif[6] = Dif[6] + (long)Math.abs(D + D3);
                        if ((byteCount & 0x1F) == 0) {
                            long minDif = Dif[0];
                            long numMinDif = 0L;
                            Dif[0] = 0L;
                            for (int j = 1; j < Dif.length; ++j) {
                                if (Dif[j] < minDif) {
                                    minDif = Dif[j];
                                    numMinDif = j;
                                }
                                Dif[j] = 0L;
                            }
                            switch ((int)numMinDif) {
                                case 1: {
                                    if (K1 < -16) break;
                                    --K1;
                                    break;
                                }
                                case 2: {
                                    if (K1 >= 16) break;
                                    ++K1;
                                    break;
                                }
                                case 3: {
                                    if (K2 < -16) break;
                                    --K2;
                                    break;
                                }
                                case 4: {
                                    if (K2 >= 16) break;
                                    ++K2;
                                    break;
                                }
                                case 5: {
                                    if (K3 < -16) break;
                                    --K3;
                                    break;
                                }
                                case 6: {
                                    if (K3 >= 16) break;
                                    ++K3;
                                }
                            }
                        }
                        i += channels;
                        ++byteCount;
                    }
                }
                break;
            }
            case VMSF_UPCASE: {
                int dataSize = this.R[4];
                int srcPos = 0;
                int destPos = dataSize;
                if (dataSize >= 122880) break;
                while (srcPos < dataSize) {
                    byte curByte;
                    if ((curByte = this.mem[srcPos++]) == 2 && (curByte = this.mem[srcPos++]) != 2) {
                        curByte = (byte)(curByte - 32);
                    }
                    this.mem[destPos++] = curByte;
                }
                this.setValue(false, this.mem, 245788, destPos - dataSize);
                this.setValue(false, this.mem, 245792, dataSize);
            }
        }
    }

    private void filterItanium_SetBits(int curPos, int bitField, int bitPos, int bitCount) {
        int inAddr = bitPos / 8;
        int inBit = bitPos & 7;
        int andMask = -1 >>> 32 - bitCount;
        andMask = ~(andMask << inBit);
        bitField <<= inBit;
        for (int i = 0; i < 4; ++i) {
            int n = curPos + inAddr + i;
            this.mem[n] = (byte)(this.mem[n] & andMask);
            int n2 = curPos + inAddr + i;
            this.mem[n2] = (byte)(this.mem[n2] | bitField);
            andMask = andMask >>> 8 | 0xFF000000;
            bitField >>>= 8;
        }
    }

    private int filterItanium_GetBits(int curPos, int bitPos, int bitCount) {
        int inAddr = bitPos / 8;
        int inBit = bitPos & 7;
        int bitField = this.mem[curPos + inAddr++] & 0xFF;
        bitField |= (this.mem[curPos + inAddr++] & 0xFF) << 8;
        bitField |= (this.mem[curPos + inAddr++] & 0xFF) << 16;
        bitField |= (this.mem[curPos + inAddr] & 0xFF) << 24;
        return (bitField >>>= inBit) & -1 >>> 32 - bitCount;
    }

    public void setMemory(int pos, byte[] data, int offset, int dataSize) {
        if (pos < 262144) {
            for (int i = 0; i < Math.min(data.length - offset, dataSize) && 262144 - pos >= i; ++i) {
                this.mem[pos + i] = data[offset + i];
            }
        }
    }
}

