/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.rarfile;

import com.junrar.io.Raw;
import com.junrar.rarfile.SubBlockHeader;

public class UnixOwnersHeader
extends SubBlockHeader {
    private int ownerNameSize;
    private int groupNameSize;
    private String owner;
    private String group;

    public UnixOwnersHeader(SubBlockHeader sb, byte[] uoHeader) {
        super(sb);
        int pos = 0;
        this.ownerNameSize = Raw.readShortLittleEndian(uoHeader, pos) & 0xFFFF;
        this.groupNameSize = Raw.readShortLittleEndian(uoHeader, pos += 2) & 0xFFFF;
        if ((pos += 2) + this.ownerNameSize < uoHeader.length) {
            this.owner = new String(uoHeader, pos, this.ownerNameSize);
        }
        if ((pos += this.ownerNameSize) + this.groupNameSize < uoHeader.length) {
            this.group = new String(uoHeader, pos, this.groupNameSize);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getGroupNameSize() {
        return this.groupNameSize;
    }

    public void setGroupNameSize(int groupNameSize) {
        this.groupNameSize = groupNameSize;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getOwnerNameSize() {
        return this.ownerNameSize;
    }

    public void setOwnerNameSize(int ownerNameSize) {
        this.ownerNameSize = ownerNameSize;
    }

    @Override
    public void print() {
        super.print();
    }
}

