/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.rarfile;

import com.junrar.exception.CorruptHeaderException;
import com.junrar.io.Raw;
import com.junrar.rarfile.BlockHeader;
import com.junrar.rarfile.FileNameDecoder;
import com.junrar.rarfile.HostSystem;
import com.junrar.rarfile.NewSubHeaderType;
import com.junrar.rarfile.UnrarHeadertype;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class FileHeader
extends BlockHeader {
    private static final byte SALT_SIZE = 8;
    private static final byte NEWLHD_SIZE = 32;
    private static final long NANOS_PER_UNIT = 100L;
    private final long unpSize;
    private final HostSystem hostOS;
    private final int fileCRC;
    private byte unpVersion;
    private byte unpMethod;
    private short nameSize;
    private final int highPackSize;
    private int highUnpackSize;
    private final byte[] fileNameBytes;
    private String fileName;
    private String fileNameW;
    private byte[] subData;
    private final byte[] salt = new byte[8];
    private FileTime mTime;
    private FileTime cTime;
    private FileTime aTime;
    private FileTime arcTime;
    private long fullPackSize;
    private long fullUnpackSize;
    private int fileAttr;
    private int subFlags;
    private int recoverySectors = -1;

    public FileHeader(BlockHeader bh, byte[] fileHeader) throws CorruptHeaderException {
        super(bh);
        int position = 0;
        this.unpSize = Raw.readIntLittleEndianAsLong(fileHeader, position);
        position += 4;
        this.hostOS = HostSystem.findHostSystem(fileHeader[4]);
        this.fileCRC = Raw.readIntLittleEndian(fileHeader, ++position);
        int fileTime = Raw.readIntLittleEndian(fileHeader, position += 4);
        position += 4;
        this.unpVersion = (byte)(this.unpVersion | fileHeader[13] & 0xFF);
        ++position;
        this.unpMethod = (byte)(this.unpMethod | fileHeader[14] & 0xFF);
        this.nameSize = Raw.readShortLittleEndian(fileHeader, ++position);
        this.fileAttr = Raw.readIntLittleEndian(fileHeader, position += 2);
        position += 4;
        if (this.isLargeBlock()) {
            this.highPackSize = Raw.readIntLittleEndian(fileHeader, position);
            this.highUnpackSize = Raw.readIntLittleEndian(fileHeader, position += 4);
            position += 4;
        } else {
            this.highPackSize = 0;
            this.highUnpackSize = 0;
            if (this.unpSize == -1L) {
                this.highUnpackSize = Integer.MAX_VALUE;
            }
        }
        this.fullPackSize |= (long)this.highPackSize;
        this.fullPackSize <<= 32;
        this.fullPackSize |= this.getPackSize();
        this.fullUnpackSize |= (long)this.highUnpackSize;
        this.fullUnpackSize <<= 32;
        this.fullUnpackSize += this.unpSize;
        this.nameSize = (short)(this.nameSize > 4096 ? 4096 : (int)this.nameSize);
        if (this.nameSize <= 0) {
            throw new CorruptHeaderException("Invalid file name with negative size");
        }
        this.fileNameBytes = new byte[this.nameSize];
        System.arraycopy(fileHeader, position, this.fileNameBytes, 0, this.nameSize);
        position += this.nameSize;
        if (this.isFileHeader()) {
            if (this.isUnicode()) {
                int length;
                for (length = 0; length < this.fileNameBytes.length && this.fileNameBytes[length] != 0; ++length) {
                }
                this.fileName = new String(this.fileNameBytes, 0, length);
                this.fileNameW = length != this.nameSize ? FileNameDecoder.decode(this.fileNameBytes, ++length) : "";
            } else {
                this.fileName = new String(this.fileNameBytes);
                this.fileNameW = "";
            }
            if (!FileHeader.isFilenameValid(this.getFileName())) {
                throw new CorruptHeaderException("Invalid filename: " + this.getFileName());
            }
        }
        if (UnrarHeadertype.NewSubHeader.equals(this.headerType)) {
            int datasize = this.headerSize - 32 - this.nameSize;
            if (this.hasSalt()) {
                datasize -= 8;
            }
            if (datasize > 0) {
                this.subData = new byte[datasize];
                for (int i = 0; i < datasize; ++i) {
                    this.subData[i] = fileHeader[position];
                    ++position;
                }
            }
            if (NewSubHeaderType.SUBHEAD_TYPE_RR.byteEquals(this.fileNameBytes)) {
                this.recoverySectors = (this.subData[8] & 0xFF) + ((this.subData[9] & 0xFF) << 8) + ((this.subData[10] & 0xFF) << 16) + ((this.subData[11] & 0xFF) << 24);
            }
        }
        if (this.hasSalt()) {
            for (int i = 0; i < 8; ++i) {
                this.salt[i] = fileHeader[position];
                ++position;
            }
        }
        this.mTime = FileTime.fromMillis(FileHeader.getDateDos(fileTime));
        if (this.hasExtTime()) {
            short extTimeFlags;
            if (position + 1 < fileHeader.length) {
                extTimeFlags = Raw.readShortLittleEndian(fileHeader, position);
                position += 2;
            } else {
                extTimeFlags = 0;
            }
            TimePositionTuple mTimeTuple = FileHeader.parseExtTime(12, extTimeFlags, fileHeader, position, this.mTime);
            this.mTime = mTimeTuple.time;
            position = mTimeTuple.position;
            TimePositionTuple cTimeTuple = FileHeader.parseExtTime(8, extTimeFlags, fileHeader, position);
            this.cTime = cTimeTuple.time;
            position = cTimeTuple.position;
            TimePositionTuple aTimeTuple = FileHeader.parseExtTime(4, extTimeFlags, fileHeader, position);
            this.aTime = aTimeTuple.time;
            position = aTimeTuple.position;
            TimePositionTuple arcTimeTuple = FileHeader.parseExtTime(0, extTimeFlags, fileHeader, position);
            this.arcTime = arcTimeTuple.time;
            position = arcTimeTuple.position;
        }
    }

    private static boolean isFilenameValid(String filename) {
        try {
            new File(filename).getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static TimePositionTuple parseExtTime(int shift, short flags, byte[] fileHeader, int position) {
        return FileHeader.parseExtTime(shift, flags, fileHeader, position, null);
    }

    private static TimePositionTuple parseExtTime(int shift, short flags, byte[] fileHeader, int position, FileTime baseTime) {
        int flag = flags >>> shift;
        if ((flag & 8) != 0) {
            long seconds;
            if (baseTime != null) {
                seconds = baseTime.to(TimeUnit.SECONDS);
            } else {
                seconds = TimeUnit.MILLISECONDS.toSeconds(FileHeader.getDateDos(Raw.readIntLittleEndian(fileHeader, position)));
                position += 4;
            }
            int count = flag & 3;
            long remainder = 0L;
            for (int i = 0; i < count; ++i) {
                int b = fileHeader[position] & 0xFF;
                remainder = (long)(b << 16) | remainder >>> 8;
                ++position;
            }
            long nanos = remainder * 100L;
            if ((flag & 4) != 0) {
                nanos += TimeUnit.SECONDS.toNanos(1L);
            }
            FileTime time = FileTime.from(Instant.ofEpochSecond(seconds, nanos));
            return new TimePositionTuple(position, time);
        }
        return new TimePositionTuple(position, baseTime);
    }

    @Override
    public void print() {
        super.print();
    }

    private static long getDateDos(int time) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (time >>> 25) + 1980);
        cal.set(2, (time >>> 21 & 0xF) - 1);
        cal.set(5, time >>> 16 & 0x1F);
        cal.set(11, time >>> 11 & 0x1F);
        cal.set(12, time >>> 5 & 0x3F);
        cal.set(13, (time & 0x1F) * 2);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    private static Date toDate(FileTime time) {
        return time != null ? new Date(time.toMillis()) : null;
    }

    private static FileTime toFileTime(Date time) {
        return time != null ? FileTime.fromMillis(time.getTime()) : null;
    }

    public FileTime getArchivalTime() {
        return this.arcTime;
    }

    public void setArchivalTime(FileTime archivalTime) {
        this.arcTime = archivalTime;
    }

    public Date getArcTime() {
        return FileHeader.toDate(this.getArchivalTime());
    }

    public void setArcTime(Date arcTime) {
        this.setArchivalTime(FileHeader.toFileTime(arcTime));
    }

    public FileTime getLastAccessTime() {
        return this.aTime;
    }

    public void setLastAccessTime(FileTime time) {
        this.aTime = time;
    }

    public Date getATime() {
        return FileHeader.toDate(this.getLastAccessTime());
    }

    public void setATime(Date time) {
        this.setLastAccessTime(FileHeader.toFileTime(time));
    }

    public FileTime getCreationTime() {
        return this.cTime;
    }

    public void setCreationTime(FileTime time) {
        this.cTime = time;
    }

    public Date getCTime() {
        return FileHeader.toDate(this.getCreationTime());
    }

    public void setCTime(Date time) {
        this.setCreationTime(FileHeader.toFileTime(time));
    }

    public int getFileAttr() {
        return this.fileAttr;
    }

    public void setFileAttr(int fileAttr) {
        this.fileAttr = fileAttr;
    }

    public int getFileCRC() {
        return this.fileCRC;
    }

    public byte[] getFileNameByteArray() {
        return this.fileNameBytes;
    }

    @Deprecated
    public String getFileNameString() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Deprecated
    public String getFileNameW() {
        return this.fileNameW;
    }

    public void setFileNameW(String fileNameW) {
        this.fileNameW = fileNameW;
    }

    public int getHighPackSize() {
        return this.highPackSize;
    }

    public int getHighUnpackSize() {
        return this.highUnpackSize;
    }

    public HostSystem getHostOS() {
        return this.hostOS;
    }

    public FileTime getLastModifiedTime() {
        return this.mTime;
    }

    public void setLastModifiedTime(FileTime time) {
        this.mTime = time;
    }

    public Date getMTime() {
        return FileHeader.toDate(this.getLastModifiedTime());
    }

    public void setMTime(Date time) {
        this.setLastModifiedTime(FileHeader.toFileTime(time));
    }

    public short getNameSize() {
        return this.nameSize;
    }

    public int getRecoverySectors() {
        return this.recoverySectors;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getSubData() {
        return this.subData;
    }

    public int getSubFlags() {
        return this.subFlags;
    }

    public byte getUnpMethod() {
        return this.unpMethod;
    }

    public long getUnpSize() {
        return this.unpSize;
    }

    public byte getUnpVersion() {
        return this.unpVersion;
    }

    public long getFullPackSize() {
        return this.fullPackSize;
    }

    public long getFullUnpackSize() {
        return this.fullUnpackSize;
    }

    public String toString() {
        return super.toString();
    }

    public boolean isSplitAfter() {
        return (this.flags & 2) != 0;
    }

    public boolean isSplitBefore() {
        return (this.flags & 1) != 0;
    }

    public boolean isSolid() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isEncrypted() {
        return (this.flags & 4) != 0;
    }

    public boolean isUnicode() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isFileHeader() {
        return UnrarHeadertype.FileHeader.equals(this.headerType);
    }

    public boolean hasSalt() {
        return (this.flags & 0x400) != 0;
    }

    public boolean hasExtTime() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean isLargeBlock() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isDirectory() {
        return (this.flags & 0xE0) == 224;
    }

    public String getFileName() {
        return this.isUnicode() && this.fileNameW != null && !this.fileNameW.isEmpty() ? this.fileNameW : this.fileName;
    }

    private static final class TimePositionTuple {
        private final int position;
        private final FileTime time;

        private TimePositionTuple(int position, FileTime time) {
            this.position = position;
            this.time = time;
        }
    }
}

