/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.nmrml;

import com.integratedgraphics.ifd.vendor.NMRVendorPlugin;
import com.integratedgraphics.ifd.vendor.nmrml.NmrMLHeader;
import java.util.HashMap;
import java.util.Map;
import org.iupac.fairdata.common.IFDConst;
import org.nmrml.parser.Acqu;

public abstract class NmrMLIFDVendorPlugin
extends NMRVendorPlugin {
    private static Map<String, String> ifdMap = new HashMap<String, String>();

    protected void report(String key, Object val) {
        this.addProperty(ifdMap.get(key), val);
    }

    protected void setParams(NmrMLHeader header, Acqu acq) {
        this.reportVendor();
        this.report("DIM", header.getDimension() + "D");
        double freq = acq.getTransmiterFreq();
        this.report("F1", freq);
        String nuc = NmrMLIFDVendorPlugin.fixNucleus(acq.getObservedNucleus());
        this.report("N1", nuc);
        this.report("SF", NmrMLIFDVendorPlugin.getNominalFrequency(freq, nuc));
        this.report("SOLVENT", NmrMLIFDVendorPlugin.fixSolvent(acq.getSolvent()));
        this.report("TEMPERATURE", acq.getTemperature());
        this.report("PP", acq.getPulseProgram());
        this.report("PROBE", acq.getProbehead());
        this.report("TIMESTAMP", header.getCreationTime());
        this.addProperty("Comment", header.getComment());
        this.addProperty("Title", header.getTitle());
        this.report("TITLE", header.getTitle());
    }

    static {
        String[] keys = new String[]{"DIM", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_DIMENSION"), "F1", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_1"), "F2", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_2"), "F3", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_3"), "N1", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_1"), "N2", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_2"), "N3", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_3"), "PP", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_PULSE_PROGRAM"), "SOLVENT", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_SOLVENT"), "SF", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.INSTR_NOMINAL_FREQ"), "PROBE", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.INSTR_PROBE_TYPE"), "TEMPERATURE", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_ABSOLUTE_TEMPERATURE"), "TIMESTAMP", IFDConst.IFD_PROPERTY_DATAOBJECT_TIMESTAMP, "TITLE", NmrMLIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_TITLE")};
        int i = 0;
        while (i < keys.length) {
            ifdMap.put(keys[i++], keys[i++]);
        }
    }
}

