/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor.mestrelab;

import com.integratedgraphics.ifd.vendor.NMRVendorPlugin;
import com.integratedgraphics.ifd.vendor.mestrelab.MNovaMetadataReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.extract.MetadataReceiverI;

public class MestrelabIFDVendorPlugin
extends NMRVendorPlugin {
    private static Map<String, String> ifdMap;
    private String mnovaVersion;
    private Globals pageGlobals = new Globals();
    private Map<String, Object> params;
    private int page = 0;
    private String originPath;
    private List<Map<String, Object>> pageList;

    public MestrelabIFDVendorPlugin() {
        this.paramRegex = "\\.mnova[^/]*$";
    }

    @Override
    public String accept(MetadataReceiverI extractor, String originPath, byte[] bytes) {
        super.accept(extractor, originPath, bytes);
        try {
            this.page = 0;
            this.params = null;
            this.pageList = new ArrayList<Map<String, Object>>();
            MNovaMetadataReader reader = new MNovaMetadataReader(this, bytes);
            this.originPath = originPath;
            boolean haveMetadata = reader.process();
            if (this.page > 0 && haveMetadata) {
                this.finalizeParams();
                int nPages = this.pageList.size();
                boolean sendNewPage = nPages > 1;
                for (int i = 0; i < nPages; ++i) {
                    Map<String, Object> params = this.pageList.get(i);
                    this.reportVendor();
                    for (Map.Entry<String, Object> p : params.entrySet()) {
                        String key = p.getKey();
                        boolean isNewPage = key.equals("*NEW_PAGE*");
                        boolean isSpecialKey = key.startsWith("_");
                        if (!(isSpecialKey ? key.startsWith("_struc.") : sendNewPage || !isNewPage)) continue;
                        this.report(key, p.getValue());
                    }
                }
                this.close();
                this.report("*NEW_PAGE*", "\u0001");
                return this.processRepresentation(null, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getVendorName() {
        return (this.pageGlobals.origin == null ? "" : this.pageGlobals.origin + "/") + "Mestrelab";
    }

    @Override
    public String processRepresentation(String originPath, byte[] bytes) {
        return IFD_REP_DATAOBJECT_FAIRSPEC_NMR_VENDOR_DATASET;
    }

    void addParam(String key, Object oval, MNovaMetadataReader.Param param1, MNovaMetadataReader.Param param2) {
        if (param1 != null) {
            oval = param1.value == null || param1.value.length() == 0 ? param1.calc : param1.value;
        }
        String key0 = key;
        String propName = null;
        if (oval instanceof String) {
            String val = (String)oval;
            if (oval == null || val.length() == 0 || val.charAt(0) == '=') {
                return;
            }
            val = val.trim();
            oval = val;
            try {
                switch (key) {
                    case "Owner": {
                        return;
                    }
                    case "_struc.png:css": {
                        this.pageGlobals.pngcss = val;
                        return;
                    }
                    case "Origin": {
                        oval = this.pageGlobals.setOrigin(val);
                        break;
                    }
                    case "Acquisition Date": {
                        propName = "TIMESTAMP";
                        oval = FAIRSpecUtilities.rep(val, "\n", " ").trim();
                        break;
                    }
                    case "Comment": {
                        propName = "TITLE";
                    }
                    default: {
                        oval = FAIRSpecUtilities.rep(val, "\n", " ").trim();
                        break;
                    }
                    case "Purity": {
                        break;
                    }
                    case "Data File Name": {
                        this.pageGlobals.isJDF = val.endsWith(".jdf");
                        return;
                    }
                    case "Temperature": {
                        double d = Double.parseDouble(val);
                        if (this.pageGlobals.isJDF) {
                            d += 273.15;
                        }
                        oval = d;
                        break;
                    }
                    case "Nucleus": {
                        this.pageGlobals.nuc1 = val;
                        if (param2 != null) {
                            this.params.put("Nucleus2", param2.value);
                        }
                        break;
                    }
                    case "Spectrometer Frequency": {
                        this.pageGlobals.freq = Double.parseDouble(val);
                        oval = this.pageGlobals.freq;
                        if (param2 != null) {
                            this.params.put("Spectrometer Frequency2", Double.valueOf(param2.value));
                        }
                        break;
                    }
                    case "Spectrum Quality": {
                        double q = Double.parseDouble(val);
                        if (q != 0.0) {
                            oval = q;
                        }
                        break;
                    }
                    case "Pulse Width": 
                    case "Spectral Width": 
                    case "Receiver Gain": 
                    case "Relaxation Delay": 
                    case "Lowest Frequency": 
                    case "Acquisition Time": {
                        oval = Double.parseDouble(val);
                        break;
                    }
                    case "Spectral Size": {
                        oval = Integer.parseInt(val);
                        if (param2 != null) {
                            this.pageGlobals.dim = 2;
                        }
                        break;
                    }
                    case "Number of Scans": 
                    case "Acquired Size": {
                        oval = Integer.parseInt(val);
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (oval == null) {
            return;
        }
        switch (key) {
            case "_struc.png": {
                oval = new Object[]{oval, this.originPath + "#page" + this.page + ".png", this.pageGlobals.pngcss};
                break;
            }
            case "_struc.cdx": {
                oval = new Object[]{oval, this.originPath + "#page" + this.page + ".cdx", null, null};
                break;
            }
            case "_struc.cdxml": {
                oval = new Object[]{oval, this.originPath + "#page" + this.page + ".cdxml", null, null};
                break;
            }
            case "_struc.mol": {
                oval = new Object[]{oval, this.originPath + "#page" + this.page + ".mol", null, null};
            }
        }
        if (propName != null) {
            this.params.put(ifdMap.get(propName), oval);
        }
        this.params.put(key, oval);
        System.out.println("----------- MNova page " + this.page + " " + key + " = " + oval + " was " + key0 + " " + param1 + (param2 == null ? "" : "/ " + param2));
    }

    void newPage(int page) {
        this.page = page;
        this.finalizeParams();
        this.params = new LinkedHashMap<String, Object>();
        this.params.put("*NEW_PAGE*", "_page=" + page);
        this.pageGlobals = new Globals();
        this.pageList.add(this.params);
        System.out.println("MestrelabIFDVendor ------------ page " + page);
    }

    int getPage() {
        return this.page;
    }

    protected void report(String key, Object val) {
        String k = ifdMap.get(key);
        if (k == null && key.equals("Page_Header")) {
            this.addProperty(IFDConst.IFD_PROPERTY_DESCRIPTION, val);
            this.addProperty("*idf.property.compound.id.source*", val);
        }
        if (!key.startsWith("!")) {
            this.addProperty(key, val);
        }
        if (k != null) {
            this.addProperty(k, val);
        }
    }

    private void close() {
        System.out.println("MestreLabIFDVendorPlugin done " + this.page + " pages for " + this.originPath + "\n=============================================\n");
        this.finalizeParams();
        this.page = 0;
    }

    private void finalizeParams() {
        if (this.params != null && this.pageGlobals.freq != 0.0) {
            int f = MestrelabIFDVendorPlugin.getNominalFrequency(this.pageGlobals.freq, this.pageGlobals.nuc1);
            this.params.put("!SF", f);
            this.params.put("!DIM", Integer.valueOf(this.pageGlobals.dim) + "D");
            this.params.put("mnovaVersion", this.mnovaVersion);
        }
        this.params = null;
    }

    void setVersion(String mnovaVersion) {
        this.mnovaVersion = mnovaVersion;
    }

    static {
        MestrelabIFDVendorPlugin.register(MestrelabIFDVendorPlugin.class);
        ifdMap = new HashMap<String, String>();
        String[] keys = new String[]{"Pulse Sequence", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_PULSE_PROGRAM"), "Solvent", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_SOLVENT"), "Probe", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.INSTR_PROBE_TYPE"), "Temperature", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_ABSOLUTE_TEMPERATURE"), "DIM", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_DIMENSION"), "TITLE", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_TITLE"), "Spectrometer Frequency", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_1"), "Spectrometer Frequency2", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_2"), "Spectrometer Frequency3", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_FREQ_3"), "Nucleus", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_1"), "Nucleus2", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_2"), "Nucleus3", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.EXPT_NUCL_3"), "SF", MestrelabIFDVendorPlugin.getProp("IFD_PROPERTY_DATAOBJECT_FAIRSPEC_NMR.INSTR_NOMINAL_FREQ"), "TIMESTAMP", IFDConst.IFD_PROPERTY_DATAOBJECT_TIMESTAMP};
        int i = 0;
        while (i < keys.length) {
            ifdMap.put(keys[i++], keys[i++]);
        }
    }

    private class Globals {
        private String pngcss;
        private boolean isJDF;
        private String nuc1;
        private double freq;
        private String origin;
        public int dim = 1;

        private Globals() {
        }

        private String setOrigin(String val) {
            this.origin = FAIRSpecUtilities.rep(val, "\n", " ").trim();
            int pt = this.origin.indexOf(" ");
            if (pt >= 0) {
                this.origin = this.origin.substring(0, pt);
            }
            return this.origin;
        }
    }
}

