/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.ifd.vendor;

import com.integratedgraphics.ifd.api.VendorPluginI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jspecview.source.JDXDataObject;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.extract.MetadataReceiverI;
import org.jmol.util.Elements;

public abstract class DefaultVendorPlugin
implements VendorPluginI {
    private static final String rezipPathHeader = "^(?<path#>.+(?:/|\\|)(?<dir#>[^/]+)(?:/|\\|))";
    protected MetadataReceiverI extractor;
    protected String paramRegex = "IFD_METADATA$";
    protected String rezipRegex;
    protected boolean rezipping;
    protected boolean enabled;
    private int index;
    private static Pattern nucPat = Pattern.compile("(^[^\\d]*)(\\d+)([^\\d]*)$");

    protected static void register(Class<? extends DefaultVendorPlugin> c) {
        VendorPluginI.registerIFDVendorPlugin(c);
    }

    protected abstract void reportVendor();

    protected DefaultVendorPlugin() {
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getParamRegex() {
        return this.paramRegex;
    }

    @Override
    public String getRezipRegex() {
        return this.rezipRegex == null ? null : rezipPathHeader.replace("#", "" + this.index) + this.rezipRegex;
    }

    @Override
    public String getRezipPrefix(String dirName) {
        return null;
    }

    @Override
    public String accept(MetadataReceiverI extractor, String originPath, byte[] bytes) {
        if (extractor != null) {
            this.extractor = extractor;
        }
        return this.processRepresentation(null, null);
    }

    @Override
    public boolean doExtract(String entryName) {
        return true;
    }

    @Override
    public void startRezip(MetadataReceiverI extractor) {
        this.extractor = extractor;
        this.reportVendor();
        this.rezipping = true;
    }

    protected static String getProp(String name) {
        return IFDConst.getProp(name);
    }

    @Override
    public void endRezip() {
        this.rezipping = false;
        this.extractor = null;
    }

    @Override
    public boolean doRezipInclude(MetadataReceiverI extractor, String zipfileName, String entryName) {
        return true;
    }

    public void addProperty(String key, Object val) {
        if (val == null || this.extractor == null) {
            return;
        }
        if (val instanceof Double) {
            if (Double.isNaN((Double)val)) {
                return;
            }
        } else if (val instanceof String && val != "\u0001") {
            val = ((String)val).trim();
        }
        this.extractor.addProperty(key, val);
    }

    protected static boolean isUnsignedInteger(String s) {
        int i = s.length();
        while (--i >= 0) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getDelimitedString(Map<String, String> map, String key, char c0, char c1) {
        int n;
        String val = map.get(key);
        return val == null || (n = val.length()) < 3 || val.charAt(0) != c0 || val.charAt(n - 1) != c1 ? null : val.substring(1, val.length() - 1).trim();
    }

    protected static double getDoubleValue(Map<String, String> map, String key) {
        String f = map.get(key);
        try {
            return f == null ? Double.NaN : Double.valueOf(f);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public static String fixNucleus(String nuc) {
        Matcher m = nucPat.matcher(nuc);
        if (m.find()) {
            String sn = m.group(2);
            String el = m.group(1);
            String string = el = el.length() == 0 ? m.group(3) : el;
            if (el.length() > 2) {
                int an = Elements.elementNumberFromName(el);
                if ((el = Elements.elementSymbolFromNumber(an)) != null) {
                    nuc = el;
                }
            } else {
                nuc = el;
            }
            if (nuc.length() == 2) {
                nuc = nuc.substring(0, 1).toUpperCase() + nuc.substring(1).toLowerCase();
            }
            nuc = sn + nuc;
        }
        return nuc;
    }

    public static String fixSolvent(String solvent) {
        return solvent;
    }

    public static int getNominalFrequency(double freq, String nuc) {
        return JDXDataObject.getNominalSpecFreq(nuc, freq);
    }

    @Override
    public Object[] getExtractTypeInfo(MetadataReceiverI extractor, String baseName, String entryName) {
        return null;
    }
}

