/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.ExtractorUtils;
import com.integratedgraphics.extractor.IFDExtractorLayer2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundAssociation;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundCollection;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDRepresentableObject;
import org.iupac.fairdata.core.IFDRepresentation;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.dataobject.IFDDataObjectCollection;
import org.iupac.fairdata.util.IFDDefaultJSONSerializer;

abstract class IFDExtractorLayer3
extends IFDExtractorLayer2 {
    private List<FAIRSpecExtractorHelper.FileList> rootLists;
    private String resourceList;

    IFDExtractorLayer3() {
    }

    protected String processPhase3() throws IFDException, IOException {
        this.phase3aUpdateCachedRepresentations();
        this.checkStopAfter("3a");
        if (this.insitu) {
            this.phase3bSetInSitu(this.helper.getStructureCollection());
            this.phase3bSetInSitu(this.helper.getSpecCollection());
        } else {
            this.phase3bRemoveUnmanifestedRepresentations();
        }
        this.checkStopAfter("3b");
        this.phase3cCheckForDuplicateSpecData();
        this.helper.removeInvalidData();
        this.checkStopAfter("3c");
        this.writeRootManifests();
        String msg = this.helper.finalizeExtraction(this.htURLReferences);
        this.log(msg);
        String serializedFA = this.phase3SerializeFindingAid();
        return serializedFA;
    }

    private void phase3bSetInSitu(IFDCollection<IFDRepresentableObject<?>> c) {
        for (IFDRepresentableObject iFDRepresentableObject : c) {
            for (IFDRepresentation r : iFDRepresentableObject) {
                r.setInSitu();
            }
        }
    }

    private IFDSerializerI getSerializer() {
        return new IFDDefaultJSONSerializer(this.isByID);
    }

    private void outputListJSON(String name, File file) throws IOException {
        int[] ret = new int[1];
        String json = this.helper.getFileListJSON(name, this.rootLists, this.resourceList, this.extractScriptFile.getName(), ret);
        this.writeBytesToFile(json.getBytes(), file);
        this.log("!saved " + file + " (" + ret[0] + " items)");
    }

    private void phase3cCheckForDuplicateSpecData() {
        BitSet bs = new BitSet();
        FAIRSpecCompoundCollection ssc = this.faHelper.getCompoundCollection();
        boolean isFound = false;
        boolean doRemove = false;
        int n = 0;
        HashMap<Integer, IFDAssociation> map = new HashMap<Integer, IFDAssociation>();
        for (IFDAssociation assoc : ssc) {
            IFDDataObjectCollection c = ((FAIRSpecCompoundAssociation)assoc).getDataObjectCollection();
            ArrayList<IFDDataObject> found = new ArrayList<IFDDataObject>();
            for (IFDRepresentableObject spec : c) {
                int i = spec.getIndex();
                if (bs.get(i)) {
                    found.add((IFDDataObject)spec);
                    this.log("! Extractor found duplicate DataObject reference " + spec + " for " + assoc.getFirstObj1() + " in " + assoc + " and " + map.get(i) + " template order needs changing? ");
                    isFound = true;
                    continue;
                }
                bs.set(i);
                map.put(i, assoc);
            }
            n += found.size();
            if (found.size() <= 0 || !doRemove) continue;
            c.removeAll(found);
        }
        if (isFound && doRemove && (n += this.helper.removeStructuresWithNoAssociations()) > 0) {
            this.log("! " + n + " objects removed");
        }
    }

    private void phase3bRemoveUnmanifestedRepresentations() {
        int n;
        boolean isRemoved = false;
        for (IFDRepresentableObject spec : this.faHelper.getSpecCollection()) {
            ArrayList<IFDRepresentation> lstRepRemoved = new ArrayList<IFDRepresentation>();
            for (Object o : spec) {
                IFDRepresentation rep = (IFDRepresentation)o;
                if (this.setLocalFileLength(rep) != 0L) continue;
                lstRepRemoved.add(rep);
            }
            spec.removeAll(lstRepRemoved);
            if (spec.size() != 0) continue;
            spec.setValid(false);
            isRemoved = true;
        }
        if (isRemoved && (n = this.helper.removeStructuresWithNoAssociations()) > 0) {
            this.log("!" + n + " objects with no representations removed");
        }
    }

    private String phase3SerializeFindingAid() throws IOException {
        this.log("!Extractor.extractAndCreateFindingAid serializing...");
        ArrayList products = this.rootPaths;
        IFDSerializerI ser = this.getSerializer();
        if (this.createZippedCollection && this.rootPaths != null) {
            products.add(new File(this.targetDir + "/_IFD_extract.json"));
            products.add(new File(this.targetDir + "/_IFD_ignored.json"));
            products.add(new File(this.targetDir + "/_IFD_manifest.json"));
        }
        long[] times = new long[3];
        String serializedFindingAid = this.faHelper.createSerialization((File)(this.readOnly && !this.createFindingAidOnly ? null : this.targetDir), this.createZippedCollection ? products : null, ser, times);
        this.log("!Extractor serialization done " + times[0] + " " + times[1] + " " + times[2] + " ms " + serializedFindingAid.length() + " bytes");
        return serializedFindingAid;
    }

    private void phase3aUpdateCachedRepresentations() {
        for (String ckey : this.vendorCache.keySet()) {
            ExtractorUtils.CacheRepresentation r = (ExtractorUtils.CacheRepresentation)this.vendorCache.get(ckey);
            IFDRepresentableObject<?> obj = this.getObjectFromLocalizedName(ckey, null);
            if (obj == null || !r.isValid) {
                String path = r.getRef().getOriginPath().toString();
                if (!r.isValid) continue;
                this.logDigitalItemIgnored(path, ckey, "it was never associated with an object", "addCachedRepresentationsToObjects");
                try {
                    this.addFileToFileLists(path, 1, r.getLength(), null);
                }
                catch (IOException iOException) {}
                continue;
            }
            String originPath = r.getRef().getOriginPath().toString();
            String type = r.getType();
            String mediatype = r.getMediaType();
            int pt = ckey.indexOf(0);
            String localName = pt > 0 ? ckey.substring(0, pt) : ckey;
            IFDRepresentation r1 = obj.findOrAddRepresentation(r.getRef().getResourceID(), originPath, r.getRef().getlocalDir(), localName, r.getData(), type, null);
            if (type != null && r1.getType() == null) {
                r1.setType(type);
            }
            if (mediatype != null && r1.getMediaType() == null) {
                r1.setMediaType(mediatype);
            }
            if (r1.getLength() != 0L) continue;
            r1.setLength(r.getLength());
        }
    }

    private void writeRootManifests() throws IOException {
        this.resourceList = "";
        this.rootLists = new ArrayList<FAIRSpecExtractorHelper.FileList>();
        for (ExtractorUtils.ExtractorResource r : this.htResources.values()) {
            this.resourceList = this.resourceList + ";" + r.getSourceFile();
            this.rootLists.add(r.lstManifest);
            this.rootLists.add(r.lstIgnored);
        }
        this.resourceList = this.resourceList.substring(1);
        int nign = FAIRSpecExtractorHelper.FileList.getListCount(this.rootLists, "ignored");
        int nrej = FAIRSpecExtractorHelper.FileList.getListCount(this.rootLists, "rejected");
        if (this.noOutput) {
            if (nign > 0) {
                this.logWarn("ignored " + nign + " files", "writeRootManifests");
            }
            if (nrej > 0) {
                this.logWarn("rejected " + nrej + " files", "writeRootManifests");
            }
        } else {
            File f = new File(this.targetDir + "/_IFD_extract.json");
            this.writeBytesToFile(this.extractScript.getBytes(), f);
            this.outputListJSON("manifest", new File(this.targetDir + "/_IFD_manifest.json"));
            if (nign > 0) {
                this.outputListJSON("ignored", new File(this.targetDir + "/_IFD_ignored.json"));
            }
            if (nrej > 0) {
                this.outputListJSON("rejected", new File(this.targetDir + "/_IFD_rejected.json"));
            }
        }
    }
}

