/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.IFDExtractor;
import com.integratedgraphics.zip.ZipInputStream;
import com.junrar.Archive;
import com.junrar.exception.RarException;
import com.junrar.rarfile.FileHeader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.core.IFDReference;
import org.iupac.fairdata.core.IFDRepresentation;
import org.iupac.fairdata.util.ZipUtil;

public class ExtractorUtils {

    public static class CacheRepresentation
    extends IFDRepresentation {
        protected String rezipOrigin;
        public boolean isMultiple;
        public boolean isValid = true;

        public CacheRepresentation(IFDReference ifdReference, Object o, long len, String type, String subtype) {
            super(ifdReference, o, len, type, subtype);
        }

        public void setRezipOrigin(String path) {
            this.rezipOrigin = path;
        }

        public Object getRezipOrigin() {
            return this.rezipOrigin;
        }

        public void setIsMultiple() {
            this.isMultiple = true;
        }

        public boolean isMultiple() {
            return this.isMultiple;
        }
    }

    public static class AWrap {
        private byte[] a;

        public void setBytes(byte[] bytes) {
            this.a = bytes;
        }

        public boolean equals(Object o) {
            AWrap b = (AWrap)o;
            return Arrays.equals(this.a, b.a);
        }

        public int hashCode() {
            return Arrays.hashCode(this.a);
        }
    }

    public static class ExtractorResource {
        private int id;
        private int tempID;
        private String source;
        private String localSourceFile;
        public String rootPath;
        public FAIRSpecExtractorHelper.FileList lstManifest;
        public FAIRSpecExtractorHelper.FileList lstIgnored;
        public FAIRSpecExtractorHelper.FileList lstAccepted;

        public ExtractorResource(int id, String source) {
            this.id = id;
            this.source = source;
        }

        public String getLocalSourceFileName() {
            return this.localSourceFile;
        }

        public void setLocalSourceFileName(String name) {
            this.localSourceFile = name;
        }

        public void setLists(String rootPath, String ignore, String accept) {
            if (this.lstManifest != null) {
                return;
            }
            this.lstManifest = new FAIRSpecExtractorHelper.FileList(rootPath, "manifest", null);
            this.lstIgnored = new FAIRSpecExtractorHelper.FileList(rootPath, "ignored", null);
            this.lstAccepted = new FAIRSpecExtractorHelper.FileList(rootPath, "accepted", null);
            if (ignore != null) {
                this.lstIgnored.setAcceptPattern(ignore);
            }
            if (accept != null) {
                this.lstAccepted.setAcceptPattern(accept);
            }
        }

        public String toString() {
            return "[ExtractorSource " + this.getSourceFile() + " => " + this.rootPath + "]";
        }

        public String getSourceFile() {
            return this.localSourceFile == null ? this.source : this.localSourceFile;
        }

        public void setTemp(String name) {
            this.localSourceFile = name;
            this.tempID = this.id;
        }

        public boolean isTempFile() {
            return this.tempID > 0;
        }

        public String createZipRootPath(String zipPath) {
            String rootPath;
            if (this.rootPath != null) {
                return this.rootPath;
            }
            if (this.tempID > 0) {
                zipPath = "resource" + this.tempID;
            }
            if ((rootPath = new File(zipPath).getName()).endsWith(".zip") || rootPath.endsWith(".tgz") || rootPath.endsWith(".rar") || rootPath.endsWith(".tar")) {
                rootPath = rootPath.substring(0, rootPath.length() - 4);
            } else if (rootPath.endsWith(".tar.gz")) {
                rootPath = rootPath.substring(0, rootPath.length() - 7);
            }
            this.rootPath = rootPath;
            return rootPath;
        }

        public String getRemoteSource() {
            return this.source == null ? this.localSourceFile : this.source;
        }
    }

    public static class ArchiveInputStream
    extends InputStream {
        private ZipInputStream zis;
        private TarArchiveInputStream tis;
        private InputStream is;
        private DirectoryInputStream dis;
        private RARInputStream ris;

        protected ArchiveInputStream() throws IOException {
            this(null, null);
        }

        ArchiveInputStream(InputStream is, String fname) throws IOException {
            if (is instanceof ArchiveInputStream) {
                is = new BufferedInputStream(((ArchiveInputStream)is).getStream());
            }
            if (is instanceof DirectoryInputStream) {
                this.dis = (DirectoryInputStream)is;
                this.is = this.dis;
                this.dis.reset();
            } else if (is instanceof ZipInputStream) {
                this.is = is;
            } else if (ZipUtil.isZipS(is)) {
                this.zis = new ZipInputStream(is);
                this.is = this.zis;
            } else if (ZipUtil.isGzipS(is)) {
                this.tis = ZipUtil.newTarGZInputStream(is);
                this.is = this.tis;
            } else if (fname != null && fname.endsWith(".tar")) {
                this.tis = ZipUtil.newTarInputStream(is);
                this.is = this.tis;
            } else if (fname != null && fname.endsWith(".rar")) {
                this.ris = new RARInputStream(is);
                this.is = this.ris;
            }
        }

        protected ArchiveEntry getNextEntry() throws IOException {
            if (this.ris != null) {
                return this.ris.getNextEntry();
            }
            if (this.tis != null) {
                TarArchiveEntry te = this.tis.getNextTarEntry();
                return te == null ? null : new ArchiveEntry(te);
            }
            if (this.zis != null) {
                try {
                    ZipEntry ze = this.zis.getNextEntry();
                    return ze == null ? null : new ArchiveEntry(ze);
                }
                catch (ZipException e) {
                    return new ArchiveEntry();
                }
            }
            if (this.dis != null) {
                return this.dis.getNextEntry();
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            if (this.dis != null) {
                this.dis.close();
            }
            if (this.is != null) {
                this.is.close();
            }
        }

        protected InputStream getStream() {
            return this.is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.is.read(b, off, len);
            }
            catch (IOException e) {
                this.is.read(b, off, len);
                throw e;
            }
        }
    }

    static class RARArchiveEntry
    extends ArchiveEntry {
        private BufferedInputStream is;
        private FileHeader fh;
        private Archive rar;

        protected RARArchiveEntry(Archive rar, FileHeader fh) {
            super(fh);
            this.rar = rar;
            this.fh = fh;
        }

        public void close() {
            this.fh = null;
        }

        public BufferedInputStream getInputStream() throws IOException {
            if (this.is == null) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    this.rar.extractFile(this.fh, bos);
                    byte[] bytes = bos.toByteArray();
                    bos.close();
                    this.is = new BufferedInputStream(new ByteArrayInputStream(bytes));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            return this.is;
        }
    }

    public static class RARInputStream
    extends InputStream {
        private Archive rar;
        private List<FileHeader> rarList = new ArrayList<FileHeader>();
        private int rarPt = 0;
        private RARArchiveEntry entry;

        public RARInputStream(InputStream is) throws IOException {
            FileHeader fh;
            try {
                this.rar = new Archive(is);
            }
            catch (RarException | IOException e) {
                throw new IOException(e);
            }
            ArrayList<FileHeader> list = new ArrayList<FileHeader>();
            while ((fh = this.rar.nextFileHeader()) != null) {
                list.add(fh);
            }
            list.sort(new Comparator<FileHeader>(){

                @Override
                public int compare(FileHeader o1, FileHeader o2) {
                    return o1.getFileName().compareTo(o2.getFileName());
                }
            });
            this.rarList = list;
            this.reset();
        }

        @Override
        public void reset() {
            this.rarPt = 0;
        }

        @Override
        public int read() throws IOException {
            return this.entry == null ? -1 : this.entry.getInputStream().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.entry == null ? -1 : this.entry.getInputStream().read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.closeEntry();
            super.close();
        }

        protected RARArchiveEntry getNextEntry() throws FileNotFoundException {
            this.closeEntry();
            if (this.rarPt >= this.rarList.size()) {
                return null;
            }
            this.entry = new RARArchiveEntry(this.rar, this.rarList.get(this.rarPt++));
            return this.entry;
        }

        protected void closeEntry() {
            if (this.entry != null) {
                this.entry.close();
                this.entry = null;
            }
        }
    }

    public static class DirectoryInputStream
    extends InputStream {
        File dir;
        int offset;
        DirIterator iter;
        protected DirectoryEntry entry;

        public DirectoryInputStream(String dir) {
            if (dir.startsWith("file:/")) {
                dir = dir.substring(6);
            }
            this.dir = new File(dir);
            this.offset = this.dir.getAbsolutePath().length() + 1;
            this.reset();
        }

        @Override
        public void reset() {
            this.iter = new DirIterator(this.dir);
            if (this.iter.hasNext()) {
                this.iter.next();
            }
        }

        @Override
        public int read() throws IOException {
            return this.entry == null ? -1 : this.entry.getInputStream().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.entry == null ? -1 : this.entry.getInputStream().read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.closeEntry();
            this.iter = null;
        }

        protected ArchiveEntry getNextEntry() throws FileNotFoundException {
            this.closeEntry();
            if (!this.iter.hasNext()) {
                return null;
            }
            File f = this.iter.next();
            String name = f.getAbsolutePath().substring(this.offset);
            this.entry = new DirectoryEntry(name, f);
            return this.entry;
        }

        protected void closeEntry() {
            if (this.entry != null) {
                this.entry.close();
                this.entry = null;
            }
        }
    }

    public static class DirIterator
    implements Iterator<File> {
        protected File dir;
        protected File[] list;
        protected int pt = -1;
        protected int n;
        protected DirIterator iter;

        DirIterator(File dir) {
            this.dir = dir;
            this.list = dir.listFiles();
            this.n = this.list.length;
        }

        @Override
        public boolean hasNext() {
            return this.pt < this.n || this.iter != null && this.iter.hasNext();
        }

        @Override
        public File next() {
            File f;
            if (this.iter != null) {
                if (this.iter.hasNext()) {
                    return this.iter.next();
                }
                this.iter = null;
            }
            if (this.pt < 0) {
                this.pt = 0;
                f = this.dir;
            } else if ((f = this.list[this.pt++]).isDirectory()) {
                this.iter = new DirIterator(f);
                return this.iter.next();
            }
            return f;
        }
    }

    public static class DirectoryEntry
    extends ArchiveEntry {
        protected File file;
        protected boolean isDir;
        protected BufferedInputStream bis;

        public DirectoryEntry(String name, File file) {
            super(null, 0L);
            this.file = file;
            this.isDir = file.isDirectory();
            this.name = name.replace('\\', '/') + (this.isDir ? "/" : "");
            this.size = this.isDir ? 0L : file.length();
        }

        protected BufferedInputStream getInputStream() throws FileNotFoundException {
            return this.bis != null ? this.bis : (this.isDir ? null : (this.bis = new BufferedInputStream(new FileInputStream(this.file))));
        }

        protected void close() {
            if (this.bis != null) {
                try {
                    this.bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ArchiveEntry {
        protected String name;
        protected long size;

        protected ArchiveEntry(String name, long size) {
            this.name = name;
            this.size = size;
        }

        protected ArchiveEntry(ZipEntry ze) {
            this.name = ze.getName();
            this.size = ze.getSize();
        }

        protected ArchiveEntry(TarArchiveEntry te) {
            this.name = te.getName();
            this.size = te.getSize();
        }

        protected ArchiveEntry(FileHeader fh) {
            this.name = fh.getFileName();
            this.name = this.name.replace('\\', '/');
            if (fh.isDirectory() && !this.name.endsWith("/")) {
                this.name = this.name + "/";
            }
            this.size = fh.getUnpSize();
        }

        protected ArchiveEntry(String name) {
            this.name = name;
        }

        public ArchiveEntry() {
        }

        protected boolean isDirectory() {
            return this.name.endsWith("/");
        }

        protected String getName() {
            return this.name;
        }

        protected long getSize() {
            return this.size;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ObjectParser {
        private static final String REGEX_QUOTE = "\\Q";
        private static final String REGEX_UNQUOTE = "\\E";
        private static final String REGEX_ANY_NOT_PIPE_OR_DIR = "\\E[^|/]+\\Q";
        private static final String REGEX_KEYDEF_START = "\\E(?<";
        private static final String REGEX_KEYVAL_START = "\\E\\k<";
        private static final String REGEX_KV_END = ">\\Q";
        private static final String REGEX_END_PARENS = "\\E)\\Q";
        private static final String REGEX_EMPTY_QUOTE = "\\Q\\E";
        private static final String RAW_REGEX_TAG = "{regex::";
        private static final char TEMP_RAW_IN_CHAR = '\u0000';
        private static final char TEMP_RAW_OUT_CHAR = '\u0001';
        private static final char TEMP_STAR_CHAR = '\u0002';
        private static final char TEMP_KEYVAL_IN_CHAR = '\u0003';
        private static final char TEMP_KEYVAL_OUT_CHAR = '\u0004';
        private static final char TEMP_ANY_SEP_ANY_CHAR = '\u0005';
        private static final char TEMP_ANY_SEP_ANY_CHAR2 = '\u0006';
        private static final char TEMP_IGNORE = '\u0007';
        private static final String TEMP_KEYVAL_IN = "\\E(?\u0003";
        private static final String TEMP_KEYVAL_OUT = "\u0004\\Q";
        private static final String TEMP_ANY_SEP_ANY_GROUPS = "\\E([^|/\u0005]+(?:\u0006[^|/\u0005]+)+)\\Q";
        private static final String TEMP_ANY_DIRECTORIES = "\\E(?:[^|/]+/)\u0002\\Q";
        private static final char BACK_SLASH_IGNORED = '\\';
        private static int parserCount;
        private final int index;
        private String sData;
        private Pattern p;
        private List<String> regexList;
        private Map<String, String> keys;
        private ExtractorResource dataSource;
        private IFDExtractor extractor;
        private boolean hasData;
        private List<Object> replacements;
        private ArrayList<String> keyList;

        public int getIndex() {
            return this.index;
        }

        public ObjectParser(IFDExtractor extractor, ExtractorResource resource, String sObj) throws IFDException {
            this.extractor = extractor;
            this.index = parserCount++;
            this.dataSource = resource;
            this.sData = sObj.substring(sObj.charAt(0) == '|' ? 1 : 0);
            this.init();
        }

        private void init() throws IFDException {
            String s = this.protectRegex(null);
            s = s.replace('\\', '\u0007');
            if ((s = FAIRSpecUtilities.rep(s, "**/", TEMP_ANY_DIRECTORIES)).indexOf("*") != s.lastIndexOf("*")) {
                Matcher m;
                while ((m = IFDExtractor.pStarDotStar.matcher(s)).find()) {
                    String schar = m.group(1);
                    char c = schar.charAt(0);
                    s = FAIRSpecUtilities.rep(s, "*" + schar + "*", TEMP_ANY_SEP_ANY_GROUPS.replaceAll("\u0006", "\\\\Q" + c + "\\\\E").replace('\u0005', c));
                }
            }
            s = FAIRSpecUtilities.rep(s, "*", REGEX_ANY_NOT_PIPE_OR_DIR);
            s = this.compileIFDDefs(s, true, true);
            s = s.replace('\u0002', '*');
            s = "^\\Q" + this.protectRegex(s) + REGEX_UNQUOTE + "$";
            s = FAIRSpecUtilities.rep(s, REGEX_EMPTY_QUOTE, "");
            s = FAIRSpecUtilities.rep(s, "\u0007", "");
            this.extractor.log("!Extractor.ObjectParser pattern: " + s);
            this.p = Pattern.compile(s);
        }

        private String compileIFDDefs(String s, boolean isFull, boolean replaceK) throws IFDException {
            Matcher m;
            while (s.indexOf("::") >= 0 && (m = IFDExtractor.objectDefPattern.matcher(s)).find()) {
                int pt;
                String param = m.group(1);
                String val = m.group(2);
                String pv = "{" + param + "::" + val + "}";
                if (val.indexOf("::") >= 0) {
                    val = this.compileIFDDefs(val, false, replaceK);
                }
                if ((pt = param.indexOf("=")) == 0) {
                    throw new IFDException("bad {def=key::val} expression: " + param + "::" + val);
                }
                if (this.keys == null) {
                    this.keys = new LinkedHashMap<String, String>();
                }
                String key = null;
                if (pt > 0) {
                    key = param.substring(0, pt);
                    param = param.substring(pt + 1);
                }
                param = FAIRSpecFindingAidHelper.updateKey(param);
                if (key == null) {
                    key = param.replace('.', '0').replace('_', '1');
                }
                this.keys.put(key, param);
                String bk = "{" + key + "}";
                if (s.indexOf(bk) >= 0) {
                    s = FAIRSpecUtilities.rep(s, bk, "<" + key + ">");
                }
                s = FAIRSpecUtilities.rep(s, pv, (replaceK ? TEMP_KEYVAL_IN + key + TEMP_KEYVAL_OUT : REGEX_KEYDEF_START + key + REGEX_KV_END) + val + REGEX_END_PARENS);
            }
            if (isFull && (s.indexOf("<") >= 0 || s.indexOf(3) >= 0)) {
                s = FAIRSpecUtilities.rep(s, "<", REGEX_KEYVAL_START);
                s = FAIRSpecUtilities.rep(s, ">", REGEX_KV_END).replace('\u0003', '<').replace('\u0004', '>');
            }
            return s;
        }

        private String protectRegex(String s) throws IFDException {
            if (this.sData.indexOf(RAW_REGEX_TAG) < 0) {
                return s == null ? this.sData : s;
            }
            if (s == null) {
                s = this.sData;
                this.regexList = new ArrayList<String>();
                int[] pt = new int[1];
                int i = 0;
                while ((pt[0] = s.indexOf(RAW_REGEX_TAG)) >= 0) {
                    int p0 = pt[0];
                    String rx = ObjectParser.getIFDExtractValue(s, "regex", pt);
                    this.regexList.add(REGEX_UNQUOTE + rx + REGEX_QUOTE);
                    s = s.substring(0, p0) + '\u0000' + i++ + '\u0001' + s.substring(pt[0]);
                }
            } else {
                int p;
                while ((p = s.indexOf(0)) >= 0) {
                    int p2 = s.indexOf(1);
                    int i = Integer.parseInt(s.substring(p + 1, p2));
                    s = s.substring(0, p) + this.regexList.get(i) + s.substring(p2 + 1);
                }
            }
            return s;
        }

        protected static String getIFDExtractValue(String sObj, String key, int[] pt) throws IFDException {
            int p;
            key = "{" + key + "::";
            if (pt == null) {
                pt = new int[1];
            }
            if ((p = sObj.indexOf(key, pt[0])) < 0) {
                return null;
            }
            int q = -1;
            int nBrace = 1;
            int len = sObj.length();
            block4: for (int i = p += key.length(); i < len && nBrace > 0; ++i) {
                switch (sObj.charAt(i)) {
                    case '{': {
                        q = i;
                        ++nBrace;
                        continue block4;
                    }
                    case '}': {
                        if (--nBrace < 0) {
                            throw new IFDException("unopened '}' in " + sObj + " at char " + i);
                        }
                        q = i;
                    }
                }
            }
            if (nBrace > 0) {
                throw new IFDException("unclosed '{' in " + sObj + " at char " + q);
            }
            pt[0] = q;
            int n = pt[0];
            pt[0] = n + 1;
            return sObj.substring(p, n);
        }

        public String toString() {
            return "[ObjectParser " + this.sData + "]";
        }

        public Matcher match(String origin) throws IFDException {
            if (this.replacements != null) {
                try {
                    int i = this.replacements.size();
                    while (--i >= 0) {
                        List sub = (List)this.replacements.get(i);
                        origin = FAIRSpecUtilities.rep(origin, (String)sub.get(0), (String)sub.get(1));
                    }
                }
                catch (Exception e) {
                    throw new IFDException("Error in subsitution for sub: " + e);
                }
            }
            return this.p.matcher(origin);
        }

        public void setReplacements(List<Object> replacements) {
            this.replacements = replacements;
        }

        public ExtractorResource getDataSource() {
            return this.dataSource;
        }

        public String getStringData() {
            return this.sData;
        }

        public boolean hasData() {
            return this.hasData;
        }

        public Map<String, String> getKeys() {
            return this.keys;
        }

        public void setHasData(boolean b) {
            this.hasData = b;
        }

        public List<String> getKeyList() {
            if (this.keyList == null) {
                this.keyList = new ArrayList();
                for (String key : this.getKeys().keySet()) {
                    this.keyList.add(key);
                }
            }
            return this.keyList;
        }
    }
}

