/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.util.JSJSONParser;

public class DOIInfoExtractor {
    public static final String CROSSREF = "Crossref";
    public static final String DATACITE = "DataCite";
    public static final String crossciteURL = "https://data.crosscite.org/application/vnd.datacite.datacite+json/";
    public static final String crossrefURL = "https://api.crossref.org/works/";
    public static final String DOI_ORG = "https://doi.org/";

    public static String getMetadataUrl(String puburi, String type) {
        if (puburi != null && puburi.startsWith(DOI_ORG)) {
            switch (type) {
                case "Crossref": {
                    return crossrefURL + puburi.substring(16);
                }
                case "DataCite": {
                    return crossciteURL + puburi.substring(16);
                }
            }
        }
        return null;
    }

    public static Map<String, Object> getPubInfo(String uri, boolean addPublicationMetadata, String agency) throws IOException {
        if (uri == null) {
            return null;
        }
        String url = null;
        url = DOIInfoExtractor.getMetadataUrl(uri, agency);
        if (url == null) {
            System.out.println("PubInfoExtractor: unknown type " + agency + " should be one of '" + DATACITE + "' or '" + CROSSREF + "' for " + uri);
            return null;
        }
        System.out.println("PubInfoExtractor: " + url);
        Map<String, Object> metadata = new JSJSONParser().parseMap(FAIRSpecUtilities.getURLContentsAsString(url), false);
        System.out.println("PubInfoExtractor: " + (metadata == null ? "no metadata" : "extracted " + metadata.entrySet().size() + " metadata items"));
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        try {
            if (metadata != null) {
                switch (agency) {
                    case "Crossref": {
                        DOIInfoExtractor.extractCrossRefInfo(info, metadata);
                        break;
                    }
                    case "DataCite": {
                        DOIInfoExtractor.extractCrossCiteInfo(info, metadata);
                    }
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("registrationAgency", agency);
                map.put("metadataUrl", url);
                if (addPublicationMetadata) {
                    map.put("metadata", metadata);
                }
                DOIInfoExtractor.put(info, "metadataSource", map);
            }
        }
        catch (Throwable t) {
            System.err.println(t);
            info = null;
        }
        return info;
    }

    public static void extractCrossRefInfo(Map<String, Object> info, Map<String, Object> json) {
        info.clear();
        Map<String, Object> message = DOIInfoExtractor.getMap(json, "message");
        String title = DOIInfoExtractor.getValue(message, "title", null);
        if (title != null && title.startsWith("[") && title.endsWith("]")) {
            title = title.substring(1, title.length() - 1);
        }
        DOIInfoExtractor.put(info, "title", title);
        String doi = (String)DOIInfoExtractor.getObject(message, "DOI");
        List<Object> author = DOIInfoExtractor.getList(message, "author");
        String s = "";
        if (author != null) {
            for (int i = 0; i < author.size(); ++i) {
                Map au = (Map)author.get(i);
                String name = DOIInfoExtractor.getValue(au, "given", "") + " " + DOIInfoExtractor.getValue(au, "family", "");
                s = s + ", " + name;
                String orcid = DOIInfoExtractor.getValue(au, "ORCID", null);
                if (orcid == null) continue;
                s = s + " (" + orcid.replace("http:", "https:") + ")";
            }
        }
        if (s.length() > 0) {
            DOIInfoExtractor.put(info, "authors", s.substring(2));
        }
        DOIInfoExtractor.put(info, "doi", doi);
        DOIInfoExtractor.put(info, "doiLink", DOI_ORG + doi);
        DOIInfoExtractor.put(info, "url", ((Map)DOIInfoExtractor.getList(message, "link").get(0)).get("URL"));
    }

    public static void extractCrossCiteInfo(Map<String, Object> info, Map<String, Object> crossCite) {
        DOIInfoExtractor.put(info, "dataTitle", ((Map)DOIInfoExtractor.getList(crossCite, "titles").get(0)).get("title"));
        String s = "";
        List<Object> creators = DOIInfoExtractor.getList(crossCite, "creators");
        for (int i = 0; i < creators.size(); ++i) {
            Map au = (Map)creators.get(i);
            String name = DOIInfoExtractor.getValue(au, "givenName", "") + " " + DOIInfoExtractor.getValue(au, "familyName", "");
            s = s + ", " + name.trim();
        }
        if (s.length() > 0) {
            DOIInfoExtractor.put(info, "dataCreators", s.substring(2));
        }
        String doi = DOIInfoExtractor.getValue(crossCite, "doi", "");
        DOIInfoExtractor.put(info, "dataDoi", doi);
        DOIInfoExtractor.put(info, "dataDoiLink", DOI_ORG + doi);
        DOIInfoExtractor.put(info, "dataUrl", DOIInfoExtractor.getValue(crossCite, "url", ""));
    }

    private static void put(Map<String, Object> info, String key, Object value) {
        if (value != null) {
            info.put(key, value);
        }
    }

    private static String getValue(Map<String, Object> au, String key, String defValue) {
        Object o = au.get(key);
        return o == null ? defValue : o.toString();
    }

    private static Map<String, Object> getMap(Map<String, Object> json, String ... keys) {
        return (Map)DOIInfoExtractor.getObject(json, keys);
    }

    private static List<Object> getList(Map<String, Object> json, String ... keys) {
        return (List)DOIInfoExtractor.getObject(json, keys);
    }

    private static Object getObject(Map<String, Object> json, String ... keys) {
        for (int i = 0; i < keys.length - 1; ++i) {
            json = (Map)json.get(keys[i]);
        }
        return json.get(keys[keys.length - 1]);
    }

    public static String extractOuterXML(String key, String xml) {
        if (xml == null) {
            return null;
        }
        int p = xml.indexOf("<" + key);
        int p2 = key.indexOf(" ");
        p2 = xml.indexOf("</" + (p2 < 0 ? key : key.substring(0, p2)) + (key.endsWith(">") ? "" : ">"), p);
        if (p2 < 0) {
            return null;
        }
        p2 = xml.indexOf(">", p2) + 1;
        return xml.substring(p, p2);
    }

    public static String extractXML(String key, String xml, int[] pt) {
        int p;
        if (xml == null) {
            return null;
        }
        if (pt == null) {
            pt = new int[1];
        }
        if ((p = xml.indexOf("<" + key, pt[0])) < 0 || (p = xml.indexOf(">", p) + 1) <= 0) {
            return null;
        }
        int p2 = key.indexOf(" ");
        p2 = xml.indexOf("</" + (p2 < 0 ? key : key.substring(0, p2)) + (key.endsWith(">") ? "" : ">"), p);
        if (p2 < 0) {
            return null;
        }
        pt[0] = p2 + key.length() + 2;
        return xml.substring(p, p2);
    }
}

