/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.extractor;

import com.integratedgraphics.extractor.FindingAidCreator;
import com.integratedgraphics.test.ICLDOICrawler;
import com.integratedgraphics.util.XmlReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.common.IFDUtil;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAid;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDReference;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.extract.DefaultStructureHelper;

public class DOICrawler
extends FindingAidCreator {
    protected static final String version = "0.0.6-beta+2024.12.12";
    protected static final String codeSource = "https://github.com/IUPAC/IUPAC-FAIRSpec/blob/main/src/main/java/com/integratedgraphics/extractor/DOICrawler.java";
    protected static final String TEST_PID = "10.14469/hpc/10386";
    protected static final String DATACITE_DESCRIPTION = "description";
    protected static final String DATACITE_TITLE = "title";
    protected static final String DATACITE_SUBJECT = "subject";
    protected static final String DATACITE_REFERENCES = "References";
    protected static final String DATACITE_RELATEDIDENTIFIER = "relatedidentifier";
    public static final String DATACITE_METADATA = "https://data.datacite.org/application/vnd.datacite.datacite+xml/";
    public static final String FAIRDATA_SUBJECT_SCHEME = "IFD";
    public static final String IFD_SCHEME_URI = "http://iupac.org/ifd";
    protected static final String DEFAULT_OUTDIR = "c:/temp/iupac/crawler";
    protected static final char DOI_COMP = 'C';
    protected static final char DOI_DATA = 'D';
    protected static final char DOI_REP = 'R';
    protected static final char DOI_TOP = 'T';
    protected static final String DOI_ORG = "https://doi.org/";
    protected static final String DOWNLOAD_TYPES = ";zip;jdx;png;pdf;a2r;jpg;jpeg;cdxml;mol;cif;xls;xlsx;mnova;mnpub;";
    protected static final String FAIRSPEC_COMPOUND_ID = "IFD.property.fairspec.compound.id";
    protected static final String FAIRSPEC_DATAOBJECT_FLAG = "IFD.property.dataobject.fairspec.";
    protected static final String IFD_INCHI = "IFD.representation.structure.inchi";
    protected static final String IFD_INCHIKEY = "IFD.representation.structure.inchikey";
    protected static final String IFD_SMILES = "IFD.representation.structure.smiles";
    private static String indent = "                              ";
    private static Comparator<DoiRecord> sorter = new Comparator<DoiRecord>(){

        @Override
        public int compare(DoiRecord o1, DoiRecord o2) {
            return o1.getSortKey(null, null).compareTo(o2.getSortKey(null, null));
        }
    };
    public DoiRecord doiRecord;
    protected StringBuffer log = new StringBuffer();
    protected int xmlDepth;
    private DOICustomizer customizer;
    private URL dataCiteMetadataURL;
    private boolean doDownload = true;
    private List<DoiRecord> doiList;
    private StringBuffer errorBuffer = new StringBuffer();
    private String faId;
    private FAIRSpecFindingAid findingAid;
    private int ids = 0;
    private String initialDOI;
    private boolean isSilent = false;
    private boolean isTop = true;
    private int nReps;
    private String pidPath;
    private long startTime;
    private String subdir;
    private String thisCompoundID;
    private IFDDataObject thisDataObject;
    private String thisDataObjectType;
    private File topDir;
    private File dataDir;
    private File fileDir;
    private long totalLength;
    private int urlDepth;
    private Stack<String> urlStack;
    private IFDObject<?> thisCompound;

    public static void main(String[] args) {
        if (args.length == 0) {
            ICLDOICrawler.main(args);
        } else {
            new DOICrawler(args).crawl();
        }
    }

    protected static String cleanData(String s) {
        return s.replaceAll("\t", "\\\\t").replaceAll("\r\n", "\\\\n").replaceAll("\n", "\\\\n");
    }

    protected static void sortRecords(List<DoiRecord> doiList) {
        String ckey = null;
        String dkey = null;
        block5: for (int i = 0; i < doiList.size(); ++i) {
            DoiRecord rec = doiList.get(i);
            switch (rec.type) {
                case 'C': {
                    ckey = rec.getSortKey(null, null);
                    continue block5;
                }
                case 'D': {
                    dkey = rec.getSortKey(ckey, null);
                    continue block5;
                }
                case 'R': {
                    rec.getSortKey(ckey, dkey);
                    continue block5;
                }
                default: {
                    rec.getSortKey(ckey, null);
                }
            }
        }
        doiList.sort(sorter);
    }

    private static String getHeaderAttr(String data, String name) {
        int pt = data.indexOf(name + "=");
        if (pt < 0) {
            return null;
        }
        int pt2 = data.indexOf(9, pt);
        return data.substring(pt + name.length() + 1, pt2 > 0 ? pt2 : data.length());
    }

    private static URL getMetadataURL(String pid) throws MalformedURLException {
        System.out.println(pid);
        return new URL(DATACITE_METADATA + pid);
    }

    private static URL newURL(String s) throws MalformedURLException {
        s = FAIRSpecUtilities.rep(s, "&amp;", "&");
        return new URL(s);
    }

    public DOICrawler(String ... args) {
        this.initialDOI = args.length == 0 ? TEST_PID : args[0];
        String flags = this.processFlags(args, "-nozip");
        if (flags.indexOf("-nodownload;") >= 0) {
            this.doDownload = false;
        }
        try {
            this.dataCiteMetadataURL = DOICrawler.getMetadataURL(this.initialDOI);
        }
        catch (MalformedURLException e) {
            this.addException(e);
        }
        String outdir = args.length > 1 ? args[1] : DEFAULT_OUTDIR;
        this.topDir = new File(outdir);
    }

    @Override
    public void addDeferredPropertyOrRepresentation(String key, Object val, boolean isInLine, String mediaType, String note, String method) {
    }

    @Override
    public void addProperty(String key, Object val) {
    }

    public boolean crawl() {
        this.faId = this.initialDOI.replace('/', '_');
        this.targetPath = new File(this.topDir, this.faId);
        this.targetPath.mkdirs();
        this.faHelper = new FAIRSpecFindingAidHelper(this.getCodeSource() + " " + this.getVersion());
        if (!this.isByIDSet) {
            this.setExtractorOption(IFDConst.IFD_PROPERTY_COLLECTIONSET_BYID, "true");
        }
        this.findingAid = this.faHelper.getFindingAid();
        this.findingAid.setID(this.faId);
        if (this.doDownload && this.fileDir == null) {
            this.fileDir = new File(this.targetPath, "files");
        } else if (this.fileDir == null) {
            this.doDownload = false;
        }
        if (this.dataDir == null) {
            this.dataDir = new File(this.targetPath, "metadata");
        }
        this.log = new StringBuffer();
        this.startTime = System.currentTimeMillis();
        this.doiList = new ArrayList<DoiRecord>();
        this.urlStack = new Stack();
        this.dataDir.mkdirs();
        if (this.fileDir != null) {
            this.fileDir.mkdirs();
        }
        this.nextDOI(this.dataCiteMetadataURL);
        this.outputListAndLog(this.targetPath);
        this.createFindingAid();
        if (this.errorBuffer.length() > 0) {
            System.err.println(this.errorBuffer.toString());
        }
        System.out.println("done len = " + this.totalLength + " bytes " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec");
        return true;
    }

    public boolean crawl(File topDir, File dataDir, File fileDir) {
        this.topDir = topDir;
        this.dataDir = dataDir;
        this.fileDir = fileDir;
        return this.crawl();
    }

    public void doEndXMLElement(String localName, StringBuffer chars) {
    }

    @Override
    public String getCodeSource() {
        return codeSource;
    }

    @Override
    public String getVersion() {
        return "DoiCrawler 0.0.6-beta+2024.12.12";
    }

    public String newCompound(String id) {
        this.thisCompoundID = this.doiRecord.compoundID = id;
        this.doiRecord.type = (char)67;
        return id;
    }

    public void setCustomizer(DOICustomizer customizer) {
        this.customizer = customizer;
    }

    public void setDataObjectType(String type) {
        this.doiRecord.dataObjectType = type;
    }

    public void setResourceType(char doiType) {
        this.pidPath = this.pidPath + doiType;
        if (this.doiRecord.type == '\u0000') {
            this.doiRecord.type = doiType;
        }
    }

    protected void addAttr(String key, String value) {
        this.doiRecord.addProperty(key, DOICrawler.cleanData(value));
        this.logAttr(key, value);
    }

    protected void addError(String err) {
        System.err.println(err);
        this.errorBuffer.append(err + "\n");
    }

    protected void addException(Exception e) {
        e.printStackTrace();
        this.logAttr("exception", e.getClass().getName() + ": " + e.getMessage());
    }

    protected void addProperties(IFDObject<?> c, DoiRecord rec) {
        boolean isData = rec.type == 'D';
        block6: for (Map.Entry<String, String> e : rec.properties.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            switch (key) {
                case "schemalocation": {
                    continue block6;
                }
            }
            if (isData && key.contains(IFDConst.IFD_STRUCTURE_FLAG)) {
                this.faHelper.createStructureRepresentation(null, value, value.length(), key, null);
                continue;
            }
            c.setPropertyValue(key, value, rec.compoundID);
        }
    }

    protected void appendLog(String line) {
        if (this.isSilent) {
            return;
        }
        line = line.trim();
        if (this.xmlDepth * 2 > indent.length()) {
            indent = indent + indent;
        }
        this.log.append('\n').append(this.urlDepth).append(".").append(this.xmlDepth).append(indent.substring(0, this.xmlDepth * 2)).append(line);
    }

    protected void createFindingAid() {
        String url = DOI_ORG + this.initialDOI;
        IFDReference r = new IFDReference();
        r.setDOI(url);
        this.findingAid.getCollectionSet().setReference(r);
        try {
            DoiRecord rec = this.doiList.get(0);
            String pubdoi = rec.properties.remove("PUBDOI");
            String datadoi = url;
            this.processDOIURLs(pubdoi, datadoi, this.faHelper);
            this.nestRecords();
            this.processRecords(null, this.doiList);
            String aid = this.faHelper.generateFindingAid(this.targetPath);
            if (aid != null && this.createLandingPage) {
                this.buildSite(this.targetPath);
            }
        }
        catch (Exception e) {
            this.addException(e);
        }
    }

    protected boolean customizeText(String key, String val) {
        switch (key) {
            case "subject": {
                switch (val) {
                    case "Crystal Structure": {
                        this.setDataObjectType("xrd");
                        return false;
                    }
                }
                break;
            }
            case "References": {
                if (val.indexOf("/ccdc.") < 0) break;
                return true;
            }
        }
        return this.customizer != null && this.customizer.customizeText(key, val);
    }

    protected String getTabField(String line, String key) {
        int pt = line.indexOf("\t" + key + "=");
        if (pt < 0) {
            return null;
        }
        int pt1 = line.indexOf(9, pt = pt + key.length() + 2);
        return pt1 < 0 ? line.substring(pt) : line.substring(pt, pt1);
    }

    protected void logAttr(String key, String value) {
        this.appendLog(key + "=" + value);
    }

    protected void processRecords(String dataObjectType, List<DoiRecord> doiList) throws IFDException {
        DOICrawler.sortRecords(doiList);
        for (int i = 0; i < doiList.size(); ++i) {
            DoiRecord rec = doiList.get(i);
            IFDObject o = null;
            switch (rec.type) {
                case 'T': {
                    o = this.faHelper.getFindingAid().getCollectionSet();
                    break;
                }
                case 'C': {
                    String id = rec.compoundID;
                    if (id == this.thisCompoundID) {
                        o = this.thisCompound;
                    } else {
                        this.thisCompoundID = rec.compoundID;
                        o = this.faHelper.createCompound(this.thisCompoundID);
                        this.thisCompound = o;
                        o.setDOI(rec.ifdRef.getDOI());
                        o.setURL(rec.ifdRef.getURL());
                        o.setReference(rec.ifdRef);
                    }
                    this.thisDataObject = null;
                    if (rec.itemList == null) break;
                    this.processRecords(rec.dataObjectType, rec.itemList);
                    break;
                }
                case 'D': {
                    this.thisDataObject = this.faHelper.createDataObject("" + ++this.ids, rec.dataObjectType);
                    o = this.thisDataObject;
                    o.setDOI(rec.ifdRef.getDOI());
                    o.setURL(rec.ifdRef.getURL());
                    this.thisDataObjectType = rec.dataObjectType;
                    break;
                }
                case 'R': {
                    String structureType = null;
                    if (rec.dataObjectType == null) {
                        String ext = rec.ifdRef.getLocalName();
                        structureType = DefaultStructureHelper.getType(ext = ext.substring(ext.lastIndexOf(".") + 1), null, false);
                        if (structureType != null) {
                            System.out.println(rec.ifdRef);
                            this.faHelper.createStructureRepresentation(rec.ifdRef, null, rec.length, structureType, rec.mediaType);
                        }
                    }
                    if (structureType != null) break;
                    if (this.thisDataObject == null) {
                        this.log("!!no data object for " + rec.ifdRef.getLocalName() + " " + rec.ifdRef.getURL());
                        break;
                    }
                    if (this.thisDataObjectType == null) {
                        this.thisDataObjectType = "unknown";
                        this.addError("!no data type found for " + rec);
                    }
                    if (!this.thisDataObjectType.startsWith(FAIRSPEC_DATAOBJECT_FLAG)) {
                        this.thisDataObjectType = FAIRSPEC_DATAOBJECT_FLAG + this.thisDataObjectType;
                    }
                    rec.dataObjectType = this.thisDataObjectType;
                    this.faHelper.createDataObjectRepresentation(rec.ifdRef, null, rec.length, rec.dataObjectType, rec.mediaType);
                }
            }
            if (o == null) continue;
            this.addProperties(o, rec);
        }
    }

    private void addRecord(DoiRecord doiRecord) {
        doiRecord.pidPath = this.pidPath;
        this.doiList.add(doiRecord);
    }

    private void addRelatedIdentifier(Map<String, String> attrs, String s) {
        String type = attrs.get("relatedidentifiertype");
        String generalType = attrs.get("resourcetypegeneral");
        switch (attrs.get("relationtype")) {
            case "HasPart": {
                break;
            }
            case "References": {
                if (generalType == null) {
                    if (this.customizeText(DATACITE_REFERENCES, s)) break;
                    return;
                }
                switch (generalType) {
                    case "JournalArticle": {
                        if ("DOI".equals(type)) {
                            s = DOI_ORG + s;
                        }
                        this.addAttr("PUB" + type, s);
                    }
                }
                return;
            }
            default: {
                type = null;
            }
        }
        if (type != null) {
            if (this.ignoreURL(s)) {
                return;
            }
            LinkedHashMap<String, List<String>> map = this.doiRecord.relatedItems;
            ArrayList<String> list = (ArrayList<String>)map.get(type);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(type, list);
            }
            list.add(s);
        }
    }

    private void downloadCheck(URL url, File file) throws IOException {
        long modTime = file.lastModified();
        System.out.println(file);
        if (modTime > 0L && modTime < this.startTime) {
            return;
        }
        String s = file.getName();
        int pt = s.lastIndexOf(".");
        if (pt > 0 && FAIRSpecUtilities.isOneOf(s.substring(pt + 1), DOWNLOAD_TYPES)) {
            URLConnection con;
            InputStream is;
            int n;
            if (modTime > 0L) {
                this.addError("replacing " + file.getName() + " with " + url);
            }
            if ((n = FAIRSpecUtilities.putToFile(FAIRSpecUtilities.getBytesAndClose(is = (con = url.openConnection()).getInputStream()), file)) == 0) {
                this.addError("!URL returns 0 bytes! " + url);
            }
        }
    }

    private boolean ignoreURL(String url) {
        if (this.customizer != null && this.customizer.ignoreURL(url)) {
            this.log("DOICrawler customizer ignoring " + url);
            return true;
        }
        return false;
    }

    private void nestRecords() {
        for (int i = 0; i < this.doiList.size(); ++i) {
            DoiRecord rec = this.doiList.get(i);
            if (rec.type != 'C') continue;
            while (i + 1 < this.doiList.size() && this.doiList.get((int)(i + 1)).type != 'C') {
                rec.addItem(this.doiList.remove(i + 1));
            }
        }
    }

    private boolean nextDOI(URL doi) {
        String file;
        String currentPath = this.pidPath;
        String s = doi.toString().replace(DATACITE_METADATA, "");
        this.urlStack.push(DOI_ORG + s);
        ++this.urlDepth;
        this.isTop = this.urlDepth == 1;
        String sfile = FAIRSpecUtilities.cleanFileName(s) + ".xml";
        int pt = s.lastIndexOf(47);
        String dir = s.substring(0, pt + 1);
        this.subdir = file = s.substring(pt + 1);
        this.pidPath = this.pidPath == null ? s + ">" : (s.indexOf(dir) == 0 ? this.pidPath + ">" + file + ">" : this.pidPath + ">" + s + ">");
        this.logAttr("open", doi.toString());
        try {
            InputStream is;
            File dataFile = new File(this.dataDir, sfile);
            boolean haveData = dataFile.exists();
            System.out.println("reading " + (haveData ? dataFile : doi.toString()));
            if (haveData) {
                is = new FileInputStream(dataFile);
            } else {
                URLConnection con = doi.openConnection();
                is = con.getInputStream();
            }
            byte[] metadata = FAIRSpecUtilities.getBytesAndClose(is);
            if (!haveData) {
                FAIRSpecUtilities.putToFile(metadata, dataFile);
            }
            is = new ByteArrayInputStream(metadata);
            String url = DOI_ORG + s;
            if (this.ignoreURL(url)) {
                return false;
            }
            DoiRecord doiRecord = new DoiRecord(this.thisCompoundID, url, null, null);
            this.addRecord(doiRecord);
            if (doi.equals(this.dataCiteMetadataURL)) {
                doiRecord.type = (char)84;
            }
            this.parseXML(doiRecord, this.isTop, is);
            if (doiRecord.type == 'D' && doiRecord.dataObjectType == null && doiRecord.hasRepresentations) {
                doiRecord.dataObjectType = "unknown";
                this.addError("!No data type found for " + doiRecord);
            }
        }
        catch (Exception e) {
            this.addException(e);
        }
        this.logAttr("close", doi.toString());
        this.popURLStack(currentPath);
        return true;
    }

    private void outputListAndLog(File dir) {
        File f = new File(dir, "ifd-fileURLMap.txt");
        System.out.println("writing " + this.doiList.size() + " entries " + f.getAbsolutePath());
        System.out.println(this.nReps + " representations");
        try {
            FileOutputStream fos = new FileOutputStream(f);
            for (int i = 0; i < this.doiList.size(); ++i) {
                fos.write(this.doiList.get(i).getBytes());
                fos.write(10);
            }
            fos.close();
        }
        catch (Exception e) {
            this.addException(e);
        }
        f = new File(dir, "crawler.log");
        System.out.println("writing " + this.log.length() + " bytes " + f.getAbsolutePath());
        FAIRSpecUtilities.putToFile(this.log.toString().getBytes(), f);
    }

    private void parseXML(DoiRecord doiRecord, boolean isTop, InputStream content) throws Exception {
        this.doiRecord = doiRecord;
        doiRecord.relatedItems = new LinkedHashMap();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(content), "UTF-8"));
        new DOIXMLReader(this, this.customizer, isTop, this.log).parseXML(reader);
        content.close();
        this.processRelated(doiRecord.relatedItems);
    }

    private void popURLStack(String currentPath) {
        this.pidPath = currentPath;
        this.urlStack.pop();
        --this.urlDepth;
    }

    private void processRelated(Map<String, List<String>> map) {
        try {
            List<String> list = map.get("URL");
            if (list != null) {
                TreeMap<String, DoiRecord> fMap = new TreeMap<String, DoiRecord>();
                for (int i = 0; i < list.size(); ++i) {
                    this.processRepresentation(this.subdir, DOICrawler.newURL(list.get(i)), fMap);
                }
                for (Map.Entry e : fMap.entrySet()) {
                    this.addRecord((DoiRecord)e.getValue());
                }
                this.doiRecord.hasRepresentations = true;
            }
            if ((list = map.get("DOI")) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.nextDOI(DOICrawler.getMetadataURL(list.get(i)));
                }
            }
        }
        catch (Exception e) {
            this.addException(e);
        }
    }

    private void processRepresentation(String subdir, URL url, Map<String, DoiRecord> fMap) throws IOException {
        ++this.urlDepth;
        ++this.nReps;
        File headerFile = new File(this.dataDir, FAIRSpecUtilities.cleanFileName(url.toString()) + ".txt");
        boolean haveHeaderFile = headerFile.exists();
        String fileName = null;
        String mediaType = null;
        byte[] bytes = null;
        int len = 0;
        if (haveHeaderFile) {
            bytes = FAIRSpecUtilities.getBytesAndClose(new FileInputStream(headerFile));
            String data = new String(bytes);
            fileName = DOICrawler.getHeaderAttr(data, "filename");
            String length = DOICrawler.getHeaderAttr(data, "length");
            mediaType = DOICrawler.getHeaderAttr(data, "mediaType");
            if (length != null) {
                len = IFDUtil.parsePositiveInt(length);
                this.totalLength += (long)len;
            }
        } else {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("HEAD");
            Map<String, List<String>> map = con.getHeaderFields();
            mediaType = map.get("Content-Type").get(0);
            String s = "\tURL=" + url;
            s = s + "\tmediaType=" + mediaType;
            List<String> item = map.get("Content-Disposition");
            fileName = null;
            if (item != null) {
                List<String> list = map.get("Content-Length");
                if (list != null && !list.isEmpty()) {
                    s = s + "\tlength=" + list.get(0);
                } else {
                    this.addError("!HEAD " + url + " no Content-Length!");
                }
                fileName = FAIRSpecUtilities.getQuotedOrUnquotedAttribute(item.toString(), "filename");
                s = s + "\tfilename=" + fileName;
            }
            FAIRSpecUtilities.putToFile(s.getBytes(), headerFile);
        }
        if (fileName != null) {
            DoiRecord f0;
            if (this.fileDir != null) {
                File subDir = new File(this.fileDir, subdir);
                subDir.mkdirs();
                this.downloadCheck(url, new File(subDir, FAIRSpecUtilities.cleanFileName(fileName)));
            }
            if ((f0 = fMap.remove(fileName)) != null) {
                this.log("!removed duplicate " + f0 + " " + f0.ifdRef);
            }
            String surl = url.toString();
            DoiRecord rec = new DoiRecord(this.thisCompoundID, surl, null, fileName);
            rec.length = len;
            rec.mediaType = mediaType;
            rec.type = (char)82;
            fMap.put(fileName, rec);
        }
        --this.urlDepth;
    }

    private static class DOIXMLReader
    extends XmlReader {
        private DOICrawler crawler;
        private DOICustomizer customizer;
        private boolean skipping;
        private Stack<Map<String, String>> thisAttrs = new Stack();

        public DOIXMLReader(DOICrawler crawler, DOICustomizer customizer, boolean isTop, StringBuffer log) {
            super(log);
            this.skipping = !isTop;
            this.crawler = crawler;
            this.customizer = customizer;
        }

        protected Map<String, String> getAttributes(boolean andPop) {
            return andPop ? this.thisAttrs.pop() : (Map)this.thisAttrs.get(this.thisAttrs.size() - 1);
        }

        @Override
        protected void processEndElement(String localName) {
            String s = this.chars.toString().trim();
            this.chars.setLength(0);
            switch (localName) {
                case "description": {
                    if (s.length() <= 0 || this.crawler.customizeText(DOICrawler.DATACITE_DESCRIPTION, s)) break;
                    this.crawler.addAttr(IFDConst.IFD_PROPERTY_DESCRIPTION, s);
                    break;
                }
                case "title": {
                    if (s.length() <= 0 || this.crawler.customizeText(DOICrawler.DATACITE_TITLE, s)) break;
                    this.crawler.addAttr(IFDConst.IFD_PROPERTY_LABEL, s);
                    break;
                }
                case "subject": {
                    Map<String, String> attrs = this.getAttributes(true);
                    this.addSubject(attrs, s);
                    break;
                }
                case "relatedidentifier": {
                    if (s.length() > 0) {
                        this.crawler.logAttr(DOICrawler.DATACITE_RELATEDIDENTIFIER, s);
                    }
                    this.crawler.addRelatedIdentifier(this.getAttributes(true), s);
                    break;
                }
                default: {
                    if (this.skipping || s.length() <= 0) break;
                    this.crawler.logAttr("value", s);
                    this.crawler.addAttr(localName, s);
                }
            }
            --this.crawler.xmlDepth;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void processStartElement(String localName, String nodeName) {
            void var5_31;
            void var5_23;
            ++this.crawler.xmlDepth;
            boolean isData = true;
            Object object = localName;
            int n = -1;
            switch (((String)object).hashCode()) {
                case 1820427719: {
                    if (!((String)object).equals("creators")) break;
                    boolean bl = false;
                    break;
                }
                case 95356549: {
                    if (!((String)object).equals("dates")) break;
                    boolean bl = true;
                    break;
                }
                case 109453458: {
                    if (!((String)object).equals("sizes")) break;
                    int n2 = 2;
                    break;
                }
                case -677443748: {
                    if (!((String)object).equals("formats")) break;
                    int n3 = 3;
                    break;
                }
                case 351608024: {
                    if (!((String)object).equals("version")) break;
                    int n4 = 4;
                    break;
                }
                case 1375976184: {
                    if (!((String)object).equals("contributors")) break;
                    int n5 = 5;
                    break;
                }
                case 1447404028: {
                    if (!((String)object).equals("publisher")) break;
                    int n6 = 6;
                    break;
                }
                case 1472148585: {
                    if (!((String)object).equals("publicationyear")) break;
                    int n7 = 7;
                    break;
                }
                case -1370365163: {
                    if (!((String)object).equals("rightsList")) break;
                    int n8 = 8;
                    break;
                }
                case -1618432855: {
                    if (!((String)object).equals("identifier")) break;
                    int n9 = 9;
                    break;
                }
                case -383411128: {
                    if (!((String)object).equals("resourcetype")) break;
                    int n10 = 10;
                    break;
                }
                case 1456116703: {
                    if (!((String)object).equals("relatedidentifiers")) break;
                    int n11 = 11;
                    break;
                }
                case -2069868345: {
                    if (!((String)object).equals("subjects")) break;
                    int n12 = 12;
                    break;
                }
                case 110371416: {
                    if (!((String)object).equals(DOICrawler.DATACITE_TITLE)) break;
                    int n13 = 13;
                    break;
                }
                case 1293897492: {
                    if (!((String)object).equals(DOICrawler.DATACITE_RELATEDIDENTIFIER)) break;
                    int n14 = 14;
                    break;
                }
                case -1867885268: {
                    if (!((String)object).equals(DOICrawler.DATACITE_SUBJECT)) break;
                    int n15 = 15;
                    break;
                }
                case -1724546052: {
                    if (!((String)object).equals(DOICrawler.DATACITE_DESCRIPTION)) break;
                    int n16 = 16;
                }
            }
            switch (var5_23) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.skipping = true;
                    break;
                }
                case 9: 
                case 10: {
                    this.skipping = false;
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    isData = false;
                    this.skipping = false;
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    isData = false;
                    this.skipping = false;
                }
            }
            if (!this.skipping) {
                this.crawler.logAttr("item", localName);
            }
            for (Map.Entry entry : this.atts.entrySet()) {
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (isData && !this.skipping) {
                    this.crawler.addAttr(key, val);
                    continue;
                }
                this.crawler.logAttr(key, val);
            }
            object = localName;
            int n17 = -1;
            switch (((String)object).hashCode()) {
                case -383411128: {
                    if (!((String)object).equals("resourcetype")) break;
                    boolean bl = false;
                    break;
                }
                case -1618432855: {
                    if (!((String)object).equals("identifier")) break;
                    boolean bl = true;
                    break;
                }
                case 1293897492: {
                    if (!((String)object).equals(DOICrawler.DATACITE_RELATEDIDENTIFIER)) break;
                    int n18 = 2;
                    break;
                }
                case -1724546052: {
                    if (!((String)object).equals(DOICrawler.DATACITE_DESCRIPTION)) break;
                    int n19 = 3;
                    break;
                }
                case -1867885268: {
                    if (!((String)object).equals(DOICrawler.DATACITE_SUBJECT)) break;
                    int n20 = 4;
                }
            }
            switch (var5_31) {
                case 0: {
                    switch ((String)this.atts.get("resourcetypegeneral")) {
                        case "Collection": {
                            this.crawler.setResourceType('C');
                            break;
                        }
                        case "Dataset": {
                            this.crawler.setResourceType('D');
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.thisAttrs.push(this.atts);
                }
            }
        }

        private void addSubject(Map<String, String> attrs, String s) {
            String key = attrs.get("subjectscheme");
            if (key == null) {
                this.crawler.customizeText(DOICrawler.DATACITE_SUBJECT, s);
            } else {
                switch (key) {
                    case "IFD": {
                        key = attrs.get("valueuri");
                        if (!key.startsWith(DOICrawler.IFD_SCHEME_URI)) break;
                        key = key.substring(key.lastIndexOf(47) + 1);
                        break;
                    }
                    default: {
                        key = this.customizeSubectKey(key);
                    }
                }
                if (key.startsWith(DOICrawler.FAIRSPEC_DATAOBJECT_FLAG)) {
                    String type = key.substring(DOICrawler.FAIRSPEC_DATAOBJECT_FLAG.length());
                    type = type.substring(0, type.indexOf(46));
                    this.crawler.setDataObjectType(type);
                }
                this.crawler.addAttr(key, s);
            }
        }

        private String customizeSubectKey(String key) {
            return this.customizer == null ? key : this.customizer.customizeSubjectKey(key);
        }
    }

    protected static class DoiRecord {
        public String dataObjectType;
        public boolean hasRepresentations;
        public String mediaType;
        public LinkedHashMap<String, List<String>> relatedItems;
        String compoundID;
        IFDReference ifdRef;
        int length;
        String pidPath;
        Map<String, String> properties = new TreeMap<String, String>();
        char type;
        protected List<DoiRecord> itemList;
        protected String label;
        protected String sortKey;

        DoiRecord(String id, String url, String dirName, String localName) {
            this.compoundID = id;
            this.ifdRef = new IFDReference(null, url, dirName, localName);
            if (url.startsWith(DOICrawler.DOI_ORG)) {
                this.ifdRef.setDOI(url);
            } else {
                this.ifdRef.setURL(url);
            }
        }

        public byte[] getBytes() {
            String s = this.pidPath;
            switch (this.type) {
                case 'R': {
                    s = s + ">R";
                }
            }
            s = s + "\t" + this.ifdRef + (this.label == null ? "" : "\t" + this.label);
            return s.getBytes();
        }

        public String getSortKey(String ckey, String dkey) {
            if (this.sortKey == null) {
                switch (this.type) {
                    case 'C': {
                        return "C_" + IFDUtil.getNumericalSortKey(this.compoundID);
                    }
                    case 'D': {
                        this.sortKey = dkey = ckey + "_" + this.pidPath;
                        return dkey;
                    }
                    case 'R': {
                        this.sortKey = dkey + "_" + this.ifdRef.getLocalName();
                        return this.sortKey;
                    }
                    case 'T': {
                        this.sortKey = "A_";
                        return "A_";
                    }
                }
                this.sortKey = "Z_" + ckey + "?";
                return this.sortKey;
            }
            return this.sortKey;
        }

        public String toString() {
            return "[doiRecord " + this.type + (this.type == 'D' ? "." + this.dataObjectType : "") + " " + this.compoundID + ": " + this.ifdRef.getLocalName() + " mt=" + this.mediaType + " " + this.properties + "]";
        }

        void addItem(DoiRecord rep) {
            if (this.itemList == null) {
                this.itemList = new ArrayList<DoiRecord>();
            }
            this.itemList.add(rep);
        }

        void addProperty(String key, String val) {
            if (key.endsWith(".label")) {
                this.label = val;
            }
            this.properties.put(key, val);
        }
    }

    protected static interface DOICustomizer {
        public String customizeSubjectKey(String var1);

        public boolean customizeText(String var1, String var2);

        public boolean ignoreURL(String var1);
    }
}

