/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.graph.complete;

import com.actelion.research.util.BurtleHasher;
import com.actelion.research.util.graph.complete.AMemorizedObject;
import java.util.Arrays;

public class SolutionCompleteGraph
extends AMemorizedObject
implements Comparable<SolutionCompleteGraph> {
    private byte[] heapIndexBase;
    private int sizeHeap;
    private byte[] heapIndexQuery;
    private byte maxIndexNodeQuery;
    private byte[] arrSolution = new byte[127];
    private int hash;
    private double similarity;
    private int nodes = -1;

    public SolutionCompleteGraph() {
        this.heapIndexBase = new byte[127];
        this.heapIndexQuery = new byte[127];
        for (int i = 0; i < this.arrSolution.length; ++i) {
            this.arrSolution[i] = -1;
            this.heapIndexBase[i] = -1;
            this.heapIndexQuery[i] = -1;
        }
    }

    public void add(byte by, byte by2) {
        this.arrSolution[by] = by2;
        if (by > this.maxIndexNodeQuery) {
            this.maxIndexNodeQuery = by;
        }
        this.heapIndexBase[this.sizeHeap] = by2;
        this.heapIndexQuery[this.sizeHeap] = by;
        ++this.sizeHeap;
        this.calcHashCode();
    }

    @Override
    public int compareTo(SolutionCompleteGraph solutionCompleteGraph) {
        if (this.similarity > solutionCompleteGraph.similarity) {
            return 1;
        }
        if (this.similarity < solutionCompleteGraph.similarity) {
            return -1;
        }
        return 0;
    }

    public int getSizeHeap() {
        return this.sizeHeap;
    }

    public byte getIndexBaseFromHeap(int n) {
        return this.heapIndexBase[n];
    }

    public byte getIndexQueryFromHeap(int n) {
        return this.heapIndexQuery[n];
    }

    public byte getIndexCorrespondingBaseNode(int n) {
        return this.arrSolution[n];
    }

    public byte[] getSolution() {
        return this.arrSolution;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        SolutionCompleteGraph solutionCompleteGraph = (SolutionCompleteGraph)object;
        if (this.sizeHeap != solutionCompleteGraph.sizeHeap) {
            return false;
        }
        if (this.maxIndexNodeQuery != solutionCompleteGraph.maxIndexNodeQuery) {
            return false;
        }
        for (int i = 0; i < this.maxIndexNodeQuery; ++i) {
            if (this.arrSolution[i] == solutionCompleteGraph.arrSolution[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void copyIntoThis(AMemorizedObject aMemorizedObject) {
        SolutionCompleteGraph solutionCompleteGraph = (SolutionCompleteGraph)aMemorizedObject;
        System.arraycopy(solutionCompleteGraph.heapIndexBase, 0, this.heapIndexBase, 0, solutionCompleteGraph.sizeHeap);
        System.arraycopy(solutionCompleteGraph.heapIndexQuery, 0, this.heapIndexQuery, 0, solutionCompleteGraph.sizeHeap);
        System.arraycopy(solutionCompleteGraph.arrSolution, 0, this.arrSolution, 0, this.arrSolution.length);
        this.sizeHeap = solutionCompleteGraph.sizeHeap;
        this.hash = solutionCompleteGraph.hash;
        this.similarity = solutionCompleteGraph.similarity;
        this.nodes = solutionCompleteGraph.nodes;
    }

    private void calcHashCode() {
        this.hash = BurtleHasher.hashlittle(this.arrSolution, 13L, this.maxIndexNodeQuery + 1);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.arrSolution.length; ++i) {
            this.arrSolution[i] = -1;
            this.heapIndexBase[i] = -1;
            this.heapIndexQuery[i] = -1;
        }
        this.sizeHeap = 0;
        this.hash = 0;
        this.similarity = 0.0;
        this.nodes = 0;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(double d) {
        this.similarity = d;
    }

    public void setNodesQuery(int n) {
        this.nodes = n;
    }

    public int getNodesQuery() {
        return this.nodes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.nodes > -1) {
            for (int i = 0; i < this.nodes; ++i) {
                stringBuilder.append(this.arrSolution[i]);
                if (i >= this.nodes - 1) continue;
                stringBuilder.append(" ");
            }
        } else {
            stringBuilder.append(Arrays.toString(this.arrSolution));
        }
        return stringBuilder.toString();
    }
}

