/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util.datamodel;

import com.actelion.research.util.BurtleHasher;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;

public class IntArray
implements Serializable {
    private static final int START_CAPACITY = 32;
    private static final int MAX_DELTA_CAPACITY = (int)Math.pow(2.0, 20.0);
    private int[] data;
    private int size;
    private int delta_capacity;
    private int hash;

    public IntArray() {
        this.init(32);
    }

    public IntArray(int n) {
        this.init(n);
    }

    public IntArray(int[] nArray) {
        this.data = nArray;
        this.size = this.data.length;
        this.delta_capacity = this.size / 2;
        this.calculateHashCode();
    }

    public IntArray(IntArray intArray) {
        this.init(intArray.data.length);
        System.arraycopy(intArray.data, 0, this.data, 0, intArray.size);
        this.size = intArray.size;
        this.delta_capacity = intArray.delta_capacity;
        this.hash = intArray.hash;
    }

    private void init(int n) {
        this.data = new int[n];
        this.delta_capacity = n / 2;
        this.size = 0;
        this.hash = -1;
    }

    public void calculateHashCode() {
        int n;
        this.hash = n = BurtleHasher.hashlittle(this.data, 13L, this.size);
    }

    public int getCapacity() {
        return this.data.length;
    }

    public void removeValue(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (this.data[n2] != n) continue;
            ++n3;
        }
        if (n3 == 0) {
            return;
        }
        n2 = this.size - n3;
        int[] nArray = new int[n2];
        int n4 = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == n) continue;
            nArray[n4++] = this.data[i];
        }
        this.data = nArray;
        this.size = n2;
    }

    public boolean equals(Object object) {
        IntArray intArray = (IntArray)object;
        boolean bl = true;
        if (this.length() != intArray.length()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == intArray.data[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public int hashCode() {
        return this.hash;
    }

    public int get(int n) {
        return this.data[n];
    }

    public int[] get() {
        this.resize(this.size);
        return this.data;
    }

    public int add(int n) {
        this.facultativeResize();
        this.data[this.size] = n;
        int n2 = this.size++;
        this.hash = -1;
        return n2;
    }

    public int max() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] <= n) continue;
            n = this.data[i];
        }
        return n;
    }

    private void facultativeResize() {
        if (this.size == this.data.length) {
            long l = (long)this.data.length + (long)this.delta_capacity;
            this.resize(l);
            if (this.delta_capacity < MAX_DELTA_CAPACITY) {
                this.delta_capacity *= 2;
            }
        }
    }

    public void add(int[] nArray) {
        int n = this.size + nArray.length;
        if (n > this.data.length) {
            this.resize(n);
        }
        System.arraycopy(nArray, 0, this.data, this.size, nArray.length);
        this.size = n;
        this.hash = -1;
    }

    public void add(List<Integer> list) {
        for (int n : list) {
            this.add(n);
        }
        this.calculateHashCode();
    }

    public void add(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.add(byArray[i]);
        }
    }

    public int length() {
        return this.size;
    }

    public int removeLast() {
        int n = this.get(this.size - 1);
        --this.size;
        return n;
    }

    private void resize(long l) {
        if ((long)this.data.length == l) {
            return;
        }
        int n = 0;
        long l2 = Integer.MAX_VALUE;
        if (l >= l2) {
            n = Integer.MAX_VALUE;
            new RuntimeException("Warning! Maximum length of integer array reached.").printStackTrace();
        } else {
            n = (int)l;
        }
        int[] nArray = new int[n];
        System.arraycopy(this.data, 0, nArray, 0, Math.min(this.data.length, n));
        this.data = nArray;
    }

    public void set(int n, int n2) {
        this.data[n] = n2;
    }

    public List<Integer> toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.length());
        for (int i = 0; i < this.length(); ++i) {
            arrayList.add(this.get(i));
        }
        return arrayList;
    }

    public void clear() {
        this.reset();
    }

    public void reset() {
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DecimalFormat decimalFormat = new DecimalFormat("0");
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(decimalFormat.format(this.data[i]) + " ");
        }
        return stringBuilder.toString();
    }

    public String toString(String string) {
        int n = this.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.get(i));
            if (i >= n - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static IntArray read(InputStream inputStream) throws IOException {
        int n = IntArray.parseInteger(inputStream);
        int n2 = IntArray.parseInteger(inputStream);
        int n3 = IntArray.parseInteger(inputStream);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = IntArray.parseInteger(inputStream);
        }
        IntArray intArray = new IntArray();
        intArray.data = nArray;
        intArray.size = n;
        intArray.delta_capacity = n2;
        intArray.hash = n3;
        return intArray;
    }

    public String write2String() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.size);
        stringBuilder.append(" ");
        stringBuilder.append(this.delta_capacity);
        stringBuilder.append(" ");
        stringBuilder.append(this.hash);
        stringBuilder.append(" ");
        stringBuilder.append(this.toString());
        return stringBuilder.toString();
    }

    public static int parseInteger(InputStream inputStream) throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while (32 != (n = inputStream.read()) && n != -1) {
            stringBuilder.append((char)n);
        }
        int n2 = Integer.parseInt(stringBuilder.toString());
        return n2;
    }

    public void sort() {
        this.resize(this.size);
        Arrays.sort(this.data);
    }

    public static void shuffle(IntArray intArray) {
        Random random = new Random();
        int n = 7;
        int n2 = intArray.length();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = random.nextInt(n2);
                if (n3 == j) continue;
                int n4 = intArray.get(j);
                intArray.set(j, intArray.get(n3));
                intArray.set(n3, n4);
            }
        }
    }

    public static IntArray read(String string) {
        IntArray intArray = new IntArray();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = Integer.parseInt(string2);
            intArray.add(n);
        }
        return intArray;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static List<Integer> toList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(nArray[i]);
        }
        return arrayList;
    }

    public static int[] resize(int[] nArray, int n) {
        int[] nArray2 = null;
        if (nArray.length == n) {
            return nArray2;
        }
        int n2 = 0;
        long l = Integer.MAX_VALUE;
        if ((long)n >= l) {
            n2 = Integer.MAX_VALUE;
            new RuntimeException("Warning! Maximum length of integer array reached.").printStackTrace();
        } else {
            n2 = n;
        }
        nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n2));
        return nArray2;
    }
}

