/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.util.Arrays;

public final class FastSpline {
    private final double[] knots;
    private final Polynome[] polynomials;
    private final int n;

    public FastSpline(double[] dArray, Polynome[] polynomeArray) {
        this.n = dArray.length - 1;
        this.knots = new double[this.n + 1];
        this.polynomials = new Polynome[this.n];
        System.arraycopy(dArray, 0, this.knots, 0, this.n + 1);
        System.arraycopy(polynomeArray, 0, this.polynomials, 0, this.n);
    }

    public final double value(double d) throws ArrayIndexOutOfBoundsException {
        int n = Arrays.binarySearch(this.knots, d);
        if (n < 0) {
            n = -n - 2;
        }
        if (n < 0) {
            n = 0;
        }
        return this.polynomials[n].value(d - this.knots[n]);
    }

    public final FastSpline derivative() {
        Polynome[] polynomeArray = new Polynome[this.n];
        for (int i = 0; i < this.n; ++i) {
            polynomeArray[i] = this.polynomials[i].derivative();
        }
        return new FastSpline(this.knots, polynomeArray);
    }

    public static final class Polynome {
        private final double[] coeffs;

        public Polynome(double[] dArray) {
            this.coeffs = dArray;
        }

        public final Polynome derivative() {
            return new Polynome(new double[]{this.coeffs[1], 2.0 * this.coeffs[2], 3.0 * this.coeffs[3], 0.0});
        }

        public final double value(double d) {
            return this.coeffs[0] + d * (this.coeffs[1] + d * (this.coeffs[2] + d * this.coeffs[3]));
        }

        public final double[] getCoefficients() {
            return this.coeffs;
        }
    }
}

