/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class ExceptFreq
implements Serializable {
    private static final long serialVersionUID = 20122011L;
    private Exception exception;
    private int frequency;
    private List<Date> liDate;

    public ExceptFreq(Exception exception) {
        this.exception = exception;
        this.liDate = new ArrayList<Date>();
        this.increase();
    }

    public void increase() {
        ++this.frequency;
        this.liDate.add(new Date());
    }

    public Exception get() {
        return this.exception;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The exception:\n");
        stringBuilder.append(this.exception.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append(stackTraceElementArray[i].toString());
            stringBuilder.append("\n");
        }
        stringBuilder.append("\nWas called " + this.frequency + " times.");
        return stringBuilder.toString();
    }

    public String toStringShortMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The exception:\n");
        stringBuilder.append(this.exception.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
        stringBuilder.append(stackTraceElementArray[0].toString());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String toStringDates() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The exception:\n");
        stringBuilder.append(this.exception.getMessage() + "\n");
        StackTraceElement[] stackTraceElementArray = this.exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append(stackTraceElementArray[i].toString());
            stringBuilder.append("\n");
        }
        stringBuilder.append("\nWas called " + this.frequency + " times: ");
        if (this.liDate.size() < 1000) {
            for (Date date : this.liDate) {
                stringBuilder.append(date);
                stringBuilder.append(", ");
            }
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

