/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.ExceptFreq;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ErrorHashMap
implements Serializable {
    private static final long serialVersionUID = 20122011L;
    private HashMap<String, ExceptFreq> hmMessage_ExceptionFreq = new HashMap();

    public void add(ErrorHashMap errorHashMap) {
        ArrayList<ExceptFreq> arrayList = new ArrayList<ExceptFreq>(errorHashMap.hmMessage_ExceptionFreq.values());
        for (ExceptFreq exceptFreq : arrayList) {
            this.add(exceptFreq.get());
        }
    }

    public void addAll(List<Exception> list) {
        for (Exception exception : list) {
            this.add(exception);
        }
    }

    public void add(Exception exception) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray.length == 0) {
            String string = exception.getMessage();
            ExceptFreq exceptFreq = this.hmMessage_ExceptionFreq.get(string);
            if (exceptFreq == null) {
                exceptFreq = new ExceptFreq(exception);
                this.hmMessage_ExceptionFreq.put(string, exceptFreq);
            } else {
                exceptFreq.increase();
            }
        } else {
            int n = stackTraceElementArray[0].getLineNumber();
            String string = stackTraceElementArray[0].getMethodName();
            String string2 = string + n;
            ExceptFreq exceptFreq = this.hmMessage_ExceptionFreq.get(string2);
            if (exceptFreq == null) {
                exceptFreq = new ExceptFreq(exception);
                this.hmMessage_ExceptionFreq.put(string2, exceptFreq);
            } else {
                exceptFreq.increase();
            }
        }
    }

    public void clear() {
        this.hmMessage_ExceptionFreq.clear();
    }

    public boolean hasErrors() {
        return this.hmMessage_ExceptionFreq.size() > 0;
    }

    public static void main(String[] stringArray) {
        ErrorHashMap errorHashMap = new ErrorHashMap();
        for (int i = 0; i < 10; ++i) {
            try {
                Integer.parseInt("abc");
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                errorHashMap.add(numberFormatException);
            }
        }
        System.err.println(errorHashMap.toString());
    }

    public int getSize() {
        return this.hmMessage_ExceptionFreq.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<ExceptFreq> arrayList = new ArrayList<ExceptFreq>(this.hmMessage_ExceptionFreq.values());
        for (ExceptFreq exceptFreq : arrayList) {
            stringBuilder.append(exceptFreq.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toStringShortMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<ExceptFreq> arrayList = new ArrayList<ExceptFreq>(this.hmMessage_ExceptionFreq.values());
        for (ExceptFreq exceptFreq : arrayList) {
            stringBuilder.append(exceptFreq.toStringShortMessage());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

