/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.calc.Logarithm;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.util.BitUtils;
import com.actelion.research.util.datamodel.IntArray;
import java.util.Random;

public class EncoderIntegerNumbers {
    private static final int CAPACITY_DATA = 100;
    private int min;
    private int max;
    private int bits;
    private int[] dataEncoded;
    private int ccBitCounter;
    private int ccAddedValuesCounter;
    private boolean finalized;

    public EncoderIntegerNumbers(int[] nArray) {
        int n = Integer.MAX_VALUE;
        int n2 = -2147483647;
        for (int n3 : nArray) {
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (n == n2) {
            throw new RuntimeException("Range is 0!");
        }
        this.initialize(n, n2);
        for (int n3 : nArray) {
            this.add(n3);
        }
    }

    private void initialize(int n, int n2) {
        this.min = n;
        this.max = n2;
        int n3 = this.max - this.min;
        this.bits = Logarithm.log2(n3) + 1;
        this.dataEncoded = new int[100];
        this.ccBitCounter = 0;
        this.ccBitCounter += 8;
        this.ccBitCounter += 32;
        this.ccBitCounter += 32;
        this.ccAddedValuesCounter = 0;
        this.finalized = false;
    }

    private void add(int n) {
        if (this.finalized) {
            throw new RuntimeException("Already finalized!");
        }
        if (n < this.min) {
            throw new RuntimeException("Value lower than minimum!");
        }
        if (n > this.max) {
            throw new RuntimeException("Value higher than maximum!");
        }
        int n2 = n - this.min;
        for (int i = 0; i < this.bits; ++i) {
            if ((1 & n2) == 1) {
                BitUtils.setBit(this.dataEncoded, this.ccBitCounter);
            } else {
                BitUtils.unsetBit(this.dataEncoded, this.ccBitCounter);
            }
            n2 >>= 1;
            ++this.ccBitCounter;
            if (BitUtils.isValidBitIndex(this.dataEncoded, this.ccBitCounter)) continue;
            int n3 = this.dataEncoded.length * 2;
            this.dataEncoded = IntArray.resize(this.dataEncoded, n3);
        }
        ++this.ccAddedValuesCounter;
    }

    private void set(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 + i;
            if ((n & 1) == 1) {
                BitUtils.setBit(this.dataEncoded, n4);
            } else {
                BitUtils.unsetBit(this.dataEncoded, n4);
            }
            n >>= 1;
        }
    }

    private int[] finalizeAndGet() {
        this.finalized = true;
        int n = 0;
        this.set(this.bits, 8, n);
        this.set(this.ccAddedValuesCounter, 32, n += 8);
        this.set(this.min, 32, n += 32);
        int n2 = this.ccBitCounter / 32 + 1;
        int[] nArray = new int[n2];
        System.arraycopy(this.dataEncoded, 0, nArray, 0, n2);
        return nArray;
    }

    private String encode() {
        int[] nArray = this.finalizeAndGet();
        String string = new String(new DescriptorEncoder().encode(nArray));
        return string;
    }

    public static int[] decode(String string) {
        int[] nArray = new DescriptorEncoder().decode(string);
        return EncoderIntegerNumbers.decode(nArray);
    }

    private static int[] decode(int[] nArray) {
        int n = 0;
        int n2 = EncoderIntegerNumbers.decode(nArray, n, 8);
        int n3 = EncoderIntegerNumbers.decode(nArray, n += 8, 32);
        int n4 = EncoderIntegerNumbers.decode(nArray, n += 32, 32);
        n += 32;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n5;
            nArray2[i] = n5 = EncoderIntegerNumbers.decode(nArray, n, n2) + n4;
            n += n2;
        }
        return nArray2;
    }

    private static int decode(int[] nArray, int n, int n2) {
        int n3;
        int n4 = 0;
        for (int i = n3 = n + n2 - 1; i >= n; --i) {
            if (BitUtils.isBitSet(nArray, i)) {
                n4 |= 1;
            }
            if (i <= n) continue;
            n4 <<= 1;
        }
        return n4;
    }

    public static String encode(int[] nArray) {
        EncoderIntegerNumbers encoderIntegerNumbers = new EncoderIntegerNumbers(nArray);
        return encoderIntegerNumbers.encode();
    }

    public static void main(String[] stringArray) {
        IntArray intArray = new IntArray();
        int n = 100;
        int n2 = 0;
        int n3 = 1000;
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            int n4 = 0;
            n4 = random.nextBoolean() ? random.nextInt(n3) : (n2 > 0 ? -random.nextInt(Math.abs(n2)) : random.nextInt(n3));
            intArray.add(n4);
        }
        int[] nArray = intArray.get();
        EncoderIntegerNumbers encoderIntegerNumbers = new EncoderIntegerNumbers(nArray);
        String string = encoderIntegerNumbers.encode();
        System.out.println(string);
        int[] nArray2 = EncoderIntegerNumbers.decode(string);
        for (int i = 0; i < nArray2.length; ++i) {
            System.out.println(nArray[i] + "\t" + nArray2[i]);
        }
    }
}

