/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.Vector;

public class DoubleVec
implements Comparable<DoubleVec> {
    private static final DecimalFormat NF = new DecimalFormat("0.000");
    private static final Random RAND = new Random();
    public static final int COSINE = 1;
    public static final int EUCLIDEAN = 2;
    public static final int EUCLIDEAN_FAST = 3;
    public static final int TANIMOTO = 4;
    public static final int TANIMOTO_INV = 5;
    private double[] data;
    private double mDotProd;

    public DoubleVec(DoubleVec doubleVec) {
        this.init();
        this.data = new double[doubleVec.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = doubleVec.data[i];
        }
    }

    public DoubleVec(DoubleVec doubleVec, boolean bl) {
        this.init();
        this.data = new double[doubleVec.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = doubleVec.data[i];
        }
        if (bl) {
            this.mDotProd = DoubleVec.mult(this.data, this.data);
        }
    }

    public DoubleVec(int n) {
        this.init();
        this.data = new double[n];
    }

    public DoubleVec(double[] dArray) {
        this.init();
        this.data = new double[dArray.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = dArray[i];
        }
    }

    public DoubleVec(int[] nArray) {
        this.init();
        this.data = new double[nArray.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = nArray[i];
        }
    }

    public DoubleVec(double[] dArray, boolean bl) {
        this.init();
        this.data = new double[dArray.length];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = dArray[i];
        }
        if (bl) {
            this.mDotProd = DoubleVec.mult(this.data, this.data);
        }
    }

    public DoubleVec(Vector<Double> vector) {
        this.init();
        this.data = new double[vector.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = vector.get(i);
        }
    }

    public DoubleVec(Vector<Double> vector, boolean bl) {
        this.init();
        this.data = new double[vector.size()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = vector.get(i);
        }
        if (bl) {
            this.mDotProd = DoubleVec.mult(this.data, this.data);
        }
    }

    public void addRNDvalue(double d) {
        Random random = new Random();
        for (int i = 0; i < this.data.length; ++i) {
            double d2 = this.data[i] * (d / 100.0) * random.nextDouble();
            this.data[i] = random.nextBoolean() ? this.data[i] + d2 : this.data[i] - d2;
        }
    }

    public DoubleVec add(DoubleVec doubleVec) {
        DoubleVec doubleVec2 = new DoubleVec(this.data.length);
        if (this.data.length != doubleVec.data.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < doubleVec2.data.length; ++i) {
            doubleVec2.data[i] = this.data[i] + doubleVec.data[i];
        }
        return doubleVec2;
    }

    public void addNoise(double d, double d2, double d3) {
        double d4 = d3 - d2;
        for (int i = 0; i < this.data.length; ++i) {
            double d5;
            if (!(RAND.nextDouble() < d)) continue;
            this.data[i] = d5 = d2 + RAND.nextDouble() * d4;
        }
    }

    public Object clone() {
        DoubleVec doubleVec = new DoubleVec(this);
        return doubleVec;
    }

    @Override
    public int compareTo(DoubleVec doubleVec) {
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > doubleVec.data[i]) {
                n = 1;
                break;
            }
            if (!(this.data[i] < doubleVec.data[i])) continue;
            n = -1;
            break;
        }
        return n;
    }

    public static double distance(DoubleVec doubleVec, DoubleVec doubleVec2, int n) throws Exception {
        double d = 0.0;
        if (n == 1) {
            d = DoubleVec.getCosine(doubleVec, doubleVec2);
        } else if (n == 2) {
            d = DoubleVec.euclideanDistance(doubleVec, doubleVec2);
        } else if (n == 3) {
            d = DoubleVec.getEuclideanDistanceFast(doubleVec, doubleVec2);
        } else if (n == 4) {
            d = DoubleVec.getTanimotoSimilarity(doubleVec, doubleVec2);
        } else if (n == 5) {
            d = DoubleVec.getTanimotoDistanceDotProd(doubleVec, doubleVec2);
        } else {
            throw new Exception("Unknown distance metric.");
        }
        return d;
    }

    public static DoubleVec devide(DoubleVec doubleVec, DoubleVec doubleVec2) {
        DoubleVec doubleVec3 = new DoubleVec(doubleVec.data.length);
        for (int i = 0; i < doubleVec.data.length; ++i) {
            doubleVec3.data[i] = doubleVec.data[i] / doubleVec2.data[i];
        }
        return doubleVec3;
    }

    public boolean equal(DoubleVec doubleVec) {
        boolean bl = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == doubleVec.data[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean equals(DoubleVec doubleVec) {
        boolean bl = true;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == doubleVec.data[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static double euclideanDistance(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            d2 += (doubleVec.data[i] - doubleVec2.data[i]) * (doubleVec.data[i] - doubleVec2.data[i]);
        }
        d = Math.sqrt(d2);
        return d;
    }

    public static double euclideanDistance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += (dArray[i] - dArray2[i]) * (dArray[i] - dArray2[i]);
        }
        d = Math.sqrt(d2);
        return d;
    }

    public static double overlapDistance(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            if (doubleVec.data[i] != 0.0) {
                d2 += 1.0;
            }
            if (doubleVec2.data[i] == 0.0) continue;
            d3 += 1.0;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            if (doubleVec.data[i] == 0.0 || doubleVec2.data[i] == 0.0) continue;
            d4 += Math.abs(doubleVec.data[i] - doubleVec2.data[i]);
            d5 += 1.0;
        }
        d = 1.0 - d5 / Math.min(d2, d3);
        return d;
    }

    public static double getEuclideanDistanceFast(DoubleVec doubleVec, DoubleVec doubleVec2) throws ArrayIndexOutOfBoundsException {
        double d = 0.0;
        try {
            for (int i = 0; i < doubleVec.data.length; i += 4) {
                d += (doubleVec.data[i] - doubleVec2.data[i]) * (doubleVec.data[i] - doubleVec2.data[i]);
                d += (doubleVec.data[i + 1] - doubleVec2.data[i + 1]) * (doubleVec.data[i + 1] - doubleVec2.data[i + 1]);
                d += (doubleVec.data[i + 2] - doubleVec2.data[i + 2]) * (doubleVec.data[i + 2] - doubleVec2.data[i + 2]);
                d += (doubleVec.data[i + 3] - doubleVec2.data[i + 3]) * (doubleVec.data[i + 3] - doubleVec2.data[i + 3]);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return d;
    }

    public double[] get() {
        return this.data;
    }

    public double get(int n) {
        return this.data[n];
    }

    public double getNorm() {
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            d += this.data[i] * this.data[i];
        }
        d = Math.sqrt(d);
        return d;
    }

    public static double getCosine(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            d += doubleVec.data[i] * doubleVec2.data[i];
        }
        return d;
    }

    public static double cubicDistance(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            double d2 = Math.abs(doubleVec.data[i] - doubleVec2.data[i]);
            d += d2 * d2 * d2;
        }
        return d;
    }

    public void initRND(double d, double d2) {
        double d3 = d2 - d;
        for (int i = 0; i < this.data.length; ++i) {
            double d4;
            this.data[i] = d4 = d3 * Math.random() + d;
        }
    }

    private void init() {
        this.mDotProd = Double.NaN;
    }

    public void initRND(double[][] dArray) {
        for (int i = 0; i < this.data.length; ++i) {
            double d;
            double d2 = dArray[0][i] - dArray[1][i];
            this.data[i] = d = d2 * Math.random() + dArray[1][i];
        }
    }

    public static double getManhattanBlockDistance(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            d2 += Math.abs(doubleVec.data[i] - doubleVec2.data[i]);
        }
        d = Math.sqrt(d2);
        return d;
    }

    public DoubleVec mult(double d) {
        DoubleVec doubleVec = new DoubleVec(this.data.length);
        for (int i = 0; i < doubleVec.data.length; ++i) {
            doubleVec.data[i] = this.data[i] * d;
        }
        return doubleVec;
    }

    public static double mult(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        for (int i = 0; i < doubleVec.data.length; ++i) {
            d += doubleVec.data[i] * doubleVec2.data[i];
        }
        return d;
    }

    private static double mult(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static DoubleVec multEl(DoubleVec doubleVec, DoubleVec doubleVec2) {
        DoubleVec doubleVec3 = new DoubleVec(doubleVec.data.length);
        for (int i = 0; i < doubleVec.data.length; ++i) {
            doubleVec3.data[i] = doubleVec.data[i] * doubleVec2.data[i];
        }
        return doubleVec3;
    }

    public void norm2One() {
        double d = this.getNorm();
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] / d;
        }
    }

    public static DoubleVec minus(DoubleVec doubleVec, DoubleVec doubleVec2) {
        DoubleVec doubleVec3 = new DoubleVec(doubleVec.data.length);
        for (int i = 0; i < doubleVec.data.length; ++i) {
            doubleVec3.data[i] = doubleVec.data[i] - doubleVec2.data[i];
        }
        return doubleVec3;
    }

    public void reduce(Vector<Integer> vector) {
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            int n = vector.get(i);
            dArray[i] = this.data[n];
        }
        this.data = dArray;
    }

    public static DoubleVec plus(DoubleVec doubleVec, DoubleVec doubleVec2) {
        DoubleVec doubleVec3 = new DoubleVec(doubleVec.data.length);
        for (int i = 0; i < doubleVec.data.length; ++i) {
            doubleVec3.data[i] = doubleVec.data[i] + doubleVec2.data[i];
        }
        return doubleVec3;
    }

    public void set(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = d;
        }
    }

    public void set(double[] dArray) {
        this.data = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.data[i] = dArray[i];
        }
    }

    public void set(int[] nArray) {
        this.data = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.data[i] = nArray[i];
        }
    }

    public void set(int n, double d) {
        this.data[n] = d;
    }

    public void set(int n, int n2, double d) {
        for (int i = n; i < n2; ++i) {
            this.data[i] = d;
        }
    }

    public void setRNDvalue(double d, double d2) {
        double d3 = d - d2 / 2.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d4 = d2 * Math.random();
            this.data[i] = d3 + d4;
        }
    }

    public int size() {
        return this.data.length;
    }

    public void setRNDvalue(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            double d2 = this.data[i] - d / 2.0;
            double d3 = d * Math.random();
            this.data[i] = d2 + d3;
        }
    }

    public DoubleVec sub(DoubleVec doubleVec) {
        DoubleVec doubleVec2 = new DoubleVec(this.data.length);
        for (int i = 0; i < doubleVec2.data.length; ++i) {
            doubleVec2.data[i] = this.data[i] - doubleVec.data[i];
        }
        return doubleVec2;
    }

    public static double getTanimotoSimilarity(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        double d2 = DoubleVec.mult(doubleVec, doubleVec2);
        double d3 = DoubleVec.mult(doubleVec, doubleVec);
        double d4 = DoubleVec.mult(doubleVec2, doubleVec2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoSimilarity(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = DoubleVec.mult(dArray, dArray2);
        double d3 = DoubleVec.mult(dArray, dArray);
        double d4 = DoubleVec.mult(dArray2, dArray2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoDistance(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        double d2 = DoubleVec.mult(doubleVec, doubleVec2);
        double d3 = DoubleVec.mult(doubleVec, doubleVec);
        double d4 = DoubleVec.mult(doubleVec2, doubleVec2);
        d = 1.0 - d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getTanimotoDistance(double[] dArray, double[] dArray2) {
        return 1.0 - DoubleVec.getTanimotoSimilarity(dArray, dArray2);
    }

    public static double getTanimotoDistanceDotProd(DoubleVec doubleVec, DoubleVec doubleVec2) {
        double d = 0.0;
        double d2 = DoubleVec.mult(doubleVec, doubleVec2);
        double d3 = doubleVec.mDotProd;
        double d4 = doubleVec2.mDotProd;
        d = 1.0 - d2 / (d3 + d4 - d2);
        return d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.data.length; ++i) {
            String string = NF.format(this.data[i]);
            stringBuilder.append(string + " ");
        }
        return stringBuilder.toString();
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "0";
        if (n > 0) {
            string = string + ".";
        }
        for (int i = 0; i < n; ++i) {
            string = string + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = decimalFormat.format(this.data[i]);
            stringBuffer.append(string2 + " ");
        }
        return stringBuffer.toString();
    }

    public double[] toArray() {
        return this.data;
    }
}

