/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.awt.Color;

public class ColorHelper {
    private static final float[] PERCEIVED_BRIGHTNESS = new float[]{0.299f, 0.587f, 0.114f};
    private static final float MIN_CONTRAST_TO_BACKGROUND = 0.3f;

    public static Color intermediateColor(Color color, Color color2, float f) {
        return new Color((int)((float)color.getRed() + f * (float)(color2.getRed() - color.getRed())), (int)((float)color.getGreen() + f * (float)(color2.getGreen() - color.getGreen())), (int)((float)color.getBlue() + f * (float)(color2.getBlue() - color.getBlue())));
    }

    public static int intermediateColor(int n, int n2, float f) {
        int n3 = (n & 0xFF0000) >> 16;
        int n4 = (n & 0xFF00) >> 8;
        int n5 = n & 0xFF;
        int n6 = (n2 & 0xFF0000) >> 16;
        int n7 = (n2 & 0xFF00) >> 8;
        int n8 = n2 & 0xFF;
        return (n3 + Math.round(f * (float)(n6 - n3)) << 16) + (n4 + Math.round(f * (float)(n7 - n4)) << 8) + n5 + Math.round(f * (float)(n8 - n5));
    }

    public static Color brighter(Color color, float f) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = (int)(1.0 / (1.0 - (double)f));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return new Color(Math.min((int)((float)n / f), 255), Math.min((int)((float)n2 / f), 255), Math.min((int)((float)n3 / f), 255), n4);
    }

    public static int brighter(int n, float f) {
        int n2 = n & 0xFF000000;
        int n3 = (n & 0xFF0000) >> 16;
        int n4 = (n & 0xFF00) >> 8;
        int n5 = n & 0xFF;
        int n6 = (int)(1.0 / (1.0 - (double)f));
        if (n3 == 0 && n4 == 0 && n5 == 0) {
            return n2 | n6 << 16 | n6 << 8 | n6;
        }
        if (n3 > 0 && n3 < n6) {
            n3 = n6;
        }
        if (n4 > 0 && n4 < n6) {
            n4 = n6;
        }
        if (n5 > 0 && n5 < n6) {
            n5 = n6;
        }
        return n2 | Math.min((int)((float)n3 / f), 255) << 16 | Math.min((int)((float)n4 / f), 255) << 8 | Math.min((int)((float)n5 / f), 255);
    }

    public static Color darker(Color color, float f) {
        return new Color(Math.max((int)((float)color.getRed() * f), 0), Math.max((int)((float)color.getGreen() * f), 0), Math.max((int)((float)color.getBlue() * f), 0), color.getAlpha());
    }

    public static int darker(int n, float f) {
        return n & 0xFF000000 | Math.round(f * (float)((n & 0xFF0000) >> 16)) << 16 | Math.round(f * (float)((n & 0xFF00) >> 8)) << 8 | Math.round(f * (float)(n & 0xFF));
    }

    public static float perceivedBrightness(Color color) {
        return color == null ? 1.0f : (PERCEIVED_BRIGHTNESS[0] * (float)color.getRed() + PERCEIVED_BRIGHTNESS[1] * (float)color.getGreen() + PERCEIVED_BRIGHTNESS[2] * (float)color.getBlue()) / 255.0f;
    }

    public static float perceivedBrightness(float[] fArray) {
        return PERCEIVED_BRIGHTNESS[0] * fArray[0] + PERCEIVED_BRIGHTNESS[1] * fArray[1] + PERCEIVED_BRIGHTNESS[2] * fArray[2];
    }

    public static float perceivedBrightness(int n) {
        return (PERCEIVED_BRIGHTNESS[0] * (float)((n & 0xFF0000) >> 16) + PERCEIVED_BRIGHTNESS[1] * (float)((n & 0xFF00) >> 8) + PERCEIVED_BRIGHTNESS[2] * (float)(n & 0xFF)) / 255.0f;
    }

    public static Color createColor(Color color, float f) {
        float[] fArray = color.getRGBComponents(null);
        ColorHelper.createColor(fArray, f);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public static int createColor(int n, float f) {
        float[] fArray = new float[4];
        float f2 = 0.003921569f;
        fArray[0] = f2 * (float)((n & 0xFF0000) >> 16);
        fArray[1] = f2 * (float)((n & 0xFF00) >> 8);
        fArray[2] = f2 * (float)(n & 0xFF);
        ColorHelper.createColor(fArray, f);
        return n & 0xFF000000 | Math.round(fArray[0] * 255.0f) << 16 | Math.round(fArray[1] * 255.0f) << 8 | Math.round(fArray[2] * 255.0f);
    }

    private static void createColor(float[] fArray, float f) {
        float f2 = ColorHelper.perceivedBrightness(fArray);
        if (f2 == 0.0f) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            return;
        }
        float f3 = f / f2;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i = 0; i < 3; ++i) {
            int n = i;
            fArray[n] = fArray[n] * f3;
            if (fArray[i] < 1.0f) {
                f5 += PERCEIVED_BRIGHTNESS[i];
                continue;
            }
            f4 += (fArray[i] - 1.0f) * PERCEIVED_BRIGHTNESS[i];
            fArray[i] = 1.0f;
        }
        if (f4 != 0.0f) {
            int n;
            float f6 = 0.0f;
            for (n = 0; n < 3; ++n) {
                if (!(fArray[n] < 1.0f)) continue;
                int n2 = n;
                fArray[n2] = fArray[n2] + f4 / f5;
                if (!(fArray[n] > 1.0f)) continue;
                f6 += (fArray[n] - 1.0f) * PERCEIVED_BRIGHTNESS[n];
                fArray[n] = 1.0f;
            }
            if (f6 != 0.0f) {
                for (n = 0; n < 3; ++n) {
                    if (!(fArray[n] < 1.0f)) continue;
                    int n3 = n;
                    fArray[n3] = fArray[n3] + f6 / PERCEIVED_BRIGHTNESS[n];
                    if (!(fArray[n] > 1.0f)) continue;
                    fArray[n] = 1.0f;
                }
            }
        }
    }

    public static Color getContrastColor(Color color, Color color2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = ColorHelper.perceivedBrightness(color2);
        float f7 = Math.abs(f6 - (f5 = ColorHelper.perceivedBrightness(color)));
        if (f7 > 0.3f) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        double d = Math.abs(fArray2[0] - fArray[0]);
        if (d > 0.5) {
            d = 1.0 - d;
        }
        if (f7 > (f4 = 0.3f * Math.max(f3 = 1.0f - Math.max(fArray2[1], fArray[1]), Math.max(f2 = Math.abs(f5 + f6 - 1.0f), f = (float)Math.cos(Math.PI * d * 3.0))))) {
            return color;
        }
        boolean bl = f5 > f6 ? f5 + f4 > 1.0f : f5 - f4 > 0.0f;
        return ColorHelper.createColor(color, bl ? f6 - f4 : f6 + f4);
    }

    public static int getContrastColor(int n, int n2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = ColorHelper.perceivedBrightness(n2);
        float f7 = Math.abs(f6 - (f5 = ColorHelper.perceivedBrightness(n)));
        if (f7 > 0.3f) {
            return n;
        }
        float[] fArray = Color.RGBtoHSB((n2 & 0xFF0000) >> 16, (n2 & 0xFF00) >> 8, n2 & 0xFF, null);
        float[] fArray2 = Color.RGBtoHSB((n & 0xFF0000) >> 16, (n & 0xFF00) >> 8, n & 0xFF, null);
        double d = Math.abs(fArray2[0] - fArray[0]);
        if (d > 0.5) {
            d = 1.0 - d;
        }
        if (f7 > (f4 = 0.3f * Math.max(f3 = 1.0f - Math.max(fArray2[1], fArray[1]), Math.max(f2 = Math.abs(f5 + f6 - 1.0f), f = (float)Math.cos(Math.PI * d * 3.0))))) {
            return n;
        }
        boolean bl = f5 > f6 ? f5 + f4 > 1.0f : f5 - f4 > 0.0f;
        return ColorHelper.createColor(n, bl ? f6 - f4 : f6 + f4);
    }
}

