/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import com.actelion.research.util.Platform;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class BrowserControl {
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "firefox";
    private static final String OSX_PATH = "open";

    public static void displayURL(String string) {
        new Thread(() -> {
            String string2 = null;
            try {
                Desktop desktop;
                if (Platform.isWindows()) {
                    string2 = "rundll32 url.dll,FileProtocolHandler " + string;
                    Runtime.getRuntime().exec(string2);
                } else if (Platform.isMacintosh()) {
                    string2 = "open " + string;
                    Runtime.getRuntime().exec(string2);
                } else if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(new URI(string));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        uRISyntaxException.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not invoke browser, command=" + string2);
                System.err.println("Caught: " + iOException);
            }
        }).start();
    }

    public static void main(String[] stringArray) {
        BrowserControl.displayURL("http://www.javaworld.com");
    }
}

