/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;

public class BinaryEncoder {
    private BufferedWriter mWriter;
    private int mFreeBufferBits;
    private int mData;
    private int mCharsWritten;
    private int mDataBitCount;
    private int mBitsPerCharacter;
    private int mBaseCharacter;
    private int mLineLength;
    private int[] mMask;

    public static String toString(int[] nArray, int n) {
        StringWriter stringWriter = new StringWriter();
        BinaryEncoder binaryEncoder = new BinaryEncoder(new BufferedWriter(stringWriter));
        try {
            binaryEncoder.initialize(n, nArray.length);
            for (int n2 : nArray) {
                binaryEncoder.write(n2);
            }
            binaryEncoder.finalize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String toString(byte[] byArray, int n) {
        StringWriter stringWriter = new StringWriter();
        BinaryEncoder binaryEncoder = new BinaryEncoder(new BufferedWriter(stringWriter));
        try {
            binaryEncoder.initialize(n, byArray.length);
            for (byte by : byArray) {
                binaryEncoder.write(by);
            }
            binaryEncoder.finalize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public BinaryEncoder(BufferedWriter bufferedWriter) {
        this(bufferedWriter, 6, 64, 80);
    }

    public BinaryEncoder(BufferedWriter bufferedWriter, int n, int n2, int n3) {
        this.mWriter = bufferedWriter;
        this.mBitsPerCharacter = n;
        this.mBaseCharacter = n2;
        this.mLineLength = n3;
        this.mData = 0;
        this.mCharsWritten = 0;
        this.mFreeBufferBits = n;
        this.mMask = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            this.mMask[i] = this.mMask[i - 1] << 1 | 1;
        }
    }

    public void initialize(int n, int n2) throws IOException {
        this.mDataBitCount = 32;
        this.write(n2);
        this.mDataBitCount = n;
    }

    public void write(int n) throws IOException {
        int n2 = this.mDataBitCount;
        while (n2 != 0) {
            int n3 = Math.min(this.mFreeBufferBits, n2);
            int n4 = n & this.mMask[n3] << n2 - n3;
            this.mData |= n2 > this.mFreeBufferBits ? n4 >> n2 - this.mFreeBufferBits : n4 << this.mFreeBufferBits - n2;
            n2 -= n3;
            this.mFreeBufferBits -= n3;
            if (this.mFreeBufferBits != 0) continue;
            this.mWriter.write(this.mBaseCharacter + this.mData);
            this.mFreeBufferBits = this.mBitsPerCharacter;
            this.mData = 0;
            ++this.mCharsWritten;
            if (this.mLineLength == -1 || this.mCharsWritten % this.mLineLength != 0) continue;
            this.mWriter.newLine();
        }
    }

    public void finalize() throws IOException {
        if (this.mFreeBufferBits < this.mBitsPerCharacter) {
            this.mWriter.write(this.mBaseCharacter + this.mData);
            if (this.mLineLength != -1) {
                this.mWriter.newLine();
            }
        } else if (this.mLineLength != -1 && this.mCharsWritten % this.mLineLength != 0) {
            this.mWriter.newLine();
        }
        this.mWriter.flush();
    }
}

