/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class BinaryDecoder {
    private BufferedReader mReader;
    private int mAvailableBufferBits;
    private int mData;
    private int mDataBitCount;
    private int mBitsPerCharacter;
    private int mBaseCharacter;
    private int[] mMask;

    public static byte[] toBytes(String string, int n) {
        BinaryDecoder binaryDecoder = new BinaryDecoder(new BufferedReader(new StringReader(string)));
        try {
            byte[] byArray = new byte[binaryDecoder.initialize(n)];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)binaryDecoder.read();
            }
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static int[] toInts(String string, int n) {
        BinaryDecoder binaryDecoder = new BinaryDecoder(new BufferedReader(new StringReader(string)));
        try {
            int[] nArray = new int[binaryDecoder.initialize(n)];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = binaryDecoder.read();
            }
            return nArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BinaryDecoder(BufferedReader bufferedReader) {
        this(bufferedReader, 6, 64);
    }

    public BinaryDecoder(BufferedReader bufferedReader, int n, int n2) {
        this.mReader = bufferedReader;
        this.mBitsPerCharacter = n;
        this.mBaseCharacter = n2;
        this.mAvailableBufferBits = 0;
        this.mMask = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            this.mMask[i] = this.mMask[i - 1] << 1 | 1;
        }
    }

    public int initialize(int n) throws IOException {
        this.mDataBitCount = 32;
        int n2 = this.read();
        this.mDataBitCount = n;
        return n2;
    }

    public int read() throws IOException {
        int n = 0;
        int n2 = this.mDataBitCount;
        while (n2 != 0) {
            if (this.mAvailableBufferBits == 0) {
                while ((this.mData = this.mReader.read() - this.mBaseCharacter) < 0) {
                }
                this.mAvailableBufferBits = this.mBitsPerCharacter;
            }
            int n3 = Math.min(this.mAvailableBufferBits, n2);
            int n4 = this.mData & this.mMask[n3] << this.mAvailableBufferBits - n3;
            n |= this.mAvailableBufferBits > n2 ? n4 >> this.mAvailableBufferBits - n2 : n4 << n2 - this.mAvailableBufferBits;
            n2 -= n3;
            this.mAvailableBufferBits -= n3;
        }
        return n;
    }
}

