/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.util;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ArrayUtils {
    public static boolean equals(int[] nArray, int[] nArray2) {
        boolean bl = true;
        if (nArray == null && nArray2 == null) {
            return true;
        }
        if (nArray == null) {
            return false;
        }
        if (nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static final Object resize(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        int n2 = Array.getLength(object);
        Class<?> clazz2 = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz2, n);
        System.arraycopy(object, 0, object2, 0, Math.min(n2, n));
        return object2;
    }

    public static final double[] cut(double[] dArray, int n, int n2) {
        int n3;
        double[] dArray2 = new double[dArray.length - n2];
        for (n3 = 0; n3 < n; ++n3) {
            dArray2[n3] = dArray[n3];
        }
        for (n3 = n; n3 < dArray2.length; ++n3) {
            dArray2[n3] = dArray[n3 + n2];
        }
        return dArray2;
    }

    public static final int[] toIntArray(Collection<Integer> collection) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (Integer n2 : collection) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public static final <T> List<T> toList(T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static final List<String> toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static final List<Integer> toList(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        for (int n : nArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    public static final void toList(int[] nArray, List<Integer> list) {
        for (int n : nArray) {
            list.add(n);
        }
    }

    public static final String[] toStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        return stringArray;
    }

    public static final int indexOf(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int[] nArray, int n) {
        return ArrayUtils.indexOf(nArray, n, 0);
    }

    public static final int indexOf(int[] nArray, int n, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(byte[] byArray, byte by) {
        return ArrayUtils.indexOf(byArray, by, 0);
    }

    public static final int indexOf(byte[] byArray, byte by, int n) {
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public static final int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static final double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static final double min(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.min(d, dArray[i]);
        }
        return d;
    }

    public static final double max(double[] dArray) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    public static final int max(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    public static final float max(float[] fArray) {
        if (fArray.length == 0) {
            return 0.0f;
        }
        float f = fArray[0];
        for (int i = 1; i < fArray.length; ++i) {
            f = Math.max(f, fArray[i]);
        }
        return f;
    }

    public static final String toString(int[] nArray) {
        String string = "[";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + (i > 0 ? ", " : "") + nArray[i];
        }
        return string + "]";
    }

    public static final String toString(byte[] byArray) {
        String string = "[";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + (i > 0 ? ", " : "") + byArray[i];
        }
        return string + "]";
    }

    public static final String toString(double[] dArray) {
        String string = "[";
        for (int i = 0; i < dArray.length; ++i) {
            string = string + (i > 0 ? ", " : "") + dArray[i];
        }
        return string + "]";
    }

    public static final String toString(float[] fArray) {
        String string = "[";
        for (int i = 0; i < fArray.length; ++i) {
            string = string + (i > 0 ? ", " : "") + fArray[i];
        }
        return string + "]";
    }

    public static final String toString(double[] dArray, DecimalFormat decimalFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(decimalFormat.format(dArray[i]));
            if (i >= dArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final String toString(Object[] objectArray) {
        String string = "[";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + (i > 0 ? ", " : "") + objectArray[i];
        }
        return string + "]";
    }

    public static final void shift(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[(i + n + nArray.length) % nArray.length];
        }
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
    }

    public static void shuffle(int[] nArray, Random random) {
        int n = 7;
        int n2 = nArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = random.nextInt(n2);
                if (n3 == j) continue;
                int n4 = nArray[j];
                nArray[j] = nArray[n3];
                nArray[n3] = n4;
            }
        }
    }

    public static void shuffle(int[] nArray) {
        Random random = new Random();
        ArrayUtils.shuffle(nArray, random);
    }

    public static <T> void shuffle(T[] TArray) {
        Random random = new Random();
        int n = 7;
        int n2 = TArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = random.nextInt(n2);
                if (n3 == j) continue;
                T t = TArray[j];
                TArray[j] = TArray[n3];
                TArray[n3] = t;
            }
        }
    }

    public static final Object copy(Object object) {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return null;
        }
        int n = Array.getLength(object);
        Class<?> clazz2 = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz2, n);
        System.arraycopy(object, 0, object2, 0, n);
        return object2;
    }

    public static final boolean contains(List<int[]> list, int[] nArray) {
        for (int[] nArray2 : list) {
            if (nArray.length != nArray2.length) continue;
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray2[i] == nArray[i]) continue;
            }
            return true;
        }
        return false;
    }

    public static void set(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = bl;
        }
    }
}

