/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.DrawAction;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IMouseEvent;
import java.awt.geom.Point2D;

public class ZoomRotateAction
extends DrawAction {
    private Point2D origin = null;

    public ZoomRotateAction(Model model) {
        super(model);
    }

    @Override
    public void onActionEnter() {
        this.model.pushUndo();
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        this.origin = new Point2D.Double(iMouseEvent.getX(), iMouseEvent.getY());
        StereoMolecule stereoMolecule = this.model.getMolecule();
        stereoMolecule.zoomAndRotateInit((float)this.origin.getX(), (float)this.origin.getY());
        return false;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        return true;
    }

    @Override
    public boolean onMouseMove(IMouseEvent iMouseEvent, boolean bl) {
        if (bl) {
            boolean bl2 = false;
            StereoMolecule stereoMolecule = this.model.getMolecule();
            for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                if (!stereoMolecule.isSelectedAtom(i)) continue;
                bl2 = true;
            }
            Point2D.Double double_ = new Point2D.Double(iMouseEvent.getX(), iMouseEvent.getY());
            float f = Math.abs(((Point2D)double_).getY() - this.origin.getY()) < 20.0 ? 1.0f : (float)Math.exp((((Point2D)double_).getY() - this.origin.getY()) / 100.0);
            float f2 = Math.abs(((Point2D)double_).getX() - this.origin.getX()) < 20.0 ? 0.0f : (float)(((Point2D)double_).getX() - this.origin.getX()) / 50.0f;
            stereoMolecule.zoomAndRotate(f, f2, bl2);
            return true;
        }
        return false;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        return false;
    }

    @Override
    public int getCursor() {
        return 54;
    }
}

