/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.share.gui.DialogResult;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.BondHighlightAction;
import com.actelion.research.share.gui.editor.chem.IDrawingObject;
import com.actelion.research.share.gui.editor.dialogs.IAtomQueryFeaturesDialog;
import com.actelion.research.share.gui.editor.dialogs.IBondQueryFeaturesDialog;
import com.actelion.research.share.gui.editor.geom.GeomFactory;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.geom.IPolygon;
import com.actelion.research.share.gui.editor.io.IKeyEvent;
import com.actelion.research.share.gui.editor.io.IMouseEvent;
import java.util.List;

public class SelectionAction
extends BondHighlightAction {
    private volatile IPolygon polygon;
    private GeomFactory factory;
    int atom = -1;
    int bond = -1;
    boolean shift = false;
    boolean duplicate = false;
    boolean rectangular = false;
    boolean changed = false;

    public SelectionAction(Model model) {
        super(model);
        this.factory = model.getGeomFactory();
        this.polygon = this.factory.createPolygon();
    }

    @Override
    public boolean onKeyPressed(IKeyEvent iKeyEvent) {
        this.shift = iKeyEvent.isShiftDown();
        this.rectangular = iKeyEvent.isAltDown();
        return super.onKeyPressed(iKeyEvent);
    }

    @Override
    public boolean onKeyReleased(IKeyEvent iKeyEvent) {
        this.shift = false;
        this.rectangular = false;
        this.duplicate = false;
        return super.onKeyReleased(iKeyEvent);
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        StereoMolecule stereoMolecule = this.model.getMoleculeAt(genericPoint, true);
        this.polygon = this.factory.createPolygon();
        this.polygon.add(genericPoint);
        this.duplicate = false;
        this.changed = false;
        this.model.pushUndo();
        this.last = this.origin = new GenericPoint(genericPoint.getX(), genericPoint.getY());
        this.atom = this.getAtomAt(stereoMolecule, this.origin);
        this.bond = this.getBondAt(stereoMolecule, this.origin);
        if (this.atom != -1) {
            if (!stereoMolecule.isSelectedAtom(this.atom)) {
                if (!this.shift) {
                    this.deselectAllAtoms();
                }
                stereoMolecule.setAtomSelection(this.atom, true);
            }
        } else if (this.bond != -1 && !stereoMolecule.isSelectedBond(this.bond)) {
            if (!this.shift) {
                this.deselectAllAtoms();
            }
            int n = stereoMolecule.getBondAtom(0, this.bond);
            int n2 = stereoMolecule.getBondAtom(1, this.bond);
            stereoMolecule.setAtomSelection(n, true);
            stereoMolecule.setAtomSelection(n2, true);
        }
        return false;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        this.polygon = this.factory.createPolygon();
        this.bond = -1;
        this.atom = -1;
        this.last = null;
        this.origin = null;
        this.duplicate = false;
        if (!this.changed) {
            this.model.popUndo();
            this.deselectAllAtoms();
        }
        this.changed = false;
        return true;
    }

    @Override
    public boolean onMouseMove(IMouseEvent iMouseEvent, boolean bl) {
        boolean bl2 = false;
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        if (bl) {
            double d = this.last.getX() - genericPoint.getX();
            double d2 = this.last.getY() - genericPoint.getY();
            if (!this.shift || this.duplicate) {
                bl2 = this.moveAtomsAndBonds(d, d2, this.model.getSelectedDrawingObject() != null);
                if (bl2) {
                    this.moveSelectedDrawItems(d, d2);
                } else if (this.model.getSelectedDrawingObject() != null) {
                    this.moveSelectedDrawItem(d, d2);
                    bl2 = true;
                }
                if (!bl2) {
                    bl2 = this.selectItems(genericPoint);
                }
                this.changed = bl2;
            } else if (this.shift) {
                this.duplicate = true;
                this.duplicateSelected();
                this.changed = true;
            }
        } else {
            bl2 = this.trackHighLight(genericPoint);
        }
        this.last = genericPoint;
        return bl2;
    }

    private void moveSelectedDrawItem(double d, double d2) {
        IDrawingObject iDrawingObject = this.model.getSelectedDrawingObject();
        if (iDrawingObject != null && iDrawingObject.isMovable()) {
            iDrawingObject.move((float)(-d), (float)(-d2));
        }
    }

    @Override
    boolean trackHighLight(GenericPoint genericPoint) {
        boolean bl = false;
        IDrawingObject iDrawingObject = this.model.getSelectedDrawingObject();
        List<IDrawingObject> list = this.model.getDrawingObjects();
        this.model.setSelectedDrawingObject(null);
        for (IDrawingObject iDrawingObject2 : list) {
            if (!iDrawingObject2.getBoundingRect().contains(genericPoint.getX(), genericPoint.getY())) continue;
            this.model.setSelectedDrawingObject(iDrawingObject2);
            bl = true;
            break;
        }
        boolean bl2 = bl || iDrawingObject != null || super.trackHighLight(genericPoint);
        return bl2;
    }

    @Override
    public boolean onDoubleClick(IMouseEvent iMouseEvent) {
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        StereoMolecule stereoMolecule = this.model.getMoleculeAt(genericPoint, true);
        if (stereoMolecule != null) {
            int n = stereoMolecule.findAtom((float)genericPoint.getX(), (float)genericPoint.getY());
            int n2 = stereoMolecule.findBond((float)genericPoint.getX(), (float)genericPoint.getY());
            boolean bl = iMouseEvent.isShiftDown();
            if (stereoMolecule.isFragment()) {
                if (n != -1) {
                    return this.showAtomQFDialog(n);
                }
                if (n2 != -1) {
                    return this.showBondQFDialog(n2);
                }
            } else {
                int n3 = -1;
                if (n != -1) {
                    n3 = n;
                } else if (n2 != -1) {
                    n3 = stereoMolecule.getBondAtom(0, n2);
                }
                if (n3 != -1) {
                    if (!bl) {
                        this.deselectAllAtoms();
                        if (this.model.isReaction()) {
                            this.model.selectFragmentByAtom(n3);
                        } else {
                            for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                                stereoMolecule.setAtomSelection(i, true);
                            }
                        }
                    }
                    return true;
                }
            }
        } else {
            IDrawingObject iDrawingObject = this.model.getSelectedDrawingObject();
            if (iDrawingObject != null) {
                if (iMouseEvent.isShiftDown()) {
                    this.deselectAllAtoms();
                    this.deselectAllDrawingObjects();
                }
                iDrawingObject.setSelected(true);
                this.model.setSelectedDrawingObject(iDrawingObject);
            }
        }
        return false;
    }

    @Override
    public int getCursor() {
        int n = this.model.getSelectedAtom();
        int n2 = this.model.getSelectedBond();
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (this.shift && this.rectangular) {
            return 53;
        }
        if (this.shift) {
            return 51;
        }
        if (this.rectangular) {
            return 52;
        }
        if (n != -1 && stereoMolecule.isSelectedAtom(n)) {
            return this.shift ? 48 : 47;
        }
        if (n2 != -1 && stereoMolecule.isSelectedBond(n2)) {
            return this.shift ? 48 : 47;
        }
        if (n != -1 || n2 != -1) {
            return 0;
        }
        return 50;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        iDrawContext.save();
        super.paint(iDrawContext);
        iDrawContext.setStroke(this.factory.getSelectionColor());
        if (this.rectangular && this.origin != null && this.last != null) {
            this.drawDashedRect(iDrawContext);
            return true;
        }
        if (this.polygon != null && this.polygon.size() > 1) {
            this.drawPolygon(iDrawContext);
            return true;
        }
        iDrawContext.setStroke(this.factory.getHighLightColor());
        iDrawContext.setFill(this.factory.getHighLightColor());
        IDrawingObject iDrawingObject = this.model.getSelectedDrawingObject();
        if (iDrawingObject != null) {
            iDrawingObject.draw(iDrawContext, null);
        }
        iDrawContext.restore();
        return false;
    }

    private void drawDashedRect(IDrawContext iDrawContext) {
        GenericRectangle genericRectangle = this.makeRect(this.origin, this.last);
        if (genericRectangle.getWidth() > 5.0 && genericRectangle.getHeight() > 5.0) {
            this.drawDashedRect(iDrawContext, genericRectangle.getX(), genericRectangle.getY(), genericRectangle.getWidth(), genericRectangle.getHeight(), new int[]{5, 2});
        }
    }

    private void drawPolygon(IDrawContext iDrawContext) {
        iDrawContext.drawPolygon(this.polygon);
    }

    private void drawDashedLine(IDrawContext iDrawContext, double d, double d2, double d3, double d4, int[] nArray) {
        iDrawContext.drawDashedLine(d, d2, d3, d4, nArray);
    }

    private void drawDashedRect(IDrawContext iDrawContext, double d, double d2, double d3, double d4, int[] nArray) {
        this.drawDashedLine(iDrawContext, d, d2, d + d3, d2, nArray);
        this.drawDashedLine(iDrawContext, d, d2, d, d2 + d4, nArray);
        this.drawDashedLine(iDrawContext, d, d2 + d4, d + d3, d2 + d4, nArray);
        this.drawDashedLine(iDrawContext, d + d3, d2 + d4, d + d3, d2, nArray);
    }

    private boolean moveAtomsAndBonds(double d, double d2, boolean bl) {
        boolean bl2 = false;
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            if (stereoMolecule != null && this.atom != -1 || bl) {
                this.translateAtoms(stereoMolecule, d, d2, true);
                bl2 = true;
            } else if (stereoMolecule != null && this.bond != -1 || bl) {
                this.translateBonds(stereoMolecule, d, d2, true);
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean selectItems(GenericPoint genericPoint) {
        boolean bl = false;
        if (this.rectangular) {
            this.selectRectanglarRegion(null);
            bl = true;
        } else if (this.selectPolygonRegion(null, genericPoint)) {
            bl = true;
        }
        return bl;
    }

    private boolean moveSelectedDrawItems(double d, double d2) {
        boolean bl = false;
        for (IDrawingObject iDrawingObject : this.model.getDrawingObjects()) {
            if (!iDrawingObject.isSelected() || !iDrawingObject.isMovable()) continue;
            iDrawingObject.move((float)(-d), (float)(-d2));
            bl = true;
        }
        return bl;
    }

    private void duplicateSelected() {
        int n;
        StereoMolecule stereoMolecule = this.model.getMolecule();
        int n2 = stereoMolecule.getAllAtoms();
        int n3 = stereoMolecule.getAllBonds();
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        int n4 = stereoMolecule.renumberESRGroups(1);
        int n5 = stereoMolecule.renumberESRGroups(2);
        for (n = 0; n < n2; ++n) {
            int n6;
            if (!stereoMolecule.isSelectedAtom(n)) continue;
            nArray[n] = n6 = stereoMolecule.getAllAtoms();
            stereoMolecule.copyAtom(stereoMolecule, n, n4, n5);
        }
        for (n = 0; n < n3; ++n) {
            if (!stereoMolecule.isSelectedBond(n)) continue;
            stereoMolecule.copyBond(stereoMolecule, n, n4, n5, nArray, false);
        }
        for (n = 0; n < n2; ++n) {
            stereoMolecule.setAtomSelection(n, false);
        }
        for (n = n2; n < stereoMolecule.getAllAtoms(); ++n) {
            stereoMolecule.setAtomMapNo(n, 0, false);
        }
    }

    private void duplicateSelectedOl() {
        int n;
        int n2;
        StereoMolecule stereoMolecule = this.model.getMolecule();
        int n3 = 0;
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            if (!stereoMolecule.isSelectedAtom(n2)) continue;
            ++n3;
        }
        n2 = stereoMolecule.getAllAtoms();
        int n4 = stereoMolecule.getAllBonds();
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        int n5 = stereoMolecule.renumberESRGroups(1);
        int n6 = stereoMolecule.renumberESRGroups(2);
        for (n = 0; n < n2; ++n) {
            int n7;
            if (!stereoMolecule.isSelectedAtom(n)) continue;
            nArray[n] = n7 = stereoMolecule.getAllAtoms();
            stereoMolecule.copyAtom(stereoMolecule, n, n5, n6);
        }
        for (n = 0; n < n4; ++n) {
            if (!stereoMolecule.isSelectedBond(n)) continue;
            stereoMolecule.copyBond(stereoMolecule, n, n5, n6, nArray, false);
        }
        for (n = 0; n < n2; ++n) {
            stereoMolecule.setAtomSelection(n, false);
        }
        for (n = n2; n < stereoMolecule.getAllAtoms(); ++n) {
            stereoMolecule.setAtomMapNo(n, 0, false);
        }
    }

    private boolean selectPolygonRegion(StereoMolecule stereoMolecule, GenericPoint genericPoint) {
        if (this.polygon.size() > 1 && Math.abs(genericPoint.getX() - this.polygon.get(this.polygon.size() - 1).getX()) < 10.0 && Math.abs(genericPoint.getY() - this.polygon.get(this.polygon.size() - 1).getY()) < 10.0) {
            return false;
        }
        if (this.origin == null) {
            throw new RuntimeException("NUll DOWN Point!");
        }
        this.polygon.remove(this.origin);
        this.polygon.add(genericPoint);
        this.polygon.add(this.origin);
        this.deselectAllAtoms();
        this.deselectAllDrawingObjects();
        this.selectFromPolygonRegion();
        return true;
    }

    private void selectFromPolygonRegion() {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            boolean bl = this.polygon.contains(stereoMolecule.getAtomX(i), stereoMolecule.getAtomY(i));
            stereoMolecule.setAtomSelection(i, bl);
        }
        List<IDrawingObject> list = this.model.getDrawingObjects();
        for (IDrawingObject iDrawingObject : list) {
            GenericRectangle genericRectangle = iDrawingObject.getBoundingRect();
            if (!this.polygon.contains(genericRectangle.x + genericRectangle.width / 2.0, genericRectangle.y + genericRectangle.height / 2.0)) continue;
            iDrawingObject.setSelected(true);
        }
    }

    private void deselectAllAtoms() {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        this.deselectAtoms(stereoMolecule);
    }

    private void selectRectanglarRegion(StereoMolecule stereoMolecule) {
        GenericRectangle genericRectangle = this.makeRect(this.origin, this.last);
        boolean bl = false;
        if (stereoMolecule != null) {
            this.selectAtomsInRectangle(stereoMolecule, genericRectangle);
            bl = true;
        } else {
            StereoMolecule stereoMolecule2 = this.model.getMolecule();
            this.deselectAtoms(stereoMolecule2);
            GenericRectangle genericRectangle2 = this.factory.getBoundingRect(stereoMolecule2);
            if (genericRectangle2 != null && genericRectangle2.intersects(genericRectangle)) {
                this.selectRectanglarRegion(stereoMolecule2);
            }
        }
        if (!bl) {
            this.selectDrawingObjectsInRectangle(genericRectangle);
        }
    }

    private void deselectAtoms(StereoMolecule stereoMolecule) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            stereoMolecule.setAtomSelection(i, false);
        }
    }

    private void selectDrawingObjectsInRectangle(GenericRectangle genericRectangle) {
        for (IDrawingObject iDrawingObject : this.model.getDrawingObjects()) {
            iDrawingObject.setSelected(false);
            GenericRectangle genericRectangle2 = iDrawingObject.getBoundingRect();
            if (!genericRectangle.contains(genericRectangle2.x + genericRectangle2.width / 2.0, genericRectangle2.y + genericRectangle2.height / 2.0)) continue;
            iDrawingObject.setSelected(true);
        }
    }

    private void selectAtomsInRectangle(StereoMolecule stereoMolecule, GenericRectangle genericRectangle) {
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            boolean bl = genericRectangle.contains(stereoMolecule.getAtomX(i), stereoMolecule.getAtomY(i));
            stereoMolecule.setAtomSelection(i, bl);
        }
    }

    private void translateBonds(StereoMolecule stereoMolecule, double d, double d2, boolean bl) {
        int n = stereoMolecule.getBondAtom(0, this.bond);
        int n2 = stereoMolecule.getBondAtom(1, this.bond);
        if (bl) {
            this.translateAtoms(stereoMolecule, d, d2, true);
        } else {
            this.translateAtom(stereoMolecule, n, d, d2);
            this.translateAtom(stereoMolecule, n2, d, d2);
        }
    }

    private void translateAtom(StereoMolecule stereoMolecule, int n, double d, double d2) {
        stereoMolecule.setAtomX(n, stereoMolecule.getAtomX(n) - d);
        stereoMolecule.setAtomY(n, stereoMolecule.getAtomY(n) - d2);
    }

    private void translateAtoms(StereoMolecule stereoMolecule, double d, double d2, boolean bl) {
        if (bl) {
            for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
                if (!stereoMolecule.isSelectedAtom(i)) continue;
                this.translateAtom(stereoMolecule, i, d, d2);
            }
        } else {
            this.translateAtom(stereoMolecule, this.atom, d, d2);
        }
    }

    private GenericRectangle makeRect(GenericPoint genericPoint, GenericPoint genericPoint2) {
        double d = Math.min(genericPoint.getX(), genericPoint2.getX());
        double d2 = Math.min(genericPoint.getY(), genericPoint2.getY());
        double d3 = Math.abs(genericPoint.getX() - genericPoint2.getX());
        double d4 = Math.abs(genericPoint.getY() - genericPoint2.getY());
        return new GenericRectangle(d, d2, d3, d4);
    }

    private void deselectAllDrawingObjects() {
        for (IDrawingObject iDrawingObject : this.model.getDrawingObjects()) {
            iDrawingObject.setSelected(false);
        }
    }

    private boolean showAtomQFDialog(int n) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            boolean bl = (this.model.getMode() & 4) != 0;
            IAtomQueryFeaturesDialog iAtomQueryFeaturesDialog = this.factory.createAtomQueryFeatureDialog(stereoMolecule, n, bl);
            return iAtomQueryFeaturesDialog.doModalAt(this.lastHightlightPoint.getX(), this.lastHightlightPoint.getY()) == DialogResult.IDOK;
        }
        return false;
    }

    private boolean showBondQFDialog(int n) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            IBondQueryFeaturesDialog iBondQueryFeaturesDialog = this.factory.createBondFeaturesDialog(stereoMolecule, n);
            return iBondQueryFeaturesDialog.doModalAt(this.lastHightlightPoint.getX(), this.lastHightlightPoint.getY()) == DialogResult.IDOK;
        }
        return false;
    }
}

