/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.DrawConfig;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.Action;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IKeyEvent;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public abstract class DrawAction
implements Action {
    public static final double HIGHLIGHT_ATOM_RADIUS = 5.0;
    public static final int MAX_CONNATOMS = 8;
    public static final String UNKNOWN = "<unknown>";
    public static final int KEYSTROKEFONTSIZE = 24;
    protected Model model;

    public DrawAction(Model model) {
        this.model = model;
    }

    @Override
    public void onCommand() {
    }

    @Override
    public final boolean isCommand() {
        return false;
    }

    @Override
    public boolean onKeyPressed(IKeyEvent iKeyEvent) {
        return false;
    }

    @Override
    public boolean onKeyReleased(IKeyEvent iKeyEvent) {
        return false;
    }

    @Override
    public int getCursor() {
        return 0;
    }

    @Override
    public boolean onDoubleClick(IMouseEvent iMouseEvent) {
        return false;
    }

    @Override
    public void onActionLeave() {
    }

    @Override
    public void onActionEnter() {
    }

    int getAtomAt(GenericPoint genericPoint) {
        StereoMolecule stereoMolecule = this.model.getMoleculeAt(genericPoint, false);
        return this.getAtomAt(stereoMolecule, genericPoint);
    }

    int getBondAt(GenericPoint genericPoint) {
        StereoMolecule stereoMolecule = this.model.getMoleculeAt(genericPoint, true);
        return this.getBondAt(stereoMolecule, genericPoint);
    }

    int getBondAt(StereoMolecule stereoMolecule, GenericPoint genericPoint) {
        if (stereoMolecule != null) {
            return stereoMolecule.findBond((float)genericPoint.getX(), (float)genericPoint.getY());
        }
        return -1;
    }

    int getAtomAt(StereoMolecule stereoMolecule, GenericPoint genericPoint) {
        if (stereoMolecule != null) {
            return stereoMolecule.findAtom((float)genericPoint.getX(), (float)genericPoint.getY());
        }
        return -1;
    }

    protected void drawBondHighlight(IDrawContext iDrawContext, StereoMolecule stereoMolecule, int n) {
        int n2 = (int)((double)0.32f * stereoMolecule.getAverageBondLength());
        if (n2 < 5) {
            n2 = 5;
        }
        double d = stereoMolecule.getAtomX(stereoMolecule.getBondAtom(0, n));
        double d2 = stereoMolecule.getAtomY(stereoMolecule.getBondAtom(0, n));
        double d3 = stereoMolecule.getAtomX(stereoMolecule.getBondAtom(1, n));
        double d4 = stereoMolecule.getAtomY(stereoMolecule.getBondAtom(1, n));
        DrawConfig drawConfig = this.model.getGeomFactory().getDrawConfig();
        iDrawContext.save();
        iDrawContext.setLineWidth(n2);
        iDrawContext.setStroke(drawConfig.getHighLightColor());
        iDrawContext.drawLine(d, d2, d3, d4);
        iDrawContext.restore();
    }

    protected void highlightAtom(StereoMolecule stereoMolecule, int n) {
        this.model.setSelectedAtom(n);
    }

    protected void drawAtomHighlight(IDrawContext iDrawContext, StereoMolecule stereoMolecule, int n) {
        this.drawAtomHighlightElement(iDrawContext, stereoMolecule, n);
        if (this.model.getKeyStrokeBuffer().length() > 0) {
            this.drawAtomKeyStrokes(iDrawContext, stereoMolecule, n);
        }
    }

    private void drawAtomHighlightElement(IDrawContext iDrawContext, StereoMolecule stereoMolecule, int n) {
        int n2 = (int)((double)0.32f * stereoMolecule.getAverageBondLength());
        if (n2 < 5) {
            n2 = 5;
        }
        DrawConfig drawConfig = this.model.getGeomFactory().getDrawConfig();
        GenericPoint genericPoint = new GenericPoint(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n));
        iDrawContext.save();
        iDrawContext.setFill(drawConfig.getHighLightColor());
        iDrawContext.fillElipse(genericPoint.getX() - (double)n2, genericPoint.getY() - (double)n2, 2 * n2, 2 * n2);
        iDrawContext.restore();
    }

    protected void drawAtomKeyStrokes(IDrawContext iDrawContext, StereoMolecule stereoMolecule, int n) {
        String string = this.model.getKeyStrokeBuffer().toString();
        int n2 = this.model.getAtomKeyStrokeValidity(string);
        GenericPoint genericPoint = new GenericPoint(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n));
        DrawConfig drawConfig = this.model.getGeomFactory().getDrawConfig();
        iDrawContext.save();
        iDrawContext.setFill(n2 == 1 ? drawConfig.getForegroundColor() : (n2 == 2 ? 65535L : (n2 == 3 ? 0xAAAAAAFFL : 0xFF00000FFL)));
        if (n2 == 4) {
            string = string + UNKNOWN;
        }
        iDrawContext.setFont(iDrawContext.getFont(), 24.0, false);
        iDrawContext.fillText(string, genericPoint.getX(), genericPoint.getY());
        iDrawContext.restore();
    }

    protected GenericPoint suggestNewX2AndY2(int n) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        stereoMolecule.ensureHelperArrays(1);
        double d = 2.0943951023931953;
        if (n != -1) {
            int n2;
            double[] dArray = new double[9];
            for (n2 = 0; n2 < stereoMolecule.getAllConnAtoms(n); ++n2) {
                dArray[n2] = stereoMolecule.getBondAngle(n, stereoMolecule.getConnAtom(n, n2));
            }
            if (stereoMolecule.getAllConnAtoms(n) == 0) {
                d = 2.0943951023931953;
            } else if (stereoMolecule.getAllConnAtoms(n) == 1) {
                d = dArray[0] < -2.6179938779914944 ? 1.0471975511965976 : (dArray[0] < -1.5707963267948966 ? 2.0943951023931953 : (dArray[0] < -0.5235987755982988 ? 1.0471975511965976 : (dArray[0] < 0.0 ? 2.0943951023931953 : (dArray[0] < 0.5235987755982988 ? -2.0943951023931953 : (dArray[0] < 1.5707963267948966 ? -1.0471975511965976 : (dArray[0] < 2.6179938779914944 ? -2.0943951023931953 : -1.0471975511965976))))));
            } else {
                for (n2 = stereoMolecule.getAllConnAtoms(n) - 1; n2 > 0; --n2) {
                    for (int i = 0; i < n2; ++i) {
                        if (!(dArray[i] > dArray[i + 1])) continue;
                        double d2 = dArray[i];
                        dArray[i] = dArray[i + 1];
                        dArray[i + 1] = d2;
                    }
                }
                dArray[stereoMolecule.getAllConnAtoms((int)n)] = dArray[0] + Math.PI * 2;
                n2 = 0;
                double d3 = 0.0;
                for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
                    double d4 = dArray[i + 1] - dArray[i];
                    if (!(d3 < d4)) continue;
                    d3 = d4;
                    n2 = i;
                }
                d = (dArray[n2] + dArray[n2 + 1]) / 2.0;
            }
        }
        double d5 = stereoMolecule.getAverageBondLength();
        return new GenericPoint(stereoMolecule.getAtomX(n) + d5 * Math.sin(d), stereoMolecule.getAtomY(n) + d5 * Math.cos(d));
    }
}

