/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.BondHighlightAction;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public abstract class BondBaseAction
extends BondHighlightAction {
    protected BondBaseAction(Model model) {
        super(model);
    }

    public abstract int getBondType();

    public void onAddBond(int n, int n2) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            int n3 = this.getBondType();
            if (n3 == 1) {
                n3 = stereoMolecule.suggestBondType(n, n2);
            }
            stereoMolecule.addBond(n, n2, n3);
            stereoMolecule.ensureHelperArrays(1);
        }
    }

    public void onChangeBond(int n) {
        StereoMolecule stereoMolecule = this.model.getMolecule();
        if (stereoMolecule != null) {
            stereoMolecule.changeBond(n, 511);
            stereoMolecule.ensureHelperArrays(1);
        }
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        boolean bl = true;
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        this.model.pushUndo();
        int n = this.getAtomAt(this.origin);
        int n2 = this.model.getSelectedAtom();
        this.model.setSelectedBond(-1);
        StereoMolecule stereoMolecule = this.model.getMoleculeAt(this.origin, true);
        this.model.setSelectedAtom(n);
        if (!this.dragging) {
            if (stereoMolecule != null && n != -1) {
                if (stereoMolecule.getAllConnAtoms(n) != 8) {
                    GenericPoint genericPoint2 = this.suggestNewX2AndY2(n);
                    int n3 = stereoMolecule.findAtom((float)genericPoint2.getX(), (float)genericPoint2.getY());
                    if (n3 != -1) {
                        int n4 = this.getBondType();
                        if (n4 == 1) {
                            n4 = stereoMolecule.suggestBondType(n, n3);
                        }
                        stereoMolecule.addOrChangeBond(n, n3, n4);
                    } else {
                        int n5 = stereoMolecule.addAtom((float)genericPoint2.getX(), (float)genericPoint2.getY(), 0.0);
                        this.onAddBond(n, n5);
                    }
                    bl = true;
                }
            } else if (stereoMolecule != null) {
                int n6 = this.getBondAt(stereoMolecule, genericPoint);
                if (n6 != -1) {
                    this.onChangeBond(n6);
                } else {
                    n = stereoMolecule.addAtom((float)genericPoint.getX(), (float)genericPoint.getY());
                    GenericPoint genericPoint3 = this.suggestNewX2AndY2(n);
                    int n7 = stereoMolecule.addAtom((float)genericPoint3.getX(), (float)genericPoint3.getY(), 0.0);
                    this.onAddBond(n, n7);
                }
                bl = true;
            } else {
                stereoMolecule = this.model.getMolecule();
                n = stereoMolecule.addAtom((float)iMouseEvent.getX(), (float)iMouseEvent.getY());
                GenericPoint genericPoint4 = this.suggestNewX2AndY2(n);
                int n8 = stereoMolecule.addAtom((float)genericPoint4.getX(), (float)genericPoint4.getY());
                this.onAddBond(n, n8);
                if (this.model.isReaction()) {
                    this.model.needsLayout(true);
                }
                bl = true;
            }
        } else if (stereoMolecule != null) {
            if (n != -1) {
                StereoMolecule stereoMolecule2;
                int n9 = n2;
                if (n9 == -1) {
                    double d = this.origin.getX() - genericPoint.getX();
                    double d2 = this.origin.getY() - genericPoint.getY();
                    GenericPoint genericPoint5 = genericPoint;
                    if (d * d + d2 * d2 < 100.0) {
                        genericPoint5 = this.suggestNewX2AndY2(n);
                    }
                    n9 = stereoMolecule.addAtom((float)genericPoint5.getX(), (float)genericPoint5.getY(), 0.0);
                }
                if (stereoMolecule == (stereoMolecule2 = this.model.getMoleculeAt(genericPoint, true))) {
                    this.onAddBond(n, n9);
                } else if (stereoMolecule2 != null) {
                    stereoMolecule.addMolecule(stereoMolecule2);
                    n9 = stereoMolecule.findAtom((float)genericPoint.getX(), (float)genericPoint.getY());
                    this.model.deleteMolecule(stereoMolecule2);
                    this.onAddBond(n, n9);
                }
                bl = true;
            } else {
                int n10 = stereoMolecule.addAtom((float)this.origin.getX(), (float)this.origin.getY());
                int n11 = stereoMolecule.addAtom((float)genericPoint.getX(), (float)genericPoint.getY());
                this.onAddBond(n10, n11);
                if (this.model.isReaction()) {
                    this.model.needsLayout(true);
                }
                bl = true;
            }
        } else {
            stereoMolecule = this.model.getMolecule();
            int n12 = stereoMolecule.addAtom((float)this.origin.getX(), (float)this.origin.getY());
            int n13 = stereoMolecule.addAtom((float)genericPoint.getX(), (float)genericPoint.getY());
            this.onAddBond(n12, n13);
            bl = true;
        }
        this.dragging = false;
        return bl;
    }

    @Override
    public boolean paint(IDrawContext iDrawContext) {
        boolean bl = super.paint(iDrawContext);
        if (this.dragging) {
            this.drawBondLine(iDrawContext);
            bl = true;
        }
        return bl;
    }

    private void drawBondLine(IDrawContext iDrawContext) {
        GenericPoint genericPoint = this.origin;
        if (genericPoint != null && this.last != null) {
            int n = this.getAtomAt(genericPoint);
            StereoMolecule stereoMolecule = this.model.getMoleculeAt(genericPoint, true);
            if (stereoMolecule != null && n != -1) {
                genericPoint = new GenericPoint(stereoMolecule.getAtomX(n), stereoMolecule.getAtomY(n));
            }
            iDrawContext.save();
            iDrawContext.drawLine(genericPoint.getX(), genericPoint.getY(), this.last.getX(), this.last.getY());
            iDrawContext.restore();
        }
    }
}

