/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui.editor.actions;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.Model;
import com.actelion.research.share.gui.editor.actions.BondHighlightAction;
import com.actelion.research.share.gui.editor.io.IMouseEvent;

public class AddRingAction
extends BondHighlightAction {
    Model model;
    int ringSize = 0;
    boolean aromatic = false;

    public AddRingAction(Model model, int n, boolean bl) {
        super(model);
        this.model = model;
        this.ringSize = n;
        this.aromatic = bl;
    }

    @Override
    public boolean onMouseDown(IMouseEvent iMouseEvent) {
        return false;
    }

    @Override
    public boolean onMouseUp(IMouseEvent iMouseEvent) {
        this.model.pushUndo();
        StereoMolecule stereoMolecule = this.model.getMolecule();
        GenericPoint genericPoint = new GenericPoint(iMouseEvent.getX(), iMouseEvent.getY());
        boolean bl = false;
        if (stereoMolecule != null) {
            int n = this.getAtomAt(stereoMolecule, genericPoint);
            int n2 = this.getBondAt(stereoMolecule, genericPoint);
            if (n != -1) {
                bl = stereoMolecule.addRing((float)genericPoint.getX(), (float)genericPoint.getY(), this.ringSize, this.aromatic, Molecule.getDefaultAverageBondLength());
                this.model.setSelectedBond(-1);
            } else if (n2 != -1) {
                bl = stereoMolecule.addRing((float)genericPoint.getX(), (float)genericPoint.getY(), this.ringSize, this.aromatic, Molecule.getDefaultAverageBondLength());
                this.model.setSelectedAtom(-1);
            } else {
                bl = stereoMolecule.addRing((float)genericPoint.getX(), (float)genericPoint.getY(), this.ringSize, this.aromatic, Molecule.getDefaultAverageBondLength());
                if (this.model.isReaction()) {
                    this.model.needsLayout(true);
                }
            }
        } else {
            stereoMolecule = new StereoMolecule();
            bl = stereoMolecule.addRing((float)genericPoint.getX(), (float)genericPoint.getY(), this.ringSize, this.aromatic, Molecule.getDefaultAverageBondLength());
            this.model.setValue(stereoMolecule, true);
        }
        if (bl) {
            stereoMolecule.ensureHelperArrays(1);
        }
        return bl;
    }

    @Override
    protected boolean onDrag(GenericPoint genericPoint) {
        return true;
    }
}

