/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.share.gui;

import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.share.gui.DrawConfig;
import com.actelion.research.share.gui.editor.chem.IDrawingObject;
import com.actelion.research.share.gui.editor.geom.IDrawContext;

public class Arrow
implements IDrawingObject {
    protected final DrawConfig gfxConfig;
    protected GenericRectangle rect = null;
    private boolean selected = false;

    public Arrow(DrawConfig drawConfig, double d, double d2, double d3, double d4) {
        this.gfxConfig = drawConfig;
        this.rect = new GenericRectangle(d, d2, d3, d4);
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void move(float f, float f2) {
        this.rect.set(this.rect.getX() + (double)f, this.rect.getY() + (double)f2, this.rect.getWidth(), this.rect.getHeight());
    }

    @Override
    public GenericRectangle getBoundingRect() {
        return this.rect;
    }

    @Override
    public void setRect(float f, float f2, float f3, float f4) {
        this.rect = new GenericRectangle(f, f2, f3, f4);
    }

    @Override
    public void scale(float f) {
        this.rect.set(this.rect.getX() * (double)f, this.rect.getY() * (double)f, this.rect.getWidth() * (double)f, this.rect.getHeight() * (double)f);
    }

    @Override
    public void draw(IDrawContext iDrawContext, DepictorTransformation depictorTransformation) {
        double d = depictorTransformation == null ? this.rect.getX() : depictorTransformation.transformX((float)this.rect.getX());
        double d2 = depictorTransformation == null ? this.rect.getY() : depictorTransformation.transformY((float)this.rect.getY());
        double d3 = depictorTransformation == null ? this.rect.getWidth() : depictorTransformation.transformX((float)this.rect.getWidth());
        double d4 = depictorTransformation == null ? this.rect.getHeight() : depictorTransformation.transformY((float)this.rect.getHeight());
        double d5 = d + d3;
        double d6 = d2 + d4 / 2.0;
        double d7 = d3 / 15.0;
        double[] dArray = new double[]{d5 - d7, d5, d5 - d3 / 5.0};
        double[] dArray2 = new double[]{d6, d6, d6 - d3 / 10.0};
        if (this.selected) {
            iDrawContext.setStroke(this.gfxConfig.getSelectionColor());
            iDrawContext.setFill(this.gfxConfig.getSelectionColor());
        }
        if (d5 - d >= 5.0) {
            iDrawContext.drawLine((int)d, (int)d6, (double)((int)d5) - d7, (int)d6);
        }
        iDrawContext.fillPolygon(dArray, dArray2, 3);
        dArray2[2] = (int)(d6 + d3 / 10.0);
        iDrawContext.fillPolygon(dArray, dArray2, 3);
    }

    @Override
    public boolean isMovable() {
        return false;
    }

    public boolean isOnProductSide(float f, float f2) {
        return (double)f > this.rect.getX() + this.rect.getWidth() / 2.0;
    }
}

