/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.jfx.gui.chem;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.jfx.dataformat.MoleculeDataFormats;
import com.actelion.research.jfx.gui.chem.IMoleculeView;
import com.actelion.research.jfx.gui.chem.JFXCanvasDepictor;
import com.actelion.research.jfx.gui.chem.MoleculeViewSkin;
import com.actelion.research.jfx.gui.misc.ClipboardHelper;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.scene.control.Control;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;

public class MoleculeView
extends Control
implements IMoleculeView {
    private boolean transparent;
    private boolean fillSize = false;
    private static final PseudoClass PSEUDO_CLASS_READONLY;
    private BooleanProperty editable = new SimpleBooleanProperty(this, "editable", true){

        protected void invalidated() {
            MoleculeView.this.pseudoClassStateChanged(PSEUDO_CLASS_READONLY, !this.get());
        }
    };

    public MoleculeView() {
        this.setPrefSize(100.0, 100.0);
        this.setSkin(new MoleculeViewSkin(this));
    }

    public MoleculeView(StereoMolecule stereoMolecule) {
        this();
        this.setValue(stereoMolecule);
    }

    protected void layoutChildren() {
        super.layoutChildren();
    }

    @Override
    public void setMolecule(StereoMolecule stereoMolecule) {
        ((MoleculeViewSkin)this.getSkin()).setMolecule(stereoMolecule);
    }

    public AbstractDepictor createDepictor(StereoMolecule stereoMolecule) {
        return new JFXCanvasDepictor(stereoMolecule);
    }

    public ObjectProperty<StereoMolecule> valueProperty() {
        return ((MoleculeViewSkin)this.getSkin()).valueProperty();
    }

    public StringProperty idcodeProperty() {
        return ((MoleculeViewSkin)this.getSkin()).idcodeProperty();
    }

    public final void setValue(StereoMolecule stereoMolecule) {
        ((MoleculeViewSkin)this.getSkin()).setValue(stereoMolecule);
    }

    public final StereoMolecule getValue() {
        return ((MoleculeViewSkin)this.getSkin()).getValue();
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    protected ClipboardContent getContent(MouseEvent mouseEvent) {
        return ClipboardHelper.writeContent(this.getValue());
    }

    protected boolean putContent(Clipboard clipboard) {
        StereoMolecule stereoMolecule = ClipboardHelper.readContent(clipboard);
        if (stereoMolecule != null) {
            this.setValue(stereoMolecule);
            return true;
        }
        return false;
    }

    public Color getBackgroundColor() {
        return ((MoleculeViewSkin)this.getSkin()).getBackgroundColor();
    }

    public void setBackgroundColor(Color color) {
        ((MoleculeViewSkin)this.getSkin()).setBackgroundColor(color);
    }

    public boolean sizeContent() {
        return this.fillSize;
    }

    public void sizeContent(boolean bl) {
        this.fillSize = bl;
    }

    public final boolean isEditable() {
        return this.editable.getValue();
    }

    public final void setEditable(boolean bl) {
        this.editable.setValue(Boolean.valueOf(bl));
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    static {
        MoleculeDataFormats.DATA_FORMATS.toString();
        PSEUDO_CLASS_READONLY = PseudoClass.getPseudoClass((String)"readonly");
    }
}

