/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.jfx.gui;

import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.share.gui.editor.geom.IDrawContext;
import com.actelion.research.share.gui.editor.geom.IPolygon;
import java.awt.Dimension;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class GraphicsContextImpl
implements IDrawContext<GraphicsContext> {
    GraphicsContext ctx;

    public GraphicsContextImpl(GraphicsContext graphicsContext) {
        this.ctx = graphicsContext;
    }

    public GraphicsContext getContext() {
        return this.ctx;
    }

    public static Color createColor(long l) {
        double d = (double)((l & 0xFF000000L) >> 24) / 255.0;
        double d2 = (double)((l & 0xFF0000L) >> 16) / 255.0;
        double d3 = (double)((l & 0xFF00L) >> 8) / 255.0;
        double d4 = (double)(l & 0xFFL) / 255.0;
        return new Color(d, d2, d3, d4);
    }

    @Override
    public GraphicsContext getNative() {
        return this.ctx;
    }

    @Override
    public void drawLine(double d, double d2, double d3, double d4) {
        this.ctx.setLineCap(StrokeLineCap.ROUND);
        this.ctx.setLineJoin(StrokeLineJoin.MITER);
        this.ctx.beginPath();
        this.ctx.moveTo(d, d2);
        this.ctx.lineTo(d3, d4);
        this.ctx.stroke();
    }

    @Override
    public void drawDashedLine(double d, double d2, double d3, double d4, int[] nArray) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.atan2(d6, d5);
        double d8 = d;
        double d9 = d2;
        int n = 0;
        boolean bl = true;
        this.ctx.beginPath();
        this.ctx.moveTo(d, d2);
        while (!(d5 < 0.0 ? d8 <= d3 : d8 >= d3) || !(!(d6 < 0.0) ? d9 >= d4 : d9 <= d4)) {
            double d10 = nArray[n++ % nArray.length];
            double d11 = d8 + Math.cos(d7) * d10;
            d8 = d5 < 0.0 ? Math.max(d3, d11) : Math.min(d3, d11);
            double d12 = d9 + Math.sin(d7) * d10;
            double d13 = d9 = d6 < 0.0 ? Math.max(d4, d12) : Math.min(d4, d12);
            if (bl) {
                this.ctx.lineTo(d8, d9);
            } else {
                this.ctx.moveTo(d8, d9);
            }
            bl = !bl;
        }
        this.ctx.closePath();
        this.ctx.stroke();
    }

    @Override
    public void drawPolygon(IPolygon iPolygon) {
        this.ctx.beginPath();
        GenericPoint genericPoint = iPolygon.get(0);
        this.ctx.moveTo(genericPoint.getX(), genericPoint.getY());
        for (int i = 1; i < iPolygon.size(); ++i) {
            genericPoint = iPolygon.get(i);
            this.ctx.lineTo(genericPoint.getX(), genericPoint.getY());
        }
        this.ctx.closePath();
        this.ctx.stroke();
    }

    @Override
    public Dimension getBounds(String string) {
        Font font = this.ctx.getFont();
        Text text = new Text(string);
        text.setFont(font);
        Bounds bounds = text.getLayoutBounds();
        Dimension dimension = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
        return dimension;
    }

    @Override
    public void setFont(String string, double d, boolean bl) {
        this.ctx.setFont(Font.font((String)string, (FontWeight)(bl ? FontWeight.BOLD : null), (double)d));
    }

    @Override
    public String getFont() {
        return this.ctx.getFont().getName();
    }

    @Override
    public void setFill(long l) {
        this.ctx.setFill((Paint)GraphicsContextImpl.createColor(l));
    }

    @Override
    public void fillText(String string, double d, double d2) {
        this.ctx.fillText(string, d, d2);
    }

    @Override
    public void save() {
        this.ctx.save();
    }

    @Override
    public void restore() {
        this.ctx.restore();
    }

    @Override
    public void drawRect(double d, double d2, double d3, double d4) {
        this.ctx.strokeRect(d, d2, d3, d4);
    }

    @Override
    public void drawText(String string, double d, double d2, boolean bl, boolean bl2) {
        this.ctx.setTextAlign(bl ? TextAlignment.CENTER : TextAlignment.LEFT);
        this.ctx.setTextBaseline(bl2 ? VPos.CENTER : VPos.TOP);
        this.ctx.strokeText(string, d, d2);
    }

    @Override
    public void clearRect(double d, double d2, double d3, double d4) {
        this.ctx.clearRect(d, d2, d3, d4);
    }

    @Override
    public void setStroke(long l) {
        this.ctx.setStroke((Paint)GraphicsContextImpl.createColor(l));
    }

    @Override
    public void fillElipse(double d, double d2, double d3, double d4) {
        this.ctx.fillArc(d, d2, d3, d4, 0.0, 360.0, ArcType.ROUND);
    }

    @Override
    public void fillRect(double d, double d2, double d3, double d4) {
        this.ctx.fillRect(d, d2, d3, d4);
    }

    @Override
    public void strokeLine(double d, double d2, double d3, double d4) {
        this.ctx.beginPath();
        this.ctx.moveTo(d, d2);
        this.ctx.lineTo(d3, d4);
        this.ctx.stroke();
    }

    @Override
    public void fillPolygon(double[] dArray, double[] dArray2, int n) {
        this.ctx.fillPolygon(dArray, dArray2, n);
    }

    @Override
    public void setLineWidth(double d) {
        this.ctx.setLineWidth(d);
    }
}

