/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.wmf;

import com.actelion.research.gui.wmf.WMF;
import com.actelion.research.gui.wmf.WMFGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class WMFGraphics2D
extends Graphics2D {
    private BufferedImage img;
    private WMFGraphics wmfg;
    private Graphics2D g2D;
    private AffineTransform trans;
    private Stroke stroke;
    private Paint paint;
    private Color color;
    private Shape deviceclip;
    private boolean gdifontdrawing;
    private boolean gdipendrawing;
    private boolean gdipenwidthdrawing;
    private double flatness;

    public WMFGraphics2D(WMF wMF, int n, int n2, Color color, Color color2) {
        this.gdifontdrawing = true;
        this.gdipendrawing = true;
        this.gdipenwidthdrawing = true;
        this.flatness = 0.1;
        if (color == null) {
            color = Color.black;
        }
        if (color2 == null) {
            color2 = Color.white;
        }
        this.wmfg = new WMFGraphics(wMF, n, n2, color, color2);
        this.img = new BufferedImage(1, 1, 2);
        this.g2D = (Graphics2D)this.img.getGraphics();
        this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.trans = new AffineTransform();
        this.stroke = this.g2D.getStroke();
        this.paint = color;
        this.color = color;
        this.deviceclip = null;
    }

    private WMFGraphics2D(WMFGraphics2D wMFGraphics2D) {
        this.wmfg = (WMFGraphics)wMFGraphics2D.wmfg.create();
        this.trans = (AffineTransform)wMFGraphics2D.trans.clone();
        this.stroke = wMFGraphics2D.stroke;
        this.paint = wMFGraphics2D.paint;
        this.color = wMFGraphics2D.color;
        this.deviceclip = wMFGraphics2D.deviceclip;
        this.img = new BufferedImage(wMFGraphics2D.img.getWidth(), wMFGraphics2D.img.getHeight(), 2);
        this.flatness = wMFGraphics2D.flatness;
        this.gdifontdrawing = wMFGraphics2D.gdifontdrawing;
        this.gdipendrawing = wMFGraphics2D.gdipendrawing;
        this.gdipenwidthdrawing = wMFGraphics2D.gdipenwidthdrawing;
        this.g2D = (Graphics2D)wMFGraphics2D.img.getGraphics();
        this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.g2D.addRenderingHints(map);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.paint;
        this.setColor(this.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    @Override
    public void clip(Shape shape) {
        if (this.deviceclip != null) {
            Area area = new Area(this.getClip());
            if (shape != null) {
                area.intersect(new Area(shape));
            }
            shape = area;
        }
        this.setClip(shape);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g2D.copyArea(n, n2, n3, n4, n5, n6);
    }

    @Override
    public Graphics create() {
        WMFGraphics2D wMFGraphics2D = new WMFGraphics2D(this);
        return wMFGraphics2D;
    }

    @Override
    public void dispose() {
        this.wmfg.dispose();
        this.g2D.dispose();
        this.img.flush();
    }

    private void draw(Shape shape, int n) {
        Shape shape2 = null;
        shape = this.trans.createTransformedShape(shape);
        if (this.deviceclip != null) {
            shape2 = this.deviceclip;
        }
        AffineTransform affineTransform = new AffineTransform();
        PathIterator pathIterator = shape.getPathIterator(affineTransform, this.flatness);
        float[] fArray = new float[6];
        Vector<Polygon> vector = new Vector<Polygon>();
        Polygon polygon = null;
        float[] fArray2 = new float[6];
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    if (polygon != null) {
                        vector.add(polygon);
                    }
                    polygon = new Polygon();
                    polygon.addPoint((int)((double)fArray[0] + 0.5), (int)((double)fArray[1] + 0.5));
                    System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
                    break;
                }
                case 3: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)fArray[2] + 0.5), (int)((double)fArray[3] + 0.5));
                    break;
                }
                case 2: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)fArray[4] + 0.5), (int)((double)fArray[5] + 0.5));
                    break;
                }
                case 1: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)fArray[0] + 0.5), (int)((double)fArray[1] + 0.5));
                    break;
                }
                case 4: {
                    if (polygon == null) break;
                    polygon.addPoint((int)fArray2[0], (int)fArray2[1]);
                    vector.add(polygon);
                    polygon = null;
                    break;
                }
            }
            pathIterator.next();
        }
        if (polygon != null) {
            vector.add(polygon);
        }
        Polygon[] polygonArray = new Polygon[vector.size()];
        int n3 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            polygonArray[n3] = (Polygon)iterator.next();
            ++n3;
        }
        int n4 = this.wmfg.getPenStyle();
        int n5 = this.wmfg.getBrushFillStyle();
        this.wmfg.setClip(shape2);
        this.wmfg.setColor(this.getColor());
        this.wmfg.setPenStyle(0);
        if (this.gdipenwidthdrawing) {
            this.wmfg.setPenWidth(n);
        } else {
            this.wmfg.setPenWidth(0);
        }
        this.wmfg.setGDIHollowBrush();
        for (int i = 0; i < polygonArray.length; ++i) {
            this.wmfg.drawPolyline(polygonArray[i].xpoints, polygonArray[i].ypoints, polygonArray[i].npoints);
        }
        this.wmfg.setBrushFillStyle(n5);
        this.wmfg.setPenStyle(n4);
    }

    @Override
    public void fill(Shape shape) {
        Shape shape2 = this.deviceclip;
        this.wmfg.setClip(shape2);
        Shape shape3 = this.trans.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape3.getBounds2D();
        if (this.deviceclip != null) {
            rectangle2D = rectangle2D.createIntersection(this.deviceclip.getBounds2D());
        }
        if (!(this.getPaint() instanceof Color)) {
            Rectangle rectangle = rectangle2D.getBounds();
            PaintContext paintContext = this.paint.createContext(this.img.getColorModel(), rectangle, shape.getBounds(), this.trans, this.getRenderingHints());
            Raster raster = paintContext.getRaster(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            BufferedImage bufferedImage = new BufferedImage(paintContext.getColorModel(), raster.createCompatibleWritableRaster(), false, null);
            bufferedImage.setData(raster);
            BufferedImage bufferedImage2 = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.addRenderingHints(this.getRenderingHints());
            graphics2D.setTransform(AffineTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
            graphics2D.setClip(rectangle2D);
            graphics2D.drawImage((Image)bufferedImage, rectangle.x, rectangle.y, null);
            this.wmfg.drawImage(bufferedImage2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            return;
        }
        AffineTransform affineTransform = new AffineTransform();
        PathIterator pathIterator = shape3.getPathIterator(affineTransform, this.flatness);
        if (pathIterator.getWindingRule() == 0) {
            this.wmfg.setPolyFillMode(1);
        } else {
            this.wmfg.setPolyFillMode(2);
        }
        int n = this.wmfg.getPenStyle();
        this.wmfg.setPenStyle(5);
        this.wmfg.setColor(this.getColor());
        float[] fArray = new float[6];
        Vector<Polygon> vector = new Vector<Polygon>();
        Polygon polygon = null;
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    if (polygon != null) {
                        vector.add(polygon);
                    }
                    polygon = new Polygon();
                    polygon.addPoint((int)((double)fArray[0] + 0.5), (int)((double)fArray[1] + 0.5));
                    break;
                }
                case 3: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)fArray[2] + 0.5), (int)((double)fArray[3] + 0.5));
                    break;
                }
                case 2: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)fArray[4] + 0.5), (int)((double)fArray[5] + 0.5));
                    break;
                }
                case 1: {
                    if (polygon == null) break;
                    polygon.addPoint((int)((double)fArray[0] + 0.5), (int)((double)fArray[1] + 0.5));
                    break;
                }
                case 4: {
                    if (polygon == null) break;
                    vector.add(polygon);
                    polygon = null;
                    break;
                }
            }
            pathIterator.next();
        }
        if (polygon != null) {
            vector.add(polygon);
        }
        Polygon[] polygonArray = new Polygon[vector.size()];
        int n3 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            polygonArray[n3] = (Polygon)iterator.next();
            ++n3;
        }
        boolean bl = false;
        if (shape instanceof Arc2D) {
            bl = true;
        }
        if (!bl) {
            this.wmfg.GDIPolyPolygon(polygonArray);
        } else {
            for (int i = 0; i < polygonArray.length; ++i) {
                this.wmfg.fillPolygon(polygonArray[i]);
            }
        }
        this.wmfg.setPenStyle(n);
    }

    @Override
    public void draw(Shape shape) {
        if (this.gdipendrawing && this.getPaint() instanceof Color && this.stroke instanceof BasicStroke && (((BasicStroke)this.stroke).getDashArray() == null || ((BasicStroke)this.stroke).getDashArray().length == 0)) {
            this.draw(shape, (int)((BasicStroke)this.stroke).getLineWidth());
        }
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.fill(glyphVector.getOutline(f, f2));
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int[] nArray = new int[]{n, n2, n3, n4, n5, n6, n7, n8};
        Rectangle rectangle = new Line2D.Float(n, n2, n3, n4).getBounds();
        Shape shape = this.trans.createTransformedShape(rectangle);
        Rectangle rectangle2 = shape.getBounds();
        Image image2 = this.transformImage(image, nArray, rectangle2, imageObserver, color);
        this.wmfg.setClip(null);
        this.wmfg.drawImage(image2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, imageObserver);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Shape shape = this.trans.createTransformedShape(rectangle);
        Rectangle rectangle2 = shape.getBounds();
        Image image2 = this.transformImage(image, rectangle, rectangle2, imageObserver, color);
        this.wmfg.setClip(null);
        this.wmfg.drawImage(image2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, imageObserver);
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), imageObserver);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        AffineTransform affineTransform2 = (AffineTransform)this.trans.clone();
        this.trans.concatenate(affineTransform);
        this.drawImage(image, 0, 0, imageObserver);
        this.trans = affineTransform2;
        return true;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage(bufferedImage2, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new GeneralPath(new Line2D.Float(n, n2, n3, n4)));
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n > 0) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            this.draw(generalPath);
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this.draw(rectangle);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = new BufferedImage(renderedImage.getColorModel(), renderedImage.getData().createCompatibleWritableRaster(), false, null);
        bufferedImage.setData(renderedImage.getData());
        this.drawImage(bufferedImage, affineTransform, null);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (this.isGDIFontDrawing() && this.getPaint() instanceof Color) {
            boolean bl;
            boolean bl2 = bl = this.deviceclip == null;
            if (!bl) {
                GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), string);
                Rectangle2D rectangle2D = glyphVector.getOutline(f, f2).getBounds2D();
                bl = this.deviceclip.contains(this.trans.createTransformedShape(rectangle2D).getBounds2D());
            }
            if (bl) {
                boolean bl3 = this.trans.isIdentity() && this.getFont().getTransform().isIdentity();
                double d = 1.0;
                double d2 = 0.0;
                if (!bl3) {
                    AffineTransform affineTransform = this.getFont().getTransform();
                    affineTransform.preConcatenate(this.trans);
                    d = affineTransform.getScaleX();
                    boolean bl4 = bl3 = affineTransform.getShearX() == -affineTransform.getShearY() && affineTransform.getScaleX() == affineTransform.getScaleY();
                    if (bl3 && (affineTransform.getShearX() != 0.0 || affineTransform.getScaleX() < 0.0)) {
                        d = Math.sqrt(affineTransform.getScaleX() * affineTransform.getScaleX() + affineTransform.getShearX() * affineTransform.getShearX());
                        d2 = Math.acos(affineTransform.getScaleX() / d);
                        if (affineTransform.getShearX() > 0.0) {
                            d2 = -d2;
                        }
                    }
                }
                if (bl3) {
                    this.wmfg.setColor(this.getColor());
                    float f3 = (float)((double)this.getFont().getSize2D() * d);
                    Font font = this.getFont();
                    this.wmfg.setFont(this.getFont().deriveFont(f3));
                    if (d2 != 0.0) {
                        this.wmfg.setFontEscapement((int)(-d2 * 1800.0 / Math.PI));
                    }
                    Point2D.Double double_ = new Point2D.Double((double)f + this.getFont().getTransform().getTranslateX(), (double)f2 + this.getFont().getTransform().getTranslateY());
                    this.trans.transform(double_, double_);
                    this.wmfg.drawString(string, (int)double_.getX(), (int)double_.getY());
                    if (d2 != 0.0) {
                        this.wmfg.setFontEscapement(0);
                    }
                    this.wmfg.setFont(font);
                    return;
                }
            }
        }
        this.drawGlyphVector(this.getFont().createGlyphVector(this.getFontRenderContext(), string), f, f2);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Paint paint = this.getPaint();
        this.setColor(this.getColor());
        this.fill(textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2)));
        this.setPaint(paint);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, n, n2);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Float(n, n2, n3, n4));
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    @Override
    public Color getBackground() {
        return this.wmfg.getBackground();
    }

    @Override
    public Shape getClip() {
        try {
            return this.trans.createInverse().createTransformedShape(this.deviceclip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.deviceclip != null) {
            return this.getClip().getBounds();
        }
        return null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Composite getComposite() {
        return this.g2D.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g2D.getDeviceConfiguration();
    }

    public double getFlatness() {
        return this.flatness;
    }

    @Override
    public Font getFont() {
        return this.wmfg.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.wmfg.getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        this.g2D.setTransform(this.trans);
        return this.g2D.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g2D.getRenderingHint(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g2D.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.trans.clone();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        this.g2D.setTransform(this.trans);
        this.g2D.setStroke(this.getStroke());
        this.g2D.setClip(this.getClip());
        return this.g2D.hit(rectangle, shape, bl);
    }

    public boolean isGDIFontDrawing() {
        return this.gdifontdrawing;
    }

    public boolean isGDIPenDrawing() {
        return this.gdipendrawing;
    }

    public boolean isGDIPenWidthDrawing() {
        return this.gdipenwidthdrawing;
    }

    @Override
    public void rotate(double d) {
        this.trans.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.trans.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.trans.scale(d, d2);
    }

    @Override
    public void setBackground(Color color) {
        this.wmfg.setBackground(color);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(Shape shape) {
        this.deviceclip = this.trans.createTransformedShape(shape);
    }

    @Override
    public void setColor(Color color) {
        this.setPaint(color);
    }

    @Override
    public void setComposite(Composite composite) {
        this.g2D.setComposite(composite);
    }

    public void setFlatness(double d) {
        this.flatness = d;
    }

    @Override
    public void setFont(Font font) {
        this.wmfg.setFont(font);
    }

    public void setGDIFontDrawing(boolean bl) {
        this.gdifontdrawing = bl;
    }

    public void setGDIPenDrawing(boolean bl) {
        this.gdipendrawing = bl;
    }

    public void setGDIPenWidthDrawing(boolean bl) {
        this.gdipenwidthdrawing = bl;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (paint instanceof Color) {
                this.color = (Color)paint;
            }
        }
    }

    @Override
    public void setPaintMode() {
        this.wmfg.setPaintMode();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g2D.setRenderingHint(key, object);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.g2D.setRenderingHints(map);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.trans = (AffineTransform)affineTransform.clone();
    }

    @Override
    public void setXORMode(Color color) {
        this.wmfg.setXORMode(color);
    }

    @Override
    public void shear(double d, double d2) {
        this.trans.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.trans.concatenate(affineTransform);
    }

    private Image transformImage(Image image, Rectangle rectangle, Rectangle rectangle2, ImageObserver imageObserver, Color color) {
        Object object;
        if (this.trans.isIdentity() && this.getClip() == null && color == null) {
            return image;
        }
        if (this.deviceclip != null) {
            object = new Area(this.deviceclip);
            ((Area)object).intersect(new Area(this.trans.createTransformedShape(rectangle)));
            rectangle2.setBounds(((Area)object).getBounds());
        }
        object = new BufferedImage(rectangle2.width, rectangle2.height, 2);
        Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
        graphics2D.addRenderingHints(this.getRenderingHints());
        graphics2D.translate(-rectangle2.x, -rectangle2.y);
        graphics2D.transform((AffineTransform)this.getTransform().clone());
        graphics2D.setClip(this.getClip());
        if (color != null) {
            graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, color, imageObserver);
        } else {
            graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, imageObserver);
        }
        graphics2D.dispose();
        return object;
    }

    private Image transformImage(Image image, int[] nArray, Rectangle rectangle, ImageObserver imageObserver, Color color) {
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.addRenderingHints(this.getRenderingHints());
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.transform((AffineTransform)this.getTransform().clone());
        graphics2D.setClip(this.getClip());
        if (color != null) {
            graphics2D.drawImage(image, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7], color, imageObserver);
        } else {
            graphics2D.drawImage(image, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7], imageObserver);
        }
        return bufferedImage;
    }

    @Override
    public void translate(double d, double d2) {
        this.trans.translate(d, d2);
    }

    @Override
    public void translate(int n, int n2) {
        this.trans.translate(n, n2);
    }
}

