/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.table;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableWithRowNumbers
extends JTable
implements TableModelListener {
    private static final long serialVersionUID = 537266438L;
    private RowNumberTable mRowNumberTable = null;
    private JScrollPane mScrollPane = null;
    private Cursor mResizeCursor;
    private Cursor mDefaultCursor;
    private boolean mIsResizing;
    private int mRowHeaderMinWidth;
    private int mResizingRowY;
    private int mResizingRowHeight;
    private int mHeaderLineCount;

    public JTableWithRowNumbers() {
        this.initialize();
    }

    public JTableWithRowNumbers(int n, int n2) {
        super(n, n2);
        this.initialize();
    }

    public JTableWithRowNumbers(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initialize();
    }

    public JTableWithRowNumbers(TableModel tableModel) {
        super(tableModel);
        this.initialize();
    }

    public JTableWithRowNumbers(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initialize();
    }

    public JTableWithRowNumbers(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initialize();
        this.mRowNumberTable.setSelectionModel(listSelectionModel);
    }

    public JTableWithRowNumbers(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.initialize();
    }

    private void initialize() {
        this.mRowNumberTable = new RowNumberTable();
        this.mRowNumberTable.setRowHeight(this.getRowHeight());
        this.setAutoResizeMode(0);
        this.mDefaultCursor = Cursor.getPredefinedCursor(0);
        this.mResizeCursor = Cursor.getPredefinedCursor(9);
        this.mHeaderLineCount = 1;
    }

    public JTable getRowNumberTable() {
        return this.mRowNumberTable;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mIsResizing) {
            int n = this.getWidth();
            graphics.setColor(LookAndFeelHelper.isDarkLookAndFeel() ? Color.WHITE : Color.BLACK);
            graphics.drawLine(0, this.mResizingRowY, n, this.mResizingRowY);
            graphics.drawLine(0, this.mResizingRowY + this.mResizingRowHeight, n, this.mResizingRowY + this.mResizingRowHeight);
        }
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public void setFontSize(int n) {
        Font font = new Font("SansSerif", 0, n);
        super.setFont(font);
        this.getTableHeader().setFont(font);
        if (this.mRowNumberTable != null) {
            this.mRowNumberTable.setFont(font);
            this.validateRowNumberColumnWidth();
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.mRowNumberTable != null) {
            this.mRowNumberTable.setRowHeight(n);
        }
    }

    @Override
    public void setRowHeight(int n, int n2) {
        super.setRowHeight(n, n2);
        if (this.mRowNumberTable != null) {
            this.mRowNumberTable.setRowHeight(n, n2);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getParent().getParent() instanceof JScrollPane) {
            this.mScrollPane = (JScrollPane)this.getParent().getParent();
            this.mScrollPane.setRowHeaderView(this.mRowNumberTable);
            this.validateRowNumberColumnWidth();
        }
    }

    public void setRowHeaderMinWidth(int n) {
        this.mRowHeaderMinWidth = n;
        this.validateRowNumberColumnWidth();
    }

    private void validateRowNumberColumnWidth() {
        if (this.mScrollPane != null) {
            JViewport jViewport = this.mScrollPane.getRowHeader();
            Dimension dimension = jViewport.getPreferredSize();
            int n = this.mRowNumberTable.getFontMetrics(this.mRowNumberTable.getFont()).stringWidth(Integer.toString(this.getRowCount()));
            dimension.width = Math.max(this.mRowHeaderMinWidth, n);
            jViewport.setPreferredSize(dimension);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.mRowNumberTable != null) {
            this.validateRowNumberColumnWidth();
            this.mRowNumberTable.invalidate();
            this.mRowNumberTable.repaint();
        }
    }

    public void rowNumberClicked(int n) {
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        super.setSelectionModel(listSelectionModel);
        if (this.mRowNumberTable != null) {
            this.mRowNumberTable.setSelectionModel(listSelectionModel);
        }
    }

    private class RowNumberRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 537266438L;
        private String mRowHeader;
        private Font mFont;

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = ColorHelper.darker(UIManager.getColor("Table.background"), 0.75f);
            Color color2 = LookAndFeelHelper.isDarkLookAndFeel() ? ColorHelper.darker(UIManager.getColor("Table.foreground"), 0.8f) : ColorHelper.brighter(UIManager.getColor("Table.foreground"), 0.6f);
            Dimension dimension = this.getSize();
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color2);
            graphics.setFont(this.mFont);
            int n = (this.getWidth() - graphics.getFontMetrics().stringWidth(this.mRowHeader)) / 2;
            graphics.drawString(this.mRowHeader, n, (dimension.height + this.mFont.getSize()) / 2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.mRowHeader = Integer.toString(n + 1);
            this.mFont = jTable.getFont();
            return this;
        }
    }

    private class RowNumberTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 537266438L;

        private RowNumberTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            if (JTableWithRowNumbers.this.getModel() != null) {
                return JTableWithRowNumbers.this.getModel().getRowCount();
            }
            return 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return "" + (n + 1);
        }
    }

    private class RowNumberTable
    extends JTable
    implements ListSelectionListener,
    MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 537266438L;
        private static final int cResizeTolerance = 2;
        private boolean mFullRowSelection;
        private int mDragStartY;
        private int mDragStartRow;
        private int mDragStartRowHeight;

        public RowNumberTable() {
            this.setAutoCreateColumnsFromModel(false);
            this.setModel(new RowNumberTableModel());
            JTableWithRowNumbers.this.setRowHeight(JTableWithRowNumbers.this.getRowHeight());
            this.setColumnSelectionAllowed(false);
            this.setRowSelectionAllowed(true);
            TableColumn tableColumn = new TableColumn();
            tableColumn.setResizable(false);
            tableColumn.setCellRenderer(new RowNumberRenderer());
            this.addColumn(tableColumn);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font.deriveFont(1));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.getCursor() != JTableWithRowNumbers.this.mResizeCursor) {
                JTableWithRowNumbers.this.rowNumberClicked(this.rowAtPoint(mouseEvent.getPoint()));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTableWithRowNumbers.this.mIsResizing = this.getCursor() == JTableWithRowNumbers.this.mResizeCursor;
            boolean bl = this.mFullRowSelection = !JTableWithRowNumbers.this.mIsResizing;
            if (JTableWithRowNumbers.this.mIsResizing) {
                Point point = mouseEvent.getPoint();
                point.y -= 2;
                int n = this.rowAtPoint(point);
                JTableWithRowNumbers.this.mResizingRowY = this.getCellRect((int)n, (int)0, (boolean)false).y - 1;
                this.mDragStartY = mouseEvent.getY();
                this.mDragStartRow = n;
                this.mDragStartRowHeight = JTableWithRowNumbers.this.mResizingRowHeight = this.getRowHeight(n);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (JTableWithRowNumbers.this.mIsResizing) {
                JTableWithRowNumbers.this.mIsResizing = false;
                if (this.mDragStartRowHeight != JTableWithRowNumbers.this.mResizingRowHeight) {
                    JTableWithRowNumbers.this.setRowHeight(JTableWithRowNumbers.this.mResizingRowHeight);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mFullRowSelection = false;
            if (!JTableWithRowNumbers.this.mIsResizing) {
                this.setCursor(JTableWithRowNumbers.this.mDefaultCursor);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            Rectangle rectangle = this.getCellRect(n, 0, false);
            int n2 = mouseEvent.getY() - rectangle.y;
            if (n2 < 2 && n != 0 || n2 > rectangle.height - 2 && n != this.getRowCount() - 1) {
                this.setCursor(JTableWithRowNumbers.this.mResizeCursor);
                this.setSelectionModel(new DefaultListSelectionModel());
            } else {
                this.setCursor(JTableWithRowNumbers.this.mDefaultCursor);
                this.setSelectionModel(JTableWithRowNumbers.this.getSelectionModel());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JTableWithRowNumbers.this.mIsResizing) {
                int n = Math.max(16, this.mDragStartRowHeight + mouseEvent.getY() - this.mDragStartY);
                if (JTableWithRowNumbers.this.mResizingRowHeight != n) {
                    JTableWithRowNumbers.this.mResizingRowHeight = n;
                    JTableWithRowNumbers.this.setRowHeight(this.mDragStartRow, JTableWithRowNumbers.this.mResizingRowHeight);
                }
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray;
            if (!listSelectionEvent.getValueIsAdjusting() && (nArray = this.getSelectedRows()).length > 0) {
                JTableWithRowNumbers jTableWithRowNumbers = JTableWithRowNumbers.this;
                if (this.mFullRowSelection && jTableWithRowNumbers.getColumnCount() != 0) {
                    jTableWithRowNumbers.setColumnSelectionInterval(0, jTableWithRowNumbers.getColumnCount() - 1);
                }
            }
            this.repaint();
        }
    }
}

