/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.generic.GenericImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class SwingImage
implements GenericImage {
    private BufferedImage mImage;

    public SwingImage(BufferedImage bufferedImage) {
        this.mImage = bufferedImage;
    }

    public SwingImage(String string) {
        URL uRL = SwingImage.class.getResource("/images/" + string);
        if (uRL == null) {
            throw new RuntimeException("Could not find: " + string);
        }
        try {
            this.mImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SwingImage(int n, int n2) {
        this.mImage = new BufferedImage(n, n2, 2);
    }

    @Override
    public int getRGB(int n, int n2) {
        return this.mImage.getRGB(n, n2);
    }

    @Override
    public void setRGB(int n, int n2, int n3) {
        this.mImage.setRGB(n, n2, n3);
    }

    @Override
    public BufferedImage get() {
        return this.mImage;
    }

    @Override
    public int getWidth() {
        return this.mImage.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.mImage.getHeight(null);
    }

    @Override
    public void scale(int n, int n2) {
        Image image = this.mImage.getScaledInstance(n, n2, 4);
        this.mImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = this.mImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
    }
}

