/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.swing;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericCursorHelper;
import com.actelion.research.gui.swing.SwingImage;
import com.actelion.research.util.Platform;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;

public class SwingCursorHelper
extends GenericCursorHelper {
    private static Cursor[] sCursor;
    private static boolean sIsDarkLaF;

    public static Cursor getCursor(int n) {
        boolean bl = LookAndFeelHelper.isDarkLookAndFeel();
        if (sIsDarkLaF != bl) {
            sIsDarkLaF = bl;
            sCursor = null;
        }
        if (sCursor == null) {
            sCursor = new Cursor[14];
        }
        if (sCursor[n] == null) {
            try {
                SwingCursorHelper.sCursor[n] = SwingCursorHelper.createCursor(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sCursor[n];
    }

    public static Cursor createCursor(int n) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(32, 32);
        if (!Platform.isWindows() && dimension.width >= 24 && dimension.height >= 24 && IMAGE_NAME_32[n] != null) {
            SwingImage swingImage = new SwingImage("cursor/" + IMAGE_NAME_32[n]);
            SwingCursorHelper.adaptForLaF(swingImage);
            swingImage.scale(24, 24);
            return toolkit.createCustomCursor(swingImage.get(), new Point(HOTSPOT_32[2 * n] * 3 / 4, HOTSPOT_32[2 * n + 1] * 3 / 4), "");
        }
        if (dimension.width > 15 && dimension.height > 15 && n < IMAGE_DATA_16.length) {
            SwingImage swingImage = new SwingImage(dimension.width, dimension.height);
            SwingCursorHelper.build16x16CursorImage(swingImage, n);
            SwingCursorHelper.adaptForLaF(swingImage);
            return toolkit.createCustomCursor(swingImage.get(), new Point(HOTSPOT_16[2 * n], HOTSPOT_16[2 * n + 1]), "");
        }
        if (n == 11) {
            return Cursor.getPredefinedCursor(0);
        }
        if (n == 12) {
            return Cursor.getPredefinedCursor(2);
        }
        if (n == 13) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getPredefinedCursor(0);
    }
}

