/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.hidpi.HiDPIIcon;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HiDPIIconButton
extends JButton {
    private String mImageName;
    private String mStyle;
    private int mRotation;
    private Icon[] mAnimationIcon;
    private Animator mAnimator;

    public HiDPIIconButton(String string, String string2, String string3) {
        this(string, string2, string3, 0, "bevel");
    }

    public HiDPIIconButton(String string, String string2, String string3, int n, String string4) {
        this.mImageName = string;
        this.mRotation = n;
        this.mStyle = string4;
        this.updateIconSet();
        if (string3 != null) {
            this.setActionCommand(string3);
        }
        this.setFocusable(false);
        if (string2 != null) {
            this.setToolTipText(string2);
        }
    }

    public void startAnimation(int n) {
        if (this.mAnimationIcon == null) {
            this.mAnimationIcon = new Icon[n];
            this.mAnimationIcon[0] = this.getIcon();
            for (int i = 1; i < n; ++i) {
                int n2 = this.mImageName.lastIndexOf(46);
                String string = this.mImageName.substring(0, n2) + "_" + i + this.mImageName.substring(n2);
                this.mAnimationIcon[i] = HiDPIIcon.createIcon(string, 0, false);
            }
        }
        this.mAnimator = new Animator(n);
        this.mAnimator.start();
    }

    public void stopAnimation() {
        if (this.mAnimator != null) {
            this.mAnimator.stop();
        }
    }

    public boolean isAnimating() {
        return this.mAnimator != null && this.mAnimator.isRunning();
    }

    private void updateIconSet() {
        if (this.mImageName != null) {
            this.setIcon(HiDPIIcon.createIcon(this.mImageName, this.mRotation, false));
            this.setDisabledIcon(HiDPIIcon.createIcon(this.mImageName, this.mRotation, true));
            Icon icon = this.getIcon();
            int n = Math.round((float)icon.getIconWidth() / HiDPIHelper.getRetinaScaleFactor()) + 2;
            int n2 = Math.round((float)icon.getIconHeight() / HiDPIHelper.getRetinaScaleFactor()) + 2;
            this.setPreferredSize(new Dimension(n, n2));
        }
    }

    @Override
    public void updateUI() {
        this.updateIconSet();
        super.updateUI();
    }

    private class Animator {
        private static final long FRAME_RATE = 80L;
        private volatile int mFrameCount;
        private volatile boolean mRunning;
        private int state;
        private Timer timer;

        public Animator(int n) {
            this.mFrameCount = n;
        }

        public void start() {
            if (!this.mRunning) {
                this.mRunning = true;
                this.state = 0;
                this.timer = new Timer(80, actionEvent -> {
                    if (!this.mRunning) {
                        this.timer.stop();
                        return;
                    }
                    int n = ++this.state % this.mFrameCount;
                    SwingUtilities.invokeLater(() -> HiDPIIconButton.this.setIcon(HiDPIIconButton.this.mAnimationIcon[n]));
                });
                this.timer.setRepeats(true);
                this.timer.start();
            }
        }

        public void stop() {
            this.mRunning = false;
            this.timer = null;
        }

        public boolean isRunning() {
            return this.mRunning;
        }
    }
}

