/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.hidpi;

import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingImage;
import com.actelion.research.util.Platform;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class HiDPIIcon
extends ImageIcon {
    private static final float ICON_SCALE_LIMIT_1 = 1.1f;
    private static final float ICON_SCALE_LIMIT_2 = 1.9f;
    private static final float ICON_SCALE_LIMIT_3 = 2.1f;

    public HiDPIIcon(Image image) {
        super(image);
    }

    public static Icon createIcon(String string, int n, boolean bl) {
        SwingImage swingImage = HiDPIIcon.createIconImage(string);
        HiDPIHelper.adaptForLookAndFeel(swingImage);
        HiDPIIcon.rotate(swingImage, n);
        if (bl) {
            HiDPIHelper.disableImage(swingImage);
        }
        HiDPIIcon.capCorners(swingImage);
        return new HiDPIIcon((Image)(HiDPIIcon.mustScale() ? HiDPIIcon.scale(swingImage) : swingImage).get());
    }

    public static SwingImage createIconImage(String string) {
        return new SwingImage(HiDPIIcon.useDoubleImage() ? HiDPIIcon.getDoubleResolutionFileName(string) : string);
    }

    private static String getDoubleResolutionFileName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n).concat("@2x").concat(string.substring(n));
    }

    public static float getIconScaleFactor() {
        if (!HiDPIIcon.mustScale()) {
            return 1.0f;
        }
        float f = HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor();
        if (HiDPIIcon.useDoubleImage()) {
            f *= 0.5f;
        }
        return f;
    }

    public static GenericImage scale(GenericImage genericImage) {
        float f = HiDPIIcon.getIconScaleFactor();
        genericImage.scale(Math.round(f * (float)genericImage.getWidth()), Math.round(f * (float)genericImage.getHeight()));
        return genericImage;
    }

    private static boolean mustScale() {
        return HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor() > 1.1f && HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor() < 1.9f || HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor() < 2.1f;
    }

    private static boolean useDoubleImage() {
        return HiDPIHelper.getUIScaleFactor() * HiDPIHelper.getRetinaScaleFactor() > 1.1f;
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (HiDPIHelper.getRetinaScaleFactor() != 1.0f) {
            Image image = this.getImage();
            int n3 = Math.round((float)image.getWidth(null) / HiDPIHelper.getRetinaScaleFactor());
            int n4 = Math.round((float)image.getHeight(null) / HiDPIHelper.getRetinaScaleFactor());
            if (Platform.isMacintosh()) {
                n += Math.round((float)n3 / HiDPIHelper.getRetinaScaleFactor());
                n2 += Math.round((float)n4 / HiDPIHelper.getRetinaScaleFactor());
            } else {
                n += (image.getWidth(null) - n3) / 2;
                n2 += (image.getHeight(null) - n4) / 2;
            }
            if (LookAndFeelHelper.isNewSubstance()) {
                ++n2;
            }
            graphics.drawImage(image, n, n2, n3, n4, null);
        } else {
            if (LookAndFeelHelper.isNewSubstance()) {
                ++n2;
            }
            Image image = this.getImage();
            graphics.drawImage(image, n, n2, null);
        }
    }

    private static GenericImage capCorners(GenericImage genericImage) {
        genericImage.setRGB(0, 0, 0);
        genericImage.setRGB(1, 0, 0);
        genericImage.setRGB(0, 1, 0);
        genericImage.setRGB(genericImage.getWidth() - 2, 0, 0);
        genericImage.setRGB(genericImage.getWidth() - 1, 0, 0);
        genericImage.setRGB(genericImage.getWidth() - 1, 1, 0);
        genericImage.setRGB(0, genericImage.getHeight() - 1, 0);
        genericImage.setRGB(1, genericImage.getHeight() - 1, 0);
        genericImage.setRGB(0, genericImage.getHeight() - 2, 0);
        genericImage.setRGB(genericImage.getWidth() - 2, genericImage.getHeight() - 1, 0);
        genericImage.setRGB(genericImage.getWidth() - 1, genericImage.getHeight() - 1, 0);
        genericImage.setRGB(genericImage.getWidth() - 1, genericImage.getHeight() - 2, 0);
        return genericImage;
    }

    private static GenericImage rotate(GenericImage genericImage, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = genericImage.getHeight();
        int n6 = n5 - 1;
        if (n == 90) {
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                for (n3 = 0; n3 < n5 / 2; ++n3) {
                    n2 = genericImage.getRGB(n4, n3);
                    genericImage.setRGB(n4, n3, genericImage.getRGB(n3, n6 - n4));
                    genericImage.setRGB(n3, n6 - n4, genericImage.getRGB(n6 - n4, n6 - n3));
                    genericImage.setRGB(n6 - n4, n6 - n3, genericImage.getRGB(n6 - n3, n4));
                    genericImage.setRGB(n6 - n3, n4, n2);
                }
            }
        }
        if (n == 180) {
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    n2 = genericImage.getRGB(n4, n3);
                    genericImage.setRGB(n4, n3, genericImage.getRGB(n6 - n4, n6 - n3));
                    genericImage.setRGB(n6 - n4, n6 - n3, n2);
                }
            }
        }
        if (n == 270) {
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                for (n3 = 0; n3 < n5 / 2; ++n3) {
                    n2 = genericImage.getRGB(n4, n3);
                    genericImage.setRGB(n4, n3, genericImage.getRGB(n6 - n3, n4));
                    genericImage.setRGB(n6 - n3, n4, genericImage.getRGB(n6 - n4, n6 - n3));
                    genericImage.setRGB(n6 - n4, n6 - n3, genericImage.getRGB(n3, n6 - n4));
                    genericImage.setRGB(n3, n6 - n4, n2);
                }
            }
        }
        return genericImage;
    }
}

