/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.generic;

import com.actelion.research.chem.AbstractDepictor;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;

public class GenericDepictor
extends AbstractDepictor<GenericDrawContext> {
    private int mTextSize;
    private float mLineWidth;

    public GenericDepictor(StereoMolecule stereoMolecule) {
        super(stereoMolecule);
    }

    public GenericDepictor(StereoMolecule stereoMolecule, int n) {
        super(stereoMolecule, n);
    }

    @Override
    protected void init() {
        super.init();
        this.mLineWidth = 1.0f;
    }

    @Override
    protected void drawBlackLine(AbstractDepictor.DepictorLine depictorLine) {
        ((GenericDrawContext)this.mContext).drawLine(depictorLine.x1, depictorLine.y1, depictorLine.x2, depictorLine.y2);
    }

    @Override
    protected void drawDottedLine(AbstractDepictor.DepictorLine depictorLine) {
        ((GenericDrawContext)this.mContext).drawDottedLine(depictorLine.x1, depictorLine.y1, depictorLine.x2, depictorLine.y2);
    }

    @Override
    protected void drawString(String string, double d, double d2) {
        ((GenericDrawContext)this.mContext).drawCenteredString(d, d2, string);
    }

    @Override
    protected void drawPolygon(GenericPolygon genericPolygon) {
        ((GenericDrawContext)this.mContext).fillPolygon(genericPolygon);
    }

    @Override
    protected void fillCircle(double d, double d2, double d3) {
        ((GenericDrawContext)this.mContext).fillCircle(d, d2, d3);
    }

    @Override
    protected double getStringWidth(String string) {
        return ((GenericDrawContext)this.mContext).getBounds(string).getWidth();
    }

    @Override
    protected void setTextSize(int n) {
        this.mTextSize = n;
        if (this.mContext != null) {
            ((GenericDrawContext)this.mContext).setFont(n, false, false);
        }
    }

    @Override
    public int getTextSize() {
        return this.mTextSize;
    }

    @Override
    public void hiliteAtomBackgrounds(int[] nArray, float[] fArray) {
        int n;
        int n2;
        int n3;
        double d = this.getTransformation().getScaling() * this.getMolecule().getAverageBondLength();
        double d2 = fArray == null ? 0.6 * d : 0.75 * d;
        GenericRectangle genericRectangle = this.simpleCalculateBounds();
        int n4 = (int)Math.floor(genericRectangle.x - d2);
        int n5 = (int)Math.floor(genericRectangle.y - d2);
        int n6 = (int)Math.ceil(genericRectangle.x + genericRectangle.width + d2) - n4 + 1;
        int n7 = (int)Math.ceil(genericRectangle.y + genericRectangle.height + d2) - n5 + 1;
        float[] fArray2 = new float[4 * n6 * n7];
        float[] fArray3 = new float[4];
        float[] fArray4 = this.getBackgroundColor().getRGBColorComponents(null);
        for (int i = 0; i < this.getMolecule().getAtoms(); ++i) {
            if ((nArray[i] & 0xFF000000) == 0) continue;
            n3 = (int)Math.round(this.getAtomX(i)) - n4;
            n2 = (int)Math.round(this.getAtomY(i)) - n5;
            float f = (float)((nArray[i] & 0xFF000000) >>> 24) / 255.0f;
            fArray3[1] = (float)((nArray[i] & 0xFF0000) >> 16) / 255.0f;
            fArray3[2] = (float)((nArray[i] & 0xFF00) >> 8) / 255.0f;
            fArray3[3] = (float)(nArray[i] & 0xFF) / 255.0f;
            if (f != 1.0f) {
                fArray3[1] = fArray4[0] + f * (fArray3[1] - fArray4[0]);
                fArray3[2] = fArray4[1] + f * (fArray3[2] - fArray4[1]);
                fArray3[3] = fArray4[2] + f * (fArray3[3] - fArray4[2]);
            }
            n = fArray == null ? (int)d2 : (int)(d2 * (double)fArray[i]);
            int n8 = n * n;
            for (int j = 0; j <= n; ++j) {
                for (int k = 0; k <= n; ++k) {
                    float f2 = j * j + k * k;
                    if (!(f2 <= (float)n8)) continue;
                    fArray3[0] = 1.0f - (float)Math.sqrt(f2) / (float)n;
                    if (j != 0 && k != 0) {
                        this.mixInColor(fArray2, 4 * ((n2 - k) * n6 + n3 - j), fArray3);
                    }
                    if (k != 0) {
                        this.mixInColor(fArray2, 4 * ((n2 - k) * n6 + n3 + j), fArray3);
                    }
                    if (j != 0) {
                        this.mixInColor(fArray2, 4 * ((n2 + k) * n6 + n3 - j), fArray3);
                    }
                    this.mixInColor(fArray2, 4 * ((n2 + k) * n6 + n3 + j), fArray3);
                }
            }
        }
        GenericImage genericImage = ((GenericDrawContext)this.mContext).createARGBImage(n6, n7);
        n3 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            for (int i = 0; i < n6; ++i) {
                n = 0;
                if (fArray2[n3] != 0.0f) {
                    if (fArray2[n3] > 1.0f) {
                        float f = fArray2[n3++];
                        n = -16777216;
                        n += (int)(255.0f * fArray2[n3++] / f) << 16;
                        n += (int)(255.0f * fArray2[n3++] / f) << 8;
                        n += (int)(255.0f * fArray2[n3++] / f);
                    } else {
                        n = (int)(255.0f * fArray2[n3++]) << 24;
                        n += (int)(255.0f * fArray2[n3++]) << 16;
                        n += (int)(255.0f * fArray2[n3++]) << 8;
                        n += (int)(255.0f * fArray2[n3++]);
                    }
                } else {
                    n3 += 4;
                }
                genericImage.setRGB(i, n2, n);
            }
        }
        ((GenericDrawContext)this.mContext).drawImage(genericImage, n4, n5);
    }

    private void mixInColor(float[] fArray, int n, float[] fArray2) {
        if (fArray[n] == 0.0f) {
            fArray[n++] = fArray2[0];
            fArray[n++] = fArray2[1];
            fArray[n++] = fArray2[2];
            fArray[n++] = fArray2[3];
        } else {
            float f;
            float f2 = fArray[n];
            fArray[n] = f = fArray[n] + fArray2[0];
            fArray[++n] = (fArray[n] * f2 + fArray2[1] * fArray2[0]) / f;
            fArray[++n] = (fArray[n] * f2 + fArray2[2] * fArray2[0]) / f;
            fArray[++n] = (fArray[n] * f2 + fArray2[3] * fArray2[0]) / f;
        }
    }

    @Override
    protected double getLineWidth() {
        return this.mLineWidth;
    }

    @Override
    protected void setLineWidth(double d) {
        this.mLineWidth = (float)d;
        ((GenericDrawContext)this.mContext).setLineWidth(this.mLineWidth);
    }

    @Override
    protected void setRGB(int n) {
        ((GenericDrawContext)this.mContext).setRGB(n);
    }
}

