/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.fx;

import com.actelion.research.gui.generic.GenericImage;
import com.actelion.research.gui.swing.SwingImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javafx.embed.swing.SwingFXUtils;
import javax.imageio.ImageIO;

public class FXImage
implements GenericImage {
    private javafx.scene.image.Image mFXImage;
    private BufferedImage mAWTImage;

    public FXImage(String string) {
        URL uRL = SwingImage.class.getResource("/images/" + string);
        if (uRL == null) {
            throw new RuntimeException("Could not find: " + string);
        }
        try {
            this.mAWTImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FXImage(int n, int n2) {
        this.mAWTImage = new BufferedImage(n, n2, 2);
    }

    @Override
    public int getWidth() {
        return Math.round(this.mAWTImage.getWidth());
    }

    @Override
    public int getHeight() {
        return Math.round(this.mAWTImage.getHeight());
    }

    @Override
    public int getRGB(int n, int n2) {
        return this.mAWTImage.getRGB(n, n2);
    }

    @Override
    public void setRGB(int n, int n2, int n3) {
        this.mAWTImage.setRGB(n, n2, n3);
        this.mFXImage = null;
    }

    public javafx.scene.image.Image get() {
        if (this.mFXImage == null) {
            this.mFXImage = SwingFXUtils.toFXImage((BufferedImage)this.mAWTImage, null);
        }
        return this.mFXImage;
    }

    @Override
    public void scale(int n, int n2) {
        Image image = this.mAWTImage.getScaledInstance(n, n2, 4);
        this.mAWTImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = this.mAWTImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        this.mFXImage = null;
    }
}

