/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.TextDrawingObject;
import com.actelion.research.gui.editor.AsynchronousQueryBuilder;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.generic.GenericUIHelper;

public class TextDrawingObjectDialogBuilder
extends AsynchronousQueryBuilder {
    static final long serialVersionUID = 537985829L;
    private static final int[] TEXT_STYLE = new int[]{0, 2, 1, 3};
    private static final String[] TEXT_STYLE_LIST = new String[]{"plain", "italic", "bold", "italics & bold"};
    private static final String[] TEXT_SIZE_LIST = new String[]{"8", "9", "10", "12", "14", "18", "24", "32"};
    private GenericTextField mTextArea;
    private TextDrawingObject mTextObject;
    private GenericComboBox mComboBoxTextSize;
    private GenericComboBox mComboBoxStyle;

    public TextDrawingObjectDialogBuilder(GenericUIHelper genericUIHelper, TextDrawingObject textDrawingObject) {
        this.mDialog = genericUIHelper.createDialog("Edit Text", this);
        this.mTextObject = textDrawingObject;
        this.build();
    }

    private void build() {
        this.mComboBoxTextSize = this.mDialog.createComboBox();
        for (String string : TEXT_SIZE_LIST) {
            this.mComboBoxTextSize.addItem(string);
        }
        this.mComboBoxTextSize.setEditable(true);
        this.mComboBoxTextSize.setSelectedItem("" + (int)this.mTextObject.getSize());
        this.mComboBoxStyle = this.mDialog.createComboBox();
        String[] stringArray = TEXT_STYLE_LIST;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            string = stringArray[i];
            this.mComboBoxStyle.addItem(string);
        }
        int n2 = 0;
        for (n = 0; n < TEXT_STYLE.length; ++n) {
            if (this.mTextObject.getStyle() != TEXT_STYLE[n]) continue;
            n2 = n;
            break;
        }
        this.mComboBoxStyle.setSelectedIndex(n2);
        int[] nArray = new int[]{8, -2, 4, -2, 8};
        int[] nArray2 = new int[]{8, -2, 4, -2, 8, -2, 8};
        this.mDialog.setLayout(nArray, nArray2);
        this.mDialog.add(this.mDialog.createLabel("Text size:"), 1, 1);
        this.mDialog.add(this.mComboBoxTextSize, 3, 1);
        this.mDialog.add(this.mDialog.createLabel("Text style:"), 1, 3);
        this.mDialog.add(this.mComboBoxStyle, 3, 3);
        this.mTextArea = this.mDialog.createTextField(20, 3);
        this.mTextArea.setText(this.mTextObject.getText());
        this.mDialog.add(this.mTextArea, 1, 5, 3, 5);
    }

    @Override
    public void eventHappened(GenericActionEvent genericActionEvent) {
        this.handleOkCancel(genericActionEvent);
    }

    @Override
    protected void setQueryFeatures() {
        int n;
        try {
            n = Integer.parseInt(this.mComboBoxTextSize.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            this.mDialog.showMessage("Illegal text size.");
            return;
        }
        int n2 = TEXT_STYLE[this.mComboBoxStyle.getSelectedIndex()];
        this.mTextObject.setValues(this.mTextArea.getText(), n, n2);
    }
}

