/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.StructureListener;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.editor.SwingEditorArea;
import com.actelion.research.gui.editor.SwingEditorToolbar;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SwingEditorDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 539037955L;
    private static final String DEFAULT_MOLECULE_TITLE = "Structure Editor";
    private static final String DEFAULT_REACTION_TITLE = "Reaction Editor";
    private StereoMolecule mMolecule;
    private SwingEditorToolbar mToolBar;
    private SwingEditorArea mArea;
    private JPanel mButtonPanel;
    private boolean mIsCancelled;
    private ArrayList<StructureListener> mListener;

    public SwingEditorDialog(Window window, StereoMolecule stereoMolecule) {
        this(window, stereoMolecule, Dialog.DEFAULT_MODALITY_TYPE);
    }

    public SwingEditorDialog(Window window, Reaction reaction) {
        this(window, reaction, Dialog.DEFAULT_MODALITY_TYPE);
    }

    public SwingEditorDialog(Window window, StereoMolecule stereoMolecule, Dialog.ModalityType modalityType) {
        super(window, DEFAULT_MOLECULE_TITLE, modalityType);
        this.mMolecule = stereoMolecule == null ? new StereoMolecule() : new StereoMolecule(stereoMolecule);
        this.initialize(window, 0);
    }

    public SwingEditorDialog(Window window, StereoMolecule[] stereoMoleculeArray, Dialog.ModalityType modalityType) {
        super(window, DEFAULT_MOLECULE_TITLE, modalityType);
        this.mMolecule = new StereoMolecule();
        this.initialize(window, 1);
        if (stereoMoleculeArray != null) {
            this.mArea.getGenericDrawArea().setFragments(stereoMoleculeArray);
        }
    }

    public SwingEditorDialog(Window window, Reaction reaction, Dialog.ModalityType modalityType) {
        super(window, DEFAULT_REACTION_TITLE, modalityType);
        this.mMolecule = new StereoMolecule();
        this.initialize(window, 4);
        if (reaction != null) {
            this.mArea.getGenericDrawArea().setReaction(reaction);
        }
    }

    private void initialize(Component component, int n) {
        this.mArea = new SwingEditorArea(this.mMolecule, n);
        this.mArea.setPreferredSize(new Dimension(HiDPIHelper.scale(n == 4 ? 800.0f : 480.0f), HiDPIHelper.scale(300.0f)));
        this.getContentPane().add((Component)this.mArea, "Center");
        this.mToolBar = new SwingEditorToolbar(this.mArea);
        this.getContentPane().add((Component)this.mToolBar, "West");
        this.mButtonPanel = new JPanel();
        this.mButtonPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 8, 0));
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        jPanel.add(jButton);
        JButton jButton2 = new JButton("OK");
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        this.mButtonPanel.add((Component)jPanel, "East");
        JButton jButton3 = new JButton("Help");
        jButton3.addActionListener(this);
        this.mButtonPanel.add((Component)jButton3, "West");
        this.mButtonPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.getContentPane().add((Component)this.mButtonPanel, "South");
        this.mListener = new ArrayList();
        this.addKeyListener(this.mArea.getKeyHandler());
        this.pack();
        this.setLocationRelativeTo(component);
        this.mIsCancelled = true;
    }

    public void addStructureListener(StructureListener structureListener) {
        this.mListener.add(structureListener);
    }

    public GenericEditorArea getDrawArea() {
        return this.mArea.getGenericDrawArea();
    }

    public void setAccessory(Component component) {
        this.mButtonPanel.add(component, "North");
        this.pack();
    }

    public StereoMolecule getStructure() {
        return this.mMolecule;
    }

    public Reaction getReaction() {
        return this.mArea.getGenericDrawArea().getReaction();
    }

    public Reaction getReactionAndDrawings() {
        return this.mArea.getGenericDrawArea().getReactionAndDrawings();
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Help")) {
            this.mArea.getGenericDrawArea().showHelpDialog();
            return;
        }
        if (actionEvent.getActionCommand().equals("OK")) {
            for (StructureListener structureListener : this.mListener) {
                structureListener.structureChanged(this.mMolecule);
            }
            this.mIsCancelled = false;
        }
        this.dispose();
    }
}

