/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.DrawingObjectList;
import com.actelion.research.chem.ExtendedDepictor;
import com.actelion.research.chem.MarkushStructure;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.NamedSubstituents;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.TextDrawingObject;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.io.RDFileParser;
import com.actelion.research.chem.io.RXNFileParser;
import com.actelion.research.chem.name.StructureNameResolver;
import com.actelion.research.chem.reaction.IReactionMapper;
import com.actelion.research.chem.reaction.MCSReactionMapper;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.chem.reaction.ReactionArrow;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.LookAndFeelHelper;
import com.actelion.research.gui.clipboard.IClipboardHandler;
import com.actelion.research.gui.editor.AsynchronousQueryBuilder;
import com.actelion.research.gui.editor.AtomQueryFeatureDialogBuilder;
import com.actelion.research.gui.editor.BondQueryFeatureDialogBuilder;
import com.actelion.research.gui.editor.CustomAtomDialogBuilder;
import com.actelion.research.gui.editor.EditorEvent;
import com.actelion.research.gui.editor.TextDrawingObjectDialogBuilder;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCanvas;
import com.actelion.research.gui.generic.GenericDepictor;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericEvent;
import com.actelion.research.gui.generic.GenericEventListener;
import com.actelion.research.gui.generic.GenericKeyEvent;
import com.actelion.research.gui.generic.GenericMouseEvent;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericPopupMenu;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.gui.generic.GenericShape;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import com.actelion.research.gui.swing.SwingUIHelper;
import com.actelion.research.util.ColorHelper;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.Timer;

public class GenericEditorArea
implements GenericEventListener {
    public static final int MODE_MULTIPLE_FRAGMENTS = 1;
    public static final int MODE_MARKUSH_STRUCTURE = 2;
    public static final int MODE_REACTION = 4;
    public static final int MODE_DRAWING_OBJECTS = 8;
    public static final String TEMPLATE_TYPE_KEY = "TEMPLATE";
    public static final String TEMPLATE_TYPE_REACTION_QUERIES = "REACTION_QUERIES";
    public static final String TEMPLATE_SECTION_KEY = "SECTION";
    public static final int DEFAULT_ALLOWED_PSEUDO_ATOMS = 331;
    private static final int MAX_CONNATOMS = 8;
    private static final int MIN_BOND_LENGTH_SQUARE = 100;
    private static final int KEY_IS_ATOM_LABEL = 1;
    private static final int KEY_IS_SUBSTITUENT = 2;
    private static final int KEY_IS_VALID_START = 3;
    private static final int KEY_IS_INVALID = 4;
    private static final int RGB_BLUE = -16776961;
    private static final int RGB_RED = -65536;
    private static final int RGB_DARK_RED = -8388608;
    private static final int RGB_BLACK = -16777216;
    private static final int RGB_GRAY = -8355712;
    private static final String ITEM_COPY_STRUCTURE = "Copy Structure";
    private static final String ITEM_COPY_REACTION = "Copy Reaction";
    private static final String ITEM_PASTE_STRUCTURE = "Paste Structure";
    private static final String ITEM_PASTE_REACTION = "Paste Reaction";
    private static final String ITEM_USE_TEMPLATE = "Use Reaction Template...";
    private static final String ITEM_PASTE_WITH_NAME = "Paste Structure or Name";
    private static final String ITEM_LOAD_REACTION = "Open Reaction File...";
    private static final String ITEM_ADD_AUTO_MAPPING = "Auto-Map Reaction";
    private static final String ITEM_REMOVE_MAPPING = "Remove Manual Atom Mapping";
    private static final String ITEM_FLIP_HORIZONTALLY = "Flip Horizontally";
    private static final String ITEM_FLIP_VERTICALLY = "Flip Vertically";
    private static final String ITEM_FLIP_ROTATE180 = "Rotate 180\u00c2\u00b0";
    private static final String ITEM_SHOW_HELP = "Help Me";
    private static final String ITEM_SHOW_ATOM_BOND_NUMBERS = "Show Atom & Bond Numbers";
    private static final String ITEM_SHOW_SYMMETRY = "Show Symmetry";
    private static final String ITEM_SHOW_NORMAL = "Show Normal";
    private static final int WARNING_MILLIS = 1200;
    private static final float FRAGMENT_MAX_CLICK_DISTANCE = 24.0f;
    private static final float FRAGMENT_GROUPING_DISTANCE = 1.4f;
    private static final float FRAGMENT_CLEANUP_DISTANCE = 1.5f;
    private static final float DEFAULT_ARROW_LENGTH = 0.08f;
    protected static final int UPDATE_NONE = 0;
    protected static final int UPDATE_REDRAW = 1;
    protected static final int UPDATE_CHECK_VIEW = 2;
    protected static final int UPDATE_CHECK_COORDS = 3;
    protected static final int UPDATE_SCALE_COORDS = 4;
    protected static final int UPDATE_SCALE_COORDS_USE_FRAGMENTS = 5;
    protected static final int UPDATE_INVENT_COORDS = 6;
    private static final int DEFAULT_SELECTION_BACKGROUND = -8346432;
    private static final int cRequestNone = 0;
    private static final int cRequestNewBond = 1;
    private static final int cRequestNewChain = 2;
    private static final int cRequestMoveSingle = 3;
    private static final int cRequestMoveSelected = 4;
    private static final int cRequestLassoSelect = 5;
    private static final int cRequestSelectRect = 6;
    private static final int cRequestZoomAndRotate = 7;
    private static final int cRequestMapAtoms = 8;
    private static final int cRequestCopySelected = 9;
    private static final int cRequestMoveObject = 10;
    private static final int cRequestCopyObject = 11;
    private static IReactionMapper sMapper;
    private static String[][] sReactionQueryTemplates;
    private int mMode;
    private int mChainAtoms;
    private int mCurrentTool;
    private int mCustomAtomicNo;
    private int mCustomAtomMass;
    private int mCustomAtomValence;
    private int mCustomAtomRadical;
    private int mCurrentHiliteAtom;
    private int mCurrentHiliteBond;
    private int mPendingRequest;
    private int mEventsScheduled;
    private int mFirstAtomKey;
    private int mCurrentCursor;
    private int mReactantCount;
    private int mUpdateMode;
    private int mDisplayMode;
    private int mAtom1;
    private int mAtom2;
    private int mMaxAVBL;
    private int mAllowedPseudoAtoms;
    private int[] mChainAtom;
    private int[] mFragmentNo;
    private int[] mHiliteBondSet;
    private double mX1;
    private double mY1;
    private double mX2;
    private double mY2;
    private double mWidth;
    private double mHeight;
    private double mUIScaling;
    private double mTextSizeFactor;
    private double[] mX;
    private double[] mY;
    private double[] mChainAtomX;
    private double[] mChainAtomY;
    private boolean mAltIsDown;
    private boolean mShiftIsDown;
    private boolean mMouseIsDown;
    private boolean mIsAddingToSelection;
    private boolean mAtomColorSupported;
    private boolean mAllowQueryFeatures;
    private boolean mAllowFragmentChangeOnPasteOrDrop;
    private boolean[] mIsSelectedAtom;
    private boolean[] mIsSelectedObject;
    private String mCustomAtomLabel;
    private String mWarningMessage;
    private String mAtomKeyStrokeSuggestion;
    private String[] mAtomText;
    private ExtendedDepictor mDepictor;
    private StereoMolecule mMol;
    private Molecule mUndoMol;
    private StereoMolecule[] mFragment;
    private DrawingObjectList mDrawingObjectList;
    private DrawingObjectList mUndoDrawingObjectList;
    private AbstractDrawingObject mCurrentHiliteObject;
    private GenericPolygon mLassoRegion;
    private ArrayList<GenericEventListener> mListeners;
    private IClipboardHandler mClipboardHandler;
    private StringBuilder mAtomKeyStrokeBuffer;
    private GenericUIHelper mUIHelper;
    private GenericCanvas mCanvas;

    public GenericEditorArea(StereoMolecule stereoMolecule, int n, GenericUIHelper genericUIHelper, GenericCanvas genericCanvas) {
        this.mMol = stereoMolecule;
        this.mMode = n;
        this.mUIHelper = genericUIHelper;
        this.mCanvas = genericCanvas;
        this.mListeners = new ArrayList();
        this.mCurrentTool = 5;
        this.mCurrentHiliteAtom = -1;
        this.mCurrentHiliteBond = -1;
        this.mCurrentHiliteObject = null;
        this.mAtom1 = -1;
        this.mCustomAtomicNo = 6;
        this.mCustomAtomMass = 0;
        this.mCustomAtomValence = -1;
        this.mCustomAtomRadical = 0;
        this.mCustomAtomLabel = null;
        this.mAllowQueryFeatures = true;
        this.mAllowFragmentChangeOnPasteOrDrop = false;
        this.mPendingRequest = 0;
        this.mCurrentCursor = 11;
        this.mAtomKeyStrokeBuffer = new StringBuilder();
        this.mAllowedPseudoAtoms = 331;
        this.mTextSizeFactor = 1.0;
        this.mUIScaling = HiDPIHelper.getUIScaleFactor();
        this.mMaxAVBL = HiDPIHelper.scale(24.0f);
        if ((this.mMode & 6) != 0) {
            this.mMode |= 1;
        }
        if ((this.mMode & 0xC) != 0) {
            this.mDrawingObjectList = new DrawingObjectList();
        }
        this.mUpdateMode = 4;
    }

    public static String[][] getReactionQueryTemplates() {
        return sReactionQueryTemplates;
    }

    public static void setReactionQueryTemplates(String[][] stringArray) {
        sReactionQueryTemplates = stringArray;
    }

    public GenericUIHelper getUIHelper() {
        return this.mUIHelper;
    }

    public void setClipboardHandler(IClipboardHandler iClipboardHandler) {
        this.mClipboardHandler = iClipboardHandler;
    }

    private void update(int n) {
        this.mUpdateMode = Math.max(this.mUpdateMode, n);
        this.mCanvas.repaint();
    }

    public static void setReactionMapper(IReactionMapper iReactionMapper) {
        sMapper = iReactionMapper;
    }

    public void paintContent(GenericDrawContext genericDrawContext) {
        int n;
        int n2;
        Object object;
        if (this.mWidth != this.mCanvas.getCanvasWidth() || this.mHeight != this.mCanvas.getCanvasHeight()) {
            this.mWidth = this.mCanvas.getCanvasWidth();
            this.mHeight = this.mCanvas.getCanvasHeight();
            if (this.mUpdateMode < 3) {
                this.mUpdateMode = 3;
            }
        }
        int n3 = genericDrawContext.getBackgroundRGB();
        int n4 = genericDrawContext.getForegroundRGB();
        genericDrawContext.setRGB(n3);
        genericDrawContext.fillRectangle(0.0, 0.0, this.mWidth, this.mHeight);
        if ((this.mMode & 4) != 0 && this.mDrawingObjectList.size() == 0) {
            float f = 0.5f * (float)this.mWidth;
            float f2 = 0.5f * (float)this.mHeight;
            float f3 = 0.04f * (float)this.mWidth;
            object = new ReactionArrow();
            ((ReactionArrow)object).setCoordinates(f - f3, f2, f + f3, f2);
            ((AbstractDrawingObject)object).setDeletable(false);
            this.mDrawingObjectList.add(object);
        }
        boolean bl = false;
        if (this.mUpdateMode != 0) {
            if ((this.mMode & 1) != 0 && this.mUpdateMode != 5) {
                this.analyzeFragmentMembership();
            }
            this.mDepictor = (this.mMode & 4) != 0 ? new ExtendedDepictor(new Reaction(this.mFragment, this.mReactantCount), this.mDrawingObjectList, false) : ((this.mMode & 2) != 0 ? new ExtendedDepictor(this.mFragment, this.mReactantCount, this.mDrawingObjectList) : ((this.mMode & 1) != 0 ? new ExtendedDepictor(this.mFragment, this.mDrawingObjectList) : new ExtendedDepictor(this.mMol, this.mDrawingObjectList)));
            this.mDepictor.setForegroundColor(n4, n3);
            this.mDepictor.setDefaultAVBL(this.mMaxAVBL);
            this.mDepictor.setFragmentNoColor((this.mMode & 1) == 0 ? 0 : (LookAndFeelHelper.isDarkLookAndFeel() ? ColorHelper.brighter(n3, 0.85f) : ColorHelper.darker(n3, 0.85f)));
            this.mDepictor.setFactorTextSize(this.mTextSizeFactor);
            this.mDepictor.setDisplayMode(this.mDisplayMode | 8 | (this.mCurrentTool == 19 ? 80 : 0));
            if ((this.mMode & 7) == 0) {
                this.mDepictor.getMoleculeDepictor(0).setAtomText(this.mAtomText);
            }
            switch (this.mUpdateMode) {
                case 4: 
                case 5: 
                case 6: {
                    this.cleanupCoordinates(genericDrawContext);
                    break;
                }
                case 3: {
                    DepictorTransformation depictorTransformation = this.mDepictor.updateCoords(genericDrawContext, new GenericRectangle(0.0, 0.0, this.mWidth, this.mHeight), 0);
                    if (depictorTransformation == null || (this.mMode & 1) == 0) break;
                    depictorTransformation.applyTo(this.mMol);
                    break;
                }
                case 2: {
                    DepictorTransformation depictorTransformation = this.mDepictor.validateView(genericDrawContext, new GenericRectangle(0.0, 0.0, this.mWidth, this.mHeight), 0);
                    bl = depictorTransformation != null && !depictorTransformation.isVoidTransformation();
                }
            }
            this.mUpdateMode = 0;
        }
        if (this.mDepictor != null) {
            this.mDepictor.paintFragmentNumbers(genericDrawContext);
        }
        if (!bl) {
            this.drawHiliting(genericDrawContext);
        }
        if (this.mDepictor != null) {
            this.mDepictor.paintStructures(genericDrawContext);
            this.mDepictor.paintDrawingObjects(genericDrawContext);
        }
        if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
            int n5 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
            int n6 = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
            object = this.mAtomKeyStrokeBuffer.toString();
            n2 = this.getAtomKeyStrokeValidity((String)object);
            genericDrawContext.setRGB(n2 == 1 ? n4 : (n2 == 2 ? -16776961 : -8355712));
            if (n2 == 1) {
                object = Molecule.cAtomLabel[Molecule.getAtomicNoFromLabel((String)object, this.mAllowedPseudoAtoms)];
            } else if (n2 == 2) {
                object = this.mAtomKeyStrokeSuggestion.substring(0, ((String)object).length());
            }
            n = 3 * genericDrawContext.getFontSize() / 2;
            genericDrawContext.setFont(n, false, false);
            genericDrawContext.drawString(n5, n6, (String)object);
            if (n2 == 4) {
                genericDrawContext.setRGB(-65536);
                genericDrawContext.drawCenteredString((double)n5 + genericDrawContext.getBounds((String)object).getWidth() / 2.0, n6 + n, "<unknown>");
            }
            if (n2 == 2) {
                genericDrawContext.setRGB(-8355712);
                genericDrawContext.drawString((double)n5 + genericDrawContext.getBounds((String)object).getWidth(), n6, this.mAtomKeyStrokeSuggestion.substring(((String)object).length()));
            }
        }
        genericDrawContext.setRGB(n4);
        switch (this.mPendingRequest) {
            case 1: {
                int n7;
                int n8 = (int)this.mX1;
                int n9 = (int)this.mY1;
                if (this.mCurrentHiliteAtom == -1 || this.mCurrentHiliteAtom == this.mAtom1) {
                    n7 = (int)this.mX2;
                    n2 = (int)this.mY2;
                } else {
                    n7 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
                    n2 = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
                }
                switch (this.mCurrentTool) {
                    case 5: {
                        genericDrawContext.drawLine(n8, n9, n7, n2);
                        break;
                    }
                    case 6: {
                        n = (n9 - n2) / 9;
                        int n10 = (n7 - n8) / 9;
                        GenericPolygon genericPolygon = new GenericPolygon(3);
                        genericPolygon.addPoint(n8, n9);
                        genericPolygon.addPoint(n7 + n, n2 + n10);
                        genericPolygon.addPoint(n7 - n, n2 - n10);
                        genericDrawContext.fillPolygon(genericPolygon);
                        break;
                    }
                    case 23: {
                        n = n7 - n8;
                        int n11 = n2 - n9;
                        for (int i = 2; i < 17; i += 2) {
                            int n12 = n8 + i * n / 17 - i * n11 / 128;
                            int n13 = n9 + i * n11 / 17 + i * n / 128;
                            int n14 = n8 + i * n / 17 + i * n11 / 128;
                            int n15 = n9 + i * n11 / 17 - i * n / 128;
                            genericDrawContext.drawLine(n12, n13, n14, n15);
                        }
                        break;
                    }
                }
                break;
            }
            case 2: {
                if (this.mChainAtoms > 0) {
                    genericDrawContext.drawLine((int)this.mX1, (int)this.mY1, (int)this.mChainAtomX[0], (int)this.mChainAtomY[0]);
                }
                if (this.mChainAtoms <= 1) break;
                for (int i = 1; i < this.mChainAtoms; ++i) {
                    genericDrawContext.drawLine((int)this.mChainAtomX[i - 1], (int)this.mChainAtomY[i - 1], (int)this.mChainAtomX[i], (int)this.mChainAtomY[i]);
                }
                break;
            }
            case 5: {
                genericDrawContext.setRGB(GenericEditorArea.lassoColor(genericDrawContext));
                genericDrawContext.drawPolygon(this.mLassoRegion);
                genericDrawContext.setRGB(n4);
                break;
            }
            case 6: {
                int n16 = this.mX1 < this.mX2 ? (int)this.mX1 : (int)this.mX2;
                int n17 = this.mY1 < this.mY2 ? (int)this.mY1 : (int)this.mY2;
                int n18 = (int)Math.abs(this.mX2 - this.mX1);
                int n19 = (int)Math.abs(this.mY2 - this.mY1);
                genericDrawContext.setRGB(GenericEditorArea.lassoColor(genericDrawContext));
                genericDrawContext.drawRectangle(n16, n17, n18, n19);
                genericDrawContext.setRGB(n4);
                break;
            }
            case 8: {
                int n20;
                int n21 = (int)this.mX1;
                int n22 = (int)this.mY1;
                if (this.mCurrentHiliteAtom == -1 || this.mCurrentHiliteAtom == this.mAtom1) {
                    n20 = (int)this.mX2;
                    n2 = (int)this.mY2;
                } else {
                    n20 = (int)this.mMol.getAtomX(this.mCurrentHiliteAtom);
                    n2 = (int)this.mMol.getAtomY(this.mCurrentHiliteAtom);
                }
                genericDrawContext.setRGB(GenericEditorArea.mapToolColor(genericDrawContext));
                genericDrawContext.drawLine(n21, n22, n20, n2);
                genericDrawContext.setRGB(n4);
            }
        }
        if (this.mWarningMessage != null) {
            genericDrawContext.setFont(12, true, false);
            int n23 = genericDrawContext.getRGB();
            genericDrawContext.setRGB(-65536);
            genericDrawContext.drawCenteredString(this.mWidth / 2.0, genericDrawContext.getFontSize(), this.mWarningMessage);
            genericDrawContext.setRGB(n23);
        }
    }

    private double getScaledAVBL() {
        return this.mMol.getAverageBondLength(24.0 * this.mUIScaling);
    }

    public static int lassoColor(GenericDrawContext genericDrawContext) {
        int n = GenericEditorArea.selectionColor(genericDrawContext);
        return ColorHelper.createColor(n, LookAndFeelHelper.isDarkLookAndFeel() ? 0.65f : 0.35f);
    }

    public static int selectionColor(GenericDrawContext genericDrawContext) {
        int n = genericDrawContext.getSelectionBackgroundRGB();
        return n != 0 ? n : -8346432;
    }

    public static int mapToolColor(GenericDrawContext genericDrawContext) {
        int n = genericDrawContext.getBackgroundRGB();
        return ColorHelper.getContrastColor(-8388608, n);
    }

    public static int chainHiliteColor(GenericDrawContext genericDrawContext) {
        int n = genericDrawContext.getBackgroundRGB();
        int n2 = GenericEditorArea.selectionColor(genericDrawContext);
        return ColorHelper.intermediateColor(n2, n, 0.5f);
    }

    private void drawHiliting(GenericDrawContext genericDrawContext) {
        int n;
        if (this.mHiliteBondSet != null) {
            genericDrawContext.setRGB(GenericEditorArea.chainHiliteColor(genericDrawContext));
            for (n = 0; n < this.mHiliteBondSet.length; ++n) {
                this.hiliteBond(genericDrawContext, this.mHiliteBondSet[n]);
            }
        }
        if (this.mCurrentHiliteAtom != -1) {
            genericDrawContext.setRGB(GenericEditorArea.selectionColor(genericDrawContext));
            this.hiliteAtom(genericDrawContext, this.mCurrentHiliteAtom);
            if (this.mCurrentTool == 19 && (n = this.mMol.getAtomMapNo(this.mCurrentHiliteAtom)) != 0) {
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    if (i == this.mCurrentHiliteAtom || this.mMol.getAtomMapNo(i) != n) continue;
                    this.hiliteAtom(genericDrawContext, i);
                }
            }
        }
        if (this.mCurrentHiliteBond != -1) {
            genericDrawContext.setRGB(GenericEditorArea.selectionColor(genericDrawContext));
            this.hiliteBond(genericDrawContext, this.mCurrentHiliteBond);
        }
        if (this.mCurrentHiliteObject != null) {
            this.mCurrentHiliteObject.hilite(genericDrawContext);
        }
    }

    private void hiliteAtom(GenericDrawContext genericDrawContext, int n) {
        int n2 = (int)((double)0.32f * this.mMol.getAverageBondLength());
        int n3 = (int)this.mMol.getAtomX(n);
        int n4 = (int)this.mMol.getAtomY(n);
        genericDrawContext.fillCircle(n3 - n2, n4 - n2, 2 * n2);
    }

    private void hiliteBond(GenericDrawContext genericDrawContext, int n) {
        int n2 = (int)((double)0.32f * this.mMol.getAverageBondLength());
        int n3 = (int)this.mMol.getAtomX(this.mMol.getBondAtom(0, n));
        int n4 = (int)this.mMol.getAtomY(this.mMol.getBondAtom(0, n));
        int n5 = (int)this.mMol.getAtomX(this.mMol.getBondAtom(1, n));
        int n6 = (int)this.mMol.getAtomY(this.mMol.getBondAtom(1, n));
        float f = genericDrawContext.getLineWidth();
        genericDrawContext.setLineWidth(n2);
        genericDrawContext.drawLine(n3, n4, n5, n6);
        genericDrawContext.setLineWidth(f);
    }

    public void addDrawAreaListener(GenericEventListener<EditorEvent> genericEventListener) {
        this.mListeners.add(genericEventListener);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.clearAll();
                return;
            }
            case 1: {
                this.storeState();
                this.updateAndFireEvent(6);
                return;
            }
            case 17: {
                this.restoreState();
                this.updateAndFireEvent(2);
                return;
            }
        }
    }

    public void clearAll() {
        if (this.mDrawingObjectList != null) {
            this.mDrawingObjectList.clear();
            this.update(1);
        }
        this.storeState();
        boolean bl = this.mMol.isFragment();
        this.mMol.clear();
        this.mMol.setFragment(bl);
        if (this.mUndoMol.getAllAtoms() != 0) {
            this.updateAndFireEvent(1);
        } else {
            this.update(1);
        }
    }

    public void toolChanged(int n) {
        if (this.mCurrentTool != n) {
            if (this.mCurrentTool == 19 || n == 19) {
                this.update(1);
            }
            this.mCurrentTool = n;
        }
    }

    public void setCustomAtom(int n, int n2, int n3, int n4, String string) {
        this.mCustomAtomicNo = n;
        this.mCustomAtomMass = n2;
        this.mCustomAtomValence = n3;
        this.mCustomAtomRadical = n4;
        this.mCustomAtomLabel = string;
    }

    public void eventHappened(GenericEvent genericEvent) {
        if (genericEvent instanceof GenericActionEvent) {
            this.eventHappened((GenericActionEvent)genericEvent);
        } else if (genericEvent instanceof GenericKeyEvent) {
            this.eventHappened((GenericKeyEvent)genericEvent);
        } else if (genericEvent instanceof GenericMouseEvent) {
            this.eventHappened((GenericMouseEvent)genericEvent);
        }
    }

    private void eventHappened(GenericActionEvent genericActionEvent) {
        String string = genericActionEvent.getMessage();
        if (string.equals(ITEM_COPY_STRUCTURE) || string.equals(ITEM_COPY_REACTION)) {
            this.copy();
        } else if (string.equals(ITEM_PASTE_REACTION)) {
            this.pasteReaction();
        } else if (string.startsWith(ITEM_USE_TEMPLATE)) {
            this.useTemplate(string.substring(ITEM_USE_TEMPLATE.length()));
        } else if (string.startsWith(ITEM_PASTE_STRUCTURE)) {
            this.pasteMolecule();
        } else if (string.equals(ITEM_LOAD_REACTION)) {
            this.openReactionAsync();
        } else if (string.equals(ITEM_ADD_AUTO_MAPPING)) {
            this.autoMapReaction();
            this.updateAndFireEvent(Math.max(this.mUpdateMode, 1));
        } else if (string.equals(ITEM_REMOVE_MAPPING)) {
            this.removeManualMapping();
        } else if (string.equals(ITEM_FLIP_HORIZONTALLY)) {
            this.flip(true);
        } else if (string.equals(ITEM_FLIP_VERTICALLY)) {
            this.flip(false);
        } else if (string.equals(ITEM_FLIP_ROTATE180)) {
            this.rotate180();
        } else if (string.equals(ITEM_SHOW_HELP)) {
            this.showHelpDialog();
        } else if (string.startsWith("atomColor")) {
            int n = string.indexOf(58);
            int n2 = Integer.parseInt(string.substring(9, n));
            int n3 = Integer.parseInt(string.substring(n + 1));
            if (this.mMol.isSelectedAtom(n2)) {
                for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                    if (!this.mMol.isSelectedAtom(i)) continue;
                    this.mMol.setAtomColor(i, n3);
                }
            } else {
                this.mMol.setAtomColor(n2, n3);
            }
        } else if (string.equals(ITEM_SHOW_ATOM_BOND_NUMBERS)) {
            this.setDisplayMode(6);
        } else if (string.equals(ITEM_SHOW_SYMMETRY)) {
            this.setDisplayMode(256);
        } else if (string.equals(ITEM_SHOW_NORMAL)) {
            this.setDisplayMode(this.mCurrentTool == 19 ? 16 : 0);
        }
    }

    private void removeManualMapping() {
        boolean bl = false;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mMol.getAtomMapNo(i) == 0 || this.mMol.isAutoMappedAtom(i)) continue;
            if (!bl) {
                this.storeState();
                bl = true;
            }
            this.mMol.setAtomMapNo(i, 0, false);
        }
        if (bl) {
            this.autoMapReaction();
            this.updateAndFireEvent(Math.max(this.mUpdateMode, 1));
        }
    }

    private boolean analyseCopy(boolean bl) {
        boolean bl2 = (this.mMode & 4) != 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        ReactionArrow reactionArrow = null;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (!this.mMol.isSelectedAtom(i)) continue;
            if (!bl3) {
                bl3 = true;
                if (!bl2) break;
                reactionArrow = (ReactionArrow)this.mDrawingObjectList.get(0);
                bl5 = reactionArrow.isOnProductSide(this.mMol.getAtomX(i), this.mMol.getAtomY(i));
                continue;
            }
            if (bl5 == reactionArrow.isOnProductSide(this.mMol.getAtomX(i), this.mMol.getAtomY(i))) continue;
            bl4 = true;
            break;
        }
        if (!bl) {
            return bl2 && (bl4 || !bl3);
        }
        if (bl2) {
            if (bl4) {
                this.copyReaction(true);
                return true;
            }
            if (bl3) {
                this.copyMolecule(true);
                return false;
            }
            this.copyReaction(false);
            return true;
        }
        this.copyMolecule(bl3);
        return false;
    }

    private void copy() {
        this.analyseCopy(true);
    }

    private boolean copyReaction(boolean bl) {
        Reaction reaction;
        Reaction reaction2 = reaction = bl ? this.getSelectedReaction() : this.getReaction();
        if (reaction != null && this.mClipboardHandler != null) {
            return this.mClipboardHandler.copyReaction(reaction);
        }
        return false;
    }

    private Reaction getSelectedReaction() {
        Reaction reaction = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            StereoMolecule stereoMolecule = this.getSelectedCopy(this.mFragment[i]);
            if (stereoMolecule == null) continue;
            if (i < this.mReactantCount) {
                reaction.addReactant(stereoMolecule);
                continue;
            }
            reaction.addProduct(stereoMolecule);
        }
        return reaction;
    }

    private StereoMolecule getSelectedCopy(StereoMolecule stereoMolecule) {
        int n;
        int n2 = 0;
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            if (!stereoMolecule.isSelectedAtom(n)) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        n = 0;
        for (int i = 0; i < stereoMolecule.getAllBonds(); ++i) {
            if (!stereoMolecule.isSelectedBond(i)) continue;
            ++n;
        }
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            blArray[i] = stereoMolecule.isSelectedAtom(i);
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(n2, n);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, false, null);
        return stereoMolecule2;
    }

    private boolean copyMolecule(boolean bl) {
        if (this.mMol.getAllAtoms() != 0 && this.mClipboardHandler != null) {
            return this.mClipboardHandler.copyMolecule(bl ? this.getSelectedCopy(this.mMol) : this.mMol.getCompactCopy());
        }
        return false;
    }

    private void paste() {
        if ((this.mMode & 4) != 0 && this.pasteReaction()) {
            return;
        }
        this.pasteMolecule();
    }

    private boolean pasteReaction() {
        boolean bl = false;
        if (this.mClipboardHandler != null) {
            Reaction reaction = this.mClipboardHandler.pasteReaction();
            if (reaction != null) {
                if (!this.mAllowFragmentChangeOnPasteOrDrop) {
                    for (int i = 0; i < reaction.getMolecules(); ++i) {
                        reaction.getMolecule(i).setFragment(this.mMol.isFragment());
                    }
                }
                this.storeState();
                this.setReaction(reaction);
                bl = true;
            } else {
                this.showWarningMessage("No reaction on clipboard!");
            }
        }
        return bl;
    }

    private boolean pasteMolecule() {
        if (this.mClipboardHandler != null) {
            StereoMolecule stereoMolecule = this.mClipboardHandler.pasteMolecule();
            if (this.addPastedOrDropped(stereoMolecule, null)) {
                return true;
            }
            this.showWarningMessage("No molecule on clipboard!");
        }
        return false;
    }

    public boolean addPastedOrDropped(StereoMolecule stereoMolecule, GenericPoint genericPoint) {
        if (stereoMolecule == null || stereoMolecule.getAllAtoms() == 0) {
            return false;
        }
        if (genericPoint == null) {
            this.mMol.clear();
        }
        if (stereoMolecule.getAllBonds() != 0) {
            double d = this.getScaledAVBL();
            new GenericDepictor(stereoMolecule).updateCoords(this.mCanvas.getDrawContext(), new GenericRectangle(0.0, 0.0, this.mCanvas.getCanvasWidth(), this.mCanvas.getCanvasHeight()), 65536 + (int)d);
            while (this.atomCoordinatesCollide(stereoMolecule, 0.2 * d)) {
                stereoMolecule.translateCoords(0.5 * d, 0.5 * d);
            }
        }
        this.storeState();
        stereoMolecule.removeAtomColors();
        stereoMolecule.removeBondHiliting();
        boolean bl = this.mMol.isFragment();
        if (this.mMol.getAllAtoms() == 0) {
            stereoMolecule.copyMolecule(this.mMol);
            if (!this.mAllowFragmentChangeOnPasteOrDrop) {
                this.mMol.setFragment(bl);
            }
            this.updateAndFireEvent(4);
        } else {
            if (genericPoint != null) {
                stereoMolecule.translateCoords(genericPoint.x - this.mCanvas.getCanvasWidth() / 2.0, genericPoint.y - this.mCanvas.getCanvasHeight() / 2.0);
            }
            int n = this.mMol.getAllAtoms();
            this.mMol.addMolecule(stereoMolecule);
            if (!this.mAllowFragmentChangeOnPasteOrDrop) {
                this.mMol.setFragment(bl);
            }
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                this.mMol.setAtomSelection(i, i >= n);
            }
            this.updateAndFireEvent(3);
        }
        return true;
    }

    private void useTemplate(String string) {
        this.storeState();
        this.setReaction(ReactionEncoder.decode(string, true));
    }

    private boolean atomCoordinatesCollide(StereoMolecule stereoMolecule, double d) {
        int n = 0;
        d *= d;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            double d2 = stereoMolecule.getAtomX(i);
            double d3 = stereoMolecule.getAtomY(i);
            boolean bl = false;
            for (int j = 0; j < this.mMol.getAllAtoms(); ++j) {
                double d4;
                double d5;
                double d6 = this.mMol.getAtomX(j);
                double d7 = d6 - d2;
                if (!(d7 * d7 + (d5 = (d4 = this.mMol.getAtomY(j)) - d3) * d5 < d)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            ++n;
        }
        return n == stereoMolecule.getAllAtoms();
    }

    private void openReactionAsync() {
        this.mUIHelper.openChemistryFileAsync(true, file -> {
            if (file != null) {
                try {
                    Reaction reaction = null;
                    if (FileHelper.getFileType(file.getName()) == 1024) {
                        reaction = new RXNFileParser().getReaction((File)file);
                    } else {
                        RDFileParser rDFileParser = new RDFileParser((File)file);
                        if (rDFileParser.isReactionNext()) {
                            reaction = rDFileParser.getNextReaction();
                        }
                    }
                    if (reaction != null) {
                        for (int i = 0; i < reaction.getMolecules(); ++i) {
                            reaction.getMolecule(i).setFragment(this.mMol.isFragment());
                        }
                        this.storeState();
                        this.setReaction(reaction);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected void showWarningMessage(String string) {
        this.mWarningMessage = string;
        this.mCanvas.repaint();
        Timer timer = new Timer(1200, actionEvent -> {
            this.mWarningMessage = null;
            this.mCanvas.repaint();
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void eventHappened(GenericMouseEvent genericMouseEvent) {
        int n;
        if (genericMouseEvent.getWhat() == 1) {
            if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
                this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
            }
            this.mAtomKeyStrokeBuffer.setLength(0);
            if (genericMouseEvent.isPopupTrigger()) {
                this.handlePopupTrigger(genericMouseEvent.getX(), genericMouseEvent.getY());
                return;
            }
            if (genericMouseEvent.getButton() == 1) {
                if (genericMouseEvent.getClickCount() == 2) {
                    return;
                }
                this.mMouseIsDown = true;
                this.updateCursor();
                this.mousePressedButton1(genericMouseEvent);
            }
        }
        if (genericMouseEvent.getWhat() == 2) {
            if (genericMouseEvent.isPopupTrigger()) {
                this.handlePopupTrigger(genericMouseEvent.getX(), genericMouseEvent.getY());
                return;
            }
            if (genericMouseEvent.getButton() == 1) {
                if (genericMouseEvent.getClickCount() == 2) {
                    this.handleDoubleClick(genericMouseEvent.getX(), genericMouseEvent.getY());
                    return;
                }
                this.mMouseIsDown = false;
                this.updateCursor();
                this.mouseReleasedButton1();
            }
        }
        if (genericMouseEvent.getWhat() == 4) {
            this.mUIHelper.grabFocus();
            this.updateCursor();
        }
        if (genericMouseEvent.getWhat() == 6) {
            int n2;
            this.mMouseIsDown = false;
            n = genericMouseEvent.getX();
            if (this.trackHiliting(n, n2 = genericMouseEvent.getY(), false)) {
                this.mCanvas.repaint();
            }
            this.updateCursor();
        }
        if (genericMouseEvent.getWhat() == 7) {
            this.mMouseIsDown = true;
            this.mX2 = genericMouseEvent.getX();
            this.mY2 = genericMouseEvent.getY();
            n = this.trackHiliting(this.mX2, this.mY2, true) ? 1 : 0;
            switch (this.mPendingRequest) {
                case 2: {
                    int n3;
                    double d;
                    double d2;
                    if (this.mChainAtoms > 0) {
                        d2 = this.mChainAtomX[this.mChainAtoms - 1];
                        d = this.mChainAtomY[this.mChainAtoms - 1];
                    } else {
                        d2 = 0.0;
                        d = 0.0;
                    }
                    double d3 = this.getScaledAVBL();
                    double d4 = (int)d3;
                    double d5 = (int)(0.866 * d3);
                    double d6 = (int)(0.5 * d3);
                    double d7 = this.mX2 - this.mX1;
                    double d8 = this.mY2 - this.mY1;
                    if (Math.abs(d8) > Math.abs(d7)) {
                        this.mChainAtoms = (int)(2.0 * Math.abs(d8) / (d4 + d6));
                        if (Math.abs(d8) % (d4 + d6) > d4) {
                            ++this.mChainAtoms;
                        }
                        this.mChainAtomX = new double[this.mChainAtoms];
                        this.mChainAtomY = new double[this.mChainAtoms];
                        if (this.mX2 < this.mX1) {
                            d5 = -d5;
                        }
                        if (this.mY2 < this.mY1) {
                            d4 = -d4;
                            d6 = -d6;
                        }
                        for (n3 = 0; n3 < this.mChainAtoms; ++n3) {
                            this.mChainAtomX[n3] = this.mX1 + (double)((n3 + 1) / 2) * d5;
                            this.mChainAtomY[n3] = this.mY1 + (double)((n3 + 1) / 2) * (d4 + d6);
                            if ((n3 & 1) != 0) continue;
                            int n4 = n3;
                            this.mChainAtomY[n4] = this.mChainAtomY[n4] + d4;
                        }
                    } else {
                        this.mChainAtoms = (int)(Math.abs(d7) / d5);
                        this.mChainAtomX = new double[this.mChainAtoms];
                        this.mChainAtomY = new double[this.mChainAtoms];
                        if (this.mX2 < this.mX1) {
                            d5 = -d5;
                        }
                        if (this.mY2 < this.mY1) {
                            d6 = -d6;
                        }
                        for (n3 = 0; n3 < this.mChainAtoms; ++n3) {
                            this.mChainAtomX[n3] = this.mX1 + (double)(n3 + 1) * d5;
                            this.mChainAtomY[n3] = this.mY1;
                            if ((n3 & 1) != 0) continue;
                            int n5 = n3;
                            this.mChainAtomY[n5] = this.mChainAtomY[n5] + d6;
                        }
                    }
                    if (this.mChainAtoms > 0) {
                        this.mChainAtom = new int[this.mChainAtoms];
                        for (n3 = 0; n3 < this.mChainAtoms; ++n3) {
                            this.mChainAtom[n3] = this.mMol.findAtom(this.mChainAtomX[n3], this.mChainAtomY[n3]);
                            if (this.mChainAtom[n3] == -1) continue;
                            this.mChainAtomX[n3] = this.mMol.getAtomX(this.mChainAtom[n3]);
                            this.mChainAtomY[n3] = this.mMol.getAtomY(this.mChainAtom[n3]);
                        }
                        if (this.mChainAtomX[this.mChainAtoms - 1] == d2 && this.mChainAtomY[this.mChainAtoms - 1] == d) break;
                        n = 1;
                        break;
                    }
                    if (d2 == 0.0 && d == 0.0) break;
                    n = 1;
                    break;
                }
                case 1: {
                    if ((this.mX2 - this.mX1) * (this.mX2 - this.mX1) + (this.mY2 - this.mY1) * (this.mY2 - this.mY1) < 100.0) {
                        this.suggestNewX2AndY2(this.mAtom1);
                    }
                    n = 1;
                    break;
                }
                case 3: {
                    this.mMol.setAtomX(this.mAtom1, this.mX[this.mAtom1] + this.mX2 - this.mX1);
                    this.mMol.setAtomY(this.mAtom1, this.mY[this.mAtom1] + this.mY2 - this.mY1);
                    if (this.mAtom2 != -1) {
                        this.mMol.setAtomX(this.mAtom2, this.mX[this.mAtom2] + this.mX2 - this.mX1);
                        this.mMol.setAtomY(this.mAtom2, this.mY[this.mAtom2] + this.mY2 - this.mY1);
                    }
                    this.update(2);
                    break;
                }
                case 9: {
                    this.duplicateSelected();
                    this.mPendingRequest = 4;
                }
                case 4: {
                    if (this.mDrawingObjectList != null) {
                        for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                            if (!abstractDrawingObject.isSelected()) continue;
                            abstractDrawingObject.translate(this.mX2, this.mY2);
                        }
                    }
                    for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        if (!this.mMol.isSelectedAtom(i)) continue;
                        this.mMol.setAtomX(i, this.mX[i] + this.mX2 - this.mX1);
                        this.mMol.setAtomY(i, this.mY[i] + this.mY2 - this.mY1);
                    }
                    this.update(2);
                    break;
                }
                case 11: {
                    this.mDrawingObjectList.add(this.mCurrentHiliteObject.clone());
                    this.mPendingRequest = 10;
                }
                case 10: {
                    this.mCurrentHiliteObject.translate(this.mX2, this.mY2);
                    this.update(2);
                    break;
                }
                case 7: {
                    boolean bl;
                    int n6;
                    boolean bl2 = false;
                    for (n6 = 0; n6 < this.mMol.getAllAtoms() && !bl2; ++n6) {
                        bl2 = this.mMol.isSelectedAtom(n6);
                    }
                    n6 = 0;
                    if (this.mDrawingObjectList != null) {
                        for (int i = 0; i < this.mDrawingObjectList.size() && n6 == 0; ++i) {
                            n6 = ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected() ? 1 : 0;
                        }
                    }
                    double d = Math.abs(this.mY2 - this.mY1) < 20.0 ? 1.0 : Math.exp((this.mY2 - this.mY1) / 100.0);
                    double d9 = Math.abs(this.mX2 - this.mX1) < 20.0 ? 0.0 : (this.mX2 - this.mX1) / 50.0;
                    boolean bl3 = bl = bl2 || n6 != 0;
                    if (!(this.mDrawingObjectList == null || bl && n6 == 0)) {
                        for (int i = 0; i < this.mDrawingObjectList.size(); ++i) {
                            if (bl && !((AbstractDrawingObject)this.mDrawingObjectList.get(i)).isSelected()) continue;
                            ((AbstractDrawingObject)this.mDrawingObjectList.get(i)).zoomAndRotate(d, d9);
                        }
                        this.update(2);
                    }
                    if (bl && !bl2) break;
                    this.mMol.zoomAndRotate(d, d9, bl);
                    this.update(2);
                    break;
                }
                case 5: 
                case 6: {
                    int n7;
                    GenericShape genericShape = null;
                    if (this.mPendingRequest == 5) {
                        if (Math.abs(this.mX2 - this.mLassoRegion.getX(this.mLassoRegion.getSize() - 1)) < 3.0 && Math.abs(this.mY2 - this.mLassoRegion.getY(this.mLassoRegion.getSize() - 1)) < 3.0) break;
                        this.mLassoRegion.removeLastPoint();
                        this.mLassoRegion.addPoint(this.mX2, this.mY2);
                        this.mLassoRegion.addPoint(this.mX1, this.mY1);
                        genericShape = this.mLassoRegion;
                    } else {
                        genericShape = new GenericRectangle(Math.min(this.mX1, this.mX2), Math.min(this.mY1, this.mY2), Math.abs(this.mX2 - this.mX1), Math.abs(this.mY2 - this.mY1));
                    }
                    if (this.mDrawingObjectList != null) {
                        for (n7 = 0; n7 < this.mDrawingObjectList.size(); ++n7) {
                            AbstractDrawingObject abstractDrawingObject = (AbstractDrawingObject)this.mDrawingObjectList.get(n7);
                            boolean bl = abstractDrawingObject.isSurroundedBy(genericShape);
                            if (this.mIsAddingToSelection && this.mIsSelectedObject[n7] || bl == abstractDrawingObject.isSelected()) continue;
                            abstractDrawingObject.setSelected(bl);
                            this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                        }
                    }
                    for (n7 = 0; n7 < this.mMol.getAllAtoms(); ++n7) {
                        boolean bl = genericShape.contains((int)this.mMol.getAtomX(n7), (int)this.mMol.getAtomY(n7));
                        if (this.mIsAddingToSelection && this.mIsSelectedAtom[n7] || bl == this.mMol.isSelectedAtom(n7)) continue;
                        this.mMol.setAtomSelection(n7, bl);
                        this.mUpdateMode = Math.max(this.mUpdateMode, 1);
                    }
                    n = 1;
                    break;
                }
                case 8: {
                    n = 1;
                }
            }
            if (n != 0) {
                this.mCanvas.repaint();
            }
        }
    }

    public void showHelpDialog() {
        this.mUIHelper.showHelpDialog("/html/editor/editor.html", "Structure Editor Help");
    }

    private void eventHappened(GenericKeyEvent genericKeyEvent) {
        if (genericKeyEvent.getWhat() == 1) {
            if (genericKeyEvent.getKey() == -3) {
                this.mShiftIsDown = true;
                this.updateCursor();
            }
            if (genericKeyEvent.getKey() == -2) {
                this.mAltIsDown = true;
                this.updateCursor();
            }
            if (genericKeyEvent.getKey() == -1) {
                this.updateCursor();
            }
            if (genericKeyEvent.isMenuShortcut()) {
                if (genericKeyEvent.getKey() == 122) {
                    this.restoreState();
                    this.updateAndFireEvent(2);
                } else if (genericKeyEvent.getKey() == 99) {
                    this.copy();
                } else if (genericKeyEvent.getKey() == 118) {
                    this.paste();
                }
            } else if (genericKeyEvent.getKey() == -4) {
                this.storeState();
                if (this.mCurrentTool == 19) {
                    boolean bl = false;
                    for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                        if (this.mMol.getAtomMapNo(i) == 0) continue;
                        this.mMol.setAtomMapNo(i, 0, false);
                        bl = true;
                    }
                    if (bl) {
                        this.updateAndFireEvent(1);
                    }
                } else if (!this.deleteHilited() && this.mMol.deleteSelectedAtoms()) {
                    this.updateAndFireEvent(1);
                }
            } else {
                if (genericKeyEvent.getKey() == -6 || this.mCurrentHiliteAtom == -1 && genericKeyEvent.getKey() == 63) {
                    this.showHelpDialog();
                    return;
                }
                if (this.mCurrentHiliteBond != -1) {
                    int n = genericKeyEvent.getKey();
                    if (n == 113 && this.mMol.isFragment()) {
                        this.showBondQFDialog(this.mCurrentHiliteBond);
                    } else if (n == 118) {
                        if (this.mMol.addRingToBond(this.mCurrentHiliteBond, 3, false, this.getScaledAVBL())) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (n >= 52 && n <= 55) {
                        if (this.mMol.addRingToBond(this.mCurrentHiliteBond, n - 48, false, this.getScaledAVBL())) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (n == 97 || n == 98) {
                        if (this.mMol.addRingToBond(this.mCurrentHiliteBond, 6, true, this.getScaledAVBL())) {
                            this.updateAndFireEvent(3);
                        }
                    } else {
                        boolean bl;
                        boolean bl2 = n == 48 ? this.changeHighlightedBond(32) : (n == 49 ? this.changeHighlightedBond(1) : (n == 50 ? this.changeHighlightedBond(2) : (n == 51 ? this.changeHighlightedBond(4) : (n == 117 ? this.changeHighlightedBond(257) : (n == 100 ? this.changeHighlightedBond(129) : (n == 99 ? this.changeHighlightedBond(386) : (bl = n == 109 ? this.changeHighlightedBond(32) : false)))))));
                        if (bl) {
                            this.updateAndFireEvent(1);
                        }
                    }
                } else if (this.mCurrentHiliteAtom != -1) {
                    boolean bl;
                    int n = genericKeyEvent.getKey();
                    boolean bl3 = bl = this.mAtomKeyStrokeBuffer.length() == 0;
                    if (bl) {
                        this.mFirstAtomKey = n;
                    } else {
                        if (this.mFirstAtomKey == 108) {
                            this.mAtomKeyStrokeBuffer.setLength(0);
                            this.mAtomKeyStrokeBuffer.append('L');
                        }
                        this.mFirstAtomKey = -1;
                    }
                    if (bl && n == 108) {
                        this.mAtomKeyStrokeBuffer.append("Cl");
                        this.update(1);
                    } else if (bl && (n == 43 || n == 45)) {
                        this.storeState();
                        if (this.mMol.changeAtomCharge(this.mCurrentHiliteAtom, n == 43)) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (bl && n == 46) {
                        this.storeState();
                        int n2 = this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 32 ? 0 : 32;
                        this.mMol.setAtomRadical(this.mCurrentHiliteAtom, n2);
                        this.updateAndFireEvent(3);
                    } else if (bl && n == 58) {
                        this.storeState();
                        int n3 = this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 48 ? 16 : (this.mMol.getAtomRadical(this.mCurrentHiliteAtom) == 16 ? 0 : 48);
                        this.mMol.setAtomRadical(this.mCurrentHiliteAtom, n3);
                        this.updateAndFireEvent(3);
                    } else if (bl && n == 113 && this.mMol.isFragment()) {
                        this.showAtomQFDialog(this.mCurrentHiliteAtom);
                    } else if (bl && this.mMol.isFragment() && (n == 120 || n == 88)) {
                        int[] nArray = new int[]{9, 17, 35, 53};
                        this.mMol.setAtomList(this.mCurrentHiliteAtom, nArray);
                        this.updateAndFireEvent(3);
                    } else if (bl && n == 63) {
                        this.storeState();
                        if (this.mMol.changeAtom(this.mCurrentHiliteAtom, 0, 0, -1, 0)) {
                            this.updateAndFireEvent(3);
                        }
                    } else if (bl && n > 48 && n <= 57) {
                        if (this.mMol.getFreeValence(this.mCurrentHiliteAtom) > 0) {
                            this.storeState();
                            int n4 = n - 47;
                            int n5 = this.mCurrentHiliteAtom;
                            int n6 = this.mMol.getAllAtoms() - this.mMol.getAtoms();
                            for (int i = 1; i < n4; ++i) {
                                this.suggestNewX2AndY2(n5);
                                int n7 = this.mMol.addAtom(this.mX2, this.mY2);
                                if (n7 == -1) break;
                                this.mMol.addBond(n5, n7);
                                n5 = n7 - n6;
                                this.mMol.ensureHelperArrays(1);
                            }
                            this.updateAndFireEvent(3);
                        }
                    } else if (!bl && genericKeyEvent.getKey() == -7) {
                        this.mAtomKeyStrokeBuffer.setLength(0);
                        this.update(1);
                    } else if (!bl && genericKeyEvent.getKey() == -5) {
                        this.mAtomKeyStrokeBuffer.setLength(this.mAtomKeyStrokeBuffer.length() - 1);
                        this.update(1);
                    } else if (n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 45) {
                        this.mAtomKeyStrokeBuffer.append((char)n);
                        this.update(1);
                    } else if (n == 10 || n == 13) {
                        this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
                    }
                } else if (this.mCurrentHiliteAtom == -1 && this.mCurrentHiliteBond == -1 && (this.mMode & 7) == 0) {
                    int n = genericKeyEvent.getKey();
                    if (n == 104) {
                        this.flip(true);
                    }
                    if (n == 118) {
                        this.flip(false);
                    }
                }
            }
        }
        if (genericKeyEvent.getWhat() == 2) {
            if (genericKeyEvent.getKey() == -3) {
                this.mShiftIsDown = false;
                this.updateCursor();
            }
            if (genericKeyEvent.getKey() == -2) {
                this.mAltIsDown = false;
                this.updateCursor();
            }
            if (genericKeyEvent.getKey() == -1) {
                this.updateCursor();
            }
        }
    }

    private boolean changeHighlightedBond(int n) {
        this.storeState();
        return this.mMol.changeBond(this.mCurrentHiliteBond, n);
    }

    private void handlePopupTrigger(int n, int n2) {
        GenericPopupMenu genericPopupMenu = null;
        if (this.mClipboardHandler != null) {
            genericPopupMenu = this.mUIHelper.createPopupMenu(this);
            String string = this.analyseCopy(false) ? ITEM_COPY_REACTION : ITEM_COPY_STRUCTURE;
            genericPopupMenu.addItem(string, null, this.mMol.getAllAtoms() != 0);
            String string2 = StructureNameResolver.getInstance() == null ? ITEM_PASTE_STRUCTURE : ITEM_PASTE_WITH_NAME;
            genericPopupMenu.addItem(string2, null, true);
            if ((this.mMode & 4) != 0) {
                genericPopupMenu.addItem(ITEM_PASTE_REACTION, null, true);
                genericPopupMenu.addSeparator();
                if (sReactionQueryTemplates != null && this.mMol.isFragment()) {
                    boolean bl = false;
                    for (String[] stringArray : sReactionQueryTemplates) {
                        if (TEMPLATE_SECTION_KEY.equals(stringArray[0])) {
                            if (bl) {
                                genericPopupMenu.endSubMenu();
                            }
                            genericPopupMenu.startSubMenu("Use " + stringArray[1] + " Template");
                            bl = true;
                            continue;
                        }
                        if (!bl) {
                            genericPopupMenu.startSubMenu("Use Template");
                            bl = true;
                        }
                        genericPopupMenu.addItem(stringArray[0], ITEM_USE_TEMPLATE + stringArray[1], true);
                    }
                    genericPopupMenu.endSubMenu();
                }
            }
            if ((this.mMode & 4) != 0) {
                genericPopupMenu.addItem(ITEM_LOAD_REACTION, null, true);
            }
        }
        if ((this.mMode & 4) != 0 && this.mCurrentTool == 19) {
            if (genericPopupMenu == null) {
                genericPopupMenu = this.mUIHelper.createPopupMenu(this);
            } else {
                genericPopupMenu.addSeparator();
            }
            genericPopupMenu.addItem(ITEM_ADD_AUTO_MAPPING, null, true);
            genericPopupMenu.addItem(ITEM_REMOVE_MAPPING, null, true);
        }
        if (this.mCurrentTool == 18) {
            if (genericPopupMenu == null) {
                genericPopupMenu = this.mUIHelper.createPopupMenu(this);
            } else {
                genericPopupMenu.addSeparator();
            }
            genericPopupMenu.addItem(ITEM_FLIP_HORIZONTALLY, null, true);
            genericPopupMenu.addItem(ITEM_FLIP_VERTICALLY, null, true);
            genericPopupMenu.addItem(ITEM_FLIP_ROTATE180, null, true);
        }
        if (this.mAtomColorSupported && this.mCurrentHiliteAtom != -1) {
            int n3 = this.mMol.getAtomColor(this.mCurrentHiliteAtom);
            if (genericPopupMenu == null) {
                genericPopupMenu = this.mUIHelper.createPopupMenu(this);
            } else {
                genericPopupMenu.addSeparator();
            }
            genericPopupMenu.startSubMenu("Set Atom Color");
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 0, -16777216, n3 == 0);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 64, -14655233, n3 == 64);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 448, -6291456, n3 == 448);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 128, -65536, n3 == 128);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 384, -16744448, n3 == 384);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 192, -16711936, n3 == 192);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 256, -4194049, n3 == 256);
            genericPopupMenu.addRadioButtonItem("\t  ", "atomColor" + this.mCurrentHiliteAtom + ":" + 320, -24576, n3 == 320);
            genericPopupMenu.endSubMenu();
        }
        if (genericPopupMenu == null) {
            genericPopupMenu = this.mUIHelper.createPopupMenu(this);
        } else {
            genericPopupMenu.addSeparator();
        }
        genericPopupMenu.addItem(ITEM_SHOW_HELP, null, true);
        if (System.getProperty("development") != null) {
            if (genericPopupMenu == null) {
                genericPopupMenu = this.mUIHelper.createPopupMenu(this);
            } else {
                genericPopupMenu.addSeparator();
            }
            genericPopupMenu.addItem(ITEM_SHOW_ATOM_BOND_NUMBERS, null, true);
            genericPopupMenu.addItem(ITEM_SHOW_SYMMETRY, null, true);
            genericPopupMenu.addItem(ITEM_SHOW_NORMAL, null, true);
        }
        if (genericPopupMenu != null) {
            genericPopupMenu.show(n, n2);
        }
    }

    private void handleDoubleClick(int n, int n2) {
        int n3 = this.mMol.findAtom(n, n2);
        int n4 = this.mMol.findBond(n, n2);
        if (this.mCurrentTool == 2) {
            if (this.mMol.isFragment()) {
                if (n3 != -1) {
                    this.showAtomQFDialog(n3);
                } else if (n4 != -1) {
                    this.showBondQFDialog(n4);
                } else if (this.mCurrentHiliteObject != null) {
                    if (!this.mShiftIsDown) {
                        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                            this.mMol.setAtomSelection(i, false);
                        }
                        for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                            abstractDrawingObject.setSelected(false);
                        }
                    }
                    this.mCurrentHiliteObject.setSelected(true);
                    this.update(1);
                }
            } else {
                int n5 = -1;
                if (n3 != -1) {
                    n5 = n3;
                } else if (n4 != -1) {
                    n5 = this.mMol.getBondAtom(0, n4);
                }
                if (n5 != -1 || this.mCurrentHiliteObject != null) {
                    if (!this.mShiftIsDown) {
                        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                            this.mMol.setAtomSelection(i, false);
                        }
                        if (this.mDrawingObjectList != null) {
                            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                                abstractDrawingObject.setSelected(false);
                            }
                        }
                    }
                    if (n5 != -1) {
                        if ((this.mMode & 1) != 0) {
                            int n6 = this.mFragmentNo[n5];
                            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                                if (this.mFragmentNo[i] != n6) continue;
                                this.mMol.setAtomSelection(i, true);
                            }
                        } else {
                            int[] nArray = this.mMol.getFragmentAtoms(n5);
                            for (int i = 0; i < nArray.length; ++i) {
                                this.mMol.setAtomSelection(nArray[i], true);
                            }
                        }
                    } else {
                        this.mCurrentHiliteObject.setSelected(true);
                    }
                    this.update(1);
                }
            }
        } else if (this.mCurrentTool == 18) {
            int n7 = -2;
            if ((this.mMode & 1) != 0) {
                n7 = this.findFragment(n, n2);
            }
            if (n7 != -1) {
                double d = 2.147483647E9;
                double d2 = -2.147483648E9;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (n7 != -2 && this.mFragmentNo[i] != n7) continue;
                    if (d > this.mMol.getAtomX(i)) {
                        d = this.mMol.getAtomX(i);
                    }
                    if (!(d2 < this.mMol.getAtomX(i))) continue;
                    d2 = this.mMol.getAtomX(i);
                }
                if (d2 > d) {
                    int n8;
                    double d3 = (d2 + d) / 2.0;
                    for (n8 = 0; n8 < this.mMol.getAllAtoms(); ++n8) {
                        if (n7 != -2 && this.mFragmentNo[n8] != n7) continue;
                        this.mMol.setAtomX(n8, 2.0 * d3 - this.mMol.getAtomX(n8));
                    }
                    block12: for (n8 = 0; n8 < this.mMol.getAllBonds(); ++n8) {
                        if (n7 != -2 && this.mFragmentNo[this.mMol.getBondAtom(0, n8)] != n7) continue;
                        switch (this.mMol.getBondType(n8)) {
                            case 257: {
                                this.mMol.setBondType(n8, 129);
                                continue block12;
                            }
                            case 129: {
                                this.mMol.setBondType(n8, 257);
                            }
                        }
                    }
                }
                this.updateAndFireEvent(1);
            }
        } else if (this.mCurrentTool == 33) {
            this.mUIHelper.showMessage("To change current custom atom properties hold 'Ctrl'\nwhile clicking an atom with the left mouse button.");
        }
    }

    private void showAtomQFDialog(int n) {
        if (this.mAllowQueryFeatures) {
            this.storeState();
            boolean bl = (this.mMode & 4) != 0;
            AtomQueryFeatureDialogBuilder atomQueryFeatureDialogBuilder = new AtomQueryFeatureDialogBuilder(this.mUIHelper, this.mMol, n, bl);
            this.showBuilderAsync(atomQueryFeatureDialogBuilder, true);
        }
    }

    private void showBondQFDialog(int n) {
        if (this.mAllowQueryFeatures) {
            this.storeState();
            BondQueryFeatureDialogBuilder bondQueryFeatureDialogBuilder = new BondQueryFeatureDialogBuilder(this.mUIHelper, this.mMol, n);
            this.showBuilderAsync(bondQueryFeatureDialogBuilder, true);
        }
    }

    private void showBuilderAsync(AsynchronousQueryBuilder asynchronousQueryBuilder, boolean bl) {
        if (SwingUIHelper.isAsynchronous()) {
            asynchronousQueryBuilder.showDialog(() -> {
                if (bl) {
                    this.updateAndFireEvent(1);
                }
            }, null);
        } else if (asynchronousQueryBuilder.showDialog() && bl) {
            this.updateAndFireEvent(1);
        }
    }

    private void mousePressedButton1(GenericMouseEvent genericMouseEvent) {
        this.mX1 = genericMouseEvent.getX();
        this.mY1 = genericMouseEvent.getY();
        switch (this.mCurrentTool) {
            case 18: {
                double d = this.mX1;
                double d2 = this.mY1;
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mMol.zoomAndRotateInit(d, d2);
                if (this.mDrawingObjectList != null) {
                    for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                        abstractDrawingObject.zoomAndRotateInit(d, d2);
                    }
                }
                this.storeState();
                this.mPendingRequest = 7;
                break;
            }
            case 2: {
                int n;
                this.mPendingRequest = 0;
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    this.mAtom2 = -1;
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                    this.mPendingRequest = this.mMol.isSelectedAtom(this.mAtom1) ? (this.mShiftIsDown ? 9 : 4) : 3;
                }
                if (this.mPendingRequest == 0 && (n = this.mMol.findBond(this.mX1, this.mY1)) != -1) {
                    this.mAtom1 = this.mMol.getBondAtom(0, n);
                    this.mAtom2 = this.mMol.getBondAtom(1, n);
                    this.mPendingRequest = this.mMol.isSelectedBond(n) ? (this.mShiftIsDown ? 9 : 4) : 3;
                }
                if (this.mPendingRequest == 0 && this.mCurrentHiliteObject != null) {
                    if (this.mCurrentHiliteObject.isSelected()) {
                        this.mPendingRequest = this.mShiftIsDown ? 9 : 4;
                    } else {
                        int n2 = this.mPendingRequest = this.mShiftIsDown && !(this.mCurrentHiliteObject instanceof ReactionArrow) ? 11 : 10;
                    }
                }
                if (this.mPendingRequest != 0) {
                    this.mX = new double[this.mMol.getAllAtoms()];
                    this.mY = new double[this.mMol.getAllAtoms()];
                    for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                        this.mX[n] = this.mMol.getAtomX(n);
                        this.mY[n] = this.mMol.getAtomY(n);
                    }
                    if (this.mDrawingObjectList != null) {
                        for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                            abstractDrawingObject.translateInit(this.mX1, this.mY1);
                        }
                    }
                    this.storeState();
                    break;
                }
                this.mIsSelectedAtom = new boolean[this.mMol.getAllAtoms()];
                if (this.mDrawingObjectList != null) {
                    this.mIsSelectedObject = new boolean[this.mDrawingObjectList.size()];
                }
                this.mIsAddingToSelection = genericMouseEvent.isShiftDown();
                for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                    this.mIsSelectedAtom[n] = this.mMol.isSelectedAtom(n);
                }
                if (this.mDrawingObjectList != null) {
                    for (n = 0; n < this.mDrawingObjectList.size(); ++n) {
                        this.mIsSelectedObject[n] = ((AbstractDrawingObject)this.mDrawingObjectList.get(n)).isSelected();
                    }
                }
                if (genericMouseEvent.isAltDown()) {
                    this.mPendingRequest = 6;
                    break;
                }
                this.mLassoRegion = new GenericPolygon();
                this.mLassoRegion.addPoint(this.mX1, this.mY1);
                this.mLassoRegion.addPoint(this.mX1, this.mY1);
                this.mPendingRequest = 5;
                break;
            }
            case 4: {
                this.storeState();
                this.deleteAt(this.mX1, this.mY1);
                break;
            }
            case 3: {
                int n = this.mMol.findAtom(this.mX1, this.mY1);
                if (n == -1) break;
                this.storeState();
                this.mMol.setAtomConfigurationUnknown(n, !this.mMol.isAtomConfigurationUnknown(n));
                this.updateAndFireEvent(1);
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                if (this.mCurrentHiliteBond == -1 || !this.qualifiesForESR(this.mCurrentHiliteBond)) break;
                this.storeState();
                this.setESRInfo(this.mCurrentHiliteBond, this.mCurrentTool == 101 ? 0 : (this.mCurrentTool == 103 ? 1 : 2));
                this.updateAndFireEvent(1);
                break;
            }
            case 5: 
            case 6: 
            case 23: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 == -1) {
                    int n = this.mMol.findBond(this.mX1, this.mY1);
                    if (n != -1) {
                        this.storeState();
                        int n3 = 511;
                        if (this.mCurrentTool == 6) {
                            n3 = 257;
                        } else if (this.mCurrentTool == 23) {
                            n3 = 129;
                        }
                        if (!this.mMol.changeBond(n, n3)) break;
                        this.updateAndFireEvent(1);
                        break;
                    }
                } else {
                    if (this.mMol.getAllConnAtomsPlusMetalBonds(this.mAtom1) == 8) {
                        return;
                    }
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mPendingRequest = 1;
                this.suggestNewX2AndY2(this.mAtom1);
                this.mCanvas.repaint();
                break;
            }
            case 22: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 != -1) {
                    if (this.mMol.getAllConnAtomsPlusMetalBonds(this.mAtom1) == 8) {
                        return;
                    }
                    this.mX1 = this.mMol.getAtomX(this.mAtom1);
                    this.mY1 = this.mMol.getAtomY(this.mAtom1);
                }
                this.mPendingRequest = 2;
                this.mChainAtoms = 0;
                break;
            }
            case 7: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 3, false, this.getScaledAVBL())) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 24: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 4, false, this.getScaledAVBL())) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 8: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 5, false, this.getScaledAVBL())) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 25: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 6, false, this.getScaledAVBL())) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 9: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 7, false, this.getScaledAVBL())) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 26: {
                this.storeState();
                if (!this.mMol.addRing(this.mX1, this.mY1, 6, true, this.getScaledAVBL())) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 10: {
                this.storeState();
                if (!this.mMol.changeAtomCharge(this.mX1, this.mY1, true)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 27: {
                this.storeState();
                if (!this.mMol.changeAtomCharge(this.mX1, this.mY1, false)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 16: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 1, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 11: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 6, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 12: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 7, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 13: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 8, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 28: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 14, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 29: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 15, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 30: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 16, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 14: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 9, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 31: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 17, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 15: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 35, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 32: {
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, 53, 0, -1, 0, null)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 33: {
                if (genericMouseEvent.isControlDown()) {
                    int n = this.mMol.findAtom(this.mX1, this.mY1);
                    if (n == -1) break;
                    this.showCustomAtomDialog(n);
                    break;
                }
                this.storeState();
                if (!this.mMol.addOrChangeAtom(this.mX1, this.mY1, this.mCustomAtomicNo, this.mCustomAtomMass, this.mCustomAtomValence, this.mCustomAtomRadical, this.mCustomAtomLabel)) break;
                this.updateAndFireEvent(3);
                break;
            }
            case 19: {
                this.mAtom1 = this.mMol.findAtom(this.mX1, this.mY1);
                if (this.mAtom1 == -1 || this.mAtom1 >= this.mMol.getAtoms()) break;
                this.mX1 = this.mMol.getAtomX(this.mAtom1);
                this.mY1 = this.mMol.getAtomY(this.mAtom1);
                this.mPendingRequest = 8;
                break;
            }
            case 21: {
                TextDrawingObject textDrawingObject = null;
                if (this.mCurrentHiliteObject == null) {
                    textDrawingObject = new TextDrawingObject();
                    textDrawingObject.setCoordinates(this.mX1, this.mY1);
                    this.mDrawingObjectList.add(textDrawingObject);
                } else if (this.mCurrentHiliteObject instanceof TextDrawingObject) {
                    textDrawingObject = (TextDrawingObject)this.mCurrentHiliteObject;
                }
                this.editTextObject(textDrawingObject);
                this.storeState();
                this.update(3);
            }
        }
    }

    private void mouseReleasedButton1() {
        int n = this.mPendingRequest;
        this.mPendingRequest = 0;
        switch (n) {
            case 1: {
                int n2 = this.mMol.findAtom(this.mX2, this.mY2);
                if (n2 != -1 && this.mMol.getAllConnAtomsPlusMetalBonds(n2) == 8) {
                    return;
                }
                this.storeState();
                if (this.mAtom1 == -1) {
                    this.mAtom1 = this.mMol.addAtom(this.mX1, this.mY1);
                }
                if (n2 == -1) {
                    n2 = this.mMol.addAtom(this.mX2, this.mY2);
                }
                if (this.mAtom1 != -1 && n2 != -1) {
                    int n3;
                    int n4 = n3 = this.mMol.isMetalAtom(this.mAtom1) || this.mMol.isMetalAtom(n2) ? 32 : 1;
                    if (this.mCurrentTool == 6) {
                        n3 = 257;
                    }
                    if (this.mCurrentTool == 23) {
                        n3 = 129;
                    }
                    this.mMol.addOrChangeBond(this.mAtom1, n2, n3);
                }
                this.updateAndFireEvent(3);
                break;
            }
            case 2: {
                this.storeState();
                if (this.mChainAtoms > 0) {
                    if (this.mAtom1 == -1) {
                        this.mAtom1 = this.mMol.addAtom(this.mX1, this.mY1);
                    }
                    if (this.mChainAtom[0] == -1) {
                        this.mChainAtom[0] = this.mMol.addAtom(this.mChainAtomX[0], this.mChainAtomY[0]);
                    }
                    if (this.mChainAtom[0] != -1) {
                        this.mMol.addBond(this.mAtom1, this.mChainAtom[0]);
                    }
                }
                if (this.mChainAtoms > 1) {
                    for (int i = 1; i < this.mChainAtoms; ++i) {
                        if (this.mChainAtom[i] == -1) {
                            this.mChainAtom[i] = this.mMol.addAtom(this.mChainAtomX[i], this.mChainAtomY[i]);
                        }
                        if (this.mChainAtom[i] == -1) continue;
                        this.mMol.addBond(this.mChainAtom[i - 1], this.mChainAtom[i]);
                    }
                }
                this.updateAndFireEvent(3);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.updateAndFireEvent(3);
                break;
            }
            case 10: {
                this.update(3);
                break;
            }
            case 5: 
            case 6: {
                boolean bl = false;
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    if (this.mIsSelectedAtom[i] == this.mMol.isSelectedAtom(i)) continue;
                    bl = true;
                    break;
                }
                this.mCanvas.repaint();
                if (!bl) break;
                this.fireEventLater(new EditorEvent(this, 2, true));
                break;
            }
            case 8: {
                boolean bl = false;
                int n5 = this.mCurrentHiliteAtom;
                int n6 = this.mMol.getAtomMapNo(this.mAtom1);
                if (n5 == -1) {
                    this.storeState();
                    if (n6 != 0) {
                        bl = true;
                        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                            if (this.mMol.getAtomMapNo(i) != n6) continue;
                            this.mMol.setAtomMapNo(i, 0, false);
                        }
                        this.autoMapReaction();
                    }
                } else {
                    this.storeState();
                    bl = true;
                    if (this.mAtom1 == n5) {
                        int n7 = this.mMol.getAtomMapNo(this.mAtom1);
                        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                            if (this.mMol.getAtomMapNo(i) != n7) continue;
                            this.mMol.setAtomMapNo(i, 0, false);
                        }
                    } else {
                        int n8;
                        int n9 = this.mMol.getAtomMapNo(n5);
                        for (n8 = 0; n8 < this.mMol.getAtoms(); ++n8) {
                            if (this.mMol.getAtomMapNo(n8) != n6 && this.mMol.getAtomMapNo(n8) != n9) continue;
                            this.mMol.setAtomMapNo(n8, 0, false);
                        }
                        n8 = 1;
                        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                            if (this.mMol.getAtomMapNo(i) != n8) continue;
                            ++n8;
                            i = -1;
                        }
                        this.mMol.setAtomMapNo(this.mAtom1, n8, false);
                        this.mMol.setAtomMapNo(n5, n8, false);
                    }
                    this.autoMapReaction();
                }
                if (bl) {
                    this.updateAndFireEvent(Math.max(this.mUpdateMode, 1));
                }
                this.mCanvas.repaint();
            }
        }
    }

    private void autoMapReaction() {
        int n;
        int n2;
        int n3;
        if (sMapper == null) {
            sMapper = new MCSReactionMapper();
        }
        SSSearcher sSSearcher = new SSSearcher(){

            @Override
            public boolean areAtomsSimilar(int n, int n2) {
                if (this.mMolecule.getAtomicNo(n) == this.mFragment.getAtomicNo(n2)) {
                    if (this.mMolecule.getAtomMass(n) != this.mFragment.getAtomMass(n2)) {
                        return false;
                    }
                    if (this.mMolecule.isAromaticAtom(n) || this.mFragment.isAromaticAtom(n2)) {
                        return true;
                    }
                }
                return super.areAtomsSimilar(n, n2);
            }

            @Override
            public boolean areBondsSimilar(int n, int n2) {
                if (this.mMolecule.isAromaticBond(n) || this.mMolecule.isDelocalizedBond(n) || this.mFragment.isAromaticBond(n2) || this.mFragment.isDelocalizedBond(n2)) {
                    return true;
                }
                return super.areBondsSimilar(n, n2);
            }
        };
        Reaction reaction = this.getReaction();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n4 = 1;
        int[] nArray = new int[this.mFragment.length];
        for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
            n2 = this.mFragmentNo[n3];
            this.mFragment[n2].setAtomMapNo(nArray[n2], 0, false);
            if (this.mMol.getAtomMapNo(n3) != 0 && !this.mMol.isAutoMappedAtom(n3)) {
                n = this.mMol.getAtomMapNo(n3);
                Integer n5 = (Integer)treeMap.get(-n);
                if (n5 == null) {
                    n5 = new Integer(n4++);
                    treeMap.put(-n, n5);
                }
                this.mFragment[n2].setAtomMass(nArray[n2], 512 + n5);
            }
            int n6 = n2;
            nArray[n6] = nArray[n6] + 1;
        }
        if ((reaction = sMapper.mapReaction(reaction, sSSearcher)) != null) {
            nArray = new int[this.mFragment.length];
            for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
                int n7;
                n2 = this.mFragmentNo[n3];
                int n8 = n = this.mFragment[n2].getAtomMass(nArray[n2]) > 512 ? 1 : 0;
                if (n != 0) {
                    n7 = this.mFragment[n2].getAtomMass(nArray[n2]) - 512;
                    this.mFragment[n2].setAtomMass(nArray[n2], this.mMol.getAtomMass(n3));
                    this.mMol.setAtomMapNo(n3, n7, false);
                    this.mFragment[n2].setAtomMapNo(nArray[n2], n7, false);
                } else {
                    n7 = this.mFragment[n2].getAtomMapNo(nArray[n2]);
                    Integer n9 = 0;
                    if (n7 != 0 && (n9 = (Integer)treeMap.get(n7)) == null) {
                        n9 = new Integer(n4++);
                        treeMap.put(n7, n9);
                    }
                    this.mMol.setAtomMapNo(n3, n9, true);
                    this.mFragment[n2].setAtomMapNo(nArray[n2], n9, true);
                }
                int n10 = n2;
                nArray[n10] = nArray[n10] + 1;
            }
        } else {
            nArray = new int[this.mFragment.length];
            for (n3 = 0; n3 < this.mMol.getAllAtoms(); ++n3) {
                n2 = this.mFragmentNo[n3];
                this.mFragment[n2].setAtomMass(nArray[n2], this.mMol.getAtomMass(n3));
                this.mFragment[n2].setAtomMapNo(nArray[n2], this.mMol.getAtomMapNo(n3), this.mMol.isAutoMappedAtom(n3));
                int n11 = n2;
                nArray[n11] = nArray[n11] + 1;
            }
        }
    }

    private boolean qualifiesForESR(int n) {
        return this.mMol.isStereoBond(n) && (this.getESRAtom(n) != -1 || this.getESRBond(n) != -1);
    }

    private int getESRAtom(int n) {
        int n2 = this.mMol.getBondAtom(0, n);
        if (this.mMol.getAtomParity(n2) != 0) {
            return this.mMol.isAtomParityPseudo(n2) || this.mMol.getAtomParity(n2) != 1 && this.mMol.getAtomParity(n2) != 2 ? -1 : n2;
        }
        if (this.mMol.getAtomPi(n2) == 1) {
            for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
                int n3;
                if (this.mMol.getConnBondOrder(n2, i) != 2 || this.mMol.getAtomPi(n3 = this.mMol.getConnAtom(n2, i)) != 2 || this.mMol.getAtomParity(n3) != 1 && this.mMol.getAtomParity(n3) != 2) continue;
                return n3;
            }
        }
        return -1;
    }

    private int getESRBond(int n) {
        int n2 = this.mMol.findBINAPChiralityBond(this.mMol.getBondAtom(0, n));
        if (n2 != -1 && this.mMol.getBondParity(n2) != 1 && this.mMol.getBondParity(n2) != 2) {
            n2 = -1;
        }
        return n2;
    }

    private void setESRInfo(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = -1;
        int n8 = this.getESRAtom(n);
        int n9 = n6 = n8 == -1 ? this.getESRBond(n) : -1;
        if (n2 != 0) {
            n5 = -1;
            for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
                if (n4 == n8 || this.mMol.getAtomESRType(n4) != n2 || this.mMol.isSelectedBond(n) && this.mMol.isSelectedAtom(n4) || n5 >= (n3 = this.mMol.getAtomESRGroup(n4))) continue;
                n5 = n3;
            }
            for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
                if (n4 == n6 || this.mMol.getBondESRType(n4) != n2 || this.mMol.isSelectedBond(n) && this.mMol.isSelectedBond(n4) || n5 >= (n3 = this.mMol.getBondESRGroup(n4))) continue;
                n5 = n3;
            }
            if ((n8 == -1 ? this.mMol.getBondESRType(n6) : this.mMol.getAtomESRType(n8)) != n2) {
                n7 = Math.min(n5 + 1, 31);
            } else {
                int n10 = n7 = n8 == -1 ? this.mMol.getBondESRGroup(n6) : this.mMol.getAtomESRGroup(n8);
                if (this.mMol.isSelectedBond(n)) {
                    n4 = 1;
                    for (n3 = 0; n3 < this.mMol.getAtoms(); ++n3) {
                        if (n3 == n8 || !this.mMol.isSelectedAtom(n3) || this.mMol.getAtomESRType(n3) != n2 || this.mMol.getAtomESRGroup(n3) == n7) continue;
                        n4 = 0;
                        break;
                    }
                    for (n3 = 0; n3 < this.mMol.getBonds(); ++n3) {
                        if (n3 == n6 || !this.mMol.isSelectedBond(n3) || this.mMol.getBondESRType(n3) != n2 || this.mMol.getBondESRGroup(n3) == n7) continue;
                        n4 = 0;
                        break;
                    }
                    if (n4 != 0) {
                        if (n7 <= n5) {
                            if (++n7 == 32) {
                                n7 = 0;
                            }
                        } else {
                            n7 = 0;
                        }
                    }
                } else if (n7 <= n5) {
                    if (++n7 == 32) {
                        n7 = 0;
                    }
                } else {
                    n7 = 0;
                }
            }
        }
        if (this.mMol.isSelectedBond(n)) {
            for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
                if (!this.mMol.isSelectedBond(n5) || !this.mMol.isStereoBond(n5)) continue;
                n4 = this.getESRAtom(n5);
                n3 = this.getESRBond(n5);
                if (n4 != -1) {
                    this.mMol.setAtomESR(n4, n2, n7);
                    continue;
                }
                if (n3 == -1) continue;
                this.mMol.setBondESR(n3, n2, n7);
            }
        } else if (n8 != -1) {
            this.mMol.setAtomESR(n8, n2, n7);
        } else if (n6 != -1) {
            this.mMol.setBondESR(n6, n2, n7);
        }
    }

    private int findFragment(double d, double d2) {
        int n = -1;
        double d3 = Double.MAX_VALUE;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            double d4;
            double d5 = this.mX1 - this.mMol.getAtomX(i);
            double d6 = Math.sqrt(d5 * d5 + (d4 = this.mY1 - this.mMol.getAtomY(i)) * d4);
            if (!(d6 < 24.0) || !(d3 > d6)) continue;
            d3 = d6;
            n = this.mFragmentNo[i];
        }
        return n;
    }

    private void suggestNewX2AndY2(int n) {
        double d = 2.0943951023931953;
        if (n != -1) {
            int n2;
            double[] dArray = new double[9];
            for (n2 = 0; n2 < this.mMol.getAllConnAtomsPlusMetalBonds(n); ++n2) {
                dArray[n2] = this.mMol.getBondAngle(n, this.mMol.getConnAtom(n, n2));
            }
            if (this.mMol.getAllConnAtomsPlusMetalBonds(n) == 1) {
                d = dArray[0] < -2.6179938779914944 ? 1.0471975511965976 : (dArray[0] < -1.5707963267948966 ? 2.0943951023931953 : (dArray[0] < -0.5235987755982988 ? 1.0471975511965976 : (dArray[0] < 0.0 ? 2.0943951023931953 : (dArray[0] < 0.5235987755982988 ? -2.0943951023931953 : (dArray[0] < 1.5707963267948966 ? -1.0471975511965976 : (dArray[0] < 2.6179938779914944 ? -2.0943951023931953 : -1.0471975511965976))))));
            } else {
                for (n2 = this.mMol.getAllConnAtomsPlusMetalBonds(n) - 1; n2 > 0; --n2) {
                    for (int i = 0; i < n2; ++i) {
                        if (!(dArray[i] > dArray[i + 1])) continue;
                        double d2 = dArray[i];
                        dArray[i] = dArray[i + 1];
                        dArray[i + 1] = d2;
                    }
                }
                dArray[this.mMol.getAllConnAtomsPlusMetalBonds((int)n)] = dArray[0] + Math.PI * 2;
                n2 = 0;
                double d3 = 0.0;
                for (int i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(n); ++i) {
                    double d4 = dArray[i + 1] - dArray[i];
                    if (!(d3 < d4)) continue;
                    d3 = d4;
                    n2 = i;
                }
                d = (dArray[n2] + dArray[n2 + 1]) / 2.0;
            }
        }
        double d5 = this.getScaledAVBL();
        this.mX2 = (n == -1 ? this.mX1 : this.mMol.getAtomX(n)) + d5 * (double)((float)Math.sin(d));
        this.mY2 = (n == -1 ? this.mY1 : this.mMol.getAtomY(n)) + d5 * (double)((float)Math.cos(d));
    }

    private boolean areAtomsMappingCompatible(int n, int n2) {
        if (this.mMol.isFragment()) {
            int n3;
            int n4;
            int[] nArray;
            if ((this.mMol.getAtomQueryFeatures(n) & 0x20000000L) != 0L || (this.mMol.getAtomQueryFeatures(n) & 0x20000000L) != 0L) {
                return false;
            }
            int[] nArray2 = this.mMol.getAtomList(n);
            if (nArray2 == null ^ (nArray = this.mMol.getAtomList(n2)) == null) {
                return false;
            }
            if (nArray2 != null) {
                if (nArray2.length != nArray.length) {
                    return false;
                }
                for (n4 = 0; n4 < nArray2.length; ++n4) {
                    if (nArray2[n4] == nArray[n4]) continue;
                    return false;
                }
            }
            n4 = (this.mMol.getAtomQueryFeatures(n) & 1L) != 0L ? 1 : 0;
            int n5 = n3 = (this.mMol.getAtomQueryFeatures(n2) & 1L) != 0L ? 1 : 0;
            if (n4 != n3) {
                return false;
            }
        }
        return this.mMol.getAtomicNo(n) == this.mMol.getAtomicNo(n2);
    }

    private boolean trackHiliting(double d, double d2, boolean bl) {
        boolean bl2;
        int n = this.mMol.findAtom(d, d2);
        int n2 = -1;
        if (bl && this.mPendingRequest == 8 && n != -1 && (!this.areAtomsMappingCompatible(this.mAtom1, n) || this.mMol.getAtomMapNo(this.mAtom1) != 0 && this.mMol.getAtomMapNo(this.mAtom1) == this.mMol.getAtomMapNo(n) && !this.mMol.isAutoMappedAtom(this.mAtom1) || this.shareSameReactionSide(this.mAtom1, n))) {
            n = -1;
        }
        if (n != -1) {
            if (this.mCurrentTool == 101 || this.mCurrentTool == 103 || this.mCurrentTool == 102) {
                n2 = this.mMol.getStereoBond(n);
                n = -1;
            } else if (this.mCurrentTool == 19 && n >= this.mMol.getAtoms()) {
                n = -1;
            }
        }
        if (n2 == -1 && n == -1 && this.mCurrentTool != 22 && this.mCurrentTool != 19 && this.mCurrentTool != 3 && this.mCurrentTool != 10 && this.mCurrentTool != 27 && this.mCurrentTool != 16 && this.mCurrentTool != 11 && this.mCurrentTool != 12 && this.mCurrentTool != 13 && this.mCurrentTool != 28 && this.mCurrentTool != 29 && this.mCurrentTool != 30 && this.mCurrentTool != 14 && this.mCurrentTool != 31 && this.mCurrentTool != 15 && this.mCurrentTool != 32 && this.mCurrentTool != 33) {
            n2 = this.mMol.findBond(d, d2);
        }
        if (!(n2 == -1 || this.mCurrentTool != 101 && this.mCurrentTool != 103 && this.mCurrentTool != 102 || this.qualifiesForESR(n2))) {
            n2 = -1;
        }
        AbstractDrawingObject abstractDrawingObject = this.mCurrentHiliteObject;
        if (!bl && this.mDrawingObjectList != null) {
            abstractDrawingObject = null;
            if (n == -1 && n2 == -1 && (this.mCurrentTool == 2 || this.mCurrentTool == 4 || this.mCurrentTool == 21)) {
                for (AbstractDrawingObject abstractDrawingObject2 : this.mDrawingObjectList) {
                    if (this.mCurrentTool != 2 && (this.mCurrentTool != 4 || abstractDrawingObject2 instanceof ReactionArrow) && (this.mCurrentTool != 21 || !(abstractDrawingObject2 instanceof TextDrawingObject)) || !abstractDrawingObject2.checkHiliting(d, d2)) continue;
                    abstractDrawingObject = abstractDrawingObject2;
                    if (this.mCurrentHiliteObject == null || this.mCurrentHiliteObject == abstractDrawingObject2) break;
                    this.mCurrentHiliteObject.clearHiliting();
                    break;
                }
            }
        }
        boolean bl3 = bl2 = this.mCurrentHiliteAtom != n || this.mCurrentHiliteBond != n2 || this.mCurrentHiliteObject != abstractDrawingObject || abstractDrawingObject != null;
        if (this.mCurrentHiliteAtom != n) {
            if (this.mCurrentHiliteAtom != -1 && this.mAtomKeyStrokeBuffer.length() != 0) {
                this.expandAtomKeyStrokes(this.mAtomKeyStrokeBuffer.toString());
            }
            this.mCurrentHiliteAtom = n;
            this.mAtomKeyStrokeBuffer.setLength(0);
            this.fireEventLater(new EditorEvent(this, 4, true));
        }
        if (this.mCurrentHiliteBond != n2) {
            this.mCurrentHiliteBond = n2;
            this.fireEventLater(new EditorEvent(this, 8, true));
        }
        this.mCurrentHiliteObject = abstractDrawingObject;
        return bl2;
    }

    private int getAtomKeyStrokeValidity(String string) {
        if (Molecule.getAtomicNoFromLabel(string, this.mAllowedPseudoAtoms) != 0) {
            return 1;
        }
        this.mAtomKeyStrokeSuggestion = NamedSubstituents.identify(string);
        if (this.mAtomKeyStrokeSuggestion == null) {
            return this.isValidAtomKeyStrokeStart(string) ? 3 : 4;
        }
        if (this.mAtomKeyStrokeSuggestion.length() == 0) {
            return 3;
        }
        return 2;
    }

    private boolean isValidAtomKeyStrokeStart(String string) {
        if (string.length() < 3) {
            for (int i = 1; i < Molecule.cAtomLabel.length; ++i) {
                if (!Molecule.cAtomLabel[i].startsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void expandAtomKeyStrokes(String string) {
        StereoMolecule stereoMolecule;
        this.mAtomKeyStrokeBuffer.setLength(0);
        int n = Molecule.getAtomicNoFromLabel(string, this.mAllowedPseudoAtoms);
        if (n != 0) {
            this.storeState();
            if (this.mMol.changeAtom(this.mCurrentHiliteAtom, n, 0, -1, 0)) {
                this.updateAndFireEvent(3);
                return;
            }
        }
        if (this.mAtomKeyStrokeSuggestion != null && this.mAtomKeyStrokeSuggestion.length() != 0) {
            string = this.mAtomKeyStrokeSuggestion;
        }
        if ((stereoMolecule = NamedSubstituents.getSubstituent(string)) != null) {
            this.storeState();
            StereoMolecule stereoMolecule2 = new StereoMolecule();
            stereoMolecule2.addFragment(this.mMol, this.mCurrentHiliteAtom, null);
            double d = stereoMolecule2.getAverageBondLength(this.mUIScaling * 24.0);
            int n2 = stereoMolecule2.getAllAtoms();
            for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
                stereoMolecule2.setAtomMarker(i, true);
            }
            stereoMolecule2.addSubstituent(stereoMolecule, 0);
            new CoordinateInventor(4).invent(stereoMolecule2);
            double d2 = this.mMol.getAtomX(this.mCurrentHiliteAtom) - d * stereoMolecule2.getAtomX(0);
            double d3 = this.mMol.getAtomY(this.mCurrentHiliteAtom) - d * stereoMolecule2.getAtomY(0);
            int n3 = this.mMol.getAllAtoms();
            this.mMol.addSubstituent(stereoMolecule, this.mCurrentHiliteAtom);
            int n4 = this.mMol.getAllAtoms() - n3;
            for (int i = 0; i < n4; ++i) {
                this.mMol.setAtomX(n3 + i, d * stereoMolecule2.getAtomX(n2 + i) + d2);
                this.mMol.setAtomY(n3 + i, d * stereoMolecule2.getAtomY(n2 + i) + d3);
            }
            this.mMol.setStereoBondsFromParity();
            this.updateAndFireEvent(3);
        }
    }

    public int getAllowedPseudoAtoms() {
        return this.mAllowedPseudoAtoms;
    }

    public void setAllowedPseudoAtoms(int n) {
        this.mAllowedPseudoAtoms = n;
    }

    private AbstractDrawingObject findDrawingObject(double d, double d2, String string, boolean bl) {
        if (this.mDrawingObjectList != null) {
            for (AbstractDrawingObject abstractDrawingObject : this.mDrawingObjectList) {
                if (string != null && (!string.equals(abstractDrawingObject.getTypeString()) || bl) && !abstractDrawingObject.isDeletable() || !abstractDrawingObject.contains(d, d2)) continue;
                return abstractDrawingObject;
            }
        }
        return null;
    }

    private void editTextObject(TextDrawingObject textDrawingObject) {
        new TextDrawingObjectDialogBuilder(this.mUIHelper, textDrawingObject);
        boolean bl = false;
        for (int i = 0; i < textDrawingObject.getText().length(); ++i) {
            if (Character.isWhitespace(textDrawingObject.getText().charAt(i))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.mDrawingObjectList.remove(textDrawingObject);
        }
        this.mCanvas.repaint();
    }

    private boolean shareSameReactionSide(int n, int n2) {
        ReactionArrow reactionArrow = (ReactionArrow)this.mDrawingObjectList.get(0);
        return !(reactionArrow.isOnProductSide(this.mMol.getAtomX(n), this.mMol.getAtomY(n)) ^ reactionArrow.isOnProductSide(this.mMol.getAtomX(n2), this.mMol.getAtomY(n2)));
    }

    protected void restoreState() {
        if (this.mUndoMol == null) {
            return;
        }
        this.mUndoMol.copyMolecule(this.mMol);
        this.mDrawingObjectList = this.mUndoDrawingObjectList == null ? null : new DrawingObjectList(this.mUndoDrawingObjectList);
    }

    public void storeState() {
        if (this.mUndoMol == null) {
            this.mUndoMol = new Molecule();
        }
        this.mMol.copyMolecule(this.mUndoMol);
        this.mUndoDrawingObjectList = this.mDrawingObjectList == null ? null : new DrawingObjectList(this.mDrawingObjectList);
    }

    private boolean deleteHilited() {
        if (this.mCurrentHiliteAtom != -1) {
            this.mMol.deleteAtom(this.mCurrentHiliteAtom);
            this.mCurrentHiliteAtom = -1;
            this.updateAndFireEvent(1);
            return true;
        }
        if (this.mCurrentHiliteBond != -1) {
            this.mMol.deleteBondAndSurrounding(this.mCurrentHiliteBond);
            this.mCurrentHiliteBond = -1;
            this.updateAndFireEvent(1);
            return true;
        }
        if (this.mCurrentHiliteObject != null && this.mCurrentHiliteObject.isDeletable()) {
            this.mDrawingObjectList.remove(this.mCurrentHiliteObject);
            this.mCurrentHiliteObject = null;
            this.update(1);
            return true;
        }
        return false;
    }

    private boolean deleteAt(double d, double d2) {
        if (this.mMol.deleteAtomOrBond(d, d2)) {
            this.updateAndFireEvent(1);
            return true;
        }
        AbstractDrawingObject abstractDrawingObject = this.findDrawingObject(d, d2, null, true);
        if (abstractDrawingObject != null) {
            this.mDrawingObjectList.remove(abstractDrawingObject);
            this.mCurrentHiliteObject = null;
            this.update(1);
            return true;
        }
        return false;
    }

    private void duplicateSelected() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            if (!this.mMol.isSelectedAtom(n2)) continue;
            ++n3;
        }
        n2 = this.mMol.getAllAtoms();
        int n4 = this.mMol.getAllBonds();
        this.mX = Arrays.copyOf(this.mX, this.mX.length + n3);
        this.mY = Arrays.copyOf(this.mY, this.mY.length + n3);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n5 = this.mMol.renumberESRGroups(1);
        int n6 = this.mMol.renumberESRGroups(2);
        for (n = 0; n < n2; ++n) {
            if (!this.mMol.isSelectedAtom(n)) continue;
            int n7 = this.mMol.getAllAtoms();
            this.mX[n7] = this.mX[n];
            this.mY[n7] = this.mY[n];
            nArray[n] = n7;
            this.mMol.copyAtom(this.mMol, n, n5, n6);
        }
        for (n = 0; n < n4; ++n) {
            if (!this.mMol.isSelectedBond(n)) continue;
            this.mMol.copyBond(this.mMol, n, n5, n6, nArray, false);
        }
        for (n = 0; n < n2; ++n) {
            this.mMol.setAtomSelection(n, false);
        }
        for (n = n2; n < this.mMol.getAllAtoms(); ++n) {
            this.mMol.setAtomMapNo(n, 0, false);
        }
        if (this.mDrawingObjectList != null) {
            for (n = this.mDrawingObjectList.size() - 1; n >= 0; --n) {
                AbstractDrawingObject abstractDrawingObject = (AbstractDrawingObject)this.mDrawingObjectList.get(n);
                if (!abstractDrawingObject.isSelected() || abstractDrawingObject instanceof ReactionArrow) continue;
                this.mDrawingObjectList.add(abstractDrawingObject.clone());
            }
        }
    }

    private void fireEventLater(EditorEvent editorEvent) {
        int n = editorEvent.getWhat();
        if ((n & this.mEventsScheduled) == 0) {
            this.mUIHelper.runLater(() -> {
                this.mEventsScheduled &= ~n;
                for (GenericEventListener genericEventListener : this.mListeners) {
                    genericEventListener.eventHappened(editorEvent);
                }
            });
            this.mEventsScheduled |= n;
        }
    }

    public void moleculeChanged() {
        this.update(4);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    private void updateAndFireEvent(int n) {
        this.update(n);
        this.fireEventLater(new EditorEvent(this, 1, true));
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public void setMolecule(StereoMolecule stereoMolecule) {
        if (this.mMol == stereoMolecule) {
            return;
        }
        this.storeState();
        this.mMol = stereoMolecule;
        this.mMode = 0;
        this.mDrawingObjectList = null;
        this.moleculeChanged();
    }

    public StereoMolecule[] getFragments() {
        return this.mFragment;
    }

    public void setFragments(StereoMolecule[] stereoMoleculeArray) {
        int n;
        this.mMol.clear();
        this.mFragment = stereoMoleculeArray;
        for (n = 0; n < stereoMoleculeArray.length; ++n) {
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.mMode = 1;
        this.mDrawingObjectList = null;
        this.update(5);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    public Reaction getReaction() {
        if ((this.mMode & 4) == 0 || this.mFragment == null) {
            return null;
        }
        Reaction reaction = new Reaction();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                reaction.addReactant(this.mFragment[i]);
                continue;
            }
            reaction.addProduct(this.mFragment[i]);
        }
        return reaction;
    }

    public Reaction getReactionAndDrawings() {
        Reaction reaction = this.getReaction();
        if (reaction != null) {
            reaction.setDrawingObjects(this.getDrawingObjects());
        }
        return reaction;
    }

    public void setReaction(Reaction reaction) {
        int n;
        this.mMol.clear();
        this.mFragment = new StereoMolecule[reaction.getMolecules()];
        this.mReactantCount = reaction.getReactants();
        for (n = 0; n < reaction.getMolecules(); ++n) {
            this.mFragment[n] = reaction.getMolecule(n);
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.mMol.setFragment(reaction.isFragment());
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.mDrawingObjectList = new DrawingObjectList();
        this.mMode = 5;
        this.update(5);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    public MarkushStructure getMarkushStructure() {
        if ((this.mMode & 2) == 0) {
            return null;
        }
        MarkushStructure markushStructure = new MarkushStructure();
        for (int i = 0; i < this.mFragment.length; ++i) {
            if (i < this.mReactantCount) {
                markushStructure.addCore(this.mFragment[i]);
                continue;
            }
            markushStructure.addRGroup(this.mFragment[i]);
        }
        return markushStructure;
    }

    public void setMarkushStructure(MarkushStructure markushStructure) {
        int n;
        this.mMol.clear();
        this.mDrawingObjectList = null;
        this.mFragment = new StereoMolecule[markushStructure.getCoreCount() + markushStructure.getRGroupCount()];
        this.mReactantCount = markushStructure.getCoreCount();
        boolean bl = false;
        for (n = 0; n < markushStructure.getCoreCount() + markushStructure.getRGroupCount(); ++n) {
            this.mFragment[n] = n < markushStructure.getCoreCount() ? markushStructure.getCoreStructure(n) : markushStructure.getRGroup(n - markushStructure.getCoreCount());
            bl |= this.mFragment[n].isFragment();
            this.mMol.addMolecule(this.mFragment[n]);
        }
        this.mMol.setFragment(bl);
        this.storeState();
        this.mFragmentNo = new int[this.mMol.getAllAtoms()];
        n = 0;
        for (int i = 0; i < this.mFragment.length; ++i) {
            for (int j = 0; j < this.mFragment[i].getAllAtoms(); ++j) {
                this.mFragmentNo[n++] = i;
            }
        }
        this.mMode = 3;
        this.update(5);
        this.fireEventLater(new EditorEvent(this, 1, false));
    }

    public int getDisplayMode() {
        return this.mDisplayMode;
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
        this.update(1);
    }

    public void setTextSizeFactor(double d) {
        this.mTextSizeFactor = d;
        this.update(1);
    }

    public void setAllowQueryFeatures(boolean bl) {
        if (this.mAllowQueryFeatures != bl) {
            this.mAllowQueryFeatures = bl;
            if (!bl) {
                this.mMol.removeQueryFeatures();
            }
        }
    }

    public void setAllowFragmentChangeOnPasteOrDrop(boolean bl) {
        this.mAllowFragmentChangeOnPasteOrDrop = bl;
    }

    public void setAtomText(String[] stringArray) {
        this.mAtomText = stringArray;
    }

    public DrawingObjectList getDrawingObjects() {
        return this.mDrawingObjectList;
    }

    public void setDrawingObjects(DrawingObjectList drawingObjectList) {
        this.mDrawingObjectList = drawingObjectList;
        this.storeState();
        this.update(4);
    }

    public int getMode() {
        return this.mMode;
    }

    public int getHiliteAtom() {
        return this.mCurrentHiliteAtom;
    }

    public int getHiliteBond() {
        return this.mCurrentHiliteBond;
    }

    public void setHiliteBondSet(int[] nArray) {
        this.mHiliteBondSet = nArray;
        this.update(1);
    }

    public void setReactionMode(boolean bl) {
        if (bl) {
            StereoMolecule[] stereoMoleculeArray = this.getFragments();
            if (stereoMoleculeArray == null) {
                this.setReaction(new Reaction(new StereoMolecule[]{new StereoMolecule(this.getMolecule())}, 1));
            } else {
                this.mMode = 5;
                Reaction reaction = this.getReaction();
                this.setReaction(reaction);
            }
        } else {
            this.mMode &= 0xFFFFFFFB;
        }
    }

    protected void setUpdateMode(int n) {
        this.mUpdateMode = n;
    }

    public boolean isAtomColorSupported() {
        return this.mAtomColorSupported;
    }

    public void setAtomColorSupported(boolean bl) {
        this.mAtomColorSupported = bl;
    }

    private void cleanupCoordinates(GenericDrawContext genericDrawContext) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.mMol.getAllAtoms(); n += 1) {
            if (!this.mMol.isSelectedAtom(n)) continue;
            ++n2;
        }
        int n3 = n = n2 != 0 && n2 != this.mMol.getAllAtoms() ? 1 : 0;
        if ((this.mMode & 1) != 0) {
            this.cleanupMultiFragmentCoordinates(genericDrawContext, n != 0);
        } else {
            this.cleanupMoleculeCoordinates(genericDrawContext, n != 0);
        }
    }

    private void cleanupMoleculeCoordinates(GenericDrawContext genericDrawContext, boolean bl) {
        if (this.mUpdateMode == 6) {
            if (bl) {
                for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                    this.mMol.setAtomMarker(i, !this.mMol.isSelectedAtom(i));
                }
            }
            new CoordinateInventor(bl ? 4 : 0).invent(this.mMol);
            if (bl) {
                this.mMol.removeAtomMarkers();
            }
        }
        this.mDepictor.updateCoords(genericDrawContext, new GenericRectangle(0.0, 0.0, this.mCanvas.getCanvasWidth(), this.mCanvas.getCanvasHeight()), 0x10000 | this.mMaxAVBL);
    }

    private void cleanupMultiFragmentCoordinates(GenericDrawContext genericDrawContext, boolean bl) {
        int n;
        Object[] objectArray;
        if (bl && this.mUpdateMode == 6) {
            objectArray = new int[this.mFragment.length];
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                int n2 = this.mFragmentNo[n];
                this.mFragment[n2].setAtomMarker((int)objectArray[n2], !this.mMol.isSelectedAtom(n));
                int n3 = n2;
                objectArray[n3] = objectArray[n3] + true;
            }
        }
        objectArray = new GenericRectangle[this.mFragment.length];
        for (n = 0; n < this.mFragment.length; ++n) {
            if (this.mUpdateMode == 6) {
                new CoordinateInventor(bl ? 4 : 0).invent(this.mFragment[n]);
                this.mFragment[n].setStereoBondsFromParity();
            }
            GenericDepictor genericDepictor = new GenericDepictor(this.mFragment[n]);
            genericDepictor.updateCoords(genericDrawContext, null, 0x10000 | this.mMaxAVBL);
            objectArray[n] = genericDepictor.getBoundingRect();
        }
        double d = 1.5f * (float)this.mMaxAVBL;
        double d2 = this.getScaledAVBL();
        double d3 = (this.mMode & 4) == 0 ? 0.0 : (this.mUpdateMode == 5 ? (double)0.08f * this.mCanvas.getCanvasWidth() : (double)(((ReactionArrow)this.mDrawingObjectList.get(0)).getLength() * (float)this.mMaxAVBL) / d2);
        double d4 = 0.5 * d;
        for (int i = 0; i <= this.mFragment.length; ++i) {
            if ((this.mMode & 4) != 0 && i == this.mReactantCount) {
                ((ReactionArrow)this.mDrawingObjectList.get(0)).setCoordinates(d4 - d / 2.0, this.mCanvas.getCanvasHeight() / 2.0, d4 - d / 2.0 + d3, this.mCanvas.getCanvasHeight() / 2.0);
                d4 += d3;
            }
            if (i == this.mFragment.length) break;
            double d5 = d4 - objectArray[i].x;
            double d6 = 0.5 * (this.mCanvas.getCanvasHeight() - objectArray[i].height) - objectArray[i].y;
            this.mFragment[i].translateCoords(d5, d6);
            d4 += d + objectArray[i].width;
        }
        this.mDepictor.updateCoords(genericDrawContext, new GenericRectangle(0.0, 0.0, this.mCanvas.getCanvasWidth(), this.mCanvas.getCanvasHeight()), 0x10000 | this.mMaxAVBL);
        int[] nArray = new int[this.mFragment.length];
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            int n4 = this.mFragmentNo[i];
            this.mMol.setAtomX(i, this.mFragment[n4].getAtomX(nArray[n4]));
            this.mMol.setAtomY(i, this.mFragment[n4].getAtomY(nArray[n4]));
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        this.mMol.setStereoBondsFromParity();
    }

    private void analyzeFragmentMembership() {
        this.mMol.ensureHelperArrays(15);
        int[] nArray = new int[this.mMol.getAllAtoms()];
        int n = this.mMol.getFragmentNumbers(nArray, false, true);
        n = this.joinCloseFragments(nArray, n);
        this.sortFragmentsByPosition(nArray, n);
        this.mFragmentNo = nArray;
        this.mFragment = this.mMol.getFragments(nArray, n);
    }

    private int joinCloseFragments(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        if (n < 2) {
            return n;
        }
        boolean[][] blArrayArray = new boolean[n][];
        for (int i = 1; i < n; ++i) {
            blArrayArray[i] = new boolean[i];
        }
        double d = this.getScaledAVBL();
        for (int i = 1; i < this.mMol.getAllAtoms(); ++i) {
            for (n4 = 0; n4 < i; ++n4) {
                int n5;
                double d2;
                double d3 = this.mMol.getAtomX(n4) - this.mMol.getAtomX(i);
                double d4 = Math.sqrt(d3 * d3 + (d2 = this.mMol.getAtomY(n4) - this.mMol.getAtomY(i)) * d2);
                if (!(d4 < (double)1.4f * d) || (n3 = nArray[i]) == (n5 = nArray[n4])) continue;
                if (n3 > n5) {
                    blArrayArray[n3][n5] = true;
                    continue;
                }
                blArrayArray[n5][n3] = true;
            }
        }
        int[] nArray2 = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray2[n4] = n4;
        }
        n4 = 0;
        for (n2 = 1; n2 < n; ++n2) {
            for (int i = 0; i < n2; ++i) {
                int n6;
                int n7;
                if (!blArrayArray[n2][i] || (n7 = nArray2[n2]) == (n6 = nArray2[i])) continue;
                ++n4;
                int n8 = Math.min(n7, n6);
                int n9 = Math.max(n7, n6);
                for (n3 = 0; n3 < n; ++n3) {
                    if (nArray2[n3] == n9) {
                        nArray2[n3] = n8;
                        continue;
                    }
                    if (nArray2[n3] <= n9) continue;
                    int n10 = n3;
                    nArray2[n10] = nArray2[n10] - 1;
                }
            }
        }
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            nArray[n2] = nArray2[nArray[n2]];
        }
        return n - n4;
    }

    private void sortFragmentsByPosition(int[] nArray, int n) {
        int n2;
        Point[] pointArray;
        int[][] nArray2 = new int[n][(this.mMode & 6) != 0 ? 2 : 1];
        for (int i = 0; i < n; ++i) {
            nArray2[i][0] = i;
        }
        Point[] pointArray2 = this.calculateFragmentCenterOfGravity(nArray, n);
        if ((this.mMode & 4) != 0) {
            this.mReactantCount = 0;
            pointArray = (this.mMode & 4) != 0 ? (ReactionArrow)this.mDrawingObjectList.get(0) : null;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray2[i][1] = pointArray.isOnProductSide(pointArray2[i].x, pointArray2[i].y) ? 1 : 0;
                if (nArray2[i][1] != 0) continue;
                ++this.mReactantCount;
            }
        } else if ((this.mMode & 2) != 0) {
            this.mReactantCount = n;
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (this.mMol.getAtomicNo(i) != 0 || nArray2[nArray[i]][1] != 0) continue;
                nArray2[nArray[i]][1] = 1;
                --this.mReactantCount;
            }
        }
        pointArray = pointArray2;
        Arrays.sort(nArray2, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                if ((GenericEditorArea.this.mMode & 6) != 0 && nArray[1] != nArray2[1]) {
                    return nArray[1] == 0 ? -1 : 1;
                }
                return pointArray[nArray[0]].x + pointArray[nArray[0]].y < pointArray[nArray2[0]].x + pointArray[nArray2[0]].y ? -1 : 1;
            }
        });
        int[] nArray3 = new int[n];
        Point[] pointArray3 = new Point[n];
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = nArray2[n2][0];
            nArray3[n4] = n2;
            pointArray3[n2] = pointArray2[n4];
        }
        pointArray2 = pointArray3;
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            nArray[n2] = nArray3[nArray[n2]];
        }
    }

    private Point[] calculateFragmentCenterOfGravity(int[] nArray, int n) {
        int n2;
        Point[] pointArray = new Point[n];
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            pointArray[n2] = new Point(0, 0);
        }
        for (n2 = 0; n2 < this.mMol.getAllAtoms(); ++n2) {
            pointArray[nArray[n2]].x = (int)((double)pointArray[nArray[n2]].x + this.mMol.getAtomX(n2));
            pointArray[nArray[n2]].y = (int)((double)pointArray[nArray[n2]].y + this.mMol.getAtomY(n2));
            int n3 = nArray[n2];
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            pointArray[n2].x /= nArray2[n2];
            pointArray[n2].y /= nArray2[n2];
        }
        return pointArray;
    }

    private void updateCursor() {
        int n = -1;
        switch (this.mCurrentTool) {
            case 18: {
                n = 9;
                break;
            }
            case 2: {
                if (this.mCurrentHiliteAtom != -1 && this.mMol.isSelectedAtom(this.mCurrentHiliteAtom) || this.mCurrentHiliteBond != -1 && this.mMol.isSelectedBond(this.mCurrentHiliteBond)) {
                    n = this.mMouseIsDown ? 4 : (this.mShiftIsDown ? 3 : 2);
                    break;
                }
                if (this.mCurrentHiliteAtom != -1 || this.mCurrentHiliteBond != -1) {
                    n = 11;
                    break;
                }
                if (this.mCurrentHiliteObject != null) {
                    n = this.mMouseIsDown ? 4 : (this.mShiftIsDown && !(this.mCurrentHiliteObject instanceof ReactionArrow) ? 3 : 2);
                    break;
                }
                n = this.mShiftIsDown ? (this.mAltIsDown ? 8 : 6) : (this.mAltIsDown ? 7 : 5);
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            case 22: {
                n = 0;
                break;
            }
            case 21: {
                n = 12;
                break;
            }
            default: {
                n = 11;
            }
        }
        if (this.mCurrentCursor != n) {
            this.mCurrentCursor = n;
            this.mUIHelper.setCursor(n);
        }
    }

    private Point2D calculateCenterOfGravity(boolean bl) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (bl && !this.mMol.isSelectedAtom(i)) continue;
            d += this.mMol.getAtomX(i);
            d2 += this.mMol.getAtomY(i);
            ++n;
        }
        return n > 1 ? new Point2D.Double(d / (double)n, d2 / (double)n) : null;
    }

    private void rotate180() {
        Point2D point2D;
        boolean bl = false;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (!this.mMol.isSelectedAtom(i)) continue;
            bl = true;
            break;
        }
        if ((point2D = this.calculateCenterOfGravity(bl)) != null) {
            this.storeState();
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (bl && !this.mMol.isSelectedAtom(i)) continue;
                this.mMol.setAtomX(i, 2.0 * point2D.getX() - this.mMol.getAtomX(i));
                this.mMol.setAtomY(i, 2.0 * point2D.getY() - this.mMol.getAtomY(i));
            }
            this.update(1);
        }
    }

    private void flip(boolean bl) {
        Point2D point2D;
        boolean bl2 = false;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            if (!this.mMol.isSelectedAtom(i)) continue;
            bl2 = true;
            break;
        }
        if ((point2D = this.calculateCenterOfGravity(bl2)) != null) {
            int n;
            this.storeState();
            for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
                if (bl2 && !this.mMol.isSelectedAtom(n)) continue;
                if (bl) {
                    this.mMol.setAtomX(n, 2.0 * point2D.getX() - this.mMol.getAtomX(n));
                    continue;
                }
                this.mMol.setAtomY(n, 2.0 * point2D.getY() - this.mMol.getAtomY(n));
            }
            for (n = 0; n < this.mMol.getAllBonds(); ++n) {
                if (bl2 && !this.mMol.isSelectedBond(n)) continue;
                if (this.mMol.getBondType(n) == 257) {
                    this.mMol.setBondType(n, 129);
                    continue;
                }
                if (this.mMol.getBondType(n) != 129) continue;
                this.mMol.setBondType(n, 257);
            }
            this.update(1);
        }
    }

    public void showCustomAtomDialog(final int n, Runnable runnable, Runnable runnable2) {
        this.storeState();
        CustomAtomDialogBuilder customAtomDialogBuilder = n == -1 ? new CustomAtomDialogBuilder(this.mUIHelper, this, this.mCustomAtomicNo, this.mCustomAtomMass, this.mCustomAtomValence, this.mCustomAtomRadical, this.mCustomAtomLabel) : new CustomAtomDialogBuilder(this.mUIHelper, this, this.mMol, n);
        customAtomDialogBuilder.getDialog().setEventConsumer(new GenericEventListener<GenericActionEvent>(){

            @Override
            public void eventHappened(GenericActionEvent genericActionEvent) {
                if (n != -1) {
                    GenericEditorArea.this.updateAndFireEvent(1);
                }
            }
        });
        customAtomDialogBuilder.showDialog(runnable, runnable2);
    }

    public void showCustomAtomDialog(int n) {
        this.storeState();
        CustomAtomDialogBuilder customAtomDialogBuilder = n == -1 ? new CustomAtomDialogBuilder(this.mUIHelper, this, this.mCustomAtomicNo, this.mCustomAtomMass, this.mCustomAtomValence, this.mCustomAtomRadical, this.mCustomAtomLabel) : new CustomAtomDialogBuilder(this.mUIHelper, this, this.mMol, n);
        this.showBuilderAsync(customAtomDialogBuilder, n != -1);
    }
}

