/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.gui.editor.FXEditorArea;
import com.actelion.research.gui.editor.FXEditorToolbar;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;

public class FXEditorPane
extends BorderPane {
    private FXEditorToolbar mToolBar;
    private FXEditorArea mArea;
    private static String MOLFILE_FORMAT = "JAVA_DATAFLAVOR:chemical/x-mdl-molfilev3; class=java.lang.String";

    public FXEditorPane(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 0);
    }

    public FXEditorPane(StereoMolecule stereoMolecule, int n) {
        this.initialize(stereoMolecule, n);
    }

    public FXEditorPane(StereoMolecule[] stereoMoleculeArray) {
        this.initialize(null, 1);
        this.mArea.getGenericDrawArea().setFragments(stereoMoleculeArray);
    }

    public FXEditorPane(Reaction reaction) {
        this.initialize(null, 4);
        this.mArea.getGenericDrawArea().setReaction(reaction);
    }

    private void initialize(StereoMolecule stereoMolecule, int n) {
        this.mArea = new FXEditorArea(stereoMolecule != null ? stereoMolecule : new StereoMolecule(), n);
        this.mToolBar = new FXEditorToolbar(this.mArea);
        this.widthProperty().addListener((observableValue, number, number2) -> this.mArea.setWidth((Double)number2 - this.mToolBar.getWidth()));
        this.heightProperty().addListener((observableValue, number, number2) -> this.mArea.setHeight((Double)number2));
        this.setLeft((Node)this.mToolBar);
        this.setCenter((Node)new Pane(new Node[]{this.mArea}));
        this.initializeDragAndDrop();
    }

    public GenericEditorArea getDrawArea() {
        return this.mArea.getGenericDrawArea();
    }

    public FXEditorArea getFXDrawArea() {
        return this.mArea;
    }

    public void cleanStructure() {
        this.mArea.getGenericDrawArea().toolChanged(1);
    }

    private void initializeDragAndDrop() {
        this.setOnDragEntered(dragEvent -> {
            System.out.println("onDragEntered");
            if (dragEvent.getGestureSource() == this || dragEvent.getDragboard().hasString()) {
                // empty if block
            }
            dragEvent.consume();
        });
        this.setOnDragOver(dragEvent -> {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragEvent.getGestureSource() != this && this.getAcceptedFormats(dragboard).size() > 0) {
                dragEvent.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            dragEvent.consume();
        });
        this.setOnDragExited(dragEvent -> dragEvent.consume());
        this.setOnDragDropped(dragEvent -> {
            System.out.println("onDragDropped");
            Dragboard dragboard = dragEvent.getDragboard();
            boolean bl = false;
            List<DataFormat> list = this.getAcceptedFormats(dragboard);
            StereoMolecule stereoMolecule = new StereoMolecule();
            for (DataFormat dataFormat : list) {
                if (!this.isJavaFormat(dataFormat, MOLFILE_FORMAT)) continue;
                MolfileParser molfileParser = new MolfileParser();
                molfileParser.parse(stereoMolecule, dragboard.getContent(dataFormat).toString());
                bl = true;
                break;
            }
            if (!bl && dragboard.hasString()) {
                try {
                    IDCodeParser iDCodeParser = new IDCodeParser(true);
                    iDCodeParser.parse(stereoMolecule, dragboard.getString());
                    bl = true;
                }
                catch (Exception exception) {
                    System.err.println("Cannot parse data for molecules ");
                }
            }
            if (bl) {
                this.mArea.getGenericDrawArea().addPastedOrDropped(stereoMolecule, new GenericPoint(dragEvent.getX(), dragEvent.getY()));
            }
            dragEvent.setDropCompleted(bl);
            dragEvent.consume();
        });
    }

    private List<DataFormat> getAcceptedFormats(Dragboard dragboard) {
        Set set = dragboard.getContentTypes();
        ArrayList<DataFormat> arrayList = new ArrayList<DataFormat>();
        for (DataFormat dataFormat : set) {
            if (dataFormat.equals((Object)DataFormat.PLAIN_TEXT)) {
                arrayList.add(dataFormat);
                continue;
            }
            if (!this.isJavaFormat(dataFormat, MOLFILE_FORMAT)) continue;
            arrayList.add(dataFormat);
        }
        return arrayList;
    }

    private boolean isJavaFormat(DataFormat dataFormat, String string) {
        Set set = dataFormat.getIdentifiers();
        for (String string2 : set) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

