/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.editor.AsynchronousQueryBuilder;
import com.actelion.research.gui.editor.GenericEditorArea;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.generic.GenericUIHelper;
import javax.swing.JTextField;

public class CustomAtomDialogBuilder
extends AsynchronousQueryBuilder {
    private static final String[] RADICAL_STATES = new String[]{"None", "One electron (duplet)", "Two electrons (triplet)", "Two electrons (singulet)"};
    private GenericEditorArea mEditorArea;
    private StereoMolecule mMol;
    private int mAtom;
    private int mOldAtomicNo;
    private int mOldAtomMass;
    private int mOldAtomValence;
    private int mOldAtomRadical;
    private String mOldCustomLabel;
    private GenericTextField mTextFieldLabel;
    private GenericTextField mTextFieldMass;
    private GenericTextField mTextFieldValence;
    private GenericComboBox mComboBoxRadical;

    public CustomAtomDialogBuilder(GenericUIHelper genericUIHelper, GenericEditorArea genericEditorArea, int n, int n2, int n3, int n4, String string) {
        this.mDialog = genericUIHelper.createDialog("Atom Properties", this);
        this.mEditorArea = genericEditorArea;
        this.mAtom = -1;
        this.mOldAtomicNo = n;
        this.mOldAtomMass = n2;
        this.mOldAtomValence = n3;
        this.mOldAtomRadical = n4;
        this.mOldCustomLabel = string;
        this.build();
    }

    public CustomAtomDialogBuilder(GenericUIHelper genericUIHelper, GenericEditorArea genericEditorArea, StereoMolecule stereoMolecule, int n) {
        this.mDialog = genericUIHelper.createDialog("Atom Properties", this);
        this.mEditorArea = genericEditorArea;
        this.mMol = stereoMolecule;
        this.mAtom = n;
        this.mOldAtomicNo = this.mMol.getAtomicNo(n);
        this.mOldAtomMass = this.mMol.getAtomMass(n);
        this.mOldAtomValence = this.mMol.getAtomAbnormalValence(n);
        this.mOldAtomRadical = this.mMol.getAtomRadical(n);
        this.mOldCustomLabel = this.mMol.getAtomCustomLabel(n);
        this.build();
    }

    private void build() {
        int n;
        String[] stringArray;
        int[] nArray = new int[]{8, -2, 8, -2, 8};
        int[] nArray2 = new int[]{8, -2, 4, -2, 12, -2, 4, -2, 12, -2, 4, -2, 12, -2, 8};
        this.mDialog.setLayout(nArray, nArray2);
        this.mTextFieldLabel = this.mDialog.createTextField(1, 1);
        this.mTextFieldLabel.addEventConsumer(this);
        this.mDialog.add(this.mDialog.createLabel("Atom Label:"), 1, 1);
        this.mDialog.add(this.mTextFieldLabel, 3, 1);
        this.mDialog.add(this.mDialog.createLabel("(examples: 'D', 'Li', 'Cys', 'R12', 'R3@C')"), 1, 3, 3, 3);
        this.mTextFieldMass = this.mDialog.createTextField(1, 1);
        this.mTextFieldMass.addEventConsumer(this);
        this.mDialog.add(this.mDialog.createLabel("Atom Mass:"), 1, 5);
        this.mDialog.add(this.mTextFieldMass, 3, 5);
        this.mDialog.add(this.mDialog.createLabel("(empty for natural abundance)"), 1, 7, 3, 7);
        this.mTextFieldValence = this.mDialog.createTextField(1, 1);
        this.mTextFieldValence.addEventConsumer(this);
        this.mDialog.add(this.mDialog.createLabel("Abnormal Valence:"), 1, 9);
        this.mDialog.add(this.mTextFieldValence, 3, 9);
        this.mDialog.add(this.mDialog.createLabel("(empty for default valence)"), 1, 11, 3, 11);
        if (this.mAtom == -1) {
            stringArray = Molecule.cAtomLabel[this.mOldAtomicNo];
            this.mTextFieldLabel.setText((String)(this.mOldCustomLabel == null ? stringArray : this.mOldCustomLabel + "@" + (String)stringArray));
            if (this.mOldAtomMass != 0) {
                this.mTextFieldMass.setText("" + this.mOldAtomMass);
            }
            if (this.mOldAtomValence != -1) {
                this.mTextFieldValence.setText("" + this.mOldAtomValence);
            }
        } else {
            stringArray = this.mMol.getAtomLabel(this.mAtom);
            String string = this.mMol.getAtomCustomLabel(this.mAtom);
            this.mTextFieldLabel.setText((String)(string == null ? stringArray : string + "@" + (String)stringArray));
            if (this.mMol.getAtomMass(this.mAtom) != 0) {
                this.mTextFieldMass.setText("" + this.mMol.getAtomMass(this.mAtom));
            }
            if (this.mMol.getAtomAbnormalValence(this.mAtom) != -1) {
                this.mTextFieldValence.setText("" + this.mMol.getAtomAbnormalValence(this.mAtom));
            }
        }
        this.mComboBoxRadical = this.mDialog.createComboBox();
        for (String string : RADICAL_STATES) {
            this.mComboBoxRadical.addItem(string);
        }
        int n2 = n = this.mAtom == -1 ? this.mOldAtomRadical : this.mMol.getAtomRadical(this.mAtom);
        this.mComboBoxRadical.setSelectedIndex(n == 32 ? 1 : (n == 48 ? 2 : (n == 16 ? 3 : 0)));
        this.mDialog.add(this.mDialog.createLabel("Radical State:"), 1, 13);
        this.mDialog.add(this.mComboBoxRadical, 3, 13);
    }

    @Override
    public void eventHappened(GenericActionEvent genericActionEvent) {
        if (genericActionEvent.getSource() instanceof JTextField) {
            this.processAtomLabel(false);
        } else if (genericActionEvent.getWhat() == 1 && this.mAtom != -1) {
            this.mMol.setAtomicNo(this.mAtom, this.mOldAtomicNo);
            this.mMol.setAtomMass(this.mAtom, this.mOldAtomMass);
            this.mMol.setAtomAbnormalValence(this.mAtom, this.mOldAtomValence);
            this.mMol.setAtomRadical(this.mAtom, this.mOldAtomRadical);
            this.mMol.setAtomCustomLabel(this.mAtom, this.mOldCustomLabel);
        }
        this.handleOkCancel(genericActionEvent);
    }

    @Override
    protected void setQueryFeatures() {
        this.processAtomLabel(true);
    }

    private void processAtomLabel(boolean bl) {
        int n;
        String string = this.mTextFieldLabel.getText();
        String string2 = null;
        if (string.length() != 0 && (n = string.indexOf(64)) != -1) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (string.length() != 0 && ((n = Molecule.getAtomicNoFromLabel(string, this.mEditorArea.getAllowedPseudoAtoms())) != 0 || string.equals("?"))) {
            int n2;
            int n3 = 0;
            if (this.mTextFieldMass.getText().length() != 0) {
                try {
                    n3 = Integer.parseInt(this.mTextFieldMass.getText());
                    if (n3 < Molecule.cRoundedMass[n] - 18 || n3 > Molecule.cRoundedMass[n] + 12) {
                        this.mDialog.showMessage("Your mass is out of range!");
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.mDialog.showMessage("Your mass is not a number!");
                    return;
                }
            }
            int n4 = -1;
            if (this.mTextFieldValence.getText().length() != 0) {
                try {
                    n4 = Integer.parseInt(this.mTextFieldValence.getText());
                    if (n4 < 0 || n4 > 15) {
                        this.mDialog.showMessage("Your valence is out of range!");
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.mDialog.showMessage("Your valence is not a number!");
                    return;
                }
            }
            int n5 = this.mComboBoxRadical.getSelectedIndex() == 1 ? 32 : (this.mComboBoxRadical.getSelectedIndex() == 2 ? 48 : (n2 = this.mComboBoxRadical.getSelectedIndex() == 3 ? 16 : 0));
            if (bl) {
                this.mEditorArea.setCustomAtom(n, n3, n4, n2, string2);
            }
            if (this.mAtom != -1) {
                this.mMol.changeAtom(this.mAtom, n, n3, n4, n2);
                this.mMol.setAtomCustomLabel(this.mAtom, string2);
            }
            this.mOKSelected = true;
            this.mDialog.disposeDialog();
        }
    }
}

