/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.editor;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.gui.editor.AsynchronousQueryBuilder;
import com.actelion.research.gui.generic.GenericActionEvent;
import com.actelion.research.gui.generic.GenericCheckBox;
import com.actelion.research.gui.generic.GenericComboBox;
import com.actelion.research.gui.generic.GenericLabel;
import com.actelion.research.gui.generic.GenericTextField;
import com.actelion.research.gui.generic.GenericUIHelper;
import com.actelion.research.gui.hidpi.HiDPIHelper;
import java.util.Arrays;

public class AtomQueryFeatureDialogBuilder
extends AsynchronousQueryBuilder {
    public static final String[] RING_SIZE_SHORT_TEXT = new String[]{"", "r0", "r", "r3", "r3-4", "r3-5", "r3-6", "r3-7", "r4", "r4-5", "r4-6", "r4-7", "r>3", "r5", "r5-6", "r5-7", "r>4", "r6", "r6-7", "r>5", "r7", "r>6", "r>7"};
    private static final String[] RING_SIZE_OPTIONS = new String[]{"any", "is not in a ring", "is in any ring", "3 members", "3-4 members", "3-5 members", "3-6 members", "3-7 members", "4 members", "4-5 members", "4-6 members", "4-7 members", "> 3 members", "5 members", "5-6 members", "5-7 members", "> 4 members", "6 members", "6-7 members", "> 5 members", "7 members", "> 6 members", "> 7 members"};
    public static final long[] RING_SIZE_VALUES = new long[]{0L, 0x100000000L, 0x7E00000000L, 0x200000000L, 0x600000000L, 0xE00000000L, 0x1E00000000L, 0x3E00000000L, 0x400000000L, 0xC00000000L, 0x1C00000000L, 0x3C00000000L, 0x7C00000000L, 0x800000000L, 0x1800000000L, 0x3800000000L, 0x7800000000L, 0x1000000000L, 0x3000000000L, 0x7000000000L, 0x2000000000L, 0x6000000000L, 0x4000000000L};
    private GenericLabel mLabelAtomList;
    private GenericTextField mTFAtomList;
    private GenericCheckBox mCBAny;
    private GenericCheckBox mCBBlocked;
    private GenericCheckBox mCBSubstituted;
    private GenericCheckBox mCBMatchStereo;
    private GenericCheckBox mCBExcludeGroup;
    private GenericComboBox mChoiceArom;
    private GenericComboBox mChoiceRingState;
    private GenericComboBox mChoiceSmallRingSize;
    private GenericComboBox mChoiceRingSize;
    private GenericComboBox mChoiceCharge;
    private GenericComboBox mChoiceNeighbours;
    private GenericComboBox mChoiceHydrogen;
    private GenericComboBox mChoicePi;
    private GenericComboBox mChoiceENeighbours;
    private GenericComboBox mChoiceReactionParityHint;
    private GenericComboBox mChoiceStereoCenter;
    private ExtendedMolecule mMol;
    private int mAtom;
    private long mRingSizeCustomValue;

    public AtomQueryFeatureDialogBuilder(GenericUIHelper genericUIHelper, ExtendedMolecule extendedMolecule, int n, boolean bl) {
        this.mDialog = genericUIHelper.createDialog(extendedMolecule.isSelectedAtom(n) ? "Atom Query Features (Multiple)" : "Atom Query Features", this);
        this.build(extendedMolecule, n, bl);
    }

    private void build(ExtendedMolecule extendedMolecule, int n, boolean bl) {
        this.mMol = extendedMolecule;
        this.mAtom = n;
        int n2 = HiDPIHelper.scale(8.0f);
        int[] nArray = new int[]{n2, n2 / 2, n2 * 3 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 / 2, n2 * 3 / 2, n2 / 4, n2 / 2, n2 / 2, n2 / 4};
        int[] nArray2 = new int[]{n2 * 3 / 2, n2 / 2};
        int[] nArray3 = new int[]{n2, -2, n2, -2, n2};
        int[] nArray4 = new int[1 + 2 * nArray.length + (bl ? 2 * nArray2.length : 0)];
        int n3 = 0;
        for (int n4 : nArray) {
            nArray4[n3++] = n4;
            nArray4[n3++] = -2;
        }
        if (bl) {
            for (int n4 : nArray2) {
                nArray4[n3++] = n4;
                nArray4[n3++] = -2;
            }
        }
        nArray4[n3++] = n2;
        this.mDialog.setLayout(nArray3, nArray4);
        this.mCBAny = this.mDialog.createCheckBox("Any atomic number");
        this.mCBAny.addEventConsumer(this);
        this.mDialog.add(this.mCBAny, 1, 1, 3, 1);
        this.mLabelAtomList = this.mDialog.createLabel("Excluded atoms:");
        this.mTFAtomList = this.mDialog.createTextField(16, 1);
        this.mDialog.add(this.mLabelAtomList, 1, 3);
        this.mDialog.add(this.mTFAtomList, 3, 3);
        this.mChoiceArom = this.mDialog.createComboBox();
        this.mChoiceArom.addItem("any");
        this.mChoiceArom.addItem("is aromatic");
        this.mChoiceArom.addItem("is hetero-aromatic");
        this.mChoiceArom.addItem("is not aromatic");
        this.mDialog.add(this.mDialog.createLabel("Aromaticity:"), 1, 5);
        this.mDialog.add(this.mChoiceArom, 3, 5);
        this.mChoiceRingState = this.mDialog.createComboBox();
        this.mChoiceRingState.addItem("any");
        this.mChoiceRingState.addItem("0 (not in a ring)");
        this.mChoiceRingState.addItem("0 or 2 (0 or 1 ring)");
        this.mChoiceRingState.addItem(">=2 (any ring count)");
        this.mChoiceRingState.addItem("2 (in 1 ring)");
        this.mChoiceRingState.addItem("3 (bridge head; 2 rings)");
        this.mChoiceRingState.addItem(">3 (in more than 2 rings)");
        this.mDialog.add(this.mDialog.createLabel("Ring bonds:"), 1, 7);
        this.mDialog.add(this.mChoiceRingState, 3, 7);
        this.mChoiceSmallRingSize = this.mDialog.createComboBox();
        this.mChoiceSmallRingSize.addItem("any");
        this.mChoiceSmallRingSize.addItem("3 members");
        this.mChoiceSmallRingSize.addItem("4 members");
        this.mChoiceSmallRingSize.addItem("5 members");
        this.mChoiceSmallRingSize.addItem("6 members");
        this.mChoiceSmallRingSize.addItem("7 members");
        this.mDialog.add(this.mDialog.createLabel("Smallest ring size:"), 1, 9);
        this.mDialog.add(this.mChoiceSmallRingSize, 3, 9);
        this.mChoiceRingSize = this.mDialog.createComboBox();
        for (String string : RING_SIZE_OPTIONS) {
            this.mChoiceRingSize.addItem(string);
        }
        this.mDialog.add(this.mDialog.createLabel("Any ring size:"), 1, 11);
        this.mDialog.add(this.mChoiceRingSize, 3, 11);
        this.mChoiceCharge = this.mDialog.createComboBox();
        this.mChoiceCharge.addItem("any");
        this.mChoiceCharge.addItem("not charged");
        this.mChoiceCharge.addItem("has negative charge");
        this.mChoiceCharge.addItem("has positive charge");
        this.mDialog.add(this.mDialog.createLabel("Charge:"), 1, 13);
        this.mDialog.add(this.mChoiceCharge, 3, 13);
        this.mChoiceNeighbours = this.mDialog.createComboBox();
        this.mChoiceNeighbours.addItem("any");
        this.mChoiceNeighbours.addItem("exactly 1");
        this.mChoiceNeighbours.addItem("exactly 2");
        this.mChoiceNeighbours.addItem("exactly 3");
        this.mChoiceNeighbours.addItem("less than 3");
        this.mChoiceNeighbours.addItem("less than 4");
        this.mChoiceNeighbours.addItem("at least 1");
        this.mChoiceNeighbours.addItem("at least 2");
        this.mChoiceNeighbours.addItem("at least 3");
        this.mChoiceNeighbours.addItem("at least 4");
        this.mDialog.add(this.mDialog.createLabel("Non-H neighbours:"), 1, 15);
        this.mDialog.add(this.mChoiceNeighbours, 3, 15);
        this.mChoiceENeighbours = this.mDialog.createComboBox();
        this.mChoiceENeighbours.addItem("any");
        this.mChoiceENeighbours.addItem("exactly 0");
        this.mChoiceENeighbours.addItem("exactly 1");
        this.mChoiceENeighbours.addItem("exactly 2");
        this.mChoiceENeighbours.addItem("exactly 3");
        this.mChoiceENeighbours.addItem("less than 2");
        this.mChoiceENeighbours.addItem("less than 3");
        this.mChoiceENeighbours.addItem("less than 4");
        this.mChoiceENeighbours.addItem("at least 1");
        this.mChoiceENeighbours.addItem("at least 2");
        this.mChoiceENeighbours.addItem("at least 3");
        this.mChoiceENeighbours.addItem("at least 4");
        this.mChoiceENeighbours.addItem("from 1 to 2");
        this.mChoiceENeighbours.addItem("from 1 to 3");
        this.mChoiceENeighbours.addItem("from 2 to 3");
        this.mDialog.add(this.mDialog.createLabel("Electroneg. neighbours:"), 1, 17);
        this.mDialog.add(this.mChoiceENeighbours, 3, 17);
        this.mChoiceHydrogen = this.mDialog.createComboBox();
        this.mChoiceHydrogen.addItem("any");
        this.mChoiceHydrogen.addItem("none");
        this.mChoiceHydrogen.addItem("exactly 1");
        this.mChoiceHydrogen.addItem("exactly 2");
        this.mChoiceHydrogen.addItem("at least 1");
        this.mChoiceHydrogen.addItem("at least 2");
        this.mChoiceHydrogen.addItem("at least 3");
        this.mChoiceHydrogen.addItem("less than 2");
        this.mChoiceHydrogen.addItem("less than 3");
        this.mDialog.add(this.mDialog.createLabel("Hydrogen count:"), 1, 19);
        this.mDialog.add(this.mChoiceHydrogen, 3, 19);
        this.mChoicePi = this.mDialog.createComboBox();
        this.mChoicePi.addItem("any");
        this.mChoicePi.addItem("none");
        this.mChoicePi.addItem("exactly 1");
        this.mChoicePi.addItem("exactly 2");
        this.mChoicePi.addItem("at least 1");
        this.mDialog.add(this.mDialog.createLabel("Pi-electron count:"), 1, 21);
        this.mDialog.add(this.mChoicePi, 3, 21);
        this.mCBBlocked = this.mDialog.createCheckBox("prohibit further substitution");
        this.mCBBlocked.addEventConsumer(this);
        this.mDialog.add(this.mCBBlocked, 1, 23, 3, 23);
        this.mCBSubstituted = this.mDialog.createCheckBox("require further substitution");
        this.mCBSubstituted.addEventConsumer(this);
        this.mDialog.add(this.mCBSubstituted, 1, 25, 3, 25);
        this.mChoiceStereoCenter = this.mDialog.createComboBox();
        this.mChoiceStereoCenter.addItem("any");
        this.mChoiceStereoCenter.addItem("is a stereo center");
        this.mChoiceStereoCenter.addItem("is not a stereo center");
        this.mDialog.add(this.mDialog.createLabel("Stereo center:"), 1, 27);
        this.mDialog.add(this.mChoiceStereoCenter, 3, 27);
        this.mCBMatchStereo = this.mDialog.createCheckBox("match stereo center");
        this.mDialog.add(this.mCBMatchStereo, 1, 29, 3, 29);
        this.mCBExcludeGroup = this.mDialog.createCheckBox("is part of exclude group");
        this.mDialog.add(this.mCBExcludeGroup, 1, 31, 3, 31);
        if (bl) {
            this.mDialog.add(this.mDialog.createLabel("Stereo center hint for product:"), 1, 33, 3, 33);
            this.mChoiceReactionParityHint = this.mDialog.createComboBox();
            this.mChoiceReactionParityHint.addItem("Copy from generic product");
            this.mChoiceReactionParityHint.addItem("Keep reactant configuration");
            this.mChoiceReactionParityHint.addItem("Invert reactant configuration");
            this.mChoiceReactionParityHint.addItem("Racemise configuration");
            this.mDialog.add(this.mChoiceReactionParityHint, 1, 35, 3, 35);
        }
        this.mMol.ensureHelperArrays(31);
        this.setInitialStates();
    }

    @Override
    public void eventHappened(GenericActionEvent genericActionEvent) {
        if (this.handleOkCancel(genericActionEvent)) {
            return;
        }
        if (genericActionEvent.getSource() == this.mCBAny) {
            if (genericActionEvent.getValue() == 1) {
                this.mTFAtomList.setText("");
                this.mLabelAtomList.setText("Excluded atoms:");
            } else {
                this.mTFAtomList.setText(this.mMol.getAtomLabel(this.mAtom));
                this.mLabelAtomList.setText("Allowed atoms:");
            }
        } else if (genericActionEvent.getSource() == this.mCBBlocked) {
            this.mCBSubstituted.setSelected(false);
            this.mChoiceNeighbours.setSelectedIndex(0);
            this.mChoiceENeighbours.setSelectedIndex(0);
        } else if (genericActionEvent.getSource() == this.mCBSubstituted) {
            this.mCBBlocked.setSelected(false);
        }
    }

    private void setInitialStates() {
        long l;
        long l2 = this.mMol.getAtomQueryFeatures(this.mAtom);
        if ((l2 & 1L) != 0L) {
            this.mCBAny.setSelected(true);
            this.mLabelAtomList.setText("Excluded atoms:");
        } else {
            this.mLabelAtomList.setText("Allowed atoms:");
        }
        this.mTFAtomList.setText(this.mMol.getAtomList(this.mAtom) == null ? "" : this.mMol.getAtomListString(this.mAtom));
        long l3 = l2 & 0x400000000006L;
        if ((l3 & 0x400000000000L) != 0L) {
            this.mChoiceArom.setSelectedIndex(2);
        } else if (l3 == 2L) {
            this.mChoiceArom.setSelectedIndex(1);
        } else if (l3 == 4L) {
            this.mChoiceArom.setSelectedIndex(3);
        } else {
            this.mChoiceArom.setSelectedIndex(0);
        }
        long l4 = l2 & 0x78L;
        if (l4 == 112L) {
            this.mChoiceRingState.setSelectedIndex(1);
        } else if (l4 == 96L) {
            this.mChoiceRingState.setSelectedIndex(2);
        } else if (l4 == 8L) {
            this.mChoiceRingState.setSelectedIndex(3);
        } else if (l4 == 104L) {
            this.mChoiceRingState.setSelectedIndex(4);
        } else if (l4 == 88L) {
            this.mChoiceRingState.setSelectedIndex(5);
        } else if (l4 == 56L) {
            this.mChoiceRingState.setSelectedIndex(6);
        } else {
            this.mChoiceRingState.setSelectedIndex(0);
        }
        int n = (int)((l2 & 0x1C00000L) >> 22);
        this.mChoiceSmallRingSize.setSelectedIndex(n == 0 ? 0 : n - 2);
        long l5 = l2 & 0x7F00000000L;
        int n2 = -1;
        for (int i = 0; i < RING_SIZE_VALUES.length; ++i) {
            if (l5 != RING_SIZE_VALUES[i]) continue;
            n2 = i;
            break;
        }
        if (n2 != -1) {
            this.mChoiceRingSize.setSelectedIndex(n2);
        } else {
            StringBuilder stringBuilder = new StringBuilder("Custom:");
            if ((l5 & 0x100000000L) != 0L) {
                stringBuilder.append(" 0");
            }
            if ((l5 & 0x200000000L) != 0L) {
                stringBuilder.append(" 3");
            }
            if ((l5 & 0x400000000L) != 0L) {
                stringBuilder.append(" 4");
            }
            if ((l5 & 0x800000000L) != 0L) {
                stringBuilder.append(" 5");
            }
            if ((l5 & 0x1000000000L) != 0L) {
                stringBuilder.append(" 6");
            }
            if ((l5 & 0x2000000000L) != 0L) {
                stringBuilder.append(" 7");
            }
            if ((l5 & 0x4000000000L) != 0L) {
                stringBuilder.append(" >=8");
            }
            this.mRingSizeCustomValue = l5;
            this.mChoiceRingSize.addItem(stringBuilder.toString());
            this.mChoiceRingSize.setSelectedIndex(RING_SIZE_VALUES.length);
        }
        long l6 = l2 & 0x3E0000L;
        if (l6 == 0x3A0000L) {
            this.mChoiceNeighbours.setSelectedIndex(1);
        } else if (l6 == 0x360000L) {
            this.mChoiceNeighbours.setSelectedIndex(2);
        } else if (l6 == 0x2E0000L) {
            this.mChoiceNeighbours.setSelectedIndex(3);
        } else if (l6 == 0x300000L) {
            this.mChoiceNeighbours.setSelectedIndex(4);
        } else if (l6 == 0x200000L) {
            this.mChoiceNeighbours.setSelectedIndex(5);
        } else if (l6 == 131072L) {
            this.mChoiceNeighbours.setSelectedIndex(6);
        } else if (l6 == 393216L) {
            this.mChoiceNeighbours.setSelectedIndex(7);
        } else if (l6 == 917504L) {
            this.mChoiceNeighbours.setSelectedIndex(8);
        } else if (l6 == 0x1E0000L) {
            this.mChoiceNeighbours.setSelectedIndex(9);
        } else {
            this.mChoiceNeighbours.setSelectedIndex(0);
        }
        long l7 = l2 & 0xF8000000000L;
        if (l7 == 0xF0000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(1);
        } else if (l7 == 0xE8000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(2);
        } else if (l7 == 0xD8000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(3);
        } else if (l7 == 0xB8000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(4);
        } else if (l7 == 0xE0000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(5);
        } else if (l7 == 0xC0000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(6);
        } else if (l7 == 0x80000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(7);
        } else if (l7 == 0x8000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(8);
        } else if (l7 == 0x18000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(9);
        } else if (l7 == 0x38000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(10);
        } else if (l7 == 0x78000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(11);
        } else if (l7 == 0xC8000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(12);
        } else if (l7 == 0x88000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(13);
        } else if (l7 == 0x98000000000L) {
            this.mChoiceENeighbours.setSelectedIndex(14);
        } else {
            this.mChoiceENeighbours.setSelectedIndex(0);
        }
        long l8 = l2 & 0xE000000L;
        if (l8 == 0xA000000L) {
            this.mChoiceCharge.setSelectedIndex(1);
        } else if (l8 == 0xC000000L) {
            this.mChoiceCharge.setSelectedIndex(2);
        } else if (l8 == 0x6000000L) {
            this.mChoiceCharge.setSelectedIndex(3);
        } else {
            this.mChoiceCharge.setSelectedIndex(0);
        }
        long l9 = l2 & 0x780L;
        if (l9 == 1792L) {
            this.mChoiceHydrogen.setSelectedIndex(1);
        } else if (l9 == 1664L) {
            this.mChoiceHydrogen.setSelectedIndex(2);
        } else if (l9 == 1408L) {
            this.mChoiceHydrogen.setSelectedIndex(3);
        } else if (l9 == 128L) {
            this.mChoiceHydrogen.setSelectedIndex(4);
        } else if (l9 == 384L) {
            this.mChoiceHydrogen.setSelectedIndex(5);
        } else if (l9 == 896L) {
            this.mChoiceHydrogen.setSelectedIndex(6);
        } else if (l9 == 1536L) {
            this.mChoiceHydrogen.setSelectedIndex(7);
        } else if (l9 == 1024L) {
            this.mChoiceHydrogen.setSelectedIndex(8);
        } else {
            this.mChoiceHydrogen.setSelectedIndex(0);
        }
        long l10 = l2 & 0x1C000L;
        if (l10 == 98304L) {
            this.mChoicePi.setSelectedIndex(1);
        } else if (l10 == 81920L) {
            this.mChoicePi.setSelectedIndex(2);
        } else if (l10 == 49152L) {
            this.mChoicePi.setSelectedIndex(3);
        } else if (l10 == 16384L) {
            this.mChoicePi.setSelectedIndex(4);
        } else {
            this.mChoicePi.setSelectedIndex(0);
        }
        if ((l2 & 0x800L) != 0L) {
            this.mCBBlocked.setSelected(true);
        }
        if ((l2 & 0x1000L) != 0L) {
            this.mCBSubstituted.setSelected(true);
        }
        if ((l = l2 & 0x300000000000L) == 0x100000000000L) {
            this.mChoiceStereoCenter.setSelectedIndex(1);
        } else if (l == 0x200000000000L) {
            this.mChoiceStereoCenter.setSelectedIndex(2);
        } else {
            this.mChoiceStereoCenter.setSelectedIndex(0);
        }
        if ((l2 & 0x2000L) != 0L) {
            this.mCBMatchStereo.setSelected(true);
        }
        if ((l2 & 0x20000000L) != 0L) {
            this.mCBExcludeGroup.setSelected(true);
        }
        if (this.mChoiceReactionParityHint != null) {
            long l11 = l2 & 0xC0000000L;
            if (l11 == 0x40000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(1);
            } else if (l11 == 0x80000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(2);
            } else if (l11 == 0xC0000000L) {
                this.mChoiceReactionParityHint.setSelectedIndex(3);
            } else {
                this.mChoiceReactionParityHint.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected void setQueryFeatures() {
        int[] nArray = this.createAtomList();
        if (this.mMol.isSelectedAtom(this.mAtom)) {
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (!this.mMol.isSelectedAtom(i)) continue;
                this.setQueryFeatures(i, nArray);
            }
        } else {
            this.setQueryFeatures(this.mAtom, nArray);
        }
        this.mMol.validateAtomQueryFeatures();
    }

    private void setQueryFeatures(int n, int[] nArray) {
        int n2;
        long l = 0L;
        if (this.mCBAny.isSelected()) {
            l |= 1L;
            this.mMol.setAtomList(n, nArray, true);
        } else {
            this.mMol.setAtomList(n, nArray, false);
        }
        if (this.mChoiceArom.getSelectedIndex() == 2) {
            if (!this.mMol.isHeteroAromaticAtom(n)) {
                l |= 0x400000000002L;
            }
        } else if (!this.mMol.isAromaticAtom(n)) {
            if (this.mChoiceArom.getSelectedIndex() == 1) {
                l |= 2L;
            } else if (this.mChoiceArom.getSelectedIndex() == 3) {
                l |= 4L;
            }
        }
        int n3 = 0;
        for (n2 = 0; n2 < this.mMol.getConnAtoms(n); ++n2) {
            if (!this.mMol.isRingBond(this.mMol.getConnBond(n, n2))) continue;
            ++n3;
        }
        switch (this.mChoiceRingState.getSelectedIndex()) {
            case 1: {
                if (n3 != 0) break;
                l |= 0x70L;
                break;
            }
            case 2: {
                if (n3 > 2) break;
                l |= 0x60L;
                break;
            }
            case 3: {
                l |= 8L;
                break;
            }
            case 4: {
                if (n3 >= 3) break;
                l |= 0x68L;
                break;
            }
            case 5: {
                if (n3 >= 4) break;
                l |= 0x58L;
                break;
            }
            case 6: {
                l |= 0x38L;
            }
        }
        if (this.mChoiceSmallRingSize.getSelectedIndex() != 0) {
            l |= (long)(this.mChoiceSmallRingSize.getSelectedIndex() + 2) << 22;
        }
        if ((n2 = this.mChoiceRingSize.getSelectedIndex()) == RING_SIZE_VALUES.length) {
            l |= this.mRingSizeCustomValue;
        } else if (n2 != 0) {
            l |= RING_SIZE_VALUES[n2];
        }
        switch (this.mChoiceCharge.getSelectedIndex()) {
            case 1: {
                l |= 0xA000000L;
                break;
            }
            case 2: {
                l |= 0xC000000L;
                break;
            }
            case 3: {
                l |= 0x6000000L;
            }
        }
        switch (this.mChoiceNeighbours.getSelectedIndex()) {
            case 1: {
                if (this.mMol.getConnAtoms(n) == 1) {
                    l |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 1) break;
                l |= 0x3A0000L;
                break;
            }
            case 2: {
                if (this.mMol.getConnAtoms(n) == 2) {
                    l |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 2) break;
                l |= 0x360000L;
                break;
            }
            case 3: {
                if (this.mMol.getConnAtoms(n) == 3) {
                    l |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 3) break;
                l |= 0x2E0000L;
                break;
            }
            case 4: {
                if (this.mMol.getConnAtoms(n) == 2) {
                    l |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 2) break;
                l |= 0x300000L;
                break;
            }
            case 5: {
                if (this.mMol.getConnAtoms(n) == 3) {
                    l |= 0x800L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 3) break;
                l |= 0x200000L;
                break;
            }
            case 6: {
                if (this.mMol.getConnAtoms(n) != 0) break;
                l |= 0x1000L;
                break;
            }
            case 7: {
                if (this.mMol.getConnAtoms(n) == 1) {
                    l |= 0x1000L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 1) break;
                l |= 0x60000L;
                break;
            }
            case 8: {
                if (this.mMol.getConnAtoms(n) == 2) {
                    l |= 0x1000L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 2) break;
                l |= 0xE0000L;
                break;
            }
            case 9: {
                if (this.mMol.getConnAtoms(n) == 3) {
                    l |= 0x1000L;
                    break;
                }
                if (this.mMol.getConnAtoms(n) >= 3) break;
                l |= 0x1E0000L;
            }
        }
        int n4 = this.mMol.getAtomElectronegativeNeighbours(n);
        switch (this.mChoiceENeighbours.getSelectedIndex()) {
            case 1: {
                if (n4 != 0) break;
                l |= 0xF0000000000L;
                break;
            }
            case 2: {
                if (n4 > 1) break;
                l |= 0xE8000000000L;
                break;
            }
            case 3: {
                if (n4 > 2) break;
                l |= 0xD8000000000L;
                break;
            }
            case 4: {
                if (n4 > 3) break;
                l |= 0xB8000000000L;
                break;
            }
            case 5: {
                if (n4 >= 2) break;
                l |= 0xE0000000000L;
                break;
            }
            case 6: {
                if (n4 >= 3) break;
                l |= 0xC0000000000L;
                break;
            }
            case 7: {
                if (n4 >= 4) break;
                l |= 0x80000000000L;
                break;
            }
            case 8: {
                if (n4 != 0) break;
                l |= 0x8000000000L;
                break;
            }
            case 9: {
                if (n4 >= 2) break;
                l |= 0x18000000000L;
                break;
            }
            case 10: {
                if (n4 >= 3) break;
                l |= 0x38000000000L;
                break;
            }
            case 11: {
                if (n4 >= 4) break;
                l |= 0x78000000000L;
                break;
            }
            case 12: {
                if (n4 >= 2) break;
                l |= 0xC8000000000L;
                break;
            }
            case 13: {
                if (n4 >= 3) break;
                l |= 0x88000000000L;
                break;
            }
            case 14: {
                if (n4 >= 3) break;
                l |= 0x98000000000L;
            }
        }
        switch (this.mChoiceHydrogen.getSelectedIndex()) {
            case 1: {
                l |= 0x700L;
                break;
            }
            case 2: {
                l |= 0x680L;
                break;
            }
            case 3: {
                l |= 0x580L;
                break;
            }
            case 4: {
                l |= 0x80L;
                break;
            }
            case 5: {
                l |= 0x180L;
                break;
            }
            case 6: {
                l |= 0x380L;
                break;
            }
            case 7: {
                l |= 0x600L;
                break;
            }
            case 8: {
                l |= 0x400L;
            }
        }
        switch (this.mChoicePi.getSelectedIndex()) {
            case 1: {
                l |= 0x18000L;
                break;
            }
            case 2: {
                l |= 0x14000L;
                break;
            }
            case 3: {
                l |= 0xC000L;
                break;
            }
            case 4: {
                l |= 0x4000L;
            }
        }
        if (this.mCBBlocked.isSelected() && (this.mMol.getFreeValence(n) > 0 || this.mMol.getAtomCharge(n) == 0 && (this.mMol.getAtomicNo(n) == 5 || this.mMol.isNitrogenFamily(n) || this.mMol.isChalcogene(n)))) {
            l |= 0x800L;
        }
        if (this.mCBSubstituted.isSelected() && (this.mMol.getFreeValence(n) > 0 || this.mMol.getAtomCharge(n) == 0 && (this.mMol.getAtomicNo(n) == 5 || this.mMol.isNitrogenFamily(n) || this.mMol.isChalcogene(n)))) {
            l |= 0x1000L;
        }
        switch (this.mChoiceStereoCenter.getSelectedIndex()) {
            case 1: {
                l |= 0x100000000000L;
                break;
            }
            case 2: {
                l |= 0x200000000000L;
            }
        }
        if (this.mCBMatchStereo.isSelected()) {
            l |= 0x2000L;
        }
        if (this.mCBExcludeGroup.isSelected()) {
            l |= 0x20000000L;
        }
        if (this.mChoiceReactionParityHint != null) {
            switch (this.mChoiceReactionParityHint.getSelectedIndex()) {
                case 1: {
                    l |= 0x40000000L;
                    break;
                }
                case 2: {
                    l |= 0x80000000L;
                    break;
                }
                case 3: {
                    l |= 0xC0000000L;
                }
            }
        }
        this.mMol.setAtomQueryFeature(n, -1L, false);
        this.mMol.setAtomQueryFeature(n, l, true);
    }

    private int[] createAtomList() {
        int[] nArray = null;
        String string = this.mTFAtomList.getText().trim();
        while (string.length() != 0) {
            String string2;
            int n = string.indexOf(44);
            if (n == -1) {
                string2 = string.trim();
                string = "";
            } else {
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            }
            if (string2.equals("X")) {
                if (string.length() != 0) {
                    string = ",";
                }
                string = string.concat("F,Cl,Br,I");
                continue;
            }
            int n2 = Molecule.getAtomicNoFromLabel(string2);
            if (n2 == 0) continue;
            if (n2 == 1) {
                this.mDialog.showMessage("'H' cannot be part of an atom list and is removed.");
                continue;
            }
            if (nArray == null) {
                nArray = new int[]{n2};
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                if (n2 != nArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            int[] nArray2 = new int[nArray.length + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i];
            }
            nArray2[nArray.length] = n2;
            nArray = nArray2;
        }
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        return nArray;
    }
}

