/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui.dnd;

import com.actelion.research.chem.Depictor2D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.dnd.ChemistryFlavors;
import com.actelion.research.gui.dnd.MoleculeTransferable;
import com.actelion.research.gui.generic.GenericRectangle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public abstract class MoleculeDragAdapter
implements DragSourceListener {
    int mAllowedDragAction;
    Cursor cursor = null;

    public MoleculeDragAdapter(Component component) {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(component, 3, new DGListener());
        this.mAllowedDragAction = 3;
    }

    public void allowDrag(boolean bl) {
        this.mAllowedDragAction = bl ? 3 : 0;
    }

    public abstract Transferable getTransferable(Point var1);

    public void onDragEnter() {
    }

    public void onDragOver() {
    }

    public void onDragExit() {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & this.mAllowedDragAction) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
        this.onDragEnter();
    }

    @Override
    public final void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.onDragOver();
    }

    @Override
    public final void dragExit(DragSourceEvent dragSourceEvent) {
        this.onDragExit();
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        int n = dragSourceDragEvent.getDropAction();
        if ((n & this.mAllowedDragAction) != 0) {
            dragSourceContext.setCursor(DragSource.DefaultCopyDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    protected void onDragBegin(DragGestureEvent dragGestureEvent) {
        Transferable transferable;
        this.cursor = null;
        if ((dragGestureEvent.getDragAction() & this.mAllowedDragAction) != 0 && (transferable = this.getTransferable(dragGestureEvent.getDragOrigin())) != null) {
            try {
                Image image = null;
                if (DragSource.isDragImageSupported() && (image = this.drawDragImage(transferable, 400, 400)) != null) {
                    dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, image, new Point(200, 200), transferable, this);
                } else {
                    dragGestureEvent.startDrag(this.cursor, transferable, this);
                }
                this.dragIsValidAndStarts();
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                System.err.println(invalidDnDOperationException);
            }
        }
    }

    public Image drawDragImage(Transferable transferable, int n, int n2) {
        if (transferable instanceof MoleculeTransferable) {
            try {
                MoleculeTransferable moleculeTransferable = (MoleculeTransferable)transferable;
                Object object = moleculeTransferable.getTransferData(ChemistryFlavors.DF_SERIALIZED_MOLECULE);
                if (object instanceof StereoMolecule) {
                    StereoMolecule stereoMolecule = (StereoMolecule)object;
                    Depictor2D depictor2D = new Depictor2D(stereoMolecule);
                    BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                    depictor2D.validateView(graphics2D, new GenericRectangle(0.0, 0.0, n, n2), 65536);
                    depictor2D.paint(graphics2D);
                    return bufferedImage;
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.err.println(unsupportedFlavorException);
            }
        }
        return null;
    }

    public void dragIsValidAndStarts() {
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            MoleculeDragAdapter.this.onDragBegin(dragGestureEvent);
        }
    }
}

