/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = 537986067L;
    int _halign;
    int _valign;
    int _hgap;
    int _vgap;
    boolean _hfill;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    public VerticalFlowLayout() {
        this(3, 0, 5, 5, true);
    }

    public VerticalFlowLayout(int n, int n2) {
        this(n, n2, 5, 5, true);
    }

    public VerticalFlowLayout(int n, int n2, int n3, int n4, boolean bl) {
        this._hgap = n3;
        this._vgap = n4;
        this._hfill = bl;
        this.setAlignment(n, n2);
    }

    public void setAlignment(int n, int n2) {
        this._halign = n;
        this._valign = n2;
    }

    public void setHgap(int n) {
        this._hgap = n;
    }

    public void setVgap(int n) {
        this._vgap = n;
    }

    public int getHalignment() {
        return this._halign;
    }

    public int getValignment() {
        return this._valign;
    }

    public int getHgap() {
        return this._hgap;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setHorizontalFill(boolean bl) {
        this._hfill = bl;
    }

    public boolean getHorizontalFill() {
        return this._hfill;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (bl) {
                    bl = false;
                } else {
                    dimension.height += this._vgap;
                }
                dimension.height += dimension2.height;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this._hgap * 2;
            dimension.height += insets.top + insets.bottom + this._vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (bl) {
                    bl = false;
                } else {
                    dimension.height += this._vgap;
                }
                dimension.height += dimension2.height;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this._hgap * 2;
            dimension.height += insets.top + insets.bottom + this._vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getHeight() - (insets.top + insets.bottom) - 2 * this._vgap;
            int n2 = container.getWidth() - (insets.left + insets.right) - 2 * this._hgap;
            int n3 = container.getComponentCount();
            Dimension dimension = this.preferredLayoutSize(container);
            Dimension dimension2 = container.getSize();
            int n4 = this._valign == 0 ? insets.top : (this._valign == 1 ? (dimension2.height - dimension.height) / 2 : dimension2.height - dimension.height - insets.bottom);
            for (int i = 0; i < n3; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension3 = component.getPreferredSize();
                if (this._hfill) {
                    component.setSize(n2, dimension3.height);
                    dimension3.width = n2;
                } else {
                    component.setSize(dimension3.width, dimension3.height);
                }
                if (n4 + dimension3.height > n) break;
                if (n4 > 0) {
                    n4 += this._vgap;
                }
                int n5 = this._halign == 3 ? insets.left : (this._halign == 1 ? (dimension2.width - dimension3.width) / 2 : dimension2.width - dimension3.width - insets.right);
                component.setLocation(n5 + this._hgap, n4 + this._vgap);
                n4 = (int)((double)n4 + dimension3.getHeight());
            }
        }
    }

    public String toString() {
        String string = "";
        switch (this._halign) {
            case 0: {
                string = "top";
                break;
            }
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "bottom";
            }
        }
        String string2 = "";
        switch (this._valign) {
            case 0: {
                string2 = "top";
                break;
            }
            case 1: {
                string2 = "center";
                break;
            }
            case 2: {
                string2 = "bottom";
            }
        }
        return this.getClass().getName() + "[hgap=" + this._hgap + ",vgap=" + this._vgap + ",halign=" + string + ",valign=" + string2 + "]";
    }
}

